/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.IdentitySubjectsPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ListValues;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class IdentitySubjectsPanelLogical
extends IdentitySubjectsPanel {
    private JCDescriptor descriptor = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public IdentitySubjectsPanelLogical(Frame mainFrame, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstant;
        this.init(this.madeFrom);
    }

    public void setDescriptor(JCDescriptor descr) {
        this.descriptor = descr;
        this.clearFields();
        this.setEnabled(this.descriptor.getAuthenticationType(), this.descriptor.getUserStore());
        this.authComboBox.setSelectedItem(this.descriptor.getAuthenticationType() != null ? this.descriptor.getAuthenticationType() : "");
        this.storeComboBox.setSelectedItem(this.descriptor.getUserStore() != null ? this.descriptor.getUserStore() : "");
        this.initList(this.descriptor.getIdentitySubjects());
    }

    public JCDescriptor getDescriptor() {
        return this.descriptor;
    }

    private void initList(IdentitySubject[] values) {
        this.model.clear();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.addElement(new ListValues(values[i], 3));
                ++i;
            }
        }
    }

    private void addIdentity(IdentitySubject identity) {
        ListValues listValue = null;
        String userName = identity.getResourcePrincipal().getUserName();
        IdentitySubject temp = null;
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            temp = listValue.getIdentitySubject();
            if (!userName.equals(temp.getResourcePrincipal().getUserName())) continue;
            if (identity.equals(temp)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Identity Subject for Resource Principal <" + userName + "> already exists.\n Would you like to save the changes and modify this Identity Subject?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyIdentity(listValue, identity);
            }
            this.clearFields();
            return;
        }
        this.model.addElement(new ListValues(identity, 3));
    }

    private void modifyIdentity(ListValues listValue, IdentitySubject identity) {
        String userName = identity.getResourcePrincipal().getUserName();
        if (!listValue.getIdentitySubject().getResourcePrincipal().getUserName().equals(userName)) {
            return;
        }
        listValue.setIdentitySubject(identity);
    }

    private void removeIdentity(ListValues identity) {
        this.model.removeElement(identity);
    }

    private void showIdentity(ListValues ident) {
        if (ident == null) {
            return;
        }
        this.mappingPanel.setIdentitySubject(ident.getIdentitySubject());
    }

    public void setContext(RemoteSecurity node) {
        this.mappingPanel.setContext(node);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.identitiesList.isSelectionEmpty()) {
                this.showIdentity((ListValues)this.model.get(this.identitiesList.getSelectedIndex()));
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        }
    }

    private void checkPanel() {
        if (!this.mappingPanel.isDefined()) {
            return;
        }
        if (this.mappingPanel.isCorrect() != 0) {
            return;
        }
        this.mappingPanel.commitChange();
        IdentitySubject temp = this.mappingPanel.getIdentitySubject();
        if (temp == null) {
            return;
        }
        String name = temp.getResourcePrincipal().getUserName();
        ListValues listValue = null;
        IdentitySubject ident = null;
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            ident = listValue.getIdentitySubject();
            if (!name.equals(ident.getResourcePrincipal().getUserName())) continue;
            if (temp.equals(ident)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Identity Subject <" + name + "> was changed.\n Would you like to save the changes and modify this Identity Subject?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyIdentity(listValue, temp);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Identity Subject?", "Warning", 0, 2);
        if (answer == 0) {
            this.addIdentity(temp);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.authComboBox) || src.equals(this.storeComboBox)) {
            this.setEnabled((String)this.authComboBox.getSelectedItem(), (String)this.storeComboBox.getSelectedItem());
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("SELECT_CMD") || cmd.equals("DESELECT_CMD")) {
            if (this.mappingPanel.checkEnabling("ADD")) {
                this.addButton.setEnabled(true);
                if (this.identitiesList.isSelectionEmpty()) {
                    this.modifyButton.setEnabled(false);
                } else {
                    this.modifyButton.setEnabled(true);
                }
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(false);
            }
            if (this.mappingPanel.checkEnabling("CLEAR") || !this.identitiesList.isSelectionEmpty()) {
                this.clearButton.setEnabled(true);
            } else {
                this.clearButton.setEnabled(false);
            }
            return;
        }
        IdentitySubject identity = null;
        if (!this.mappingPanel.isDefined()) {
            return;
        }
        if (this.mappingPanel.isCorrect() == 0) {
            this.mappingPanel.commitChange();
            identity = this.mappingPanel.getIdentitySubject();
        }
        if (cmd.equals("ADD_CMD")) {
            if (identity != null) {
                this.addIdentity(identity);
            }
            this.identitiesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            if (identity != null) {
                this.modifyIdentity((ListValues)this.identitiesList.getSelectedValue(), identity);
            }
            this.identitiesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeIdentity((ListValues)this.identitiesList.getSelectedValue());
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.identitiesList.clearSelection();
            this.clearFields();
        }
    }

    private void setEnabled(String auth, String store) {
        int flag = 0;
        if (auth == null || auth.equals("") || auth.equals("Caller Impersonation")) {
            this.storeComboBox.setSelectedItem("");
            this.storeComboBox.setEnabled(false);
            this.model.clear();
            this.mappingPanel.setEnabled(flag);
        } else if (auth.equals("Credentials Mapping")) {
            this.storeComboBox.setEnabled(true);
            this.model.clear();
            this.mappingPanel.setEnabled(flag);
        } else if (auth.equals("Configured Identity")) {
            this.storeComboBox.setEnabled(true);
            flag |= 1;
            if (store == null || store.equals("")) {
                flag |= 2;
            }
            this.mappingPanel.setEnabled(flag);
        } else {
            this.storeComboBox.setEnabled(true);
            flag = flag | 1 | 4;
            if (store == null || store.equals("")) {
                flag |= 2;
            }
            this.mappingPanel.setEnabled(flag);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        if (this.mappingPanel.checkEnabling("ADD")) {
            this.addButton.setEnabled(true);
            if (this.identitiesList.isSelectionEmpty()) {
                this.modifyButton.setEnabled(false);
            } else {
                this.modifyButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
        }
        if (this.mappingPanel.checkEnabling("CLEAR") || !this.identitiesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        this.mappingPanel.init(this.madeFrom);
    }

    public void clear() {
        this.model.clear();
        this.descriptor = null;
        this.clearFields();
    }

    public int isCorrect() {
        int i;
        boolean passwordDefined;
        IdentitySubject temp;
        boolean storeDefined;
        if (((String)this.authComboBox.getSelectedItem()).equals("")) {
            return 0;
        }
        if (((String)this.authComboBox.getSelectedItem()).equals("Credentials Mapping") && ((String)this.storeComboBox.getSelectedItem()).equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "In case of Credentials Mapping authentication user store definition is compulsory.", "Warning", 2);
            return 2;
        }
        if (((String)this.authComboBox.getSelectedItem()).equals("Configured Identity")) {
            if (this.model.isEmpty()) {
                JOptionPane.showMessageDialog(this.mainFrame, "In case of Configured Identity authentication at least one identity subject should be defined.", "Warning", 2);
                return 2;
            }
            storeDefined = false;
            if (!((String)this.storeComboBox.getSelectedItem()).equals("")) {
                storeDefined = true;
            }
            temp = null;
            passwordDefined = false;
            i = 0;
            while (i < this.model.size()) {
                temp = ((ListValues)this.model.elementAt(i)).getIdentitySubject();
                passwordDefined = false;
                if (temp != null) {
                    if (temp.getResourcePrincipal() != null && temp.getResourcePrincipal().getPassword() != null && !temp.getResourcePrincipal().getPassword().equals("")) {
                        passwordDefined = true;
                    }
                    if (!(storeDefined ^ passwordDefined)) {
                        JOptionPane.showMessageDialog(this.mainFrame, "In case of Configured Identity authentication either user store, or principal password for each identity subject should be defined.", "Warning", 2);
                        if (!passwordDefined) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Default passwords \"\" will be set.", "Warning", 2);
                        } else {
                            return 2;
                        }
                    }
                    if (temp.getCallerPrincipal() != null && (temp.getCallerPrincipal().getUserNames() != null || temp.getCallerPrincipal().getGroups() != null)) {
                        JOptionPane.showMessageDialog(this.mainFrame, "In case of Configured Identity authentication no caller principals for identity subjects are allowed.", "Warning", 2);
                        return 2;
                    }
                }
                ++i;
            }
        }
        if (((String)this.authComboBox.getSelectedItem()).equals("Principal Mapping")) {
            if (this.model.isEmpty()) {
                JOptionPane.showMessageDialog(this.mainFrame, "In case of Principal Mapping authentication at least one identity subject should be defined.", "Warning", 2);
                return 2;
            }
            storeDefined = false;
            if (!((String)this.storeComboBox.getSelectedItem()).equals("")) {
                storeDefined = true;
            }
            temp = null;
            passwordDefined = false;
            i = 0;
            while (i < this.model.size()) {
                temp = ((ListValues)this.model.elementAt(i)).getIdentitySubject();
                passwordDefined = false;
                if (temp != null) {
                    if (temp.getResourcePrincipal() != null && temp.getResourcePrincipal().getPassword() != null && !temp.getResourcePrincipal().getPassword().equals("")) {
                        passwordDefined = true;
                    }
                    if (!(storeDefined ^ passwordDefined)) {
                        JOptionPane.showMessageDialog(this.mainFrame, "In case of Principal Mapping authentication either user store, or principal password for each identity subject should be defined.", "Warning", 2);
                        if (!passwordDefined) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Default passwords \"\" will be set.", "Warning", 2);
                        } else {
                            return 2;
                        }
                    }
                    if (temp.getCallerPrincipal() == null || temp.getCallerPrincipal().getUserNames() == null && temp.getCallerPrincipal().getGroups() == null) {
                        JOptionPane.showMessageDialog(this.mainFrame, "In case of Principal Mapping authentication at least one caller principal for each identity subject should be defined.", "Warning", 2);
                        return 2;
                    }
                }
                ++i;
            }
        }
        return 0;
    }

    public void commitChange() {
        IdentitySubject[] identities = new IdentitySubject[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            identities[i] = ((ListValues)this.model.get(i)).getIdentitySubject();
            ++i;
        }
        if (this.authComboBox.getSelectedItem() != null && !((String)this.authComboBox.getSelectedItem()).equals("")) {
            this.descriptor.setAuthenticationType((String)this.authComboBox.getSelectedItem());
        } else {
            this.descriptor.setAuthenticationType(null);
        }
        if (this.storeComboBox.getSelectedItem() != null && !((String)this.storeComboBox.getSelectedItem()).equals("")) {
            this.descriptor.setUserStore((String)this.storeComboBox.getSelectedItem());
        } else {
            this.descriptor.setUserStore(null);
        }
        this.descriptor.setIdentitySubjects(identities);
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

