/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.GeneralPanel;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Frame;

public class GeneralPanelLogical
extends GeneralPanel
implements MadeFromConstants {
    private JCDescriptor descriptor = null;
    private ApplicationInformationProvider appProvider;
    private int madeFrom = 0;

    public GeneralPanelLogical(Frame mainFrame, int madeFromConstants) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstants;
    }

    public void setDescriptor(JCDescriptor descr) {
        this.descriptor = descr;
        this.clear();
        this.initFields();
        this.init(this.madeFrom);
    }

    public JCDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String[] getClasses() {
        return new String[]{this.managedClassTextField.getText().trim(), this.cfImplTextField.getText().trim(), this.connectionImplTextField.getText().trim(), this.cfInterfaceTextField.getText().trim(), this.connectionTextField.getText().trim()};
    }

    public void initFields() {
        if (this.descriptor.getVendorName() != null) {
            this.vendorTextField.setText(this.descriptor.getVendorName());
        }
        if (this.descriptor.getSpecVersion() != null) {
            this.specTextField.setText(this.descriptor.getSpecVersion());
        }
        if (this.descriptor.getVersion() != null) {
            this.versionTextField.setText(this.descriptor.getVersion());
        }
        if (this.descriptor.getEisType() != null) {
            this.eisTextField.setText(this.descriptor.getEisType());
        }
        if (this.descriptor.getLicenseRequired()) {
            this.licenseCheckBox.setSelected(true);
        } else {
            this.licenseCheckBox.setSelected(false);
        }
        if (this.descriptor.getLicenseDescription() != null) {
            this.descrPanel.setText(this.descriptor.getLicenseDescription());
        }
        if (this.descriptor.getManagedConnectionFactoryClass() != null) {
            this.managedClassTextField.setText(this.descriptor.getManagedConnectionFactoryClass());
        }
        if (this.descriptor.getConnectionFactoryInterface() != null) {
            this.cfInterfaceTextField.setText(this.descriptor.getConnectionFactoryInterface());
        }
        if (this.descriptor.getConnectionFactoryImplClass() != null) {
            this.cfImplTextField.setText(this.descriptor.getConnectionFactoryImplClass());
        }
        if (this.descriptor.getConnectionInterface() != null) {
            this.connectionTextField.setText(this.descriptor.getConnectionInterface());
        }
        if (this.descriptor.getConnectionImplClass() != null) {
            this.connectionImplTextField.setText(this.descriptor.getConnectionImplClass());
        }
        if (this.descriptor.getTransactionSupport() != null && (this.descriptor.getTransactionSupport().equals("LocalTransaction") || this.descriptor.getTransactionSupport().equals("XATransaction"))) {
            this.transactionComboBox.setSelectedItem(this.descriptor.getTransactionSupport());
        } else {
            this.transactionComboBox.setSelectedItem("NoTransaction");
        }
    }

    public void commitChange() {
        if (!this.vendorTextField.getText().trim().equals("")) {
            this.descriptor.setVendorName(this.vendorTextField.getText());
        }
        if (!this.specTextField.getText().trim().equals("")) {
            this.descriptor.setSpecVersion(this.specTextField.getText());
        }
        if (!this.versionTextField.getText().trim().equals("")) {
            this.descriptor.setVersion(this.versionTextField.getText());
        }
        if (!this.eisTextField.getText().trim().equals("")) {
            this.descriptor.setEisType(this.eisTextField.getText());
        }
        if (this.licenseCheckBox.isSelected()) {
            this.descriptor.setLicenseRequired(true);
        } else {
            this.descriptor.setLicenseRequired(false);
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            this.descriptor.setLicenseDescription(this.descrPanel.getText());
        }
        if (!this.managedClassTextField.getText().trim().equals("")) {
            this.descriptor.setManagedConnectionFactoryClass(this.managedClassTextField.getText().trim());
        }
        if (!this.cfInterfaceTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionFactoryInterface(this.cfInterfaceTextField.getText());
        }
        if (!this.cfImplTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionFactoryImplClass(this.cfImplTextField.getText());
        }
        if (!this.connectionTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionInterface(this.connectionTextField.getText());
        }
        if (!this.connectionImplTextField.getText().trim().equals("")) {
            this.descriptor.setConnectionImplClass(this.connectionImplTextField.getText());
        }
        this.descriptor.setTransactionSupport((String)this.transactionComboBox.getSelectedItem());
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 0 || this.madeFrom == 1) {
            this.vendorTextField.setEnabled(true);
            this.specTextField.setEnabled(true);
            this.eisTextField.setEnabled(true);
            this.versionTextField.setEnabled(true);
            this.managedClassTextField.setEnabled(true);
            this.cfInterfaceTextField.setEnabled(true);
            this.cfImplTextField.setEnabled(true);
            this.connectionTextField.setEnabled(true);
            this.connectionImplTextField.setEnabled(true);
            this.licenseCheckBox.setEnabled(true);
            this.transactionComboBox.setEnabled(true);
        } else {
            this.vendorTextField.setEnabled(false);
            this.specTextField.setEnabled(false);
            this.eisTextField.setEnabled(false);
            this.versionTextField.setEnabled(false);
            this.managedClassTextField.setEnabled(false);
            this.cfInterfaceTextField.setEnabled(false);
            this.cfImplTextField.setEnabled(false);
            this.connectionTextField.setEnabled(false);
            this.connectionImplTextField.setEnabled(false);
            this.licenseCheckBox.setEnabled(false);
            this.transactionComboBox.setEnabled(false);
        }
    }

    public void clear() {
        this.vendorTextField.setText("");
        this.specTextField.setText("");
        this.eisTextField.setText("");
        this.versionTextField.setText("");
        this.managedClassTextField.setText("");
        this.cfInterfaceTextField.setText("");
        this.cfImplTextField.setText("");
        this.connectionTextField.setText("");
        this.connectionImplTextField.setText("");
        this.descrPanel.setText("");
        this.licenseCheckBox.setSelected(false);
        this.transactionComboBox.setSelectedIndex(0);
    }

    public int isCorrect() {
        return 0;
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

