/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.DriverSettingsPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class DriverSettingsPanelLogical
extends DriverSettingsPanel {
    private Frame frame;
    private JCDescriptor descriptor = null;
    private DriverInfo[] drivers;
    private ApplicationInformationProvider appInfoProvider;
    private boolean setText = false;
    private boolean selectedWithMouse = false;

    public DriverSettingsPanelLogical() {
        this.disableButtons();
    }

    public DriverSettingsPanelLogical(Frame mainFrame, int madeFromConstants) {
        this.frame = mainFrame;
        this.init(madeFromConstants);
        this.disableButtons();
    }

    public void init(int madeFrom) {
    }

    public void setDescriptor(JCDescriptor descr) {
        this.descriptor = descr;
        this.drvVector.removeAllElements();
        if (this.descriptor != null) {
            this.drivers = this.descriptor.getDrivers();
            if (this.drivers != null) {
                int i = 0;
                while (i < this.drivers.length) {
                    this.drvVector.addElement(this.drivers[i]);
                    ++i;
                }
            }
        }
        this.disableButtons();
    }

    public void clear() {
        this.clearAll();
    }

    public void commitChange() {
        this.drivers = new DriverInfo[this.drvVector.size()];
        this.drvVector.copyInto(this.drivers);
        this.descriptor.setDrivers(this.drivers);
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider provider) {
        this.appInfoProvider = provider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appInfoProvider;
    }

    public ErrorReportObject getErrorObject() {
        return null;
    }

    public void proccessErrors(ErrorReportObject e) {
    }

    public void setLoader(ClassLoader loader) {
    }

    public int isCorrect() {
        return 0;
    }

    private void clearAll() {
        if (this.selectedWithMouse) {
            this.setText = true;
            this.nameTextField.setText("");
            this.classTextField.setText("");
            this.setText = false;
        }
        this.drvList.clearSelection();
        this.disableButtons();
    }

    private void addActionPerformed() {
        DriverInfo dInf = new DriverInfo();
        dInf.setDriverName(this.nameTextField.getText());
        dInf.setDriverClassName(this.classTextField.getText());
        this.drvVector.addElement(dInf);
    }

    private void removeActionPerformed() {
        this.drvVector.remove(this.drvList.getSelectedIndex());
    }

    private void modifyActionPerformed() {
        DriverInfo dInf = (DriverInfo)this.drvVector.getElementAt(this.drvList.getSelectedIndex());
        dInf.setDriverName(this.nameTextField.getText());
        dInf.setDriverClassName(this.classTextField.getText());
    }

    private void showSelectedValue() {
        DriverInfo di = (DriverInfo)this.drvVector.getElementAt(this.drvList.getSelectedIndex());
        if (this.selectedWithMouse) {
            this.setText = true;
            this.nameTextField.setText(di.getDriverName());
            this.classTextField.setText(di.getDriverClassName());
            this.setText = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addActionPerformed();
            this.clearAll();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeActionPerformed();
            this.clearAll();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearAll();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyActionPerformed();
            this.clearAll();
        }
        this.disableButtons();
    }

    private void disableButtons() {
        this.selectedWithMouse = false;
        if (this.nameTextField.getText() != null && !this.nameTextField.getText().equals("") || this.classTextField.getText() != null && !this.classTextField.getText().equals("")) {
            this.clearButton.setEnabled(true);
        } else {
            this.clearButton.setEnabled(false);
        }
        if (this.nameTextField.getText() != null && !this.nameTextField.getText().equals("")) {
            String name = this.nameTextField.getText();
            boolean exist = false;
            int i = 0;
            while (i < this.drvVector.size()) {
                if (((DriverInfo)this.drvVector.elementAt(i)).getDriverName().equalsIgnoreCase(name)) {
                    exist = true;
                    this.drvList.setSelectedIndex(i);
                }
                ++i;
            }
            if (exist) {
                this.modifyButton.setEnabled(true);
                this.addButton.setEnabled(false);
            } else if (this.classTextField.getText() != null && !this.classTextField.getText().equals("")) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(false);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
        }
        if (this.drvList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        this.selectedWithMouse = true;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.setText) {
            return;
        }
        Object src = e.getSource();
        if (src == this.drvList) {
            if (!this.drvList.isSelectionEmpty()) {
                this.showSelectedValue();
            } else {
                this.clearAll();
            }
        }
        this.disableButtons();
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.disableButtons();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.disableButtons();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.disableButtons();
        }
    }
}

