/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ConfigPropertiesPanel;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.ListValues;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class ConfigPropertiesPanelLogical
extends ConfigPropertiesPanel
implements MadeFromConstants {
    private boolean isRemoveAction = false;
    private boolean isEditing = false;
    private ConfigProperty[] defaultProps = new ConfigProperty[]{new ConfigProperty("ServerName", "java.lang.String", null, null), new ConfigProperty("PortNumber", "java.lang.String", null, null), new ConfigProperty("UserName", "java.lang.String", null, null), new ConfigProperty("Password", "java.lang.String", null, null), new ConfigProperty("ConnectionURL", "java.lang.String", null, null)};
    private ConfigProperty[] props = null;
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    static /* synthetic */ Class class$java$lang$String;

    public ConfigPropertiesPanelLogical(Frame mainFrame, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.madeFrom = madeFromConstant;
        this.init(this.madeFrom);
    }

    private void initList(ConfigProperty[] values) {
        this.model.clear();
        this.lastSelected = -1;
        String name = null;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    name = values[i].getConfigPropertyName();
                    this.model.addElement(new ListValues(values[i], 2));
                }
                ++i;
            }
        }
    }

    private void addProp(String name, String type, String value, String descr) {
        if (name == null || name.equals("")) {
            return;
        }
        ListValues listValue = null;
        ConfigProperty prop = null;
        ConfigProperty temp = new ConfigProperty(name, type, value, descr);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            prop = listValue.getConfigProperty();
            if (!name.equals(prop.getConfigPropertyName())) continue;
            if (temp.equals(prop)) {
                return;
            }
            changed = true;
            break;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Config Property <" + name + "> already exists.\n Would you like to save the changes and modify this Config Property?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyProp(listValue, type, value, descr);
            }
            this.clearFields();
            return;
        }
        this.model.addElement(new ListValues(temp, 2));
    }

    private void modifyProp(ListValues prop, String type, String value, String descr) {
        if (prop == null) {
            return;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        if (!(this.madeFrom != 2 && this.madeFrom != 3 && this.madeFrom != 4 || prop.getConfigProperty().getConfigPropertyValue() == null || prop.getConfigProperty().getConfigPropertyValue().equals("") || value != null && !value.equals(""))) {
            JOptionPane.showMessageDialog(this.mainFrame, "Deleting Config Property Value is not allowed.\n Old value is reset.", "Warning", 2);
            ((JTextComponent)this.valueTextField).setText(prop.getConfigProperty().getConfigPropertyValue());
            return;
        }
        prop.getConfigProperty().setConfigPropertyType(type);
        prop.getConfigProperty().setConfigPropertyValue(value);
        prop.getConfigProperty().setDescription(descr);
    }

    private void removeProp(ListValues prop) {
        if (prop == null) {
            return;
        }
        this.model.removeElement(prop);
    }

    public void setConfigProperties(ConfigProperty[] configProps) {
        this.props = configProps;
        this.clearFields();
        this.checkDefaultProperties();
        this.initList(configProps);
        if (this.madeFrom == 2 || this.madeFrom == 3 || this.madeFrom == 4) {
            this.missNotValuedDefaultProperties();
        }
    }

    public ConfigProperty[] getConfigProperties() {
        return this.props;
    }

    private void checkDefaultProperties() {
        if (this.props == null || this.props.length == 0) {
            return;
        }
        ConfigProperty prop = null;
        String name = null;
        int i = 0;
        while (i < this.props.length) {
            prop = this.props[i];
            if (prop != null && (name = prop.getConfigPropertyName()) != null && !name.equals("")) {
                if (name.equals("ServerName")) {
                    this.defaultProps[0] = prop;
                } else if (name.equals("PortNumber")) {
                    this.defaultProps[1] = prop;
                } else if (name.equals("UserName")) {
                    this.defaultProps[2] = prop;
                } else if (name.equals("Password")) {
                    this.defaultProps[3] = prop;
                } else if (name.equals("ConnectionURL")) {
                    this.defaultProps[4] = prop;
                }
            }
            ++i;
        }
    }

    private void missNotValuedDefaultProperties() {
        if (this.model.isEmpty()) {
            return;
        }
        ConfigProperty property = null;
        Vector temp = new Vector();
        int i = 0;
        while (i < this.model.size()) {
            if ((ListValues)this.model.elementAt(i) != null && (property = ((ListValues)this.model.elementAt(i)).getConfigProperty()) != null && property.getConfigPropertyName() != null && !property.getConfigPropertyName().equals("")) {
                temp.addElement(this.model.elementAt(i));
            }
            ++i;
        }
        this.model.clear();
        int i2 = 0;
        while (i2 < temp.size()) {
            this.model.addElement(temp.elementAt(i2));
            ++i2;
        }
    }

    private void showProp(ListValues prop) {
        if (prop == null || prop.getConfigProperty() == null || prop.getConfigProperty().getConfigPropertyName() == null || prop.getConfigProperty().getConfigPropertyName().equals("")) {
            return;
        }
        ConfigProperty configProp = prop.getConfigProperty();
        this.nameTextField.setSelectedItem(configProp.getConfigPropertyName());
        if (((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim().equals("")) {
            ((JTextField)this.nameTextField.getEditor().getEditorComponent()).setText(configProp.getConfigPropertyName());
        }
        this.typeComboBox.setSelectedItem(configProp.getConfigPropertyType());
        String name = configProp.getConfigPropertyName();
        if (configProp.getConfigPropertyValue() == null) {
            ((JTextComponent)this.valueTextField).setText("");
        } else {
            ((JTextComponent)this.valueTextField).setText(configProp.getConfigPropertyValue());
        }
        if (configProp.getDescription() == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(configProp.getDescription());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.isRemoveAction) {
            return;
        }
        int selected = -1;
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.propertiesList.isSelectionEmpty()) {
                selected = this.propertiesList.getSelectedIndex();
                this.showProp((ListValues)this.model.get(selected));
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            this.lastSelected = selected;
        }
    }

    private void checkPanel() {
        String name = null;
        String type = null;
        String value = null;
        String descr = null;
        if (!((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim().equals("")) {
            name = ((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!this.getText(this.valueTextField).equals("")) {
            value = this.getText(this.valueTextField);
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (name == null || type == null) {
            return;
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        ListValues listValue = null;
        ConfigProperty prop = null;
        ConfigProperty temp = new ConfigProperty(name, type, value, descr);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            prop = listValue.getConfigProperty();
            if (!name.equals(prop.getConfigPropertyName())) continue;
            if (temp.equals(prop)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Config Property <" + name + "> was changed.\n Would you like to save the changes and modify this Config Property?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyProp(listValue, type, value, descr);
            }
            this.clearFields();
            return;
        }
        if (this.isRemoveAction && (answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Config Property?", "Warning", 0, 2)) == 0) {
            this.addProp(name, type, value, descr);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        String name = null;
        String type = null;
        String value = null;
        String descr = null;
        String cmd = e.getActionCommand();
        if (!((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim().equals("")) {
            name = ((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((String)this.typeComboBox.getSelectedItem()).trim().equals("")) {
            type = ((String)this.typeComboBox.getSelectedItem()).trim();
        }
        if (!this.getText(this.valueTextField).equals("")) {
            value = this.getText(this.valueTextField);
        }
        if (!this.descrPanel.getText().trim().equals("")) {
            descr = this.descrPanel.getText().trim();
        }
        if (!this.checkTypeValueConformity(type, value)) {
            return;
        }
        if (cmd.equals("ADD_CMD")) {
            this.addProp(name, type, value, descr);
            this.propertiesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyProp((ListValues)this.propertiesList.getSelectedValue(), type, value, descr);
            this.propertiesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.isRemoveAction = true;
            this.removeProp((ListValues)this.propertiesList.getSelectedValue());
            this.isRemoveAction = false;
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.propertiesList.clearSelection();
            this.clearFields();
        }
    }

    private boolean checkTypeValueConformity(String type, String value) {
        if (type == null || type.equals("")) {
            return false;
        }
        if (value == null || value.equals("")) {
            return true;
        }
        if (value.startsWith("${")) {
            return true;
        }
        Constructor<?> constructor = null;
        Class<?> clazz = null;
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigPropertiesPanelLogical.class$("java.lang.String")) : class$java$lang$String};
        Character valueObj = null;
        try {
            clazz = Class.forName(type);
            constructor = clazz.getDeclaredConstructor(params);
            valueObj = (Character)constructor.newInstance(value);
            if (type.equals("java.lang.Boolean") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                return false;
            }
        }
        catch (Exception ex) {
            try {
                if (!type.equals("java.lang.Character") || value.length() != 1) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                    return false;
                }
                valueObj = new Character(value.charAt(0));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Value for this Config Property does not conform to its type. Please, specify another value.", "Warning", 2);
                return false;
            }
        }
        return true;
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        if (this.isEditing) {
            return;
        }
        String name = ((JTextField)this.nameTextField.getEditor().getEditorComponent()).getText().trim();
        String type = ((String)this.typeComboBox.getSelectedItem()).trim();
        String value = this.getText(this.valueTextField);
        String descr = this.descrPanel.getText().trim();
        if (name.equals("") && type.equals("java.lang.String") && value.equals("") && descr.equals("") && this.propertiesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
            if (name.equalsIgnoreCase("password")) {
                this.valueTextField.setEchoChar('*');
            } else {
                this.valueTextField.setEchoChar('\u0000');
            }
        }
        if (!name.equals("")) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        ((JTextField)this.nameTextField.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.nameTextField.setEnabled(true);
        this.typeComboBox.setEnabled(true);
        this.descrPanel.setEnabled(true);
    }

    public int isCorrect() {
        if (this.model.isEmpty()) {
            return 0;
        }
        ConfigProperty prop = null;
        String name = null;
        if (this.madeFrom == 3 || this.madeFrom == 4) {
            int i = 0;
            while (i < this.model.size()) {
                prop = ((ListValues)this.model.get(i)).getConfigProperty();
                name = prop.getConfigPropertyName();
                if (!(name == null || name.equals("") || name.equals("ServerName") || name.equals("PortNumber") || name.equals("UserName") || name.equals("Password") || name.equals("ConnectionURL") || prop.getConfigPropertyValue() != null)) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Value for Config Property < " + name + " > is not specified.", "Warning", 2);
                    return 2;
                }
                ++i;
            }
        }
        return 0;
    }

    public void commitChange() {
        Vector<ConfigProperty> temp = new Vector<ConfigProperty>();
        ConfigProperty property = null;
        if (this.model.size() != 0) {
            int i = 0;
            while (i < this.model.size()) {
                property = ((ListValues)this.model.get(i)).getConfigProperty();
                if (property != null) {
                    if (property.getConfigPropertyValue() != null) {
                        temp.add(property);
                    } else if (!(this.madeFrom == 3 || this.madeFrom == 4 || property.getConfigPropertyName() == null || property.getConfigPropertyName().equals("") || property.getConfigPropertyName().equals("ServerName") || property.getConfigPropertyName().equals("PortNumber") || property.getConfigPropertyName().equals("UserName") || property.getConfigPropertyName().equals("Password") || property.getConfigPropertyName().equals("ConnectionURL"))) {
                        temp.add(property);
                    }
                }
                ++i;
            }
        }
        if (temp.size() != 0) {
            this.props = new ConfigProperty[temp.size()];
            temp.copyInto(this.props);
        } else {
            this.props = null;
        }
    }

    public void clear() {
        this.model.clear();
        this.props = null;
        this.clearFields();
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    private String getText(JPasswordField pwdField) {
        return String.valueOf(pwdField.getPassword()).trim();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("myFrame");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ConfigPropertiesPanelLogical gp = new ConfigPropertiesPanelLogical(frame, 1);
        gp.setConfigProperties(new ConfigProperty[]{new ConfigProperty("Password", "java.lang.String", "PASSWORD", null)});
        frame.getContentPane().add((Component)gp, "Center");
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

