/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.gui.AdditionalSettingsPanel;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;

public class AdditionalSettingsPanelLogical
extends AdditionalSettingsPanel
implements MadeFromConstants {
    private JCDescriptor descriptor = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public AdditionalSettingsPanelLogical(Frame frame, int madeFromConstant) {
        this.setFrame(frame);
        this.aliasesPanel.setFrame(frame);
        this.loadersPanel.setFrame(frame);
        this.init(this.madeFrom);
    }

    public void setDescriptor(JCDescriptor descr) {
        this.descriptor = descr;
        this.clearFields();
        if (this.descriptor.getConnectorJNDIName() != null) {
            this.jndiTextField.setText(this.descriptor.getConnectorJNDIName());
        }
        if (this.descriptor.getAliases() != null) {
            this.aliasesPanel.initList(this.descriptor.getAliases());
        }
        if (this.appProvider != null && this.appProvider.getRoot().toString().endsWith(".ear")) {
            this.listsPanel.remove(this.loadersPanel);
        } else {
            this.listsPanel.add((Component)this.loadersPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            if (this.descriptor.getLoaderReferences() != null) {
                this.loadersPanel.initList(this.descriptor.getLoaderReferences());
            }
        }
        if (this.descriptor.getMaxConnectionsNumber() > 0) {
            this.maxConField.setValue(this.descriptor.getMaxConnectionsNumber());
        }
        if (this.descriptor.getMaxTimeToWaitConnection() > 0) {
            this.timeToWaitField.setValue(this.descriptor.getMaxTimeToWaitConnection());
        }
        if (this.descriptor.getConnectionLifetime() > 0) {
            this.conLifetimeField.setValue(this.descriptor.getConnectionLifetime());
        }
        if (this.descriptor.getRunCleanupThreadTime() > 0) {
            this.runCleanupField.setValue(this.descriptor.getRunCleanupThreadTime());
        }
        if (this.descriptor.getProperties() != null) {
            this.propsEditor.initProperties(this.descriptor.getProperties());
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.descriptor = null;
        this.clearFields();
    }

    public int isCorrect() {
        if (this.propsEditor.getProps() == null) {
            return 0;
        }
        if (this.madeFrom == 3 || this.madeFrom == 4) {
            Properties props = this.propsEditor.getProps();
            String name = null;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (props.getProperty(name) != null && !props.getProperty(name).equals("")) continue;
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Property < " + name + " > is not specified.", "Warning", 2);
                return 2;
            }
        }
        return 0;
    }

    public void commitChange() {
        if (!this.jndiTextField.getText().trim().equals("")) {
            this.descriptor.setConnectorJNDIName(this.jndiTextField.getText().trim());
        } else {
            this.descriptor.setConnectorJNDIName(null);
        }
        if (this.aliasesPanel.getListDataArray() != null && this.aliasesPanel.getListDataArray().length != 0) {
            this.descriptor.setAliases(this.aliasesPanel.getListDataArray());
        } else {
            this.descriptor.setAliases(null);
        }
        if (this.loadersPanel.getListDataArray() != null && this.loadersPanel.getListDataArray().length != 0) {
            this.descriptor.setLoaderReferences(this.loadersPanel.getListDataArray());
        } else {
            this.descriptor.setLoaderReferences(null);
        }
        if (this.maxConField.getValue() > 0) {
            this.descriptor.setMaxConnectionsNumber(this.maxConField.getValue());
        } else {
            this.descriptor.setMaxConnectionsNumber(-1);
        }
        if (this.timeToWaitField.getValue() > 0) {
            this.descriptor.setMaxTimeToWaitConnection(this.timeToWaitField.getValue());
        } else {
            this.descriptor.setMaxTimeToWaitConnection(-1);
        }
        if (this.conLifetimeField.getValue() > 0) {
            this.descriptor.setConnectionLifetime(this.conLifetimeField.getValue());
        } else {
            this.descriptor.setConnectionLifetime(-1);
        }
        if (this.runCleanupField.getValue() > 0) {
            this.descriptor.setRunCleanupThreadTime(this.runCleanupField.getValue());
        } else {
            this.descriptor.setRunCleanupThreadTime(-1);
        }
        if (this.propsEditor.getProps() != null && ((Hashtable)this.propsEditor.getProps()).size() != 0) {
            this.descriptor.setProperties(this.propsEditor.getProps());
        } else {
            this.descriptor.setProperties(null);
        }
        if (this.appProvider != null && !this.appProvider.getRoot().toString().endsWith(".ear")) {
            this.descriptor.setRealApplication(false);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

