/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca.deploy.DeployAdmin;
import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ManagedFactoryProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.SecurityPermission;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ResorceAdapterDescriptorDocument {
    public static final String dtd = "<!DOCTYPE connector PUBLIC '-//Sun Microsystems, Inc.//DTD Connector 1.0//EN' 'http://java.sun.com/dtd/connector_1_0.dtd'>";
    public static final String additional_dtd = "<!DOCTYPE connector-j2ee-engine SYSTEM 'connector-j2ee-engine.dtd'>";
    public static final String CONFIGURED_IDENTITY = "Configured Identity";
    public static final String PRINCIPAL_MAPPING = "Principal Mapping";
    public static final String CALLER_IMPERSONATION = "Caller Impersonation";
    public static final String CREDENTIALS_MAPPING = "Credentials Mapping";
    private String rar_name = null;
    private String prefix = null;
    private Document mainDocument = null;
    private Document addDocument = null;
    private Vector warnings = null;
    private boolean realApp = true;
    private boolean provideAddXml = true;
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca$deploy$descriptor$ResorceAdapterDescriptorDocument;

    public ResorceAdapterDescriptorDocument() {
        this.warnings = new Vector();
    }

    public ResorceAdapterDescriptorDocument(JCDescriptor descriptor) {
        this.rar_name = descriptor.getRarName();
        this.realApp = descriptor.isRealApplication();
        this.prefix = descriptor.getPrefix();
        this.loadDocumentFromDescriptor(descriptor);
        this.loadAdditionalDocumentFromDescriptor(descriptor);
    }

    public void setRarName(String rar_name) {
        this.rar_name = rar_name;
    }

    public String getRarName() {
        return this.rar_name;
    }

    public void setRealApp(boolean realApp) {
        this.realApp = realApp;
    }

    public boolean isRealApp() {
        return this.realApp;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setProvideAdditionalXML(boolean provideAddXml) {
        this.provideAddXml = provideAddXml;
    }

    public boolean provideAdditionalXML() {
        return this.provideAddXml;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setAdditionalDocument(Document doc) {
        this.addDocument = doc;
    }

    public Document getAdditionalDocument() {
        return this.addDocument;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public JCDescriptor loadDescriptorFromDocument(Document document) throws IllegalArgumentException {
        Element elm = document.getDocumentElement();
        return this.loadDescriptorFromDocument(elm);
    }

    public void loadDescriptorAdditionalFromDocument(JCDescriptor descriptor, Document document) throws IllegalArgumentException {
        Element elm = document.getDocumentElement();
        this.loadDescriptorAdditionalFromDocument(descriptor, elm);
    }

    public void loadDescriptorAdditionalFromDocument(JCDescriptor resourceDescriptor, Element elmnt) throws IllegalArgumentException {
        NodeList list = elmnt.getChildNodes();
        Element element = null;
        Element secElement = null;
        Element thirdElement = null;
        String tag = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                BaseIllegalArgumentException billaExc;
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("identity-subject")) {
                    IdentitySubject subject = new IdentitySubject();
                    subject.setWarnings(this.warnings);
                    NodeList identityList = element.getChildNodes();
                    int j = 0;
                    while (j < identityList.getLength()) {
                        if (identityList.item(j).getNodeType() == 1) {
                            int k;
                            secElement = (Element)identityList.item(j);
                            tag = secElement.getTagName();
                            if (tag.equals("caller-principal")) {
                                CallerPrincipal callerPrincipal = new CallerPrincipal();
                                callerPrincipal.setWarnings(this.warnings);
                                NodeList callerPrincipalsList = secElement.getChildNodes();
                                k = 0;
                                while (k < callerPrincipalsList.getLength()) {
                                    if (callerPrincipalsList.item(k).getNodeType() == 1) {
                                        thirdElement = (Element)callerPrincipalsList.item(k);
                                        tag = thirdElement.getTagName();
                                        if (tag.equals("group-name")) {
                                            callerPrincipal.addGroup(this.getTextValue(thirdElement));
                                        } else if (tag.equals("user-name")) {
                                            callerPrincipal.addUserName(this.getTextValue(thirdElement));
                                        } else {
                                            billaExc = new BaseIllegalArgumentException("connector_0314", tag);
                                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                                ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc));
                                            }
                                        }
                                    }
                                    ++k;
                                }
                                subject.setCallerPrincipal(callerPrincipal);
                            } else if (tag.equals("resource-principal")) {
                                ResourcePrincipal resourcePrincipal = new ResourcePrincipal();
                                resourcePrincipal.setWarnings(this.warnings);
                                NodeList resourcePrincipalsList = secElement.getChildNodes();
                                k = 0;
                                while (k < resourcePrincipalsList.getLength()) {
                                    if (resourcePrincipalsList.item(k).getNodeType() == 1) {
                                        thirdElement = (Element)resourcePrincipalsList.item(k);
                                        tag = thirdElement.getTagName();
                                        if (tag.equals("user-name")) {
                                            resourcePrincipal.setUserName(this.getTextValue(thirdElement));
                                        } else if (tag.equals("user-password")) {
                                            if (this.getTextValue(thirdElement) == null) {
                                                resourcePrincipal.setPassword("");
                                            } else {
                                                resourcePrincipal.setPassword(this.getTextValue(thirdElement));
                                            }
                                        } else {
                                            billaExc = new BaseIllegalArgumentException("connector_0314", tag);
                                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                                ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc));
                                            }
                                        }
                                    }
                                    ++k;
                                }
                                subject.setResourcePrincipal(resourcePrincipal);
                            } else {
                                BaseIllegalArgumentException billaExc2 = new BaseIllegalArgumentException("connector_0314", tag);
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc2));
                                }
                            }
                        }
                        ++j;
                    }
                    resourceDescriptor.addIdentitySubject(subject);
                } else if (tag.equals("driver")) {
                    DriverInfo info = new DriverInfo();
                    info.setWarnings(this.warnings);
                    NodeList driversList = element.getChildNodes();
                    int j = 0;
                    while (j < driversList.getLength()) {
                        if (driversList.item(j).getNodeType() == 1) {
                            secElement = (Element)driversList.item(j);
                            tag = secElement.getTagName();
                            if (tag.equals("driver-class-name")) {
                                info.setDriverClassName(this.getTextValue(secElement));
                            } else if (tag.equals("driver-name")) {
                                info.setDriverName(this.getTextValue(secElement));
                            } else if (tag.equals("file-name")) {
                                info.addJar(this.getTextValue(secElement));
                            } else {
                                BaseIllegalArgumentException billaExc3 = new BaseIllegalArgumentException("connector_0314", tag);
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc3));
                                }
                            }
                        }
                        ++j;
                    }
                    resourceDescriptor.addDriver(info);
                } else if (tag.equals("pool-params")) {
                    NodeList poolParamsList = element.getChildNodes();
                    int j = 0;
                    while (j < poolParamsList.getLength()) {
                        if (poolParamsList.item(j).getNodeType() == 1) {
                            secElement = (Element)poolParamsList.item(j);
                            tag = secElement.getTagName();
                            if (tag.equals("max-connections-number")) {
                                int max_conns;
                                try {
                                    max_conns = Integer.parseInt(this.getTextValue(secElement));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new BaseIllegalArgumentException("connector_0307", this.getTextValue(secElement), (Throwable)nfe);
                                }
                                if (max_conns < 0) {
                                    throw new BaseIllegalArgumentException("connector_0307", String.valueOf(max_conns));
                                }
                                resourceDescriptor.setMaxConnectionsNumber(max_conns);
                            } else if (tag.equals("max-time-to-wait-connection")) {
                                int max_ttwc;
                                try {
                                    max_ttwc = Integer.parseInt(this.getTextValue(secElement));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new BaseIllegalArgumentException("connector_0307", this.getTextValue(secElement), (Throwable)nfe);
                                }
                                if (max_ttwc < 0) {
                                    throw new BaseIllegalArgumentException("connector_0308", String.valueOf(max_ttwc));
                                }
                                resourceDescriptor.setMaxTimeToWaitConnection(max_ttwc);
                            } else if (tag.equals("expiration-control")) {
                                NodeList expirationControlList = secElement.getChildNodes();
                                int k = 0;
                                while (k < expirationControlList.getLength()) {
                                    if (expirationControlList.item(k).getNodeType() == 1) {
                                        thirdElement = (Element)expirationControlList.item(k);
                                        tag = thirdElement.getTagName();
                                        if (tag.equals("connection-lifetime")) {
                                            int connLifeTime;
                                            try {
                                                connLifeTime = Integer.parseInt(this.getTextValue(thirdElement));
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new BaseIllegalArgumentException("connector_0309", this.getTextValue(secElement), (Throwable)nfe);
                                            }
                                            if (connLifeTime < 0) {
                                                throw new BaseIllegalArgumentException("connector_0309", String.valueOf(connLifeTime));
                                            }
                                            resourceDescriptor.setConnectionLifetime(connLifeTime);
                                        } else if (tag.equals("run-cleanup-thread")) {
                                            int run_cleanup_thread;
                                            try {
                                                run_cleanup_thread = Integer.parseInt(this.getTextValue(thirdElement));
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new BaseIllegalArgumentException("connector_0310", this.getTextValue(secElement), (Throwable)nfe);
                                            }
                                            if (run_cleanup_thread < 0) {
                                                throw new BaseIllegalArgumentException("connector_0310", String.valueOf(run_cleanup_thread));
                                            }
                                            resourceDescriptor.setRunCleanupThreadTime(run_cleanup_thread);
                                        } else {
                                            BaseIllegalArgumentException billaExc4 = new BaseIllegalArgumentException("connector_0314", tag);
                                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                                ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc4));
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                BaseIllegalArgumentException billaExc5 = new BaseIllegalArgumentException("connector_0314", tag);
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc5));
                                }
                            }
                        }
                        ++j;
                    }
                } else if (tag.equals("connector-group")) {
                    if (resourceDescriptor.isRealApplication()) {
                        this.writeMessage("In case of non standalone application, '<connector-group>' tag is not allowed and will be ignored.");
                    } else {
                        resourceDescriptor.setToDefault("connector-group", false);
                        resourceDescriptor.setConnectorGroup(this.getTextValue(element));
                    }
                } else if (tag.equals("loader-references")) {
                    if (resourceDescriptor.isRealApplication()) {
                        this.writeMessage("In case of non standalone application, '<loader-references>'tag is not allowed and will be ignored.");
                        this.writeMessage("In order to set loader references, please use deploy service or define them in application-j2ee-engine.xml.");
                    } else {
                        NodeList loaderReferencesList = element.getChildNodes();
                        int j = 0;
                        while (j < loaderReferencesList.getLength()) {
                            if (loaderReferencesList.item(j).getNodeType() == 1) {
                                secElement = (Element)loaderReferencesList.item(j);
                                tag = secElement.getTagName();
                                if (tag.equals("loader-name")) {
                                    resourceDescriptor.addLoaderReference(this.getTextValue(secElement));
                                } else {
                                    BaseIllegalArgumentException billaExc6 = new BaseIllegalArgumentException("connector_0314", tag);
                                    if (ConnectorResourceAccessor.location.beLogged(300)) {
                                        ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc6));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                } else if (tag.equals("jndi-name")) {
                    resourceDescriptor.setToDefault("jndi-name", false);
                    resourceDescriptor.setConnectorJNDIName(this.getTextValue(element));
                } else if (tag.equals("alias")) {
                    resourceDescriptor.addAlias(this.getTextValue(element));
                } else if (tag.equals("user-store")) {
                    resourceDescriptor.setUserStore(this.getTextValue(element));
                } else if (tag.equals("authentication-type")) {
                    String authType = this.getTextValue(element);
                    if (authType == null || "".equals(authType) || !authType.equalsIgnoreCase(CONFIGURED_IDENTITY) && !authType.equalsIgnoreCase(PRINCIPAL_MAPPING) && !authType.equalsIgnoreCase(CALLER_IMPERSONATION) && !authType.equalsIgnoreCase(CREDENTIALS_MAPPING)) {
                        throw new BaseIllegalArgumentException("connector_0303", new String[]{"authentication-type", "configured identity, principal mapping, caller impersonation or credentials mapping."});
                    }
                    resourceDescriptor.setAuthenticationType(authType);
                } else if (tag.equals("properties")) {
                    Properties props = new Properties();
                    String propertyName = null;
                    NodeList propertiesList = element.getChildNodes();
                    NodeList tempList = null;
                    int j = 0;
                    while (j < propertiesList.getLength()) {
                        if (propertiesList.item(j).getNodeType() == 1) {
                            secElement = (Element)propertiesList.item(j);
                            tag = secElement.getTagName();
                            if (tag.equals("property")) {
                                tempList = secElement.getChildNodes();
                                int k = 0;
                                while (k < tempList.getLength()) {
                                    if (tempList.item(k).getNodeType() == 1) {
                                        thirdElement = (Element)tempList.item(k);
                                        tag = thirdElement.getTagName();
                                        if (tag.equals("property-name")) {
                                            propertyName = this.getTextValue(thirdElement);
                                        } else if (tag.equals("property-value")) {
                                            if (propertyName != null) {
                                                props.setProperty(propertyName, this.getTextValue(thirdElement));
                                                propertyName = null;
                                            } else {
                                                this.writeMessage("Warning : trying to add invalid property.");
                                            }
                                        } else {
                                            billaExc = new BaseIllegalArgumentException("connector_0314", tag);
                                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                                ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc));
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                BaseIllegalArgumentException billaExc7 = new BaseIllegalArgumentException("connector_0314", tag);
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc7));
                                }
                            }
                        }
                        ++j;
                    }
                    resourceDescriptor.setProperties(props);
                } else {
                    BaseIllegalArgumentException billaExc8 = new BaseIllegalArgumentException("connector_0314", tag);
                    if (ConnectorResourceAccessor.location.beLogged(300)) {
                        ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(billaExc8));
                    }
                }
            }
            ++i;
        }
        this.validateAdditionalXML(resourceDescriptor);
    }

    public JCDescriptor loadDescriptorFromDocument(Element elmnt) throws IllegalArgumentException {
        NodeList list = elmnt.getChildNodes();
        JCDescriptor resourceDescriptor = new JCDescriptor();
        resourceDescriptor.setRarName(this.rar_name);
        resourceDescriptor.setRealApplication(this.realApp);
        resourceDescriptor.setPrefix(this.prefix);
        resourceDescriptor.setWarnings(this.warnings);
        Element element = null;
        String tag = null;
        String value = null;
        ManagedFactoryProperty managedFactoryProperty = new ManagedFactoryProperty();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                int k;
                String nextElTag;
                Element nextEl;
                NodeList paramsList;
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("resourceadapter")) {
                    paramsList = element.getChildNodes();
                    if (paramsList != null) {
                        nextEl = null;
                        nextElTag = null;
                        k = 0;
                        while (k < paramsList.getLength()) {
                            if (paramsList.item(k).getNodeType() == 1) {
                                int p;
                                String nextSecElTag;
                                Element nextSecEl;
                                NodeList paramsSecList;
                                nextEl = (Element)paramsList.item(k);
                                nextElTag = nextEl.getNodeName();
                                if (nextElTag.equals("managedconnectionfactory-class")) {
                                    resourceDescriptor.setManagedConnectionFactoryClass(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("authentication-mechanism")) {
                                    NodeList paramsAuthList = nextEl.getChildNodes();
                                    if (paramsAuthList != null) {
                                        Element nextAuthEl = null;
                                        String nextAuthElTag = null;
                                        AuthMechanism authMechanism = new AuthMechanism();
                                        authMechanism.setWarnings(this.warnings);
                                        int j = 0;
                                        while (j < paramsAuthList.getLength()) {
                                            if (paramsAuthList.item(j).getNodeType() == 1) {
                                                nextAuthEl = (Element)paramsAuthList.item(j);
                                                nextAuthElTag = nextAuthEl.getNodeName();
                                                if (nextAuthElTag.equals("description")) {
                                                    authMechanism.setDescription(this.getTextValue(nextAuthEl));
                                                } else if (nextAuthElTag.equals("credential-interface")) {
                                                    value = this.getTextValue(nextAuthEl);
                                                    authMechanism.setCredentialInterface(value);
                                                } else if (nextAuthElTag.equals("authentication-mechanism-type")) {
                                                    value = this.getTextValue(nextAuthEl);
                                                    authMechanism.setAuthMechType(value);
                                                }
                                            }
                                            ++j;
                                        }
                                        resourceDescriptor.addAuthMechanism(authMechanism);
                                    }
                                } else if (nextElTag.equals("reauthentication-support")) {
                                    value = this.getTextValue(nextEl);
                                    if (value == null || !value.equals("true") && !value.equals("false")) {
                                        throw new BaseIllegalArgumentException("connector_0303", new String[]{"reauthentication-support", "true or false."});
                                    }
                                    resourceDescriptor.setReauthenticationSupport(value.equals("true"));
                                } else if (nextElTag.equals("connectionfactory-interface")) {
                                    resourceDescriptor.setConnectionFactoryInterface(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("connectionfactory-impl-class")) {
                                    resourceDescriptor.setConnectionFactoryImplClass(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("connection-interface")) {
                                    resourceDescriptor.setConnectionInterface(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("connection-impl-class")) {
                                    resourceDescriptor.setConnectionImplClass(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("transaction-support")) {
                                    value = this.getTextValue(nextEl);
                                    if (value == null || "".equals(value) || !value.equals("NoTransaction") && !value.equals("LocalTransaction") && !value.equals("XATransaction")) {
                                        throw new BaseIllegalArgumentException("connector_0303", new String[]{"transaction-support.", "NoTransaction, LocalTransaction or XATransaction."});
                                    }
                                    resourceDescriptor.setTransactionSupport(value);
                                } else if (nextElTag.equals("config-property")) {
                                    paramsSecList = nextEl.getChildNodes();
                                    if (paramsSecList != null) {
                                        nextSecEl = null;
                                        nextSecElTag = null;
                                        ConfigProperty configProperty = new ConfigProperty();
                                        p = 0;
                                        while (p < paramsSecList.getLength()) {
                                            if (paramsSecList.item(p).getNodeType() == 1) {
                                                nextSecEl = (Element)paramsSecList.item(p);
                                                nextSecElTag = nextSecEl.getNodeName();
                                                if (nextSecElTag.equals("description")) {
                                                    configProperty.setDescription(this.getTextValue(nextSecEl));
                                                } else if (nextSecElTag.equals("config-property-name")) {
                                                    configProperty.setConfigPropertyName(this.getTextValue(nextSecEl));
                                                } else if (nextSecElTag.equals("config-property-type")) {
                                                    value = this.getTextValue(nextSecEl);
                                                    if (!(value != null && (value.equals("java.lang.Boolean") || value.equals("java.lang.Byte") || value.equals("java.lang.Character") || value.equals("java.lang.Double") || value.equals("java.lang.Float") || value.equals("java.lang.Integer") || value.equals("java.lang.Long") || value.equals("java.lang.Short") || value.equals("java.lang.String")))) {
                                                        throw new BaseIllegalArgumentException("connector_0303", new String[]{"config-property-type.", "java.lang.Boolean, java.lang.Byte, java.lang.Character, java.lang.Double, java.lang.Float, java.lang.Integer, java.lang.Long, java.lang.Short or java.lang.String."});
                                                    }
                                                    configProperty.setConfigPropertyType(value);
                                                } else if (nextSecElTag.equals("config-property-value")) {
                                                    configProperty.setConfigPropertyValue(this.getTextValue(nextSecEl));
                                                }
                                            }
                                            ++p;
                                        }
                                        managedFactoryProperty.addConfigProperty(configProperty);
                                    }
                                } else if (nextElTag.equals("security-permission") && (paramsSecList = nextEl.getChildNodes()) != null) {
                                    nextSecEl = null;
                                    nextSecElTag = null;
                                    SecurityPermission securityPermission = new SecurityPermission();
                                    p = 0;
                                    while (p < paramsSecList.getLength()) {
                                        if (paramsSecList.item(p).getNodeType() == 1) {
                                            nextSecEl = (Element)paramsSecList.item(p);
                                            nextSecElTag = nextSecEl.getNodeName();
                                            if (nextSecElTag.equals("description")) {
                                                securityPermission.setDescription(this.getTextValue(nextSecEl));
                                            } else if (nextSecElTag.equals("security-permission-spec")) {
                                                securityPermission.setSecurityPermissionSpec(this.getTextValue(nextSecEl));
                                            }
                                        }
                                        ++p;
                                    }
                                    resourceDescriptor.addSecurityPermission(securityPermission);
                                }
                            }
                            ++k;
                        }
                    }
                } else if (tag.equals("display-name")) {
                    resourceDescriptor.setDisplayName(this.getTextValue(element));
                } else if (tag.equals("description")) {
                    resourceDescriptor.setDescription(this.getTextValue(element));
                } else if (tag.equals("eis-type")) {
                    resourceDescriptor.setEisType(this.getTextValue(element));
                } else if (tag.equals("icon")) {
                    NodeList iconList = element.getChildNodes();
                    if (iconList != null) {
                        Element nextIconEl = null;
                        String nextIconElTag = null;
                        int l = 0;
                        while (l < iconList.getLength()) {
                            if (iconList.item(l).getNodeType() == 1) {
                                nextIconEl = (Element)iconList.item(l);
                                nextIconElTag = nextIconEl.getNodeName();
                                if (nextIconElTag.equals("small-icon")) {
                                    value = this.getTextValue(nextIconEl);
                                    if (value != null) {
                                        resourceDescriptor.setSmallIcon(new SerializableFile(new File(value)));
                                    }
                                } else if (nextIconElTag.equals("large-icon") && (value = this.getTextValue(nextIconEl)) != null) {
                                    resourceDescriptor.setLargeIcon(new SerializableFile(new File(value)));
                                }
                            }
                            ++l;
                        }
                    }
                } else if (tag.equals("license")) {
                    paramsList = element.getChildNodes();
                    if (paramsList != null) {
                        nextEl = null;
                        nextElTag = null;
                        k = 0;
                        while (k < paramsList.getLength()) {
                            if (paramsList.item(k).getNodeType() == 1) {
                                nextEl = (Element)paramsList.item(k);
                                nextElTag = nextEl.getNodeName();
                                if (nextElTag.equals("description")) {
                                    resourceDescriptor.setLicenseDescription(this.getTextValue(nextEl));
                                } else if (nextElTag.equals("license-required")) {
                                    value = this.getTextValue(nextEl);
                                    if (value == null || !value.equals("true") && !value.equals("false")) {
                                        throw new BaseIllegalArgumentException("connector_0303", new String[]{"license-required.", "true or false."});
                                    }
                                    resourceDescriptor.setLicenseRequired(value.equals("true"));
                                }
                            }
                            ++k;
                        }
                    }
                } else if (tag.equals("spec-version")) {
                    resourceDescriptor.setSpecVersion(this.getTextValue(element));
                } else if (tag.equals("vendor-name")) {
                    resourceDescriptor.setVendorName(this.getTextValue(element));
                } else if (tag.equals("version")) {
                    resourceDescriptor.setVersion(this.getTextValue(element));
                }
            }
            ++i;
        }
        resourceDescriptor.setRarName(this.rar_name);
        managedFactoryProperty.setManagedFactoryPropertyName(this.rar_name);
        resourceDescriptor.setManagedFactoryProperty(managedFactoryProperty);
        this.validateXML(resourceDescriptor);
        this.validateAdditionalXML(resourceDescriptor);
        return resourceDescriptor;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    protected void validateXML(JCDescriptor resourceDescriptor) throws IllegalArgumentException {
        if (resourceDescriptor.getTransactionLevel() == -1) {
            throw new BaseIllegalArgumentException("connector_0311", new String[]{"transaction-support", "ra.xml"});
        }
    }

    protected void validateAdditionalXML(JCDescriptor resourceDescriptor) throws IllegalArgumentException {
        IdentitySubject[] subjs;
        resourceDescriptor.setProvideAdditionalXML(this.provideAddXml);
        String authType = resourceDescriptor.getAuthenticationType();
        String message = null;
        if (resourceDescriptor.getConnectorJNDIName() == null) {
            if (this.rar_name != null) {
                resourceDescriptor.setToDefault("jndi-name", true);
                resourceDescriptor.setConnectorJNDIName(this.rar_name.substring(0, this.rar_name.length() - 4));
            } else if (this.warnings != null) {
                this.writeMessage("Rar name not specified.");
            }
        } else {
            ManagedFactoryProperty mfp = resourceDescriptor.getManagedFactoryProperty();
            if (mfp != null) {
                mfp.setManagedFactoryPropertyName(resourceDescriptor.getConnectorJNDIName());
            }
        }
        if (resourceDescriptor.getDisplayName() == null) {
            resourceDescriptor.setToDefault("display-name", true);
            resourceDescriptor.setDisplayName(resourceDescriptor.getConnectorJNDIName());
        }
        String connector_group = resourceDescriptor.getConnectorGroup();
        if (!resourceDescriptor.isRealApplication() && connector_group == null) {
            resourceDescriptor.setToDefault("connector-group", true);
            resourceDescriptor.setConnectorGroup("default");
        }
        if (authType == null) {
            if (resourceDescriptor.getIdentitySubjects() != null && resourceDescriptor.getIdentitySubjects().length != 0) {
                throw new BaseIllegalArgumentException("connector_0305", new String[]{"authentication-type", "identity-subject"});
            }
            return;
        }
        AuthMechanism[] authMechs = resourceDescriptor.getAuthMechanisms();
        boolean isSAPLogon = this.checkForSapLogon(authMechs);
        if (authType.equalsIgnoreCase(CONFIGURED_IDENTITY)) {
            if (resourceDescriptor.getUserStore() == null) {
                message = CONFIGURED_IDENTITY;
            }
            if ((subjs = resourceDescriptor.getIdentitySubjects()) == null || subjs.length == 0) {
                throw new BaseIllegalArgumentException("connector_0304", new String[]{CONFIGURED_IDENTITY, "identity-subject"});
            }
            int i = 0;
            while (i < subjs.length) {
                CallerPrincipal caller = subjs[i].getCallerPrincipal();
                ResourcePrincipal resPrincipal = subjs[i].getResourcePrincipal();
                if (caller != null && (caller.getGroups() != null || caller.getUserNames() != null)) {
                    this.writeMessage("In case of 'Configured Identity' authentication-type, caller-principal tag is not allowed and will be ignored.");
                    if (caller != null) {
                        caller.setUserNames(null);
                        caller.setGroups(null);
                    }
                }
                if (message == null) {
                    if (resPrincipal != null && resPrincipal.getPassword() != null) {
                        this.writeMessage("In case of 'Configured Identity' authentication-type, user-password tag in scope of resource-principal tag is not allowed and will be ignored.");
                        resPrincipal.password = null;
                    }
                } else if (resPrincipal != null) {
                    if (resPrincipal.getPassword() == null && !isSAPLogon) {
                        throw new BaseIllegalArgumentException("connector_0304", new String[]{message, ", when user-store tag missing, user-password tag in scope of resource-principal"});
                    }
                } else {
                    throw new BaseIllegalArgumentException("connector_0304", new String[]{CONFIGURED_IDENTITY, "resource-principal"});
                }
                ++i;
            }
        } else if (authType.equalsIgnoreCase(PRINCIPAL_MAPPING)) {
            if (resourceDescriptor.getUserStore() == null) {
                message = PRINCIPAL_MAPPING;
            }
            if ((subjs = resourceDescriptor.getIdentitySubjects()) == null || subjs.length == 0) {
                throw new BaseIllegalArgumentException("connector_0304", new String[]{PRINCIPAL_MAPPING, "identity-subject"});
            }
            boolean local_succeed = false;
            int i = 0;
            while (i < subjs.length) {
                CallerPrincipal caller = subjs[i].getCallerPrincipal();
                ResourcePrincipal resPrincipal = subjs[i].getResourcePrincipal();
                if (caller == null || (caller.getGroups() == null || caller.getGroups().isEmpty()) && (caller.getUserNames() == null || caller.getUserNames().isEmpty())) {
                    this.writeMessage("In case of 'Principal Mapping' authentication-type, caller-principal tag is requisite.");
                } else {
                    local_succeed = true;
                }
                if (message == null) {
                    if (resPrincipal != null && resPrincipal.getPassword() != null) {
                        this.writeMessage("In case of 'Principal Mapping' authentication-type, user-password tag in scope of resource-principal tag is not allowed and will be ignored.");
                        if (resPrincipal != null) {
                            resPrincipal.password = null;
                        }
                    }
                } else if (resPrincipal != null) {
                    if (resPrincipal.getPassword() == null && !isSAPLogon) {
                        throw new BaseIllegalArgumentException("connector_0304", new String[]{message, ", when user-store tag missing, user-password tag in scope of resource-principal"});
                    }
                } else {
                    throw new BaseIllegalArgumentException("connector_0304", new String[]{PRINCIPAL_MAPPING, "resource-principal"});
                }
                ++i;
            }
            if (!local_succeed) {
                throw new BaseIllegalArgumentException("connector_0304", new String[]{PRINCIPAL_MAPPING, "caller-principal"});
            }
        } else {
            if (authType.equalsIgnoreCase(CALLER_IMPERSONATION)) {
                IdentitySubject[] subjs2;
                if (resourceDescriptor.getUserStore() != null) {
                    this.writeMessage("In case of 'Caller Impersonation' authentication-type, user-store tag is not allowed and will be ignored.");
                    resourceDescriptor.setUserStore(null);
                }
                if ((subjs2 = resourceDescriptor.getIdentitySubjects()) != null) {
                    if (subjs2.length != 0) {
                        this.writeMessage("In case of 'Caller Impersonation' authentication-type, identity-subject tag is not allowed and will be ignored.");
                    }
                    resourceDescriptor.setIdentitySubjects(null);
                }
                return;
            }
            if (resourceDescriptor.getUserStore() == null && !isSAPLogon) {
                throw new BaseIllegalArgumentException("connector_0304", new String[]{CREDENTIALS_MAPPING, "user-store"});
            }
            IdentitySubject[] subjs3 = resourceDescriptor.getIdentitySubjects();
            if (subjs3 != null) {
                if (subjs3.length != 0) {
                    this.writeMessage("In case of 'Credentials Mapping' authentication-type, identity-subject tag is not allowed and will be ignored.");
                }
                resourceDescriptor.setIdentitySubjects(null);
            }
            return;
        }
        String userStore = resourceDescriptor.getUserStore();
        if (userStore == null && (authType.equalsIgnoreCase(CONFIGURED_IDENTITY) || authType.equalsIgnoreCase(PRINCIPAL_MAPPING))) {
            resourceDescriptor.setInternalUserStore(true);
            resourceDescriptor.setUserStore(DeployAdmin.fixName(DeployAdmin.makeConnectorName(resourceDescriptor)));
        }
    }

    public Document loadDocumentFromDescriptor(JCDescriptor descriptor) {
        ClassLoader previousLoader = null;
        try {
            try {
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.mainDocument = StandardDOMParser.createDocument();
                this.mainDocument.appendChild(this.loadDocumentElement(descriptor, this.mainDocument));
            }
            catch (DOMException ex) {
                ConnectorServiceFrame.logException(ex);
                throw new IllegalStateException(Log.getStackTrace(ex));
            }
            Object var5_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
        return this.mainDocument;
    }

    public Document loadAdditionalDocumentFromDescriptor(JCDescriptor descriptor) {
        ClassLoader previousLoader = null;
        try {
            try {
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.addDocument = StandardDOMParser.createDocument();
                this.addDocument.appendChild(this.loadAdditionalDocumentElement(descriptor, this.addDocument));
            }
            catch (DOMException ex) {
                ConnectorServiceFrame.logException(ex);
                throw new IllegalStateException(Log.getStackTrace(ex));
            }
            Object var5_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
        return this.addDocument;
    }

    private Element loadAdditionalDocumentElement(JCDescriptor descriptor, Document addDocument) {
        if (!this.provideAdditionalXML()) {
            // empty if block
        }
        Element docElement = null;
        String authType = descriptor.getAuthenticationType();
        try {
            docElement = addDocument.createElement("connector-j2ee-engine");
            if (descriptor.getConnectorJNDIName() != null && !descriptor.isSetToDefault("jndi-name")) {
                this.loadAdditional(docElement, descriptor.getConnectorJNDIName(), "jndi-name");
            }
            this.loadAliases(docElement, descriptor);
            if (authType != null) {
                this.loadAdditional(docElement, authType, "authentication-type");
            } else if (descriptor.getIdentitySubjects() != null && descriptor.getIdentitySubjects().length != 0) {
                throw new BaseIllegalArgumentException("connector_0305", new String[]{"authentication-type", "identity-subject"});
            }
            AuthMechanism[] authMechs = descriptor.getAuthMechanisms();
            boolean isSAPLogon = this.checkForSapLogon(authMechs);
            if (descriptor.getUserStore() != null && !descriptor.isInternalUserStore()) {
                if (!authType.equalsIgnoreCase(CALLER_IMPERSONATION)) {
                    this.loadAdditional(docElement, descriptor.getUserStore(), "user-store");
                } else {
                    this.writeMessage("In case of 'Caller Impersonation' authentication-type, user-store tag is not allowed and will be ignored.");
                }
            } else if (CREDENTIALS_MAPPING.equalsIgnoreCase(authType) && !isSAPLogon) {
                throw new BaseIllegalArgumentException("connector_0304", new String[]{CREDENTIALS_MAPPING, "user-store"});
            }
            this.loadIdentitySubject(docElement, descriptor);
            this.loadDriver(docElement, descriptor);
            this.loadPoolParams(docElement, descriptor);
            if (!descriptor.isRealApplication() && !descriptor.isSetToDefault("connector-group")) {
                this.loadAdditional(docElement, descriptor.getConnectorGroup(), "connector-group");
            }
            this.loadLoaderReferences(docElement, descriptor);
            this.loadProperties(docElement, descriptor);
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
            if (exc instanceof BaseIllegalArgumentException) {
                throw (BaseIllegalArgumentException)exc;
            }
            throw new IllegalStateException(Log.getStackTrace(exc));
        }
        return docElement;
    }

    private void loadAliases(Element docElement, JCDescriptor descriptor) {
        String[] aliases = descriptor.getAliases();
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                if (aliases[i] != null) {
                    this.loadAdditional(docElement, aliases[i], "alias");
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadIdentitySubject(Element docElement, JCDescriptor descriptor) throws IllegalArgumentException {
        block8: {
            subjects = descriptor.getIdentitySubjects();
            authType = descriptor.getAuthenticationType();
            if (subjects == null) break block8;
            i = 0;
            while (i < subjects.length) {
                block9: {
                    tempElement = this.addDocument.createElement("identity-subject");
                    if (!authType.equalsIgnoreCase("Principal Mapping")) break block9;
                    this.loadCallerPrincipals(tempElement, subjects[i]);
                    if (descriptor.getUserStore() == null) {
                        this.loadResourcePrincipal(tempElement, subjects[i], authType, true);
                    } else {
                        this.loadResourcePrincipal(tempElement, subjects[i], authType, false);
                    }
                    ** GOTO lbl25
                }
                if (authType.equalsIgnoreCase("Configured Identity")) {
                    if (descriptor.getUserStore() == null) {
                        this.loadResourcePrincipal(tempElement, subjects[i], authType, true);
                    } else {
                        this.loadResourcePrincipal(tempElement, subjects[i], authType, false);
                    }
                }
                if (subjects[i].getCallerPrincipal() == null) ** GOTO lbl25
                if (authType.equalsIgnoreCase("Caller Impersonation")) {
                    this.writeMessage("In case of '" + descriptor.getAuthenticationType() + "' identity-subject tag is not allowed and will be ignored.");
                } else {
                    this.writeMessage("In case of '" + descriptor.getAuthenticationType() + "' caller-principal tag is not allowed and will be ignored.");
lbl25:
                    // 4 sources

                    docElement.appendChild(tempElement);
                }
                ++i;
            }
        }
    }

    private void loadCallerPrincipals(Element subjectElement, IdentitySubject subject) throws IllegalArgumentException {
        HashSet userNames;
        String tempName;
        CallerPrincipal caller = subject.getCallerPrincipal();
        Element tempElement = this.addDocument.createElement("caller-principal");
        if (caller == null) {
            throw new BaseIllegalArgumentException("connector_0306", "caller principal");
        }
        HashSet groups = caller.getGroups();
        if (groups != null) {
            Iterator groupIter = groups.iterator();
            while (groupIter.hasNext()) {
                tempName = (String)groupIter.next();
                if (tempName != null) {
                    this.loadAdditional(tempElement, tempName, "group-name");
                    continue;
                }
                throw new BaseIllegalArgumentException("connector_0306", "group name");
            }
        }
        if ((userNames = caller.getUserNames()) != null) {
            Iterator usersIter = userNames.iterator();
            while (usersIter.hasNext()) {
                tempName = (String)usersIter.next();
                if (tempName != null) {
                    this.loadAdditional(tempElement, tempName, "user-name");
                    continue;
                }
                throw new BaseIllegalArgumentException("connector_0306", "user name");
            }
        } else if (groups == null) {
            throw new BaseIllegalArgumentException("connector_0306", "groups and users");
        }
        subjectElement.appendChild(tempElement);
    }

    private void loadResourcePrincipal(Element subjectElement, IdentitySubject subject, String authType, boolean passRequired) throws IllegalArgumentException {
        String tempName = null;
        Element tempElement = null;
        ResourcePrincipal principal = subject.getResourcePrincipal();
        if (principal != null) {
            tempElement = this.addDocument.createElement("resource-principal");
            tempName = principal.getUserName();
            if (tempName == null) {
                throw new BaseIllegalArgumentException("connector_0306", "user name");
            }
            this.loadAdditional(tempElement, tempName, "user-name");
            tempName = principal.getPassword();
            if (tempName == null) {
                if (passRequired) {
                    throw new BaseIllegalArgumentException("connector_0306", "password");
                }
                this.writeMessage("In case of '" + authType + "' authentication type, user-password tag is not allowed and will be ignored.");
            } else {
                this.loadAdditional(tempElement, tempName, "user-password");
            }
        } else {
            throw new BaseIllegalArgumentException("connector_0311", new String[]{"resource principal", "connector-j2ee-engine.xml"});
        }
        subjectElement.appendChild(tempElement);
    }

    private void loadDriver(Element docElement, JCDescriptor descriptor) throws IllegalArgumentException {
        DriverInfo[] drivers = descriptor.getDrivers();
        if (drivers != null) {
            int i = 0;
            while (i < drivers.length) {
                Element tempElement;
                DriverInfo info = drivers[i];
                if (info != null) {
                    String tempName = info.getDriverName();
                    if (tempName == null) {
                        throw new BaseIllegalArgumentException("connector_0306", "driver name");
                    }
                    tempElement = this.addDocument.createElement("driver");
                    this.loadAdditional(tempElement, tempName, "driver-name");
                    tempName = info.getDriverClassName();
                    if (tempName == null) {
                        throw new BaseIllegalArgumentException("connector_0306", "driver class name");
                    }
                    this.loadAdditional(tempElement, tempName, "driver-class-name");
                    HashSet jars = info.getJars();
                    if (jars != null) {
                        Iterator jarsIter = jars.iterator();
                        while (jarsIter.hasNext()) {
                            tempName = (String)jarsIter.next();
                            this.loadAdditional(tempElement, tempName, "file-name");
                        }
                    }
                } else {
                    throw new BaseIllegalArgumentException("connector_0306", "driver info");
                }
                docElement.appendChild(tempElement);
                ++i;
            }
        }
    }

    private void loadPoolParams(Element docElement, JCDescriptor descriptor) throws IllegalArgumentException {
        Element poolParamsElement = null;
        Element expirationControlElement = null;
        int value = descriptor.getMaxConnectionsNumber();
        if (value != -1) {
            poolParamsElement = this.addDocument.createElement("pool-params");
            this.loadAdditional(poolParamsElement, String.valueOf(value), "max-connections-number");
        }
        if ((value = descriptor.getMaxTimeToWaitConnection()) != -1) {
            if (poolParamsElement == null) {
                poolParamsElement = this.addDocument.createElement("pool-params");
            }
            this.loadAdditional(poolParamsElement, String.valueOf(value), "max-time-to-wait-connection");
        }
        if ((value = descriptor.getConnectionLifetime()) != -1) {
            if (poolParamsElement == null) {
                poolParamsElement = this.addDocument.createElement("pool-params");
            }
            expirationControlElement = this.addDocument.createElement("expiration-control");
            poolParamsElement.appendChild(expirationControlElement);
            this.loadAdditional(expirationControlElement, String.valueOf(value), "connection-lifetime");
        }
        if ((value = descriptor.getRunCleanupThreadTime()) != -1) {
            if (poolParamsElement == null) {
                poolParamsElement = this.addDocument.createElement("pool-params");
            }
            if (expirationControlElement == null) {
                expirationControlElement = this.addDocument.createElement("expiration-control");
                poolParamsElement.appendChild(expirationControlElement);
            }
            this.loadAdditional(expirationControlElement, String.valueOf(value), "run-cleanup-thread");
        }
        if (poolParamsElement != null) {
            docElement.appendChild(poolParamsElement);
        }
    }

    private void loadLoaderReferences(Element docElement, JCDescriptor descriptor) throws IllegalArgumentException {
        if (descriptor.isRealApplication()) {
            this.writeMessage("In case of real application, loader references are not allowed and will be ignored.\nIn order to set loader references, please use deploy service or define them in application-j2ee-engine.xml.");
            return;
        }
        String[] loaderReferences = descriptor.getLoaderReferences();
        Element loaderReferencesElement = null;
        if (loaderReferences != null) {
            loaderReferencesElement = this.addDocument.createElement("loader-references");
            int i = 0;
            while (i < loaderReferences.length) {
                this.loadAdditional(loaderReferencesElement, loaderReferences[i], "loader-name");
                ++i;
            }
            docElement.appendChild(loaderReferencesElement);
        }
    }

    private void loadProperties(Element docElement, JCDescriptor descriptor) throws IllegalArgumentException {
        Properties props = descriptor.getProperties();
        Element tempElement = null;
        Element secElement = null;
        if (props != null && !((Hashtable)props).isEmpty()) {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                if (tempElement == null) {
                    tempElement = this.addDocument.createElement("properties");
                }
                secElement = this.addDocument.createElement("property");
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                this.loadAdditional(secElement, key, "property-name");
                this.loadAdditional(secElement, value, "property-value");
                tempElement.appendChild(secElement);
            }
            docElement.appendChild(tempElement);
        }
    }

    private Element loadDocumentElement(JCDescriptor descriptor, Document mainDocument) {
        Element docElement = null;
        Element tempElement = null;
        String tempName = null;
        try {
            docElement = mainDocument.createElement("connector");
            tempName = descriptor.getDisplayName();
            if (tempName != null && !descriptor.isSetToDefault("display-name")) {
                this.load(docElement, tempName, "display-name");
            }
            if ((tempName = descriptor.getDescription()) != null) {
                this.load(docElement, tempName, "description");
            }
            if (descriptor.getSmallIcon() != null || descriptor.getLargeIcon() != null) {
                tempElement = mainDocument.createElement("icon");
                if (descriptor.getSmallIcon() != null) {
                    this.load(tempElement, descriptor.getSmallIcon().getFileName(), "small-icon");
                }
                if (descriptor.getLargeIcon() != null) {
                    this.load(tempElement, descriptor.getLargeIcon().getFileName(), "large-icon");
                }
                docElement.appendChild(tempElement);
            }
            tempName = descriptor.getVendorName();
            this.load(docElement, tempName, "vendor-name");
            tempName = descriptor.getSpecVersion();
            this.load(docElement, tempName, "spec-version");
            tempName = descriptor.getEisType();
            this.load(docElement, tempName, "eis-type");
            tempName = descriptor.getVersion();
            this.load(docElement, tempName, "version");
            tempName = descriptor.getLicenseDescription();
            if (tempName != null || descriptor.getLicenseRequired()) {
                tempElement = mainDocument.createElement("license");
                if (tempName != null) {
                    this.load(tempElement, tempName, "description");
                }
                this.load(tempElement, String.valueOf(descriptor.getLicenseRequired()), "license-required");
                docElement.appendChild(tempElement);
            }
            this.loadResourceAdapter(docElement, descriptor);
        }
        catch (Exception exc) {
            ConnectorServiceFrame.logException(exc);
            if (exc instanceof BaseIllegalArgumentException) {
                throw (BaseIllegalArgumentException)exc;
            }
            throw new IllegalStateException(Log.getStackTrace(exc));
        }
        return docElement;
    }

    private void loadResourceAdapter(Element docElement, JCDescriptor descriptor) {
        String tempName = null;
        Element raEl = this.mainDocument.createElement("resourceadapter");
        tempName = descriptor.getManagedConnectionFactoryClass();
        this.load(raEl, tempName, "managedconnectionfactory-class");
        tempName = descriptor.getConnectionFactoryInterface();
        this.load(raEl, tempName, "connectionfactory-interface");
        tempName = descriptor.getConnectionFactoryImplClass();
        this.load(raEl, tempName, "connectionfactory-impl-class");
        tempName = descriptor.getConnectionInterface();
        this.load(raEl, tempName, "connection-interface");
        tempName = descriptor.getConnectionImplClass();
        this.load(raEl, tempName, "connection-impl-class");
        tempName = descriptor.getTransactionSupport();
        this.load(raEl, tempName, "transaction-support");
        if (descriptor.getManagedFactoryProperty() != null && descriptor.getManagedFactoryProperty().getConfigProperties() != null) {
            this.loadConfigProperties(raEl, descriptor.getManagedFactoryProperty().getConfigProperties());
        }
        if (descriptor.getAuthMechanisms() != null) {
            this.loadAuthMechanisms(raEl, descriptor.getAuthMechanisms());
        }
        this.load(raEl, String.valueOf(descriptor.getReauthenticationSupport()), "reauthentication-support");
        if (descriptor.getSecurityPermissions() != null) {
            this.loadSecurityPermissions(raEl, descriptor.getSecurityPermissions());
        }
        docElement.appendChild(raEl);
    }

    private void loadConfigProperties(Element raEl, ConfigProperty[] props) {
        Element tempEl = null;
        String tempName = null;
        int i = 0;
        while (i < props.length) {
            if (props[i] != null && props[i].getConfigPropertyName() != null) {
                tempEl = this.mainDocument.createElement("config-property");
                tempName = props[i].getDescription();
                if (tempName != null) {
                    this.load(tempEl, tempName, "description");
                }
                tempName = props[i].getConfigPropertyName();
                this.load(tempEl, tempName, "config-property-name");
                tempName = props[i].getConfigPropertyType();
                this.load(tempEl, tempName, "config-property-type");
                tempName = props[i].getConfigPropertyValue();
                if (tempName != null) {
                    this.load(tempEl, tempName, "config-property-value");
                }
                raEl.appendChild(tempEl);
            }
            ++i;
        }
    }

    private void loadAuthMechanisms(Element raEl, AuthMechanism[] auths) {
        Element tempEl = null;
        String tempName = null;
        int i = 0;
        while (i < auths.length) {
            if (auths[i] != null) {
                tempEl = this.mainDocument.createElement("authentication-mechanism");
                tempName = auths[i].getDescription();
                if (tempName != null) {
                    this.load(tempEl, tempName, "description");
                }
                tempName = auths[i].getAuthMechType();
                this.load(tempEl, tempName, "authentication-mechanism-type");
                tempName = auths[i].getCredentialInterface();
                this.load(tempEl, tempName, "credential-interface");
                raEl.appendChild(tempEl);
            }
            ++i;
        }
    }

    private void loadSecurityPermissions(Element raEl, SecurityPermission[] permissions) {
        Element tempEl = null;
        String tempName = null;
        int i = 0;
        while (i < permissions.length) {
            if (permissions[i] != null && permissions[i].getSecurityPermissionSpec() != null) {
                tempEl = this.mainDocument.createElement("security-permission");
                tempName = permissions[i].getDescription();
                if (tempName != null) {
                    this.load(tempEl, tempName, "description");
                }
                tempName = permissions[i].getSecurityPermissionSpec();
                this.load(tempEl, tempName, "security-permission-spec");
                raEl.appendChild(tempEl);
            }
            ++i;
        }
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    protected void loadAdditional(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.addDocument.createElement(tagName);
        Text textNode = this.addDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    public void writeToFile(String filename) throws IOException {
        StandardDOMWriter wr = ResorceAdapterDescriptorDocument.createStandardDOMWriter();
        wr.write(this.mainDocument, filename, dtd, "UTF-8");
    }

    public void writeAdditionalToFile(String filename) throws IOException {
        StandardDOMWriter wr = ResorceAdapterDescriptorDocument.createStandardDOMWriter();
        wr.write(this.addDocument, filename, additional_dtd, "UTF-8");
    }

    private void writeMessage(String message) {
        if (message == null) {
            return;
        }
        if (this.warnings != null) {
            if (this.rar_name != null) {
                this.warnings.add("Archive '" + this.rar_name + "': " + message);
            } else {
                this.warnings.add(message);
            }
        }
        if (this.rar_name != null) {
            ConnectorResourceAccessor.location.logT(300, "Archive '" + this.rar_name + "': " + message);
        } else {
            ConnectorResourceAccessor.location.logT(300, message);
        }
    }

    private static StandardDOMWriter createStandardDOMWriter() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca$deploy$descriptor$ResorceAdapterDescriptorDocument == null ? (class$com$sap$engine$services$connector$jca$deploy$descriptor$ResorceAdapterDescriptorDocument = ResorceAdapterDescriptorDocument.class$("com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument")) : class$com$sap$engine$services$connector$jca$deploy$descriptor$ResorceAdapterDescriptorDocument).getClassLoader());
            StandardDOMWriter standardDOMWriter = new StandardDOMWriter();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMWriter;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    private boolean checkForSapLogon(AuthMechanism[] authMechs) {
        int i = 0;
        while (authMechs != null && i < authMechs.length) {
            AuthMechanism authMech = authMechs[i];
            if (authMech != null) {
                if (authMech.getAuthMechType().equals("BasicPassword")) {
                    return false;
                }
                if (AuthMechanism.SAP_ASSERTION_TICKET_SET.contains(authMech.getAuthMechType())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

