/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy.descriptor;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.ManagedFactoryProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument;
import com.sap.engine.services.connector.jca.deploy.descriptor.SecurityPermission;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JCDescriptor
extends ArchiveDescriptor
implements Serializable {
    static final long serialVersionUID = 3785916192348223759L;
    public static final byte TRANSACTION_LEVEL_NOT_SPECIFIED = -1;
    public static final byte NO_TRANSACTION = 0;
    public static final byte LOCAL_TRANSACTION = 1;
    public static final byte XA_TRANSACTION = 2;
    public static final String NO_TRANSACTION_SUPPORT = "NoTransaction";
    public static final String LOCAL_TRANSACTION_SUPPORT = "LocalTransaction";
    public static final String XA_TRANSACTION_SUPPORT = "XATransaction";
    public static final String[] TR_SUPPORTS = new String[]{"NoTransaction", "LocalTransaction", "XATransaction"};
    public static final String CONFIGURED_IDENTITY = "Configured Identity";
    public static final String PRINCIPAL_MAPPING = "Principal Mapping";
    public static final String CALLER_IMPERSONATION = "Caller Impersonation";
    public static final String CREDENTIALS_MAPPING = "Credentials Mapping";
    public static final boolean DESCRIPTOR_OK = true;
    public static final boolean DESCRIPTOR_NOT_OK = false;
    public static final int DEFAULT_MAX_CONNECTIONS_NUMBER = 100;
    public static final int DEFAULT_MAX_TIME_TO_WAIT_FOR_CONNECTION = 60;
    public static final String ACTIVE = "Active";
    public static final String SYSTEM = "System";
    public static final String CONNECTOR_DEFAULT_GROUP = "default";
    public static final String JNDI_NAME = "jndi-name";
    public static final String DISPLAY_NAME = "display-name";
    public static final String CONNECTOR_GROUP = "connector-group";
    private String vendorName = null;
    private String specVersion = null;
    private String eisType = null;
    private String version = null;
    private String licenseDescription = null;
    private boolean licenseRequired = false;
    private int reauthenticationSupport = -1;
    private String managedConnectionFactoryClass = null;
    private String connectionFactoryInterface = null;
    private String connectionFactoryImplClass = null;
    private String connectionInterface = null;
    private String connectionImplClass = null;
    private String transactionSupport = null;
    private String rar_name = null;
    private byte transaction_level = (byte)-1;
    private ManagedFactoryProperty managedFactoryProperty = null;
    private AuthMechanism[] authMechanisms = null;
    private SecurityPermission[] securityPermissions = null;
    private String jndi_name = null;
    private String[] aliases = null;
    private String user_store = null;
    private boolean is_internal_store = false;
    private String auth_type = null;
    private IdentitySubject[] subjects;
    private DriverInfo[] drivers;
    private String[] loaderReferences;
    private Properties additionalProps = null;
    private int max_conn = -1;
    private int max_ttwc = -1;
    private int connLifetime = 0;
    private int run_cleanup_thread = 0;
    private String applicationName;
    private String groupName = null;
    private boolean isRealApp = true;
    private Vector warnings = null;
    private String displayName = null;
    private String prefix = "";
    private HashSet valuesSetToDefault = new HashSet();
    private boolean provideAddXML = true;
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor;

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String name) {
        this.vendorName = name;
    }

    public void setDisplayName(String archieveName) {
        this.displayName = archieveName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String support) {
        this.transactionSupport = support;
        if (this.transactionSupport.equals(NO_TRANSACTION_SUPPORT)) {
            this.transaction_level = 0;
        } else if (this.transactionSupport.equals(LOCAL_TRANSACTION_SUPPORT)) {
            this.transaction_level = 1;
        } else if (this.transactionSupport.equals(XA_TRANSACTION_SUPPORT)) {
            this.transaction_level = (byte)2;
        } else {
            this.transactionSupport = null;
            this.transaction_level = (byte)-1;
        }
    }

    public int getTransactionLevel() {
        return this.transaction_level;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String version) {
        this.specVersion = version;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String type) {
        this.eisType = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicenseDescription() {
        return this.licenseDescription;
    }

    public void setLicenseDescription(String description) {
        this.licenseDescription = description;
    }

    public boolean getLicenseRequired() {
        return this.licenseRequired;
    }

    public void setLicenseRequired(boolean required) {
        this.licenseRequired = required;
    }

    public boolean getReauthenticationSupport() {
        return this.reauthenticationSupport == 1;
    }

    public int getReauthenticationLevel() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean support) {
        this.reauthenticationSupport = support ? 1 : 0;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String className) {
        this.managedConnectionFactoryClass = className;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String interfaceClass) {
        this.connectionFactoryInterface = interfaceClass;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public void setConnectionFactoryImplClass(String implClass) {
        this.connectionFactoryImplClass = implClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String interfaceClass) {
        this.connectionInterface = interfaceClass;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public void setConnectionImplClass(String implClass) {
        this.connectionImplClass = implClass;
    }

    public ManagedFactoryProperty getManagedFactoryProperty() {
        return this.managedFactoryProperty;
    }

    public void setManagedFactoryProperty(ManagedFactoryProperty entry) {
        if (entry == null || entry.getConfigProperties() == null || entry.getConfigProperties().length == 0) {
            return;
        }
        this.managedFactoryProperty = entry;
    }

    public void clearManagedFactoryProperty() {
        this.managedFactoryProperty = null;
    }

    public void setAuthMechanisms(AuthMechanism[] entries) {
        this.authMechanisms = entries;
    }

    public AuthMechanism[] getAuthMechanisms() {
        return this.authMechanisms;
    }

    public AuthMechanism getAuthMechanism(int i) {
        if (this.authMechanisms != null && i > -1 && i < this.authMechanisms.length) {
            return this.authMechanisms[i];
        }
        return null;
    }

    public void addAuthMechanism(AuthMechanism entry) {
        if (entry == null || entry.getAuthMechType() == null || entry.getCredentialInterface() == null) {
            return;
        }
        if (this.authMechanisms == null) {
            this.authMechanisms = new AuthMechanism[1];
            this.authMechanisms[0] = entry;
        } else {
            int i = 0;
            while (i < this.authMechanisms.length) {
                if (this.authMechanisms[i] != null && entry.getAuthMechType().equals(this.authMechanisms[i].getAuthMechType())) {
                    this.authMechanisms[i] = entry;
                    return;
                }
                ++i;
            }
            AuthMechanism[] oldData = this.authMechanisms;
            this.authMechanisms = new AuthMechanism[this.authMechanisms.length + 1];
            System.arraycopy(oldData, 0, this.authMechanisms, 0, oldData.length);
            this.authMechanisms[this.authMechanisms.length - 1] = entry;
        }
    }

    public void removeAuthMechanism(AuthMechanism entry) {
        if (this.authMechanisms == null || entry == null || entry.getAuthMechType() == null) {
            return;
        }
        int i = 0;
        while (i < this.authMechanisms.length) {
            if (this.authMechanisms[i] != null && entry.getAuthMechType().equals(this.authMechanisms[i].getAuthMechType())) {
                AuthMechanism[] oldData = this.authMechanisms;
                this.authMechanisms = new AuthMechanism[this.authMechanisms.length - 1];
                System.arraycopy(oldData, 0, this.authMechanisms, 0, i);
                System.arraycopy(oldData, i + 1, this.authMechanisms, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public void setSecurityPermissions(SecurityPermission[] entries) {
        this.securityPermissions = entries;
    }

    public SecurityPermission[] getSecurityPermissions() {
        return this.securityPermissions;
    }

    public SecurityPermission getSecurityPermission(int i) {
        if (this.securityPermissions != null && i > -1 && i < this.securityPermissions.length) {
            return this.securityPermissions[i];
        }
        return null;
    }

    public void addSecurityPermission(SecurityPermission entry) {
        if (entry == null || entry.getSecurityPermissionSpec() == null) {
            return;
        }
        if (this.securityPermissions == null) {
            this.securityPermissions = new SecurityPermission[1];
            this.securityPermissions[0] = entry;
        } else {
            int i = 0;
            while (i < this.securityPermissions.length) {
                if (this.securityPermissions[i] != null && entry.getSecurityPermissionSpec().equals(this.securityPermissions[i].getSecurityPermissionSpec())) {
                    this.securityPermissions[i] = entry;
                    return;
                }
                ++i;
            }
            SecurityPermission[] oldData = this.securityPermissions;
            this.securityPermissions = new SecurityPermission[this.securityPermissions.length + 1];
            System.arraycopy(oldData, 0, this.securityPermissions, 0, oldData.length);
            this.securityPermissions[this.securityPermissions.length - 1] = entry;
        }
    }

    public void removeSecurityPermission(SecurityPermission entry) {
        if (this.securityPermissions == null || entry == null || entry.getSecurityPermissionSpec() == null) {
            return;
        }
        int i = 0;
        while (i < this.securityPermissions.length) {
            if (this.securityPermissions[i] != null && entry.getSecurityPermissionSpec().equals(this.securityPermissions[i].getSecurityPermissionSpec())) {
                SecurityPermission[] oldData = this.securityPermissions;
                this.securityPermissions = new SecurityPermission[this.securityPermissions.length - 1];
                System.arraycopy(oldData, 0, this.securityPermissions, 0, i);
                System.arraycopy(oldData, i + 1, this.securityPermissions, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public String getRarName() {
        return this.rar_name;
    }

    public void setRarName(String rar_name) {
        this.rar_name = rar_name;
    }

    public void setConnectorJNDIName(String jndi_name) {
        this.jndi_name = jndi_name;
    }

    public String getConnectorJNDIName() {
        return this.jndi_name;
    }

    public void addAlias(String alias) {
        if (alias == null || alias.equals("")) {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add invalid or null alias.");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : trying to add invalid or null alias.");
            return;
        }
        if (this.aliases == null) {
            this.aliases = new String[1];
            this.aliases[0] = alias;
        } else {
            int i = 0;
            while (i < this.aliases.length) {
                if (this.aliases[i] != null && alias.equals(this.aliases[i])) {
                    this.aliases[i] = alias;
                    return;
                }
                ++i;
            }
            String[] oldData = this.aliases;
            this.aliases = new String[this.aliases.length + 1];
            System.arraycopy(oldData, 0, this.aliases, 0, oldData.length);
            this.aliases[this.aliases.length - 1] = alias;
        }
    }

    public void removeAlias(String alias) {
        if (this.aliases == null || alias == null) {
            return;
        }
        int i = 0;
        while (i < this.aliases.length) {
            if (this.aliases[i] != null && alias.equals(this.aliases[i])) {
                String[] oldData = this.aliases;
                this.aliases = new String[this.aliases.length - 1];
                System.arraycopy(oldData, 0, this.aliases, 0, i);
                System.arraycopy(oldData, i + 1, this.aliases, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setAuthenticationType(String auth_type) {
        this.auth_type = auth_type;
    }

    public String getAuthenticationType() {
        return this.auth_type;
    }

    public void setUserStore(String user_store) {
        this.user_store = user_store;
    }

    public void setInternalUserStore(boolean is_internal_store) {
        this.is_internal_store = is_internal_store;
    }

    public boolean isInternalUserStore() {
        return this.is_internal_store;
    }

    public String getUserStore() {
        return this.user_store;
    }

    public void addIdentitySubject(IdentitySubject entry) {
        if (entry == null) {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add invalid or null identity subject.");
            }
            ConnectorResourceAccessor.location.logT(300, "Warning : trying to add invalid or null identity subject.");
            return;
        }
        if (this.subjects == null) {
            this.subjects = new IdentitySubject[1];
            this.subjects[0] = entry;
        } else {
            int i = 0;
            while (i < this.subjects.length) {
                if (this.subjects[i] != null && entry.equals(this.subjects[i])) {
                    this.subjects[i] = entry;
                    return;
                }
                ++i;
            }
            IdentitySubject[] oldData = this.subjects;
            this.subjects = new IdentitySubject[this.subjects.length + 1];
            System.arraycopy(oldData, 0, this.subjects, 0, oldData.length);
            this.subjects[this.subjects.length - 1] = entry;
        }
    }

    public void removeIdentitySubject(IdentitySubject entry) {
        if (this.subjects == null || entry == null) {
            return;
        }
        int i = 0;
        while (i < this.subjects.length) {
            if (this.subjects[i] != null && entry.equals(this.subjects[i])) {
                IdentitySubject[] oldData = this.subjects;
                this.subjects = new IdentitySubject[this.subjects.length - 1];
                System.arraycopy(oldData, 0, this.subjects, 0, i);
                System.arraycopy(oldData, i + 1, this.subjects, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public void setIdentitySubjects(IdentitySubject[] subjects) {
        this.subjects = subjects;
    }

    public IdentitySubject[] getIdentitySubjects() {
        return this.subjects;
    }

    public void addDriver(DriverInfo entry) {
        if (entry == null || entry.getDriverClassName() == null || entry.getDriverClassName().equals("") || entry.getDriverName() == null || entry.getDriverName().equals("")) {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add invalid or null driver info.");
            }
            return;
        }
        if (this.drivers == null) {
            this.drivers = new DriverInfo[1];
            this.drivers[0] = entry;
        } else {
            int i = 0;
            while (i < this.drivers.length) {
                if (this.drivers[i] != null && entry.equals(this.drivers[i])) {
                    this.drivers[i] = entry;
                    return;
                }
                ++i;
            }
            DriverInfo[] oldData = this.drivers;
            this.drivers = new DriverInfo[this.drivers.length + 1];
            System.arraycopy(oldData, 0, this.drivers, 0, oldData.length);
            this.drivers[this.drivers.length - 1] = entry;
        }
    }

    public void removeDriver(DriverInfo entry) {
        if (this.drivers == null || entry == null) {
            return;
        }
        int i = 0;
        while (i < this.drivers.length) {
            if (this.drivers[i] != null && entry.equals(this.drivers[i])) {
                DriverInfo[] oldData = this.drivers;
                this.drivers = new DriverInfo[this.drivers.length - 1];
                System.arraycopy(oldData, 0, this.drivers, 0, i);
                System.arraycopy(oldData, i + 1, this.drivers, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public void setDrivers(DriverInfo[] drivers) {
        this.drivers = drivers;
    }

    public DriverInfo[] getDrivers() {
        return this.drivers;
    }

    public void setMaxConnectionsNumber(int max_conn) {
        this.max_conn = max_conn;
    }

    public int getMaxConnectionsNumber() {
        return this.max_conn;
    }

    public void setMaxTimeToWaitConnection(int max_ttwc) {
        this.max_ttwc = max_ttwc;
    }

    public int getMaxTimeToWaitConnection() {
        return this.max_ttwc;
    }

    public void setConnectionLifetime(int connLifetime) {
        this.connLifetime = connLifetime;
    }

    public int getConnectionLifetime() {
        return this.connLifetime;
    }

    public void setRunCleanupThreadTime(int run_cleanup_thread) {
        this.run_cleanup_thread = run_cleanup_thread;
    }

    public int getRunCleanupThreadTime() {
        return this.run_cleanup_thread;
    }

    public void setLoaderReferences(String[] loaderReferences) {
        this.loaderReferences = loaderReferences;
    }

    public String[] getLoaderReferences() {
        return this.loaderReferences;
    }

    public String getLoaderReference(int i) {
        if (this.loaderReferences != null && i > -1 && i < this.loaderReferences.length) {
            return this.loaderReferences[i];
        }
        return null;
    }

    public void addLoaderReference(String loaderReference) {
        if (loaderReference == null) {
            return;
        }
        if (this.loaderReferences == null) {
            this.loaderReferences = new String[1];
            this.loaderReferences[0] = loaderReference;
        } else {
            int i = 0;
            while (i < this.loaderReferences.length) {
                if (this.loaderReferences[i] != null && loaderReference.equals(this.loaderReferences[i])) {
                    this.loaderReferences[i] = loaderReference;
                    return;
                }
                ++i;
            }
            String[] oldData = this.loaderReferences;
            this.loaderReferences = new String[this.loaderReferences.length + 1];
            System.arraycopy(oldData, 0, this.loaderReferences, 0, oldData.length);
            this.loaderReferences[this.loaderReferences.length - 1] = loaderReference;
        }
    }

    public void removeloaderReference(String loaderReference) {
        if (this.loaderReferences == null || loaderReference == null) {
            return;
        }
        int i = 0;
        while (i < this.loaderReferences.length) {
            if (this.loaderReferences[i] != null && loaderReference.equals(this.loaderReferences[i])) {
                String[] oldData = this.loaderReferences;
                this.loaderReferences = new String[this.loaderReferences.length - 1];
                System.arraycopy(oldData, 0, this.loaderReferences, 0, i);
                System.arraycopy(oldData, i + 1, this.loaderReferences, i, oldData.length - i - 1);
                return;
            }
            ++i;
        }
    }

    public void setProperties(Properties properties) {
        this.additionalProps = properties;
    }

    public Properties getProperties() {
        return this.additionalProps;
    }

    public void addProperty(String key, String value) {
        if (key == null || value == null) {
            if (this.warnings != null) {
                this.warnings.add("Warning : trying to add property with null key or value.");
            }
            return;
        }
        if (this.additionalProps == null) {
            this.additionalProps = new Properties();
        }
        this.additionalProps.setProperty(key, value);
    }

    public void removeProperty(String key) {
        if (this.additionalProps != null) {
            ((Hashtable)this.additionalProps).remove(key);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public String getConnectorGroup() {
        return this.groupName;
    }

    public void setConnectorGroup(String groupName) {
        this.groupName = groupName;
    }

    public boolean isRealApplication() {
        return this.isRealApp;
    }

    public void setRealApplication(boolean isReal) {
        this.isRealApp = isReal;
    }

    public void setSmallIconName(String icon) {
        if (icon == null) {
            this.smallIcon = null;
        }
        this.smallIcon = new SerializableFile(new File(icon));
    }

    public void setLargeIconName(String icon) {
        if (icon == null) {
            this.largeIcon = null;
        }
        this.largeIcon = new SerializableFile(new File(icon));
    }

    public String getSmallIconName() {
        if (this.smallIcon != null) {
            return this.smallIcon.getFileName();
        }
        return null;
    }

    public String getLargeIconName() {
        if (this.largeIcon != null) {
            return this.largeIcon.getFileName();
        }
        return null;
    }

    public void setSmallIcon(SerializableFile smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeIcon(SerializableFile largeIcon) {
        this.largeIcon = largeIcon;
    }

    public Descriptor getDescriptor(String name) {
        return null;
    }

    public Descriptor[] getDescriptors() {
        return null;
    }

    public void setDescriptors(Descriptor[] descr) {
    }

    public String saveToFile(String xmlFileName) {
        StandardDOMWriter writer = JCDescriptor.createStandardDOMWriter();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        Document document = doc.loadDocumentFromDescriptor(this);
        try {
            writer.write(document, xmlFileName, "<!DOCTYPE connector PUBLIC '-//Sun Microsystems, Inc.//DTD Connector 1.0//EN' 'http://java.sun.com/dtd/connector_1_0.dtd'>", "UTF-8");
        }
        catch (IOException ioExc) {
            ConnectorResourceAccessor.location.logT(500, "saveToFile(), RAXMLFileName: " + xmlFileName + ", Error: " + Log.getStackTrace(ioExc));
        }
        return null;
    }

    public String saveRaXmlToString() throws IOException {
        StandardDOMWriter writer = JCDescriptor.createStandardDOMWriter();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        Document document = doc.loadDocumentFromDescriptor(this);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        writer.write(document, (OutputStream)outStream, "<!DOCTYPE connector PUBLIC '-//Sun Microsystems, Inc.//DTD Connector 1.0//EN' 'http://java.sun.com/dtd/connector_1_0.dtd'>");
        return new String(outStream.toByteArray());
    }

    public void saveAdditionalToFile(String xmlFileName) {
        StandardDOMWriter writer = JCDescriptor.createStandardDOMWriter();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        Document document = doc.loadAdditionalDocumentFromDescriptor(this);
        try {
            writer.write(document, xmlFileName, "<!DOCTYPE connector-j2ee-engine SYSTEM 'connector-j2ee-engine.dtd'>", "UTF-8");
        }
        catch (IOException ioExc) {
            ConnectorResourceAccessor.location.logT(500, "saveAdditionalToFile(), XMLFileName: " + xmlFileName + ", Error: " + Log.getStackTrace(ioExc));
        }
    }

    public String saveAddXmlToStringIfExists() throws IOException {
        if (!(this.jndi_name != null && !this.isSetToDefault(JNDI_NAME) || !this.isRealApp && this.groupName != null && !this.isSetToDefault(CONNECTOR_GROUP) || !this.isRealApp && this.loaderReferences != null || this.aliases != null || this.drivers != null || this.additionalProps != null || this.auth_type != null || this.max_conn != -1 || this.max_ttwc != -1 || this.connLifetime != -1 || this.run_cleanup_thread != -1 || this.provideAdditionalXML())) {
            return null;
        }
        return this.saveAddXmlToString();
    }

    public String saveAddXmlToString() throws IOException {
        StandardDOMWriter writer = JCDescriptor.createStandardDOMWriter();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        Document document = doc.loadAdditionalDocumentFromDescriptor(this);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        writer.write(document, (OutputStream)outStream, "<!DOCTYPE connector-j2ee-engine SYSTEM 'connector-j2ee-engine.dtd'>");
        return new String(outStream.toByteArray());
    }

    public Document getAsDocument() {
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        Document document = doc.loadDocumentFromDescriptor(this);
        return document;
    }

    public void loadFromDocument(Document document) {
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        doc.setRarName(this.rar_name);
        doc.setRealApp(this.isRealApp);
        doc.setPrefix(this.prefix);
        try {
            JCDescriptor descriptor = doc.loadDescriptorFromDocument(document);
            this.replaceDescriptor(descriptor);
        }
        catch (IllegalArgumentException illaExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromDocument(), Error: " + Log.getStackTrace(illaExc));
        }
    }

    public void replaceDescriptor(JCDescriptor descr) {
        if (descr != null) {
            this.description = descr.getDescription();
            this.displayName = descr.getDisplayName();
            this.prefix = descr.getPrefix();
            this.largeIcon = descr.getLargeIcon();
            this.smallIcon = descr.getSmallIcon();
            this.vendorName = descr.getVendorName();
            this.specVersion = descr.getSpecVersion();
            this.eisType = descr.getEisType();
            this.version = descr.getVersion();
            this.licenseDescription = descr.getLicenseDescription();
            this.licenseRequired = descr.getLicenseRequired();
            this.reauthenticationSupport = descr.getReauthenticationLevel();
            this.managedConnectionFactoryClass = descr.getManagedConnectionFactoryClass();
            this.connectionFactoryInterface = descr.getConnectionFactoryInterface();
            this.connectionFactoryImplClass = descr.getConnectionFactoryImplClass();
            this.connectionInterface = descr.getConnectionInterface();
            this.connectionImplClass = descr.getConnectionImplClass();
            this.transactionSupport = descr.getTransactionSupport();
            this.transaction_level = descr.transaction_level;
            this.managedFactoryProperty = descr.getManagedFactoryProperty();
            this.authMechanisms = descr.getAuthMechanisms();
            this.securityPermissions = descr.getSecurityPermissions();
            this.rar_name = descr.getRarName();
            this.jndi_name = descr.getConnectorJNDIName();
            this.aliases = descr.getAliases();
            this.auth_type = descr.getAuthenticationType();
            this.user_store = descr.getUserStore();
            this.is_internal_store = descr.isInternalUserStore();
            this.subjects = descr.getIdentitySubjects();
            this.drivers = descr.getDrivers();
            this.max_conn = descr.getMaxConnectionsNumber();
            this.max_ttwc = descr.getMaxTimeToWaitConnection();
            this.connLifetime = descr.getConnectionLifetime();
            this.run_cleanup_thread = descr.getRunCleanupThreadTime();
            this.loaderReferences = descr.getLoaderReferences();
            this.additionalProps = descr.getProperties();
            this.applicationName = descr.getApplicationName();
            this.groupName = descr.getConnectorGroup();
            this.isRealApp = descr.isRealApplication();
        }
    }

    public void loadFromFile(String xmlFile) {
        StandardDOMParser parser = JCDescriptor.createStandardDOMParser();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        doc.setRarName(this.rar_name);
        doc.setRealApp(this.isRealApp);
        doc.setPrefix(this.prefix);
        Document document = null;
        BufferedInputStream xmlStream = null;
        try {
            FileInputStream fis = new FileInputStream(xmlFile);
            xmlStream = new BufferedInputStream(fis);
            document = parser.parse((InputStream)xmlStream);
            JCDescriptor descriptor = doc.loadDescriptorFromDocument(document);
            this.replaceDescriptor(descriptor);
        }
        catch (FileNotFoundException fnfExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFile(), RAXMLFileName: " + xmlFile + ", Error: " + Log.getStackTrace(fnfExc));
        }
        catch (SAXException saxExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFile(), RAXMLFileName: " + xmlFile + ", Error: " + Log.getStackTrace(saxExc));
        }
        catch (IOException ioExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFile(), RAXMLFileName: " + xmlFile + ", Error: " + Log.getStackTrace(ioExc));
        }
        catch (IllegalArgumentException illaExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFile(), RAXMLFileName: " + xmlFile + ", Error: " + Log.getStackTrace(illaExc));
        }
    }

    public void loadFromFiles(String xmlFile, String addXmlFile) {
        StandardDOMParser parser = JCDescriptor.createStandardDOMParser();
        ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
        doc.setRarName(this.rar_name);
        doc.setRealApp(this.isRealApp);
        doc.setPrefix(this.prefix);
        Document document = null;
        BufferedInputStream xmlStream = null;
        try {
            FileInputStream fis = new FileInputStream(xmlFile);
            xmlStream = new BufferedInputStream(fis);
            document = parser.parse((InputStream)xmlStream);
            JCDescriptor descriptor = doc.loadDescriptorFromDocument(document);
            if (addXmlFile != null) {
                fis = new FileInputStream(addXmlFile);
                xmlStream = new BufferedInputStream(fis);
                document = parser.parse((InputStream)xmlStream);
                doc.loadDescriptorAdditionalFromDocument(descriptor, document);
            }
            this.replaceDescriptor(descriptor);
        }
        catch (FileNotFoundException fe) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFiles(), RAXMLFileName: " + xmlFile + ", ADDXMLFileName: " + addXmlFile + ", Error: " + Log.getStackTrace(fe));
        }
        catch (SAXException saxExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFiles(), RAXMLFileName: " + xmlFile + ", ADDXMLFileName: " + addXmlFile + ", Error: " + Log.getStackTrace(saxExc));
        }
        catch (IOException ioExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFiles(), RAXMLFileName: " + xmlFile + ", ADDXMLFileName: " + addXmlFile + ", Error: " + Log.getStackTrace(ioExc));
        }
        catch (IllegalArgumentException illaExc) {
            ConnectorResourceAccessor.location.logT(500, "loadFromFiles(), RAXMLFileName: " + xmlFile + ", ADDXMLFileName: " + addXmlFile + ", Error: " + Log.getStackTrace(illaExc));
        }
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isSetToDefault(String propertyName) {
        return this.valuesSetToDefault.contains(propertyName);
    }

    public void setToDefault(String propertyName, boolean isDefault) {
        if (isDefault) {
            this.valuesSetToDefault.add(propertyName);
        } else {
            this.valuesSetToDefault.remove(propertyName);
        }
    }

    public void setProvideAdditionalXML(boolean provideAddXML) {
        this.provideAddXML = provideAddXML;
    }

    public boolean provideAdditionalXML() {
        return this.provideAddXML;
    }

    public Object clone() {
        int i;
        JCDescriptor cloning = new JCDescriptor();
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.displayName = this.displayName == null ? null : new String(this.displayName);
        cloning.prefix = this.prefix == null ? null : new String(this.prefix);
        cloning.vendorName = this.vendorName == null ? null : new String(this.vendorName);
        cloning.specVersion = this.specVersion == null ? null : new String(this.specVersion);
        cloning.eisType = this.eisType == null ? null : new String(this.eisType);
        cloning.version = this.version == null ? null : new String(this.version);
        cloning.licenseDescription = this.licenseDescription == null ? null : new String(this.licenseDescription);
        cloning.managedConnectionFactoryClass = this.managedConnectionFactoryClass == null ? null : new String(this.managedConnectionFactoryClass);
        cloning.connectionFactoryInterface = this.connectionFactoryInterface == null ? null : new String(this.connectionFactoryInterface);
        cloning.connectionFactoryImplClass = this.connectionFactoryImplClass == null ? null : new String(this.connectionFactoryImplClass);
        cloning.connectionInterface = this.connectionInterface == null ? null : new String(this.connectionInterface);
        cloning.connectionImplClass = this.connectionImplClass == null ? null : new String(this.connectionImplClass);
        cloning.transactionSupport = this.transactionSupport == null ? null : new String(this.transactionSupport);
        cloning.licenseRequired = this.licenseRequired;
        cloning.reauthenticationSupport = this.reauthenticationSupport;
        cloning.transaction_level = this.transaction_level;
        cloning.smallIcon = this.smallIcon != null ? (SerializableFile)this.smallIcon.clone() : null;
        cloning.largeIcon = this.largeIcon != null ? (SerializableFile)this.largeIcon.clone() : null;
        cloning.managedFactoryProperty = this.managedFactoryProperty != null ? (ManagedFactoryProperty)this.managedFactoryProperty.clone() : null;
        if (this.authMechanisms == null) {
            cloning.authMechanisms = null;
        } else {
            cloning.authMechanisms = new AuthMechanism[this.authMechanisms.length];
            i = 0;
            while (i < this.authMechanisms.length) {
                cloning.authMechanisms[i] = this.authMechanisms[i] == null ? null : (AuthMechanism)this.authMechanisms[i].clone();
                ++i;
            }
        }
        if (this.securityPermissions == null) {
            cloning.securityPermissions = null;
        } else {
            cloning.securityPermissions = new SecurityPermission[this.securityPermissions.length];
            i = 0;
            while (i < this.securityPermissions.length) {
                cloning.securityPermissions[i] = this.securityPermissions[i] == null ? null : (SecurityPermission)this.securityPermissions[i].clone();
                ++i;
            }
        }
        cloning.rar_name = this.rar_name == null ? null : new String(this.rar_name);
        String string = cloning.jndi_name = this.jndi_name == null ? null : new String(this.jndi_name);
        if (this.aliases == null) {
            cloning.aliases = null;
        } else {
            cloning.aliases = new String[this.aliases.length];
            i = 0;
            while (i < this.aliases.length) {
                cloning.aliases[i] = this.aliases[i] == null ? null : new String(this.aliases[i]);
                ++i;
            }
        }
        cloning.auth_type = this.auth_type == null ? null : new String(this.auth_type);
        cloning.user_store = this.user_store == null ? null : new String(this.user_store);
        cloning.is_internal_store = this.is_internal_store;
        if (this.subjects == null) {
            cloning.subjects = null;
        } else {
            cloning.subjects = new IdentitySubject[this.subjects.length];
            i = 0;
            while (i < this.subjects.length) {
                cloning.subjects[i] = this.subjects[i] == null ? null : (IdentitySubject)this.subjects[i].clone();
                ++i;
            }
        }
        if (this.drivers == null) {
            cloning.drivers = null;
        } else {
            cloning.drivers = new DriverInfo[this.drivers.length];
            i = 0;
            while (i < this.drivers.length) {
                cloning.drivers[i] = this.drivers[i] == null ? null : (DriverInfo)this.drivers[i].clone();
                ++i;
            }
        }
        cloning.max_conn = this.max_conn;
        cloning.max_ttwc = this.max_ttwc;
        cloning.connLifetime = this.connLifetime;
        cloning.run_cleanup_thread = this.run_cleanup_thread;
        if (this.loaderReferences == null) {
            cloning.loaderReferences = null;
        } else {
            cloning.loaderReferences = new String[this.loaderReferences.length];
            i = 0;
            while (i < this.loaderReferences.length) {
                cloning.loaderReferences[i] = this.loaderReferences[i] == null ? null : new String(this.loaderReferences[i]);
                ++i;
            }
        }
        if (this.additionalProps == null) {
            cloning.additionalProps = null;
        } else {
            Properties newAddProps = new Properties();
            Enumeration enumeration = ((Hashtable)this.additionalProps).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = (String)((Hashtable)this.additionalProps).get(key);
                newAddProps.setProperty(new String(key), new String(value));
            }
            cloning.additionalProps = newAddProps;
        }
        cloning.applicationName = this.applicationName == null ? null : new String(this.applicationName);
        cloning.groupName = this.groupName == null ? null : new String(this.groupName);
        cloning.isRealApp = this.isRealApp;
        cloning.valuesSetToDefault = new HashSet();
        Iterator iterator = cloning.valuesSetToDefault.iterator();
        while (iterator.hasNext()) {
            cloning.valuesSetToDefault.add(new String((String)iterator.next()));
        }
        cloning.setLoaded(this.isLoaded());
        return cloning;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JCDescriptor)) {
            return false;
        }
        JCDescriptor jcd = (JCDescriptor)obj;
        if (jcd.description != null ? !jcd.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (jcd.displayName != null ? !jcd.displayName.equals(this.displayName) : this.displayName != null) {
            return false;
        }
        if (jcd.prefix != null ? !jcd.prefix.equals(this.prefix) : this.prefix != null) {
            return false;
        }
        if (jcd.vendorName != null ? !jcd.vendorName.equals(this.vendorName) : this.vendorName != null) {
            return false;
        }
        if (jcd.specVersion != null ? !jcd.specVersion.equals(this.specVersion) : this.specVersion != null) {
            return false;
        }
        if (jcd.eisType != null ? !jcd.eisType.equals(this.eisType) : this.eisType != null) {
            return false;
        }
        if (jcd.version != null ? !jcd.version.equals(this.version) : this.version != null) {
            return false;
        }
        if (jcd.licenseDescription != null ? !jcd.licenseDescription.equals(this.licenseDescription) : this.licenseDescription != null) {
            return false;
        }
        if (jcd.managedConnectionFactoryClass != null ? !jcd.managedConnectionFactoryClass.equals(this.managedConnectionFactoryClass) : this.managedConnectionFactoryClass != null) {
            return false;
        }
        if (jcd.connectionFactoryInterface != null ? !jcd.connectionFactoryInterface.equals(this.connectionFactoryInterface) : this.connectionFactoryInterface != null) {
            return false;
        }
        if (jcd.connectionFactoryImplClass != null ? !jcd.connectionFactoryImplClass.equals(this.connectionFactoryImplClass) : this.connectionFactoryImplClass != null) {
            return false;
        }
        if (jcd.connectionInterface != null ? !jcd.connectionInterface.equals(this.connectionInterface) : this.connectionInterface != null) {
            return false;
        }
        if (jcd.connectionImplClass != null ? !jcd.connectionImplClass.equals(this.connectionImplClass) : this.connectionImplClass != null) {
            return false;
        }
        if (jcd.transactionSupport != null ? !jcd.transactionSupport.equals(this.transactionSupport) : this.transactionSupport != null) {
            return false;
        }
        if (jcd.smallIcon != null ? !jcd.smallIcon.equals(this.smallIcon) : this.smallIcon != null) {
            return false;
        }
        if (jcd.largeIcon != null ? !jcd.largeIcon.equals(this.largeIcon) : this.largeIcon != null) {
            return false;
        }
        if (jcd.managedFactoryProperty != null ? !jcd.managedFactoryProperty.equals(this.managedFactoryProperty) : this.managedFactoryProperty != null) {
            return false;
        }
        if (jcd.licenseRequired != this.licenseRequired) {
            return false;
        }
        if (jcd.reauthenticationSupport != this.reauthenticationSupport) {
            return false;
        }
        if (jcd.transaction_level != this.transaction_level) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.authMechanisms, this.authMechanisms)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.securityPermissions, this.securityPermissions)) {
            return false;
        }
        if (jcd.rar_name != null ? !jcd.rar_name.equals(this.rar_name) : this.rar_name != null) {
            return false;
        }
        if (jcd.jndi_name != null ? !jcd.jndi_name.equals(this.jndi_name) : this.jndi_name != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.aliases, this.aliases)) {
            return false;
        }
        if (jcd.auth_type != null ? !jcd.auth_type.equals(this.auth_type) : this.auth_type != null) {
            return false;
        }
        if (jcd.user_store != null ? !jcd.user_store.equals(this.user_store) : this.user_store != null) {
            return false;
        }
        if (jcd.is_internal_store != this.is_internal_store) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.subjects, this.subjects)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.drivers, this.drivers)) {
            return false;
        }
        if (jcd.max_conn != this.max_conn) {
            return false;
        }
        if (jcd.max_ttwc != this.max_ttwc) {
            return false;
        }
        if (jcd.connLifetime != this.connLifetime) {
            return false;
        }
        if (jcd.run_cleanup_thread != this.run_cleanup_thread) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(jcd.loaderReferences, this.loaderReferences)) {
            return false;
        }
        if (!EqualUtils.equalObjects(jcd.additionalProps, this.additionalProps)) {
            return false;
        }
        if (!EqualUtils.equalObjects(jcd.applicationName, this.applicationName)) {
            return false;
        }
        if (!EqualUtils.equalObjects(jcd.groupName, this.groupName)) {
            return false;
        }
        if (jcd.isRealApp != this.isRealApp) {
            return false;
        }
        return this.isLoaded() == jcd.isLoaded();
    }

    private static StandardDOMParser createStandardDOMParser() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor == null ? (class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor = JCDescriptor.class$("com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor")) : class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor).getClassLoader());
            StandardDOMParser standardDOMParser = new StandardDOMParser();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMParser;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    private static StandardDOMWriter createStandardDOMWriter() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor == null ? (class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor = JCDescriptor.class$("com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor")) : class$com$sap$engine$services$connector$jca$deploy$descriptor$JCDescriptor).getClassLoader());
            StandardDOMWriter standardDOMWriter = new StandardDOMWriter();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMWriter;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

