/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.core.load.res.MultipleResource;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.auth.CallerImpersonationConfiguration;
import com.sap.engine.interfaces.security.auth.ConfiguredIdentityConfiguration;
import com.sap.engine.interfaces.security.auth.CredentialsMappingConfiguration;
import com.sap.engine.interfaces.security.auth.PrincipalMappingConfiguration;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.jca.deploy.ApplicationInfo;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import com.sap.engine.services.connector.jca.deploy.VersionChecker;
import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConnectorUserstoreConfiguration;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ManagedFactoryProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.login.AppConfigurationEntry;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DeployAdmin {
    private LoadContext loadContext = null;
    private SecurityContext securityContext = null;
    private Hashtable groupAppsMap = null;
    private char sepChar = File.separatorChar;
    static final String CONNECTORS_CTX = "deployedAdapters";
    static final String LOADER_PREFIX = "connector:";
    static final String MCF_CONTEXT_NAME = "mcf/";
    static final String RES_REF_SHAREABLE_CTX = "shareable";
    static final String RES_REF_UNSHAREABLE_CTX = "unshareable";
    static final String RES_REF_NON_TRANSACTIONAL_CTX = "nonGlobalTx";
    static final String DESCRIPTOR_CONTEXT_NAME = "descriptor/connector/";
    static final String CONNECTORS = "connectors";
    static final String PROPERTIES = "properties";
    static final String DRIVERS = "drivers";
    static final String META_INF = "META-INF";
    static final String SECURE_META_INF = "SECURE-META-INF";
    static final String meta_inf = "meta-inf";
    static final char[] delimiters = new char[]{'\\', '/', ' ', '_', ';', ',', '{', '}', '\"', '\'', '?', '!'};
    static final int DEPLOY_PHASE = 1;
    static final int LOAD_PHASE = 2;
    static final int UPDATE_PHASE = 3;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca$deploy$DeployAdmin;

    public DeployAdmin(ApplicationServiceContext asc) {
        this.loadContext = asc.getCoreContext().getLoadContext();
        this.init();
    }

    protected void init() {
        this.groupAppsMap = new Hashtable();
    }

    public void setSecurityContext(SecurityContext securityContext) {
        String logPrefix = "DeployAdmin.setSecurityContext(), SecurityContext: " + securityContext;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        this.securityContext = securityContext;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] extractFiles(String appName, Configuration rootConfig, String workAppDir, String absoluteRarName, String relativeRarName, Vector warnings, boolean update) throws DeploymentException {
        logPrefix = "DeployAdmin.extractFiles(File archive), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        outputDir = this.makeConnectorsDir(workAppDir) + this.sepChar + relativeRarName.replace('/', this.sepChar);
        dir = new File(outputDir);
        this.mkDirs(dir, false);
        connectorsConfig = null;
        secureMetaInfConfig = null;
        config = null;
        propertySheet = null;
        try {
            connectorsConfig = this.createConfiguration(rootConfig, "connectors/" + relativeRarName, 0);
        }
        catch (ConfigurationException confExc) {
            bdExc = new BaseDeploymentException("connector_0000", new String[]{"connectors/" + relativeRarName, rootConfig.getPath()}, (Throwable)confExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        try {
            secureMetaInfConfig = this.createConfiguration(rootConfig, "SECURE-META-INF/" + relativeRarName, 1);
        }
        catch (ConfigurationException conex) {
            bdExc = new BaseDeploymentException("connector_0000", new String[]{"SECURE-META-INF/" + relativeRarName, rootConfig.getPath()}, (Throwable)conex);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        try {
            propertySheet = secureMetaInfConfig.getPropertySheetInterface();
        }
        catch (ConfigurationException confExc) {
            bdExc = new BaseDeploymentException("connector_0073", rootConfig.getPath(), (Throwable)confExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        allJars = new Vector<String>();
        rarFile = null;
        try {
            try {
                rarFile = new JarFile(absoluteRarName);
                enum = rarFile.entries();
                entry = null;
                entryName = null;
                replacedEntryName = null;
                while (enum.hasMoreElements()) {
                    entry = enum.nextElement();
                    entryName = entry.getName();
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", ZipEntryName: " + entryName + ", Dir: " + entry.isDirectory());
                    }
                    replacedEntryName = entryName.replace('/', this.sepChar);
                    in = new BufferedInputStream(rarFile.getInputStream(entry));
                    file = null;
                    fos = null;
                    try {
                        block56: {
                            block54: {
                                block55: {
                                    if (!entry.isDirectory()) ** GOTO lbl63
                                    if (!entryName.startsWith("META-INF/") && !entryName.startsWith("meta-inf/")) {
                                        this.mkDirs(new File(outputDir + this.sepChar + replacedEntryName), false);
                                    }
                                    var38_48 = null;
                                    in.close();
lbl63:
                                    // 1 sources

                                    index = entryName.lastIndexOf("/");
                                    if (index == -1) break block54;
                                    if (entryName.startsWith("META-INF/") || entryName.startsWith("meta-inf/")) break block55;
                                    if (entryName.endsWith(".jar")) {
                                        file = new File(outputDir + this.sepChar + replacedEntryName);
                                    }
                                    try {
                                        config = this.createConfiguration(connectorsConfig, entryName.substring(0, index), 0);
                                    }
                                    catch (ConfigurationException confExc) {
                                        bdExc = new BaseDeploymentException("connector_0000", new String[]{entryName.substring(0, index), connectorsConfig.getPath()}, (Throwable)confExc);
                                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                        throw bdExc;
                                    }
                                    entryName = entryName.substring(index + 1);
                                    break block56;
                                }
                                if ((entryName.startsWith("META-INF/") || entryName.startsWith("meta-inf/")) && entryName.substring(index + 1).equals("ra.xml")) {
                                    if (index > 9) {
                                        try {
                                            config = this.createConfiguration(secureMetaInfConfig, entryName.substring(9, index), 1);
                                        }
                                        catch (ConfigurationException confExc) {
                                            bdExc = new BaseDeploymentException("connector_0000", new String[]{entryName.substring(9, index), secureMetaInfConfig.getPath()}, (Throwable)confExc);
                                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                            throw bdExc;
                                        }
                                        try {
                                            propertySheet = config.getPropertySheetInterface();
                                        }
                                        catch (ConfigurationException confExc) {
                                            bdExc = new BaseDeploymentException("connector_0073", config.getPath(), (Throwable)confExc);
                                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                            throw bdExc;
                                        }
                                    }
                                    config = secureMetaInfConfig;
                                    b = new byte[in.available()];
                                    try {
                                        in.read(b);
                                        var28_42 = null;
                                        in.close();
                                    }
                                    catch (Throwable var27_41) {
                                        var28_42 = null;
                                        in.close();
                                        throw var27_41;
                                    }
                                    addXmlEntryName = entryName.substring(0, entryName.length() - 6) + "connector-j2ee-engine.xml";
                                    addXmlEntry = rarFile.getJarEntry(addXmlEntryName);
                                    entryName = entryName.substring(index + 1);
                                    addXmlEntryName = addXmlEntryName.substring(index + 1);
                                    try {
                                        propertySheet.createSecurePropertyEntry(entryName, new String(b), entryName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        bdExc = new BaseDeploymentException("connector_0056", new String[]{entryName, config.getPath()}, (Throwable)confExc);
                                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                        throw bdExc;
                                    }
                                    if (addXmlEntry != null) {
                                        in = new BufferedInputStream(rarFile.getInputStream(addXmlEntry));
                                        b = new byte[in.available()];
                                        try {
                                            in.read(b);
                                            var32_43 = null;
                                            in.close();
                                        }
                                        catch (Throwable var31_52) {
                                            var32_43 = null;
                                            in.close();
                                            throw var31_52;
                                        }
                                        try {
                                            propertySheet.createSecurePropertyEntry(addXmlEntryName, new String(b), addXmlEntryName);
                                        }
                                        catch (ConfigurationException confExc) {
                                            bdExc = new BaseDeploymentException("connector_0056", new String[]{entryName, config.getPath()}, (Throwable)confExc);
                                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                            throw bdExc;
                                        }
                                    }
                                }
                                break block56;
                            }
                            if (entryName.endsWith(".jar")) {
                                file = new File(outputDir + this.sepChar + replacedEntryName);
                            }
                            config = connectorsConfig;
                        }
                        if (entryName.endsWith(".jar")) {
                            allJars.add(file.getPath());
                            try {
                                this.mkDirs(file, true);
                                fos = new FileOutputStream(file);
                            }
                            catch (FileNotFoundException fnfe) {
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(fnfe));
                                throw fnfe;
                            }
                        }
                        if (fos == null) {
                            var38_48 = null;
                            ** try [egrp 17[TRYBLOCK] [15 : 1736->1744)] { 
lbl170:
                            // 1 sources

                            in.close();
                        }
                        count = 1024;
                        buff = new byte[count];
                        try {
                            try {
                                if (true) ** GOTO lbl191
                                catch (IOException ioe) {
                                    warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                                }
                                continue;
lbl183:
                                // 1 sources

                                catch (IOException ioe) {
                                    warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                                }
                                continue;
                                do {
                                    fos.write(buff, 0, count);
lbl191:
                                    // 2 sources

                                } while ((count = in.read(buff)) != -1);
                                fos.flush();
                                var34_46 = null;
                                fos.close();
                            }
                            catch (Throwable var33_45) {
                                var34_46 = null;
                                fos.close();
                                throw var33_45;
                            }
                        }
                        catch (EOFException ex) {
                            buff = new byte[(int)entry.getSize()];
                            in.read(buff);
                            in.close();
                            try {
                                fos.flush();
                                var36_47 = null;
                                fos.close();
                            }
                            catch (Throwable var35_54) {
                                var36_47 = null;
                                fos.close();
                                throw var35_54;
                            }
                        }
                        this.addFileAsStreamToConfig(entryName, config, file, update);
                        var38_48 = null;
                        ** try [egrp 17[TRYBLOCK] [15 : 1736->1744)] { 
lbl223:
                        // 1 sources

                        in.close();
lbl225:
                        // 1 sources

                        catch (IOException ioe) {
                            warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                        }
                    }
                    catch (Throwable var37_55) {
                        var38_48 = null;
                        ** try [egrp 17[TRYBLOCK] [15 : 1736->1744)] { 
lbl235:
                        // 1 sources

                        in.close();
                        throw var37_55;
lbl237:
                        // 1 sources

                        catch (IOException ioe) {
                            warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioe));
                        }
                        throw var37_55;
                    }
                }
            }
            catch (IOException ioexc) {
                bdExc = new BaseDeploymentException("connector_0010", absoluteRarName, (Throwable)ioexc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            var41_56 = null;
            if (rarFile == null) return allJars.toArray(new String[allJars.size()]);
            try {
                rarFile.close();
                return allJars.toArray(new String[allJars.size()]);
            }
            catch (IOException ioe) {
                warnings.add("Cannot close '" + absoluteRarName + "' rar file, reason : " + Log.getStackTrace(ioe));
                ConnectorResourceAccessor.location.logT(300, "Cannot close '" + absoluteRarName + "' rar file, reason : " + Log.getStackTrace(ioe));
                return allJars.toArray(new String[allJars.size()]);
            }
        }
        catch (Throwable var40_60) {
            var41_57 = null;
            if (rarFile == null) throw var40_60;
            ** try [egrp 18[TRYBLOCK] [18 : 1909->1917)] { 
lbl264:
            // 1 sources

            rarFile.close();
            throw var40_60;
lbl266:
            // 1 sources

            catch (IOException ioe) {
                warnings.add("Cannot close '" + absoluteRarName + "' rar file, reason : " + Log.getStackTrace(ioe));
                ConnectorResourceAccessor.location.logT(300, "Cannot close '" + absoluteRarName + "' rar file, reason : " + Log.getStackTrace(ioe));
            }
            throw var40_60;
        }
    }

    public void writeDescriptorIntoSheet(String appName, Configuration rootConfig, JCDescriptor descriptor, String raXmlName, String addXmlName, boolean update, boolean defaultValue) throws DeploymentException {
        PropertyEntry addXmlPropEntry;
        PropertyEntry raXmlPropEntry;
        PropertySheet sheet;
        Configuration config;
        String logPrefix;
        block44: {
            block43: {
                logPrefix = "DeployAdmin.writeDescriptorIntoSheet(), Application: " + appName;
                ConnectorResourceAccessor.location.logT(100, logPrefix);
                config = null;
                sheet = null;
                try {
                    config = this.createConfiguration(rootConfig, "SECURE-META-INF/" + descriptor.getRarName(), 1);
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc = null;
                    bdExc = update ? new BaseDeploymentException("connector_0001", new String[]{"SECURE-META-INF/" + descriptor.getRarName(), rootConfig.getPath()}, (Throwable)((Object)confExc)) : new BaseDeploymentException("connector_0000", new String[]{"SECURE-META-INF/" + descriptor.getRarName(), rootConfig.getPath()}, (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
                try {
                    sheet = config.getPropertySheetInterface();
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0073", config.getPath(), (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
                raXmlPropEntry = null;
                addXmlPropEntry = null;
                try {
                    raXmlPropEntry = sheet.getPropertyEntry(raXmlName);
                    if (!update) {
                        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0071", new String[]{raXmlName, config.getPath()});
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                }
                catch (ConfigurationException confExc) {
                    if (!update) break block43;
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0003", new String[]{raXmlName, config.getPath()}, (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
            }
            try {
                addXmlPropEntry = sheet.getPropertyEntry(addXmlName);
            }
            catch (Exception exc) {
                if (!ConnectorResourceAccessor.location.beLogged(100)) break block44;
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + Log.getStackTrace(exc));
            }
        }
        String raXmlToString = null;
        String addXmlToString = null;
        try {
            raXmlToString = descriptor.saveRaXmlToString();
        }
        catch (Exception ioExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{raXmlName, config.getPath()}, (Throwable)ioExc);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            addXmlToString = descriptor.saveAddXmlToString();
        }
        catch (Exception ioExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{addXmlName, config.getPath()}, (Throwable)ioExc);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        if (raXmlPropEntry == null) {
            try {
                sheet.createSecurePropertyEntry(raXmlName, raXmlToString, raXmlName);
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0056", new String[]{raXmlName, config.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
        }
        try {
            if (defaultValue) {
                raXmlPropEntry.setDefault(raXmlToString);
            } else {
                raXmlPropEntry.setValue(raXmlToString);
            }
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{raXmlName, config.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        if (addXmlPropEntry != null) {
            try {
                if (defaultValue) {
                    addXmlPropEntry.setDefault(addXmlToString);
                }
                addXmlPropEntry.setValue(addXmlToString);
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{addXmlName, config.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
        } else {
            try {
                addXmlPropEntry = sheet.createSecurePropertyEntry(addXmlName, addXmlToString, addXmlName);
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0056", new String[]{addXmlName, config.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            if (!defaultValue) {
                try {
                    addXmlPropEntry.setValue(addXmlToString);
                    try {
                        addXmlToString = new JCDescriptor().saveAddXmlToString();
                    }
                    catch (Exception ioExc) {
                        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{addXmlName, config.getPath()}, (Throwable)ioExc);
                        if (ConnectorResourceAccessor.location.beLogged(500)) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        }
                        throw bdExc;
                    }
                    addXmlPropEntry.setDefault(addXmlToString);
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0005", new String[]{addXmlName, config.getPath()}, (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
            }
        }
    }

    public boolean extractFiles(Configuration appConfig, String appName, String workAppDir, Vector connectors, Vector allJars, Properties props, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.extractFiles(Configuration appConfig), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        boolean realApp = this.getAllConnectors(appConfig, appName, connectors, props, warnings);
        this.getAllFiles(new File(workAppDir), allJars);
        ConnectorResourceAccessor.location.logT(100, logPrefix + " was finished successfully.");
        return realApp;
    }

    private boolean getAllConnectors(Configuration appConfig, String appName, Vector connectors, Properties props, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.getAllConnectors(), Application: " + appName;
        this.loadProperties(appName, appConfig, props);
        boolean realApp = props.getProperty("isStandAlone").equalsIgnoreCase("false");
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        Hashtable map = new Hashtable();
        try {
            this.getValuesForAllPropertyEntries(appName, "/SECURE-META-INF", appConfig.getSubConfiguration(SECURE_META_INF), map, false);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0075", appConfig.getPath(), (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Iterator fileNamesIter = map.keySet().iterator();
        while (fileNamesIter.hasNext()) {
            String fileName = (String)fileNamesIter.next();
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + " FileEntryName: " + fileName);
            }
            InputStream is = (InputStream)map.get(fileName);
            String name = fileName.substring(fileName.lastIndexOf("/") + 1);
            if (!name.endsWith("ra.xml") || name.startsWith("~") || name.startsWith("@")) continue;
            String relativePath = fileName.substring(17, fileName.length() - (name.length() + 1));
            String addXmlName = fileName.substring(0, fileName.length() - 6) + "connector-j2ee-engine.xml";
            InputStream addXmlIs = (InputStream)map.get(addXmlName);
            String prefix = "";
            if (name.length() > 6) {
                prefix = name.substring(0, name.length() - 6 - 1);
            }
            JCDescriptor descr = this.getConnectorDescriptor(appName, realApp, relativePath, prefix, is, addXmlIs, warnings);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", FileEntryName: " + fileName + ", RaXmlName: " + fileName + ", AddXmlName: " + addXmlName + " Prefix: " + prefix + " JNDI: " + descr.getConnectorJNDIName());
            }
            connectors.add(descr);
        }
        ConnectorResourceAccessor.location.logT(100, logPrefix + " was finished successfully.");
        return realApp;
    }

    public void loadProperties(String appName, Configuration myContainerConfig, Properties props) throws DeploymentException {
        String logPrefix = "DeployAdmin.loadProperties(), Application: " + appName;
        Configuration propertiesConfig = null;
        try {
            propertiesConfig = myContainerConfig.getSubConfiguration(PROPERTIES);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{PROPERTIES, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            props.load(propertiesConfig.getFile(this.makePropertyFileName(appName, null, false)));
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0012", new String[]{this.makePropertyFileName(appName, null, false), propertiesConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        catch (IOException ioe) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0012", new String[]{this.makePropertyFileName(appName, null, false), propertiesConfig.getPath()}, (Throwable)ioe);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
    }

    public void extractProperties(Configuration rootConfig, String appName, String workAppDir, Properties props, boolean update) throws DeploymentException {
        String logPrefix = "DeployAdmin.extractProperties(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        Configuration propertiesConfig = null;
        try {
            propertiesConfig = this.createConfiguration(rootConfig, PROPERTIES, 0);
        }
        catch (ConfigurationException conex) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0000", new String[]{PROPERTIES, rootConfig.getPath()}, (Throwable)((Object)conex));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        this.saveProperties(appName, propertiesConfig, this.makePropertyFileName(appName, null, false), props, update);
    }

    private void saveProperties(String appName, Configuration propertiesConfig, String configEntryName, Properties props, boolean update) throws DeploymentException {
        String logPrefix = "DeployAdmin.saveProperties(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, null);
        }
        catch (IOException ioExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0011", new String[]{configEntryName, propertiesConfig.getPath()}, (Throwable)ioExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        bais = new ByteArrayInputStream(baos.toByteArray());
        this.addFileAsStreamToConfig(configEntryName, propertiesConfig, bais, update);
    }

    public void registerIdentitySubjects(String appName, ManagedConnectionFactory mcf, JCDescriptor descr, Configuration myContainerConfig) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerIdentitySubjects(), Application: " + appName;
        IdentitySubject[] subjects = descr.getIdentitySubjects();
        String connectorName = DeployAdmin.fixName(DeployAdmin.makeConnectorName(descr));
        String authenticationType = descr.getAuthenticationType();
        UserStore raUserStore = null;
        boolean internalUS = descr.isInternalUserStore();
        String userStore = descr.getUserStore();
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", AuthType: " + authenticationType);
        if (authenticationType == null) {
            return;
        }
        Configuration securityConfig = null;
        try {
            securityConfig = this.createConfiguration(myContainerConfig, "prefix:" + descr.getConnectorJNDIName(), 0);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0000", new String[]{"prefix:" + descr.getConnectorJNDIName(), myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        SecurityContext mySecurityContext = this.getMySecurityContext(appName, descr, connectorName, securityConfig, true);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", UserStore: " + userStore + ", Internal: " + internalUS);
        if (userStore != null) {
            if (internalUS) {
                raUserStore = this.registerRAUserStore(appName, descr, mySecurityContext);
            } else {
                try {
                    raUserStore = this.securityContext.getUserStoreContext().getUserStore(userStore);
                }
                catch (NullPointerException npExc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
                catch (SecurityException secExc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", new String[]{userStore, descr.getConnectorJNDIName(), appName}, (Throwable)secExc);
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
                if (raUserStore == null) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", userStore);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
            }
        }
        Hashtable userMapping = new Hashtable();
        Hashtable groupMapping = new Hashtable();
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        Vector<CallerImpersonationConfiguration> configEntries = new Vector<CallerImpersonationConfiguration>();
        if (subjects == null) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: 0");
        } else {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + subjects.length);
        }
        ResourcePrincipal resourcePrincipal = null;
        int i = 0;
        while (subjects != null && i < subjects.length) {
            CallerPrincipal callerPrincipal = subjects[i].getCallerPrincipal();
            resourcePrincipal = subjects[i].getResourcePrincipal();
            if (internalUS) {
                this.addMappingInUS(appName, descr.getConnectorJNDIName(), raUserStore, subjects[i].getResourcePrincipal());
            }
            if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
                HashSet groups;
                HashSet users = callerPrincipal.getUserNames();
                if (users != null) {
                    Iterator usersIterator = users.iterator();
                    while (usersIterator.hasNext()) {
                        Object user = usersIterator.next();
                        if (ConnectorResourceAccessor.location.beLogged(300)) {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add User Mapping: " + user + ", " + resourcePrincipal.getUserName());
                        }
                        userMapping.put(user, resourcePrincipal.getUserName());
                    }
                }
                if ((groups = callerPrincipal.getGroups()) != null) {
                    Iterator groupsIterator = groups.iterator();
                    while (groupsIterator.hasNext()) {
                        Object group = groupsIterator.next();
                        if (ConnectorResourceAccessor.location.beLogged(300)) {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add Group Mapping: " + group + ", " + resourcePrincipal.getUserName());
                        }
                        groupMapping.put(group, resourcePrincipal.getUserName());
                    }
                }
            }
            ++i;
        }
        AppConfigurationEntry configEntry = null;
        if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            options.put("Users_Mapping", userMapping);
            options.put("Groups_Mapping", groupMapping);
            configEntry = new PrincipalMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CallerImpersonationConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Credentials Mapping")) {
            if (userStore != null) {
                options.put("User_Store", userStore);
            }
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CredentialsMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Configured Identity")) {
            Hashtable<String, String> intOptions = new Hashtable<String, String>();
            intOptions.put("Configured_Identity", resourcePrincipal.getUserName());
            intOptions.put("User_Store", userStore);
            intOptions.put("Managed_Connection_Factory", (String)mcf);
            configEntry = new ConfiguredIdentityConfiguration(intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthMechanism[] authMechs = descr.getAuthMechanisms();
        boolean isSAPLogon = this.checkForSapLogon(authMechs);
        if (!(!isSAPLogon || authenticationType.equalsIgnoreCase("Caller Impersonation") || authenticationType.equalsIgnoreCase("Credentials Mapping") && userStore != null)) {
            Hashtable<String, String> _intOptions = new Hashtable<String, String>();
            _intOptions.put("ume.configuration.active", "true");
            configEntry = new AppConfigurationEntry("com.sap.security.core.server.jaas.CreateAssertionTicketLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, _intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthenticationContext myAuthenticationContext = this.getMyAuthenticationContext(appName, descr, mySecurityContext);
        try {
            myAuthenticationContext.setAuthenticationUserStore(raUserStore);
        }
        catch (SecurityException se) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0036", new String[]{userStore, connectorName}, (Throwable)se);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        try {
            myAuthenticationContext.setLoginModules(configEntries.toArray(new AppConfigurationEntry[configEntries.size()]));
        }
        catch (SecurityException se) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0037", connectorName, (Throwable)se);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
    }

    public void preRegisterIdentitySubjects(String appName, ManagedConnectionFactory mcf, JCDescriptor descr) throws DeploymentException {
        String logPrefix = "DeployAdmin.preRegisterIdentitySubjects(), Application: " + appName;
        IdentitySubject[] subjects = descr.getIdentitySubjects();
        String connectorName = DeployAdmin.fixName(DeployAdmin.makeConnectorName(descr));
        String authenticationType = descr.getAuthenticationType();
        CallerPrincipal callerPrincipal = null;
        ResourcePrincipal resourcePrincipal = null;
        AppConfigurationEntry configEntry = null;
        UserStore raUserStore = null;
        boolean internalUS = descr.isInternalUserStore();
        String userStore = descr.getUserStore();
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", AuthType: " + authenticationType);
        if (authenticationType == null) {
            return;
        }
        SecurityContext mySecurityContext = this.getMySecurityContext(appName, descr, connectorName, this.securityContext);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", UserStore: " + userStore + ", Internal: " + internalUS);
        if (userStore != null) {
            try {
                raUserStore = this.securityContext.getUserStoreContext().getUserStore(userStore);
            }
            catch (NullPointerException npExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            catch (SecurityException secExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", new String[]{userStore, descr.getConnectorJNDIName(), appName}, (Throwable)secExc);
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            if (raUserStore == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", userStore);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        Hashtable userMapping = new Hashtable();
        Hashtable groupMapping = new Hashtable();
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        Vector<CallerImpersonationConfiguration> configEntries = new Vector<CallerImpersonationConfiguration>();
        if (subjects != null) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + subjects.length);
        } else {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + 0);
        }
        int i = 0;
        while (subjects != null && i < subjects.length) {
            callerPrincipal = subjects[i].getCallerPrincipal();
            resourcePrincipal = subjects[i].getResourcePrincipal();
            if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
                HashSet groups;
                HashSet users = callerPrincipal.getUserNames();
                if (users != null) {
                    Iterator usersIterator = users.iterator();
                    while (usersIterator.hasNext()) {
                        Object user = usersIterator.next();
                        if (ConnectorResourceAccessor.location.beLogged(300)) {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add User Mapping: " + user + ", " + resourcePrincipal.getUserName());
                        }
                        userMapping.put(user, resourcePrincipal.getUserName());
                    }
                }
                if ((groups = callerPrincipal.getGroups()) != null) {
                    Iterator groupsIterator = groups.iterator();
                    while (groupsIterator.hasNext()) {
                        Object group = groupsIterator.next();
                        if (ConnectorResourceAccessor.location.beLogged(300)) {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add Group Mapping: " + group + ", " + resourcePrincipal.getUserName());
                        }
                        groupMapping.put(group, resourcePrincipal.getUserName());
                    }
                }
            }
            ++i;
        }
        if (authenticationType.equalsIgnoreCase("Principal Mapping")) {
            options.put("User_Store", userStore);
            options.put("Managed_Connection_Factory", mcf);
            options.put("Users_Mapping", userMapping);
            options.put("Groups_Mapping", groupMapping);
            configEntry = new PrincipalMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Caller Impersonation")) {
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CallerImpersonationConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Credentials Mapping")) {
            if (userStore != null) {
                options.put("User_Store", userStore);
            }
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CredentialsMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (authenticationType.equalsIgnoreCase("Configured Identity")) {
            Hashtable<String, String> intOptions = new Hashtable<String, String>();
            intOptions.put("Configured_Identity", resourcePrincipal.getUserName());
            intOptions.put("User_Store", userStore);
            intOptions.put("Managed_Connection_Factory", (String)mcf);
            configEntry = new ConfiguredIdentityConfiguration(intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthMechanism[] authMechs = descr.getAuthMechanisms();
        boolean isSAPLogon = this.checkForSapLogon(authMechs);
        if (!(!isSAPLogon || authenticationType.equalsIgnoreCase("Caller Impersonation") || authenticationType.equalsIgnoreCase("Credentials Mapping") && userStore != null)) {
            Hashtable<String, String> _intOptions = new Hashtable<String, String>();
            _intOptions.put("ume.configuration.active", "true");
            configEntry = new AppConfigurationEntry("com.sap.security.core.server.jaas.CreateAssertionTicketLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, _intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthenticationContext myAuthenticationContext = this.getMyAuthenticationContext(appName, descr, mySecurityContext);
        try {
            myAuthenticationContext.setLoginModules(configEntries.toArray(new AppConfigurationEntry[configEntries.size()]));
        }
        catch (SecurityException se) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0037", connectorName, (Throwable)se);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
    }

    public SecurityContext getMySecurityContext(String appName, JCDescriptor descr, String connectorName, Configuration securityConfig, boolean create) throws DeploymentException {
        String logPrefix = "DeployAdmin.getMySecurityContext(), Application: " + appName;
        SecurityContext mySecurityContext = null;
        try {
            mySecurityContext = this.securityContext.getModificationContext().beginModifications(securityConfig);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", MySecurityContext: " + mySecurityContext.getPolicyConfigurationName());
            if (mySecurityContext == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0031", securityConfig.getPath());
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        catch (NullPointerException npExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        catch (SecurityException sexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0031", securityConfig.getPath(), (Throwable)sexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        if (create) {
            try {
                mySecurityContext.registerPolicyConfiguration(connectorName);
            }
            catch (SecurityException se) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0039", connectorName, (Throwable)se);
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
        }
        return this.getMySecurityContext(appName, descr, connectorName, mySecurityContext);
    }

    public SecurityContext getMySecurityContext(String appName, JCDescriptor descr, String policyConfName, SecurityContext secCtx) throws DeploymentException {
        String logPrefix = "DeployAdmin.getMySecurityContext(), Application: " + appName;
        SecurityContext mySecurityContext = null;
        try {
            mySecurityContext = secCtx.getPolicyConfigurationContext(policyConfName);
            if (mySecurityContext == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0038", new String[]{policyConfName, secCtx.getPolicyConfigurationName(), descr.getConnectorJNDIName(), appName});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        catch (NullPointerException npExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0030", new String[]{"security", "security service"});
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (SecurityException secExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0038", new String[]{policyConfName, secCtx.getPolicyConfigurationName(), descr.getConnectorJNDIName(), appName}, (Throwable)secExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        return mySecurityContext;
    }

    public AuthenticationContext getMyAuthenticationContext(String appName, JCDescriptor descr, SecurityContext mySecurityContext) throws DeploymentException {
        String logPrefix = "DeployAdmin.getMyAuthenticationContext(), Application: " + appName;
        AuthenticationContext myAuthenticationContext = null;
        try {
            myAuthenticationContext = mySecurityContext.getAuthenticationContext();
            if (myAuthenticationContext == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0072", new String[]{mySecurityContext.getPolicyConfigurationName(), descr.getConnectorJNDIName(), appName});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        catch (SecurityException secExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0065", new String[]{mySecurityContext.getPolicyConfigurationName(), descr.getConnectorJNDIName(), appName}, (Throwable)secExc);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", My AuthenticationContext: " + myAuthenticationContext.getPolicyConfigurationName());
        }
        return myAuthenticationContext;
    }

    private UserStore registerRAUserStore(String appName, JCDescriptor descr, SecurityContext mySecurityContext) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerRAUserStore(), Component: " + descr.getConnectorJNDIName() + " in Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        String userStore = descr.getUserStore();
        ConnectorUserstoreConfiguration userStoreConfig = new ConnectorUserstoreConfiguration(userStore);
        try {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering UserStore: " + userStoreConfig.getName());
            }
            mySecurityContext.getUserStoreContext().registerUserStore(userStoreConfig, this.getClass().getClassLoader());
            if (ConnectorResourceAccessor.location.beLogged(300)) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", UserStore: " + userStoreConfig.getName() + " was registered successfully.");
            }
        }
        catch (SecurityException se) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0033", userStore, (Throwable)se);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        UserStore resultUserStore = this.getRAUserStore(appName, descr, mySecurityContext);
        FilterUsername filterUsername = resultUserStore.getUserContext().getFilterUsername();
        filterUsername.setRestriction(2, 256);
        FilterPassword filterPassword = resultUserStore.getUserContext().getFilterPassword();
        filterPassword.setRestriction(2, 256);
        return resultUserStore;
    }

    public UserStore getRAUserStore(String appName, JCDescriptor descr, SecurityContext mySecurityContext) throws BaseDeploymentException {
        String logPrefix = "DeployAdmin.getRAUserStore(), Component: " + descr.getConnectorJNDIName() + " in Application: " + appName;
        String userStore = descr.getUserStore();
        UserStore raUserStore = null;
        try {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Getting UserStore: " + userStore);
            }
            raUserStore = mySecurityContext.getUserStoreContext().getUserStore(userStore);
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", UserStore: " + raUserStore + " was got successfully.");
            }
        }
        catch (SecurityException se) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", new String[]{userStore, descr.getConnectorJNDIName(), appName}, (Throwable)se);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        if (raUserStore == null) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0032", new String[]{userStore, descr.getConnectorJNDIName(), appName});
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        return raUserStore;
    }

    public void unregisterRAUserStore(String appName, JCDescriptor descr, Configuration securityConfig) throws DeploymentException {
        String logPrefix = "DeployAdmin.unregisterRAUserStore(), Component: " + descr.getConnectorJNDIName() + " in Application: " + appName;
        Configuration userStoreCfg = null;
        try {
            userStoreCfg = securityConfig.getSubConfiguration("userstore");
        }
        catch (ConfigurationException cfgExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{"userstore", securityConfig.getPath()}, (Throwable)((Object)cfgExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            userStoreCfg.deleteConfiguration();
        }
        catch (ConfigurationException cfgExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0054", userStoreCfg.getPath(), (Throwable)((Object)cfgExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
    }

    public void unregisterPolicyConfiguration(String appName, JCDescriptor descr, Configuration securityConfig) throws DeploymentException {
        String logPrefix = "DeployAdmin.unregisterPolicyConfiguration(), Component: " + descr.getConnectorJNDIName() + " in Application: " + appName;
        Configuration policyCfg = null;
        try {
            policyCfg = securityConfig.getSubConfiguration("security");
        }
        catch (ConfigurationException cfgExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{"security", securityConfig.getPath()}, (Throwable)((Object)cfgExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            policyCfg.deleteConfiguration();
        }
        catch (ConfigurationException cfgExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0054", policyCfg.getPath(), (Throwable)((Object)cfgExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
    }

    private void addMappingInUS(String appName, String compName, UserStore userStore, ResourcePrincipal resPrincipal) throws BaseDeploymentException {
        String logPrefix = "DeployAdmin.addMappingInUS(), Component: " + compName + " in Application: " + appName;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Creating User: " + resPrincipal.getUserName());
        }
        try {
            UserInfo createdUser = userStore.getUserContext().createUser(resPrincipal.getUserName());
            if (resPrincipal.getPassword() != null) {
                createdUser.setPassword(resPrincipal.getPassword().toCharArray());
            } else {
                createdUser.setPassword(null);
            }
        }
        catch (SecurityException secExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0068", new String[]{resPrincipal.getUserName(), userStore.getConfiguration().getName(), compName, appName}, (Throwable)secExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", User: " + resPrincipal.getUserName() + " was created successfully.");
        }
    }

    public String[] extractDrivers(Configuration rootConfig, JCDescriptor descr, String workAppName, String relativeRarName, boolean update) throws DeploymentException {
        Configuration driversConfig = null;
        DriverInfo[] drivers = descr.getDrivers();
        if (drivers == null) {
            return new String[0];
        }
        Vector<String> allJars = new Vector<String>();
        String workDriversDirName = this.makeDriversDir(workAppName) + this.sepChar + relativeRarName.replace('/', this.sepChar);
        int i = 0;
        while (i < drivers.length) {
            HashSet jars = drivers[i].getJars();
            if (jars != null) {
                if (driversConfig == null) {
                    try {
                        driversConfig = this.createConfiguration(rootConfig, "drivers/" + relativeRarName, 0);
                    }
                    catch (ConfigurationException conex) {
                        throw new BaseDeploymentException("connector_0000", new String[]{"drivers/" + relativeRarName, rootConfig.getPath()}, (Throwable)((Object)conex));
                    }
                }
                Iterator jarsEnumeration = jars.iterator();
                while (jarsEnumeration.hasNext()) {
                    String jar = (String)jarsEnumeration.next();
                    File jarSourceFile = new File(jar);
                    String realDriverJarName = this.makeDriverJarName(workDriversDirName, descr.getRarName(), drivers[i].getDriverName(), jarSourceFile.getName(), false);
                    String replacedDriverJarName = realDriverJarName.replace('\\', this.sepChar).replace('/', this.sepChar);
                    File jarOutputFile = new File(workDriversDirName + this.sepChar + replacedDriverJarName);
                    this.mkDirs(jarOutputFile, true);
                    allJars.add(jarOutputFile.getPath());
                    int index = replacedDriverJarName.lastIndexOf(this.sepChar);
                    if (index != -1) {
                        try {
                            this.createConfiguration(driversConfig, replacedDriverJarName.substring(0, index), 0);
                        }
                        catch (ConfigurationException conex) {
                            throw new BaseDeploymentException("connector_0000", new String[]{replacedDriverJarName.substring(0, index), driversConfig.getPath()}, (Throwable)((Object)conex));
                        }
                    }
                    try {
                        FileUtils.copyFile(jarSourceFile, jarOutputFile);
                    }
                    catch (IOException ioe) {
                        throw new BaseDeploymentException("connector_0013", jar, (Throwable)ioe);
                    }
                    this.addFileAsStreamToConfig(replacedDriverJarName, driversConfig, jarOutputFile, update);
                }
            }
            ++i;
        }
        return allJars.toArray(new String[allJars.size()]);
    }

    public Driver instantiateDriver(ClassLoader loader, String driverClassName) throws DeploymentException {
        Class<?> driverClass = null;
        try {
            driverClass = loader.loadClass(driverClassName);
            Driver driver = (Driver)driverClass.newInstance();
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BaseDeploymentException("connector_0026", driverClassName, (Throwable)cnfe);
        }
        catch (InstantiationException instExc) {
            throw new BaseDeploymentException("connector_0027", driverClass.getName(), (Throwable)instExc);
        }
        catch (IllegalAccessException illAssExc) {
            throw new BaseDeploymentException("connector_0028", driverClass.getName(), (Throwable)illAssExc);
        }
    }

    public void registerDriver(String appName, Driver driver) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerDriver(), Application: " + appName;
        try {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Driver : " + driver.getClass());
            }
            DriverManager.registerDriver(driver);
            if (ConnectorResourceAccessor.location.beLogged(300)) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Driver : " + driver.getClass() + " was registered successfully.");
            }
        }
        catch (SQLException sqlExc) {
            throw new BaseDeploymentException("connector_0040", driver.getClass(), (Throwable)sqlExc);
        }
    }

    public void unregisterDrivers(ClassLoader loader, String[] drivers) {
    }

    private String makeDriverJarName(String driverJarsDir, String rarName, String driverName, String driverJarName, boolean local) {
        StringBuffer result = null;
        result = local ? new StringBuffer(driverJarsDir) : new StringBuffer();
        result.append(rarName).append("-").append(driverName).append("-").append(driverJarName);
        return result.toString();
    }

    public String registerReferenceToConnectorGroup(String classLoaderName, ApplicationInfo appInfo) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerReferenceToConnectorGroup(), Application: " + appInfo.getApplicationName();
        String groupLoaderName = DeployAdmin.makeRealConnectorLoaderName(appInfo.getConnectorGroup());
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", RegisterLoaderRef: " + classLoaderName + ", " + groupLoaderName);
        this.loadContext.registerReference(classLoaderName, groupLoaderName);
        appInfo.setClassLoaderName(classLoaderName);
        return groupLoaderName;
    }

    public void unregisterReferenceToConnectorGroup(ApplicationInfo appInfo) throws WarningException {
        String logPrefix = "DeployAdmin.unregisterReferenceToConnectorGroup(), Application: " + appInfo.getApplicationName();
        String classLoaderName = appInfo.getClassLoaderName();
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", UnregisterLoaderRef: " + classLoaderName + ", " + DeployAdmin.makeRealConnectorLoaderName(appInfo.getConnectorGroup()));
        if (classLoaderName == null) {
            return;
        }
        this.loadContext.unregisterReference(classLoaderName, DeployAdmin.makeRealConnectorLoaderName(appInfo.getConnectorGroup()));
        this.removeReferences(classLoaderName, appInfo);
    }

    public ManagedConnectionFactory instantiateMCF(ResourceLoader loader, String appName, JCDescriptor descriptor) throws DeploymentException {
        String logPrefix = "DeployAdmin.instantiateMCF(), Application: " + appName + ", Connector : " + descriptor.getConnectorJNDIName();
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Loader : " + loader.getInfo());
        Class mcfClass = null;
        try {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Load MCF.class : " + descriptor.getManagedConnectionFactoryClass());
            mcfClass = loader.loadClass(descriptor.getManagedConnectionFactoryClass());
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Create new instance of MCF.class : " + descriptor.getManagedConnectionFactoryClass());
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfClass.newInstance();
            ManagedFactoryProperty mfp = descriptor.getManagedFactoryProperty();
            if (mfp == null) {
                return mcf;
            }
            ConfigProperty[] configProps = mfp.getConfigProperties();
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", ConfigProperties: " + configProps.length);
            int j = 0;
            while (j < configProps.length) {
                String property = configProps[j].getConfigPropertyName();
                String type = configProps[j].getConfigPropertyType();
                String value = configProps[j].getConfigPropertyValue();
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", ConfigProperty[" + j + "]: " + property + ", Type : " + type);
                Class<?> propsClass = Class.forName(type);
                if (type.equals("java.lang.String")) {
                    mcfClass.getMethod(this.setMethod(property), propsClass).invoke((Object)mcf, value);
                } else {
                    Object obj = propsClass.getConstructor(class$java$lang$String == null ? DeployAdmin.class$("java.lang.String") : class$java$lang$String).newInstance(value);
                    mcfClass.getMethod(this.setMethod(property), propsClass).invoke((Object)mcf, obj);
                }
                ++j;
            }
            return mcf;
        }
        catch (ClassNotFoundException cnfe) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0026", descriptor.getManagedConnectionFactoryClass(), (Throwable)cnfe);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (NoClassDefFoundError ncdfe) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0026", descriptor.getManagedConnectionFactoryClass(), (Throwable)ncdfe);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (InstantiationException instExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0027", mcfClass.getName(), (Throwable)instExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (IllegalAccessException illAssExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0028", mcfClass.getName(), (Throwable)illAssExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (NoSuchMethodException nsmExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0028", mcfClass.getName(), (Throwable)nsmExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        catch (InvocationTargetException itExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0029", mcfClass.getName(), (Throwable)itExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
    }

    public void registerReferences(ApplicationInfo appInfo, JCDescriptor descriptor, ResourceLoader loader) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerReferences(), Application: " + appInfo.getApplicationName();
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Standalone : " + !descriptor.isRealApplication() + ", Connector : " + descriptor.getConnectorJNDIName() + ", Loader : " + loader.getInfo());
        if (!descriptor.isRealApplication()) {
            String[] loaderReferences = descriptor.getLoaderReferences();
            String loaderName = loader.getName();
            int i = 0;
            while (loaderReferences != null && i < loaderReferences.length) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", LoaderReference[" + i + "]: " + loaderReferences[i]);
                String[] registeredRefs = this.loadContext.getReferencesFrom(loaderName);
                boolean currentlyRegistered = false;
                int j = 0;
                while (j < registeredRefs.length) {
                    if (registeredRefs[j] != null && registeredRefs[j].equals(loaderReferences[i])) {
                        currentlyRegistered = true;
                        break;
                    }
                    ++j;
                }
                if (!currentlyRegistered) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register reference: " + loaderName + ", " + loaderReferences[i]);
                    this.loadContext.registerReference(loaderName, loaderReferences[i]);
                    appInfo.addLoaderReference(loaderReferences[i]);
                } else {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Reference: " + loaderName + ", " + loaderReferences[i] + " already exists.");
                }
                ++i;
            }
        }
    }

    private String setMethod(String property) {
        return "set" + property.toUpperCase().charAt(0) + property.substring(1);
    }

    private void addFileAsStreamToConfig(String entryName, Configuration config, File in, boolean update) throws DeploymentException {
        try {
            config.addFileEntryByKey(entryName, in);
        }
        catch (NameAlreadyExistsException nex) {
            if (!update) {
                throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)nex));
            }
            try {
                config.updateFileByKey(entryName, in);
            }
            catch (ConfigurationException cexc) {
                throw new BaseDeploymentException("connector_0005", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
            }
        }
        catch (ConfigurationException cexc) {
            throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
        }
    }

    private void addFileAsStreamToConfig(String entryName, Configuration config, InputStream in, boolean update) throws DeploymentException {
        try {
            config.addFileAsStream(entryName, in);
        }
        catch (NameAlreadyExistsException nex) {
            if (!update) {
                throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)nex));
            }
            try {
                config.updateFileAsStream(entryName, in);
            }
            catch (ConfigurationException cexc) {
                throw new BaseDeploymentException("connector_0005", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
            }
        }
        catch (ConfigurationException cexc) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                ConnectorServiceFrame.logException(ioe);
            }
            throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
        }
    }

    Configuration createConfiguration(Configuration rootConfig, String configurationName, int configType) throws ConfigurationException, InconsistentReadException, NoWriteAccessException {
        StringTokenizer tokenizer = new StringTokenizer(configurationName, "/");
        while (tokenizer.hasMoreElements()) {
            String subConfigName = tokenizer.nextToken();
            try {
                rootConfig = rootConfig.getSubConfiguration(subConfigName);
            }
            catch (ConfigurationException ce) {
                rootConfig = configType == 1 && tokenizer.hasMoreElements() ? rootConfig.createSubConfiguration(subConfigName, 0) : rootConfig.createSubConfiguration(subConfigName, configType);
            }
        }
        return rootConfig;
    }

    Configuration getConfiguration(Configuration rootConfig, String configurationName) throws ConfigurationException, InconsistentReadException, NoWriteAccessException {
        StringTokenizer tokenizer = new StringTokenizer(configurationName, "/");
        while (tokenizer.hasMoreElements()) {
            String subConfigName = tokenizer.nextToken();
            rootConfig = rootConfig.getSubConfiguration(subConfigName);
        }
        return rootConfig;
    }

    Configuration getConfigurationIfExists(Configuration rootConfig, String configurationName) throws ConfigurationException, InconsistentReadException, NoWriteAccessException {
        StringTokenizer tokenizer = new StringTokenizer(configurationName, "/");
        while (tokenizer.hasMoreElements()) {
            String subConfigName = tokenizer.nextToken();
            if (!rootConfig.existsSubConfiguration(subConfigName)) {
                return null;
            }
            rootConfig = rootConfig.getSubConfiguration(subConfigName);
        }
        return rootConfig;
    }

    void mkDirs(File dir, boolean isFile) throws DeploymentException {
        if (isFile && (dir = dir.getParentFile()) == null) {
            return;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new BaseDeploymentException("connector_0015", dir.getAbsolutePath());
        }
    }

    void getAllFileEntryNames(String configName, Configuration config, Set set) throws DeploymentException {
        String logPrefix = "DeployAdmin.getAllFileEntryNames(), ConfigName: " + configName;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " was started.");
        }
        String[] entryNames = null;
        try {
            entryNames = config.getAllFileEntryNames();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0004", config.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        int i = 0;
        while (i < entryNames.length) {
            if (configName.equals("")) {
                set.add(entryNames[i]);
            } else {
                set.add(configName + "/" + entryNames[i]);
            }
            ++i;
        }
        Map configs = null;
        try {
            configs = config.getAllSubConfigurations();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0064", new String[]{config.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        Iterator keys = configs.keySet().iterator();
        while (keys.hasNext()) {
            String confName = (String)keys.next();
            if (configName.equals("")) {
                this.getAllFileEntryNames(confName, (Configuration)configs.get(confName), set);
                continue;
            }
            this.getAllFileEntryNames(configName + "/" + confName, (Configuration)configs.get(confName), set);
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " was finished successfully.");
        }
    }

    void getAllFileEntries(String configName, Configuration config, Map map) throws ConfigurationException {
        Map configs = config.getAllSubConfigurations();
        Iterator keys = configs.keySet().iterator();
        while (keys.hasNext()) {
            String confName = (String)keys.next();
            this.getAllFileEntries(configName + "/" + confName, (Configuration)configs.get(confName), map);
        }
        Map tempMap = config.getAllFileEntries();
        keys = tempMap.keySet().iterator();
        while (keys.hasNext()) {
            String fileName = (String)keys.next();
            map.put(configName + "/" + fileName, tempMap.get(fileName));
        }
    }

    void getValuesForAllPropertyEntries(String appName, String configName, Configuration config, Map map, boolean both) throws DeploymentException {
        String logPrefix = "DeployAdmin.getValuesForAllPropertyEntries(), AppName: " + appName + ", Config Name: " + configName + ", Path: " + config.getPath() + ", Both: " + both;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        Map configs = null;
        try {
            configs = config.getAllSubConfigurations();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0064", new String[]{config.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        Iterator keys = configs.keySet().iterator();
        while (keys.hasNext()) {
            String confName = (String)keys.next();
            this.getValuesForAllPropertyEntries(appName, configName + "/" + confName, (Configuration)configs.get(confName), map, both);
        }
        if (configs.size() != 0) {
            return;
        }
        PropertySheet myPropertySheet = null;
        try {
            myPropertySheet = config.getPropertySheetInterface();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0073", config.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        PropertyEntry[] propEntries = null;
        try {
            propEntries = myPropertySheet.getAllPropertyEntries();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0075", config.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        int i = 0;
        while (i < propEntries.length) {
            PropertyEntry propEntry = propEntries[i];
            String fileName = propEntry.getName();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                String message = logPrefix + " FileName: " + fileName + ", DefaultValue: present";
                message = propEntry.getCustom() != null ? message + ", Custom Value: present" : message + ", Custom Value: not present";
                ConnectorResourceAccessor.location.logT(100, message);
            }
            ByteArrayInputStream fileCustomIS = null;
            if (propEntry.getCustom() != null) {
                fileCustomIS = new ByteArrayInputStream(((String)propEntry.getCustom()).getBytes());
            }
            if (both) {
                map.put(configName + "/" + fileName, new ByteArrayInputStream[]{new ByteArrayInputStream(((String)propEntry.getDefault()).getBytes()), fileCustomIS});
            } else if (fileCustomIS != null) {
                map.put(configName + "/" + fileName, fileCustomIS);
            } else {
                map.put(configName + "/" + fileName, new ByteArrayInputStream(((String)propEntry.getDefault()).getBytes()));
            }
            ++i;
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public JCDescriptor getDefaultConnectorDescriptor(String appName, JCDescriptor descr, Configuration myContainerConfig, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.getDefaultConnectorDescriptor(), AppName: " + appName + ", Path: " + myContainerConfig.getPath() + ", Connector: " + descr.getConnectorJNDIName();
        String rarName = descr.getRarName();
        boolean isRealApp = descr.isRealApplication();
        String prefix = descr.getPrefix();
        try {
            myContainerConfig = this.getConfiguration(myContainerConfig, "SECURE-META-INF/" + rarName);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{"SECURE-META-INF/", rarName, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        PropertySheet myPropertySheet = null;
        try {
            myPropertySheet = myContainerConfig.getPropertySheetInterface();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0073", myContainerConfig.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        PropertyEntry[] props = null;
        try {
            props = myPropertySheet.getAllPropertyEntries();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0075", myContainerConfig.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        int i = 0;
        while (i < props.length) {
            PropertyEntry xmlProp = props[i];
            String xmlName = xmlProp.getName();
            PropertyEntry addXmlProp = null;
            if (xmlName.endsWith("ra.xml")) {
                String currentPrefix = "";
                if (xmlName.length() > 6) {
                    currentPrefix = xmlName.substring(0, xmlName.length() - 6 - 1);
                }
                if (currentPrefix.equals(prefix)) {
                    block17: {
                        try {
                            addXmlProp = myPropertySheet.getPropertyEntry(currentPrefix + "connector-j2ee-engine.xml");
                        }
                        catch (ConfigurationException confExc) {
                            if (!ConnectorResourceAccessor.location.beLogged(400)) break block17;
                            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0076", new String[]{currentPrefix, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        }
                    }
                    ByteArrayInputStream xmlIs = new ByteArrayInputStream(((String)xmlProp.getDefault()).getBytes());
                    ByteArrayInputStream addXmlIs = null;
                    if (addXmlProp != null) {
                        addXmlIs = new ByteArrayInputStream(((String)addXmlProp.getDefault()).getBytes());
                    }
                    return this.getConnectorDescriptor(appName, isRealApp, rarName, prefix, xmlIs, addXmlIs, warnings);
                }
            }
            ++i;
        }
        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0077", new String[]{myContainerConfig.getPath()});
        if (ConnectorResourceAccessor.location.beLogged(500)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
        }
        throw bdExc;
    }

    void getAllFiles(File sourceDir, Vector files) {
        File[] list = sourceDir.listFiles();
        int i = 0;
        while (list != null && i < list.length) {
            if (list[i].isDirectory()) {
                this.getAllFiles(list[i], files);
            } else {
                files.add(list[i].getAbsolutePath());
            }
            ++i;
        }
    }

    private void bind(Context root, String name, Object obj, boolean rebind) throws NamingException {
        String s;
        Context ic = root;
        Context current = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                current = (Context)ic.lookup(s);
            }
            catch (Exception e) {
                try {
                    current = ic.createSubcontext(s);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)ic.lookup(s);
                }
            }
            ic = current;
        }
        if (rebind) {
            ic.rebind("/" + s, obj);
        } else {
            ic.bind("/" + s, obj);
        }
    }

    private static final void unbind(Context root, String name) throws NamingException {
        int index = name.lastIndexOf(47);
        if (index == -1) {
            root.unbind(name);
        } else {
            ((Context)root.lookup(name.substring(0, index))).unbind(name.substring(index + 1));
            DeployAdmin.destroyContext(root, name.substring(0, index));
        }
    }

    private static void destroyContext(Context root, String contextName) throws NamingException {
        if (contextName.equals("")) {
            return;
        }
        int index = contextName.indexOf(47);
        try {
            if (index == -1) {
                root.destroySubcontext(contextName);
            } else {
                String s = contextName.substring(0, index);
                DeployAdmin.destroyContext((Context)root.lookup(contextName.substring(0, index)), contextName.substring(index + 1));
                root.destroySubcontext(s);
            }
        }
        catch (ContextNotEmptyException cneExc) {
            ConnectorResourceAccessor.location.logT(300, Log.getStackTrace(cneExc));
        }
    }

    public String makeConnectorsDir(String workAppDir) {
        return workAppDir + this.sepChar + CONNECTORS;
    }

    public String makeDriversDir(String workAppDir) {
        return workAppDir + this.sepChar + DRIVERS;
    }

    public String makeMetaInfDir(String workAppDir) {
        return workAppDir + this.sepChar + META_INF;
    }

    public String makePropertyFileName(String appName, String workPropertiesDirName, boolean local) {
        StringBuffer result = new StringBuffer();
        if (local) {
            result.append(workPropertiesDirName).append(this.sepChar);
        }
        result.append(appName).append(".properties");
        return result.toString();
    }

    public static String makeConnectorName(JCDescriptor descriptor) {
        return descriptor.getConnectorJNDIName();
    }

    public static final String fixName(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer fixedName = new StringBuffer(name);
        int i = 0;
        while (i < fixedName.length()) {
            int j = 0;
            while (j < delimiters.length) {
                if (fixedName.charAt(i) == delimiters[j]) {
                    fixedName.setCharAt(i, '-');
                }
                ++j;
            }
            ++i;
        }
        return fixedName.toString();
    }

    /*
     * Loose catch block
     */
    public JCDescriptor getConnectorDescriptor(String appName, boolean realApp, String rarName, String prefix, InputStream raXml, InputStream addXml, Vector warnings) throws DeploymentException {
        JCDescriptor clDescriptor;
        block24: {
            ResorceAdapterDescriptorDocument clientDoc;
            block22: {
                Document doc;
                block23: {
                    BufferedInputStream xmlStream;
                    String logPrefix;
                    block21: {
                        logPrefix = "DeployAdmin.getConnectorDescriptor(InputStream is), Application: " + appName;
                        ConnectorResourceAccessor.location.logT(100, logPrefix);
                        xmlStream = null;
                        xmlStream = new BufferedInputStream(raXml);
                        doc = null;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int count = -1;
                        byte[] b = new byte[1024];
                        while ((count = xmlStream.read(b)) != -1) {
                            baos.write(b, 0, count);
                        }
                        doc = DeployAdmin.createStandardDOMParser().parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                        Object var16_21 = null;
                        try {
                            xmlStream.close();
                        }
                        catch (IOException ioExc) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                        }
                        break block21;
                        {
                            catch (IllegalArgumentException illae) {
                                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0018", (Throwable)illae);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                            catch (SAXException se) {
                                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0018", (Throwable)se);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                            catch (IOException ioe) {
                                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0019", (Throwable)ioe);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_22 = null;
                            try {
                                xmlStream.close();
                            }
                            catch (IOException ioExc) {
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                            }
                            throw throwable;
                        }
                    }
                    clientDoc = new ResorceAdapterDescriptorDocument();
                    clientDoc.setRarName(rarName);
                    clientDoc.setRealApp(realApp);
                    clientDoc.setPrefix(prefix);
                    clientDoc.setWarnings(warnings);
                    clDescriptor = clientDoc.loadDescriptorFromDocument(doc);
                    if (addXml == null) break block22;
                    clientDoc.setProvideAdditionalXML(true);
                    xmlStream = new BufferedInputStream(addXml);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int count = -1;
                    byte[] b = new byte[1024];
                    while ((count = xmlStream.read(b)) != -1) {
                        baos.write(b, 0, count);
                    }
                    doc = DeployAdmin.createStandardDOMParser().parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    Object var19_33 = null;
                    try {
                        xmlStream.close();
                    }
                    catch (IOException ioExc) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                    }
                    break block23;
                    {
                        catch (IllegalArgumentException illae) {
                            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0016", (Throwable)illae);
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                            throw bdExc;
                        }
                        catch (SAXException se) {
                            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0016", (Throwable)se);
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                            throw bdExc;
                        }
                        catch (IOException ioe) {
                            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0017", (Throwable)ioe);
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                            throw bdExc;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_34 = null;
                        try {
                            xmlStream.close();
                        }
                        catch (IOException ioExc) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                        }
                        throw throwable;
                    }
                }
                clientDoc.loadDescriptorAdditionalFromDocument(clDescriptor, doc);
                break block24;
            }
            clientDoc.setProvideAdditionalXML(false);
        }
        clDescriptor.setRealApplication(realApp);
        if (!prefix.equals("")) {
            clDescriptor.setConnectorJNDIName(prefix);
            clDescriptor.setDisplayName(prefix);
        }
        clDescriptor.setApplicationName(appName);
        return clDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JCDescriptor getConnectorDescriptor(String appName, boolean realApp, String rarArchive, String relativePath, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.getConnectorDescriptor(File archive), Application: " + appName;
        ZipFile file = null;
        InputStream raXml = null;
        InputStream addXml = null;
        try {
            try {
                file = new ZipFile(rarArchive);
                String metaInfName = null;
                ZipEntry entry = file.getEntry("META-INF/ra.xml");
                if (entry == null) {
                    entry = file.getEntry("meta-inf/ra.xml");
                    if (entry == null) {
                        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0020");
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                    metaInfName = meta_inf;
                    warnings.add(logPrefix + ", Warning: ra.xml is not located under META-INF, but meta-inf");
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Warning: ra.xml is not located under META-INF, but meta-inf");
                } else {
                    metaInfName = META_INF;
                }
                raXml = file.getInputStream(entry);
                entry = file.getEntry(metaInfName + "/connector-j2ee-engine.xml");
                if (entry == null) {
                    warnings.add(logPrefix + ", Cannot find" + metaInfName + "/connector-j2ee-engine.xml.");
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot find" + metaInfName + "/connector-j2ee-engine.xml.");
                } else {
                    if (metaInfName.equals(meta_inf)) {
                        warnings.add(logPrefix + ", Warning: connector-j2ee-engine.xml is not located under META-INF, but meta-inf");
                        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Warning: connector-j2ee-engine.xml is not located under META-INF, but meta-inf");
                    }
                    addXml = file.getInputStream(entry);
                }
                JCDescriptor jCDescriptor = this.getConnectorDescriptor(appName, realApp, relativePath, "", raXml, addXml, warnings);
                Object var14_16 = null;
                if (file == null) return jCDescriptor;
                try {
                    file.close();
                    return jCDescriptor;
                }
                catch (IOException ioExc) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                }
                return jCDescriptor;
            }
            catch (IOException ioe) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0021", (Throwable)ioe);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (file == null) throw throwable;
            try {}
            catch (IOException ioExc) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                throw throwable;
            }
            file.close();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ResourceLoader registerConnectorLoader(ApplicationInfo appInfo, String[] allJars) throws DeploymentException {
        logPrefix = "DeployAdmin.registerConnectorLoader(), Application: " + appInfo.getApplicationName();
        appName = appInfo.getApplicationName();
        groupName = appInfo.getConnectorGroup();
        loader = null;
        loaderName = DeployAdmin.makeRealConnectorLoaderName(groupName);
        classLoader = this.loadContext.getClassLoader(loaderName);
        if (classLoader == null) {
            frameLoader = this.getClass().getClassLoader().getParent();
            if (frameLoader == null) {
                bdExc = new BaseDeploymentException("connector_0025", "<Frame Loader>");
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            loader = new ResourceLoader(loaderName, new MultipleResource(), frameLoader, null);
            try {
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering ClassLoader: " + loaderName + ", parent ClassLoader: FrameLoader");
                }
                this.loadContext.register(loader);
                if (!ConnectorResourceAccessor.location.beLogged(300)) ** GOTO lbl42
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", ClassLoader: " + loaderName + ", parent ClassLoader: FrameLoader was registered successfully.");
            }
            catch (Exception exc) {
                bdExc = new BaseDeploymentException("connector_0022", loaderName, (Throwable)exc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        } else {
            if (!(classLoader instanceof ResourceLoader)) {
                bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            loader = (ResourceLoader)classLoader;
            if (ConnectorResourceAccessor.location.beInfo()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Using Existing ClassLoader: " + loaderName + ", parent ClassLoader: FrameLoader");
            }
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Existing Loader Info: " + loader.getInfo());
            }
        }
lbl42:
        // 5 sources

        if (groupName != null) {
            this.addMapping(groupName, appName);
        }
        if (allJars != null && allJars.length != 0) {
            jarsResource = null;
            resNames = loader.getResourceNames();
            i = 0;
            while (i < allJars.length) {
                jar = allJars[i];
                found = false;
                j = 0;
                while (j < resNames.length) {
                    resName = resNames[j];
                    if (new File(jar).getAbsolutePath().equals(new File(resName).getAbsolutePath())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    if (jarsResource == null) {
                        jarsResource = new JarsResource();
                    }
                    jarsResource.addJar(jar);
                }
                ++i;
            }
            if (jarsResource != null) {
                loader.addResource(jarsResource);
            }
            appInfo.addFilesForClassLoader(allJars);
        }
        return loader;
    }

    public synchronized void unregisterConnectorLoader(ApplicationInfo appInfo, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.unregisterConnectorLoader(), Application: " + appInfo.getApplicationName();
        String appName = appInfo.getApplicationName();
        String groupName = appInfo.getConnectorGroup();
        String loaderName = DeployAdmin.makeRealConnectorLoaderName(groupName);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", LoaderName: " + loaderName);
        this.removeMapping(groupName, appName, loaderName, warnings);
        this.removeReferences(loaderName, appInfo);
    }

    public void removeReferences(String loaderName, ApplicationInfo appInfo) {
        String logPrefix = "DeployAdmin.removeReferences(), Application: " + appInfo.getApplicationName();
        String[] loaderRefs = this.loadContext.getReferences(loaderName);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", LoaderRefs: " + loaderRefs);
        int i = 0;
        while (loaderRefs != null && i < loaderRefs.length) {
            if (appInfo.removeLoaderReference(loaderRefs[i])) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", RemoveLoaderRef[" + i + "]: " + loaderName + ", " + loaderRefs[i] + ": true");
                this.loadContext.unregisterReference(loaderName, loaderRefs[i]);
            }
            ++i;
        }
    }

    public static String makeRealConnectorLoaderName(String groupName) {
        return LOADER_PREFIX + groupName;
    }

    public void registerConnector(ApplicationInfo appInfo, Context rootContext, JCDescriptor descr, ResourceLoader loader) throws DeploymentException {
        String logPrefix = "DeployAdmin.registerConnector(), Application: " + appInfo.getApplicationName();
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        ManagedConnectionFactory mcf = this.instantiateMCF(loader, appInfo.getApplicationName(), descr);
        appInfo.addMCF(mcf);
        this.preRegisterIdentitySubjects(appInfo.getApplicationName(), mcf, descr);
        String[] aliases = descr.getAliases();
        try {
            this.bindMCF(appInfo.getApplicationName(), rootContext, descr, mcf, false);
            try {
                if (aliases != null) {
                    ResourceObjectFactory.registerAliases(descr.getConnectorJNDIName(), aliases);
                }
            }
            catch (Exception exc) {
                this.unbindMCF(appInfo.getApplicationName(), rootContext, descr.getConnectorJNDIName());
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0042", descr.getConnectorJNDIName(), (Throwable)exc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        catch (NamingException nexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0007", new String[]{descr.getConnectorJNDIName(), "MCF"}, (Throwable)nexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        appInfo.addMapping(descr.getConnectorJNDIName(), aliases);
        DriverInfo[] drivers = descr.getDrivers();
        if (drivers != null) {
            int j = 0;
            while (j < drivers.length) {
                Driver driver = this.instantiateDriver(loader, drivers[j].getDriverClassName());
                this.registerDriver(appInfo.getApplicationName(), driver);
                ++j;
            }
        }
        this.startFactory(appInfo.getApplicationName(), descr.getConnectorJNDIName(), descr.getConnectionFactoryInterface(), descr.getAuthenticationType() != null, !descr.isRealApplication());
    }

    public void deleteConnector(String appName, Configuration myContainerConfig, JCDescriptor descr, Hashtable newPolicyCfgToDescr, Hashtable oldPolicyCfgToDescr) throws DeploymentException {
        String logPrefix = "DeployAdmin.deleteConnector(), Application:  " + appName;
        String relativePath = descr.getRarName();
        Configuration secureMetaInfConfig = null;
        PropertySheet propertySheet = null;
        try {
            secureMetaInfConfig = this.getConfiguration(myContainerConfig, "SECURE-META-INF/" + relativePath);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{SECURE_META_INF, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)bdExc));
            throw bdExc;
        }
        try {
            propertySheet = secureMetaInfConfig.getPropertySheetInterface();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0073", secureMetaInfConfig.getPath(), (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        String prefix = descr.getPrefix();
        if (!prefix.equals("")) {
            prefix = prefix + "_";
        }
        try {
            propertySheet.deletePropertyEntry(prefix + "ra.xml");
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0058", new String[]{prefix + "ra.xml", secureMetaInfConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Properties props = null;
        try {
            props = propertySheet.getProperties();
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0075", secureMetaInfConfig.getPath(), (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        if (((Hashtable)props).containsKey(prefix + "connector-j2ee-engine.xml")) {
            try {
                propertySheet.deletePropertyEntry(prefix + "connector-j2ee-engine.xml");
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0058", new String[]{prefix + "connector-j2ee-engine.xml", secureMetaInfConfig.getPath()}, (Throwable)((Object)confExc));
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
        Vector<JCDescriptor[]> descrsPerRelativePath = new Vector<JCDescriptor[]>();
        descrsPerRelativePath.add(new JCDescriptor[]{descr, null});
        this.deleteConnectorSecurity(appName, myContainerConfig, descrsPerRelativePath, new Hashtable(), new Hashtable());
    }

    public void deleteConnectorConfiguration(String appName, Configuration myContainerConfig, String relativePath, Vector descrsPerRelativePath, Hashtable newPolicyCfgToDescr, Hashtable oldPolicyCfgToDescr) throws DeploymentException {
        block7: {
            String logPrefix = "DeployAdmin.deleteConnectorConfiguration(), Application:  " + appName + ", RelativePath: " + relativePath;
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Started.");
            }
            this.deleteConfiguration(appName, myContainerConfig, CONNECTORS, relativePath, false);
            this.deleteConfiguration(appName, myContainerConfig, SECURE_META_INF, relativePath, false);
            try {
                Configuration driversConfig;
                block8: {
                    if (!myContainerConfig.existsSubConfiguration("drivers/" + relativePath)) break block7;
                    driversConfig = null;
                    try {
                        driversConfig = this.getConfiguration(myContainerConfig, "drivers/" + relativePath);
                    }
                    catch (ConfigurationException confExc) {
                        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{"drivers/" + relativePath, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                        if (!ConnectorResourceAccessor.location.beLogged(100)) break block8;
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Debug: " + bdExc.getStackTraceString());
                    }
                }
                if (driversConfig != null) {
                    this.deleteConfiguration(appName, myContainerConfig, DRIVERS, relativePath, true);
                }
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{"drivers/" + relativePath, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
        }
        this.deleteConnectorSecurity(appName, myContainerConfig, descrsPerRelativePath, oldPolicyCfgToDescr, newPolicyCfgToDescr);
    }

    private void deleteConnectorSecurity(String appName, Configuration myContainerConfig, Vector descrsPerRelativePath, Hashtable oldPolicyCfgToDescr, Hashtable newPolicyCfgToDescr) throws DeploymentException {
        String logPrefix = "DeployAdmin.deleteConnectorsecurity(), Application:  " + appName;
        int i = 0;
        while (i < descrsPerRelativePath.size()) {
            BaseDeploymentException bdExc;
            Configuration securityConfig;
            String fixedConnectorName;
            boolean unregisterUserStore;
            boolean unregisterPolicyCfg;
            JCDescriptor oldDescr;
            block12: {
                JCDescriptor[] descrs = (JCDescriptor[])descrsPerRelativePath.elementAt(i);
                JCDescriptor jCDescriptor = oldDescr = descrs[1] != null ? descrs[1] : descrs[0];
                if (oldDescr.getAuthenticationType() == null) {
                    return;
                }
                JCDescriptor newDescr = (JCDescriptor)newPolicyCfgToDescr.get(oldDescr.getConnectorJNDIName());
                unregisterPolicyCfg = true;
                unregisterUserStore = true;
                if (newDescr != null) {
                    unregisterPolicyCfg = newDescr.getAuthenticationType() == null;
                    unregisterUserStore = !newDescr.isInternalUserStore();
                    oldPolicyCfgToDescr.put(oldDescr.getConnectorJNDIName(), oldDescr);
                }
                fixedConnectorName = DeployAdmin.fixName(DeployAdmin.makeConnectorName(oldDescr));
                securityConfig = null;
                try {
                    securityConfig = this.getConfiguration(myContainerConfig, "prefix:" + oldDescr.getConnectorJNDIName());
                }
                catch (ConfigurationException confExc) {
                    bdExc = new BaseDeploymentException("connector_0055", new String[]{"prefix:" + oldDescr.getConnectorJNDIName(), myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                    if (!ConnectorResourceAccessor.location.beLogged(100)) break block12;
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
            }
            if (securityConfig == null) {
                securityConfig = myContainerConfig;
            }
            if (unregisterUserStore && oldDescr.getUserStore() != null && oldDescr.isInternalUserStore()) {
                this.unregisterRAUserStore(appName, oldDescr, securityConfig);
            }
            if (unregisterPolicyCfg) {
                try {
                    this.unregisterPolicyConfiguration(appName, oldDescr, securityConfig);
                }
                catch (SecurityException secExc) {
                    bdExc = new BaseDeploymentException("connector_0066", new String[]{fixedConnectorName, oldDescr.getConnectorJNDIName(), appName}, (Throwable)secExc);
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Warning: " + bdExc.getStackTraceString());
                    }
                    throw bdExc;
                }
            }
            if (unregisterPolicyCfg && unregisterUserStore && securityConfig != myContainerConfig) {
                this.deleteConfiguration(appName, myContainerConfig, null, "prefix:" + oldDescr.getConnectorJNDIName(), true);
            }
            ++i;
        }
    }

    private void deleteConfiguration(String appName, Configuration myContainerConfig, String configName, String relativePath, boolean deleteMain) throws BaseDeploymentException {
        String logPrefix = "DeployAdmin.deleteConfiguration(String confName), Application:  " + appName + ", RelativePath: " + relativePath;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Started.");
        }
        if (!deleteMain) {
            try {
                myContainerConfig = this.getConfiguration(myContainerConfig, configName);
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{configName, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
        }
        if (!deleteMain) {
            this.deleteConfiguration(appName, myContainerConfig, relativePath);
        } else if (configName != null) {
            this.deleteConfiguration(appName, myContainerConfig, configName + "/" + relativePath);
        } else {
            this.deleteConfiguration(appName, myContainerConfig, relativePath);
        }
    }

    private void deleteConfiguration(String appName, Configuration rootConfig, String pathToDelete) throws BaseDeploymentException {
        String logPrefix = "DeployAdmin.deleteConfiguration(Configuration config), Application:  " + appName + ", PathToDelete: " + pathToDelete;
        Configuration config = null;
        try {
            config = this.getConfiguration(rootConfig, pathToDelete);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{pathToDelete, rootConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Deleting Subconfig: " + config.getPath());
            }
            config.deleteConfiguration();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Subconfig: " + config.getPath() + " was deleted successfully.");
            }
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0054", config.getPath(), (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        Configuration fileConfig = null;
        int index = pathToDelete.lastIndexOf("/");
        while (index != -1) {
            try {
                fileConfig = this.getConfiguration(rootConfig, pathToDelete.substring(0, index));
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0055", new String[]{pathToDelete.substring(0, index), rootConfig.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            String[] subConfigNames = null;
            try {
                subConfigNames = fileConfig.getAllSubConfigurationNames();
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0064", fileConfig.getPath(), (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Config: " + fileConfig.getPath() + ", Subconfigs: " + subConfigNames.length);
            }
            if (subConfigNames.length != 0) break;
            try {
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Deleting Subconfig: " + fileConfig.getPath());
                }
                fileConfig.deleteConfiguration();
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Subconfig: " + fileConfig.getPath() + " was deleted successfully.");
                }
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0054", fileConfig.getPath(), (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                throw bdExc;
            }
            pathToDelete = pathToDelete.substring(0, index);
            index = pathToDelete.lastIndexOf("/");
        }
    }

    public void startFactory(String appName, String name, String connFactoryInterface, boolean isAuthConfigured, boolean isStandAlone) throws DeploymentException {
        String logPrefix = "DeployAdmin.startFactory(), Application: " + appName + ", factory: " + name + " isAuthConfigured: " + isAuthConfigured;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        try {
            ResourceObjectFactory.addConnectionFactory(appName, name, connFactoryInterface, isAuthConfigured, isStandAlone);
        }
        catch (ResourceException re) {
            throw new BaseDeploymentException("connector_0041", name, (Throwable)re);
        }
        try {
            ResourceObjectFactory.startConnectionFactory(name);
        }
        catch (ResourceException re) {
            throw new BaseDeploymentException("connector_0043", name, (Throwable)re);
        }
    }

    public void stopFactory(String appName, String[] mapping, Vector warnings) {
        String logPrefix = "DeployAdmin.stopFactory(), Application: " + appName + ", factory: " + mapping[0];
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        try {
            ResourceObjectFactory.stopConnectionFactory(mapping[0]);
        }
        catch (ResourceException re) {
            warnings.add("Cannot stop factory '" + mapping[0] + "', reason : " + re.toString());
        }
        try {
            ResourceObjectFactory.removeConnectionFactory(mapping[0]);
        }
        catch (ResourceException re) {
            warnings.add("Cannot remove factory '" + mapping[0] + "', reason : " + re.toString());
        }
        if (mapping.length > 1) {
            String[] aliases = new String[mapping.length - 1];
            System.arraycopy(mapping, 1, aliases, 0, aliases.length);
            ResourceObjectFactory.unregisterAliases(aliases);
        }
    }

    public void bindMCF(String appName, Context root, JCDescriptor descr, ManagedConnectionFactory mcf, boolean rebind) throws NamingException {
        String logPrefix = "DeployAdmin.bindMCF(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", JNDIName: " + descr.getConnectorJNDIName());
        MCFWrapper mcfWrapper = new MCFWrapper(mcf, descr.getTransactionLevel(), descr.getAliases(), 0, descr.getMaxConnectionsNumber(), descr.getMaxTimeToWaitConnection(), descr.getConnectionLifetime(), descr.getRunCleanupThreadTime());
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Bind MCFWrapper");
        this.bind(root, MCF_CONTEXT_NAME + descr.getConnectorJNDIName(), mcfWrapper, rebind);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Bind ShareableResRef");
        this.bind(root, "deployedAdapters/" + descr.getConnectorJNDIName() + "/" + RES_REF_SHAREABLE_CTX + "/" + descr.getConnectorJNDIName(), this.createReference(descr, true, true), rebind);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Bind UnshareableResRef");
        this.bind(root, "deployedAdapters/" + descr.getConnectorJNDIName() + "/" + RES_REF_UNSHAREABLE_CTX + "/" + descr.getConnectorJNDIName(), this.createReference(descr, true, true), rebind);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Bind NonTransResRef");
        this.bind(root, "deployedAdapters/" + descr.getConnectorJNDIName() + "/" + RES_REF_NON_TRANSACTIONAL_CTX + "/" + descr.getConnectorJNDIName(), this.createReference(descr, false, false), rebind);
    }

    private Reference createReference(JCDescriptor descr, boolean shareable, boolean transactional) {
        Reference ref = new Reference(descr.getConnectionFactoryImplClass(), "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
        ref.add(new StringRefAddr("res-type", descr.getConnectionFactoryInterface()));
        ref.add(new StringRefAddr("res-auth", "Application"));
        ref.add(new StringRefAddr("res-name", descr.getConnectorJNDIName()));
        if (descr.isRealApplication()) {
            ref.add(new StringRefAddr("app-name", descr.getApplicationName()));
        }
        if (shareable) {
            ref.add(new StringRefAddr("sharing-scope", "Shareable"));
        } else {
            ref.add(new StringRefAddr("sharing-scope", "Unshareable"));
        }
        if (transactional) {
            ref.add(new StringRefAddr("tx-support", "true"));
        } else {
            ref.add(new StringRefAddr("tx-support", "false"));
        }
        return ref;
    }

    public void unbindMCF(String appName, Context root, String jndi_name) {
        BaseDeploymentException bdExc;
        String logPrefix = "DeployAdmin.unbindMCF(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", JNDIName: " + jndi_name);
        try {
            DeployAdmin.unbind(root, MCF_CONTEXT_NAME + jndi_name);
        }
        catch (NamingException ne) {
            bdExc = new BaseDeploymentException("connector_0008", new String[]{jndi_name, MCF_CONTEXT_NAME}, (Throwable)ne);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
        }
        try {
            DeployAdmin.unbind((Context)root.lookup("deployedAdapters/" + jndi_name), "shareable/" + jndi_name);
        }
        catch (NamingException ne) {
            bdExc = new BaseDeploymentException("connector_0008", new String[]{jndi_name, "deployedAdapters, shareable"}, (Throwable)ne);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
        }
        try {
            DeployAdmin.unbind((Context)root.lookup("deployedAdapters/" + jndi_name), "unshareable/" + jndi_name);
        }
        catch (NamingException ne) {
            bdExc = new BaseDeploymentException("connector_0008", new String[]{jndi_name, "deployedAdapters, unshareable"}, (Throwable)ne);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
        }
        try {
            DeployAdmin.unbind((Context)root.lookup("deployedAdapters/" + jndi_name), "nonGlobalTx/" + jndi_name);
        }
        catch (NamingException ne) {
            bdExc = new BaseDeploymentException("connector_0008", new String[]{jndi_name, "deployedAdapters, nonGlobalTx"}, (Throwable)ne);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
        }
        try {
            DeployAdmin.destroyContext(root, "deployedAdapters/" + jndi_name);
        }
        catch (NamingException ne) {
            ConnectorResourceAccessor.location.catching((Throwable)ne);
        }
    }

    private void addMapping(String groupName, String appName) {
        String logPrefix = "DeployAdmin.addMapping(), Application: " + appName;
        Hashtable hashtable = this.groupAppsMap;
        synchronized (hashtable) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Group: " + groupName);
            HashSet<String> appSet = (HashSet<String>)this.groupAppsMap.get(groupName);
            if (appSet == null) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Create New Set.");
                appSet = new HashSet<String>();
                this.groupAppsMap.put(groupName, appSet);
            } else if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ",  Use existing AppsSet: " + appSet);
            }
            appSet.add(appName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeMapping(String groupName, String appName, String loaderName, Vector warnings) throws DeploymentException {
        String logPrefix = "DeployAdmin.removeMapping(), Application: " + appName;
        Hashtable hashtable = this.groupAppsMap;
        synchronized (hashtable) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Group: " + groupName);
            HashSet setMap = (HashSet)this.groupAppsMap.get(groupName);
            if (setMap == null) return;
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Remove from AppsSet.");
            }
            setMap.remove(appName);
            if (setMap.isEmpty()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", AppsSet is empty.");
                this.groupAppsMap.remove(groupName);
                try {
                    BaseDeploymentException bdExc;
                    ClassLoader classLoader;
                    if (ConnectorResourceAccessor.location.beLogged(100)) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregistering ClassLoader: " + loaderName + ", parent ClassLoader: FrameLoader");
                    }
                    if ((classLoader = this.loadContext.getClassLoader(loaderName)) == null) {
                        bdExc = new BaseDeploymentException("connector_0025", loaderName);
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        if (warnings == null) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                            throw bdExc;
                        }
                        warnings.add(bdExc.getNestedLocalizedMessage());
                        ConnectorResourceAccessor.location.logT(300, bdExc.getNestedLocalizedMessage());
                    } else if (!(classLoader instanceof ResourceLoader)) {
                        bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        if (warnings == null) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                            throw bdExc;
                        }
                        warnings.add(bdExc.getNestedLocalizedMessage());
                        ConnectorResourceAccessor.location.logT(300, bdExc.getNestedLocalizedMessage());
                    }
                    ResourceLoader loader = (ResourceLoader)classLoader;
                    if (ConnectorResourceAccessor.location.beLogged(100)) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregistering ClassLoader : " + loader.getInfo());
                    }
                    this.loadContext.unregister(loader);
                    if (!ConnectorResourceAccessor.location.beLogged(300)) return;
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", ClassLoader: " + loaderName + ", parent ClassLoader: FrameLoader was unregistered successfully.");
                }
                catch (NullPointerException npe) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0023", loaderName, (Throwable)npe);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    if (warnings == null) throw bdExc;
                    warnings.add(bdExc.getStackTraceString());
                    ConnectorResourceAccessor.location.logT(300, bdExc.getStackTraceString());
                }
                catch (Exception exc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0023", loaderName, (Throwable)exc);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    if (warnings == null) throw bdExc;
                    warnings.add(bdExc.getStackTraceString());
                    ConnectorResourceAccessor.location.logT(300, bdExc.getStackTraceString());
                }
            } else {
                if (!ConnectorResourceAccessor.location.beLogged(100)) return;
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", AppsSet :" + setMap);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConnectorVersion(String appName, String rarFile, Vector warnings) throws DeploymentException {
        block18: {
            logPrefix = "DeployAdmin.getConnectorVersion(), Application: " + appName;
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", ArchiveFile: " + rarFile);
            document = null;
            archive = null;
            raXml = null;
            try {
                block19: {
                    try {
                        archive = new ZipFile(rarFile);
                        entry = archive.getEntry("META-INF/ra.xml");
                        if (entry == null) {
                            entry = archive.getEntry("meta-inf/ra.xml");
                            if (entry == null) {
                                bdExc = new BaseDeploymentException("connector_0020");
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Warning: ra.xml is not located under META-INF, but meta-inf");
                        }
                        raXml = archive.getInputStream(entry);
                        xmlStream = new BufferedInputStream(raXml);
                        try {
                            document = DeployAdmin.createStandardDOMParser().parse((InputStream)xmlStream);
                            var15_13 = null;
                            try {
                                xmlStream.close();
                            }
                            catch (IOException ioExc) {
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                            }
                            var18_24 = null;
                            if (archive == null) break block18;
                            break block19;
                            catch (IllegalArgumentException illae) {
                                bdExc = new BaseDeploymentException("connector_0018", (Throwable)illae);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                            catch (SAXException se) {
                                bdExc = new BaseDeploymentException("connector_0018", (Throwable)se);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                            catch (IOException ioe) {
                                bdExc = new BaseDeploymentException("connector_0019", (Throwable)ioe);
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                                throw bdExc;
                            }
                        }
                        catch (Throwable var14_23) {
                            var15_14 = null;
                            ** try [egrp 4[TRYBLOCK] [4 : 406->414)] { 
lbl55:
                            // 1 sources

                            xmlStream.close();
                            throw var14_23;
lbl57:
                            // 1 sources

                            catch (IOException ioExc) {
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                            }
                            throw var14_23;
                        }
                    }
                    catch (IOException ioe) {
                        bdExc = new BaseDeploymentException("connector_0021", rarFile, (Throwable)ioe);
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                }
                try {
                    archive.close();
                }
                catch (IOException ioExc) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                }
            }
            catch (Throwable var17_28) {
                var18_25 = null;
                if (archive == null) throw var17_28;
                ** try [egrp 5[TRYBLOCK] [7 : 535->543)] { 
lbl79:
                // 1 sources

                archive.close();
                throw var17_28;
lbl81:
                // 1 sources

                catch (IOException ioExc) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                }
                throw var17_28;
            }
        }
        checker = new VersionChecker(document);
        return checker.getConnectorVersion();
    }

    private static StandardDOMParser createStandardDOMParser() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca$deploy$DeployAdmin == null ? (class$com$sap$engine$services$connector$jca$deploy$DeployAdmin = DeployAdmin.class$("com.sap.engine.services.connector.jca.deploy.DeployAdmin")) : class$com$sap$engine$services$connector$jca$deploy$DeployAdmin).getClassLoader());
            StandardDOMParser standardDOMParser = new StandardDOMParser();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMParser;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] updateConnectorJars(String appName, Configuration myContainerConfig, String workAppDir, boolean realApp, String absolutePath, String relativePath, Vector warnings) throws DeploymentException {
        logPrefix = "DeployAdmin.updateConnectorJars(), Application: " + appName;
        outputDir = this.makeConnectorsDir(workAppDir) + this.sepChar + relativePath.replace('/', this.sepChar);
        connectorsConfig = null;
        try {
            connectorsConfig = this.createConfiguration(myContainerConfig, "connectors/" + relativePath, 0);
        }
        catch (ConfigurationException confExc) {
            bdExc = new BaseDeploymentException("connector_0000", new String[]{"connectors/" + relativePath, myContainerConfig.getPath()}, (Throwable)confExc);
            if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        allJars = new Vector<String>();
        rarFile = null;
        try {
            try {
                rarFile = new JarFile(absolutePath);
                enum = rarFile.entries();
                entry = null;
                entryName = null;
                replacedEntryName = null;
                while (enum.hasMoreElements()) {
                    entry = enum.nextElement();
                    entryName = entry.getName();
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", ZipEntryName: " + entryName + ", Dir: " + entry.isDirectory());
                    }
                    replacedEntryName = entryName.replace('/', this.sepChar);
                    in = new BufferedInputStream(rarFile.getInputStream(entry));
                    file = null;
                    fos = null;
                    try {
                        if (entry.isDirectory()) {
                            if (!entryName.startsWith("META-INF/") && !entryName.startsWith("meta-inf/")) {
                                this.mkDirs(new File(outputDir + this.sepChar + replacedEntryName), false);
                            }
                            var28_52 = null;
                            try {
                                in.close();
                            }
                            catch (IOException ioExc) {
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                                }
                                warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                            }
                            continue;
                        }
                        index = entryName.lastIndexOf("/");
                        if (index != -1) {
                            if (!entryName.startsWith("META-INF/") && !entryName.startsWith("meta-inf/")) {
                                if (entryName.endsWith(".jar")) {
                                    file = new File(outputDir + this.sepChar + replacedEntryName);
                                }
                                entryName = entryName.substring(index + 1);
                            }
                        } else if (entryName.endsWith(".jar")) {
                            file = new File(outputDir + this.sepChar + replacedEntryName);
                        }
                        if (entryName.endsWith(".jar")) {
                            allJars.add(file.getPath());
                            try {
                                this.mkDirs(file, true);
                                fos = new FileOutputStream(file);
                            }
                            catch (FileNotFoundException fnfExc) {
                                if (ConnectorResourceAccessor.location.beLogged(500) == false) throw fnfExc;
                                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(fnfExc));
                                throw fnfExc;
                            }
                        } else {
                            var28_52 = null;
                            ** try [egrp 8[TRYBLOCK] [6 : 861->869)] { 
lbl73:
                            // 1 sources

                            in.close();
lbl75:
                            // 1 sources

                            catch (IOException ioExc) {
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                                }
                                warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                            }
                            continue;
                        }
                        count = 1024;
                        buff = new byte[count];
                        try {
                            try {
                                while (true) {
                                    if ((count = in.read(buff)) == -1) break;
                                    fos.write(buff, 0, count);
                                }
                                fos.flush();
                                var24_50 = null;
                                fos.close();
                            }
                            catch (Throwable var23_45) {
                                var24_50 = null;
                                fos.close();
                                throw var23_45;
                            }
                        }
                        catch (EOFException eofExc) {
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Error: " + Log.getStackTrace(eofExc));
                            }
                            buff = new byte[(int)entry.getSize()];
                            in.read(buff);
                            in.close();
                            try {
                                fos.flush();
                                var26_51 = null;
                                fos.close();
                            }
                            catch (Throwable var25_54) {
                                var26_51 = null;
                                fos.close();
                                throw var25_54;
                            }
                        }
                        var28_52 = null;
                        ** try [egrp 8[TRYBLOCK] [6 : 861->869)] { 
lbl124:
                        // 1 sources

                        in.close();
lbl126:
                        // 1 sources

                        catch (IOException ioExc) {
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                            }
                            warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                        }
                    }
                    catch (Throwable var27_55) {
                        var28_52 = null;
                        ** try [egrp 8[TRYBLOCK] [6 : 861->869)] { 
lbl139:
                        // 1 sources

                        in.close();
                        throw var27_55;
lbl141:
                        // 1 sources

                        catch (IOException ioExc) {
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                            }
                            warnings.add(logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Cannot close stream, reason: " + Log.getStackTrace(ioExc));
                        }
                        throw var27_55;
                    }
                }
            }
            catch (IOException ioexc) {
                bdExc = new BaseDeploymentException("connector_0010", absolutePath, (Throwable)ioexc);
                if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            var31_56 = null;
            if (rarFile != null) {
                try {
                    rarFile.close();
                }
                catch (IOException ioExc) {
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                    }
                    warnings.add("Cannot close rar file '" + absolutePath + "', reason : " + Log.getStackTrace(ioExc));
                    ConnectorResourceAccessor.location.logT(300, "Cannot close rar file '" + absolutePath + "', reason : " + Log.getStackTrace(ioExc));
                }
            }
        }
        catch (Throwable var30_60) {
            var31_57 = null;
            if (rarFile == null) throw var30_60;
            ** try [egrp 9[TRYBLOCK] [9 : 1096->1104)] { 
lbl175:
            // 1 sources

            rarFile.close();
            throw var30_60;
lbl177:
            // 1 sources

            catch (IOException ioExc) {
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + Log.getStackTrace(ioExc));
                }
                warnings.add("Cannot close rar file '" + absolutePath + "', reason : " + Log.getStackTrace(ioExc));
                ConnectorResourceAccessor.location.logT(300, "Cannot close rar file '" + absolutePath + "', reason : " + Log.getStackTrace(ioExc));
            }
            throw var30_60;
        }
        customJarFiles = new HashSet<E>();
        this.getAllFileEntryNames("", connectorsConfig, customJarFiles);
        deployJarFileNames = allJars.iterator();
        prefixIndex = outputDir.length();
        while (deployJarFileNames.hasNext()) {
            deployJarFileName = (String)deployJarFileNames.next();
            replacedDeployJarFileName = deployJarFileName.substring(prefixIndex + 1).replace(this.sepChar, '/');
            update = customJarFiles.remove(replacedDeployJarFileName);
            index = replacedDeployJarFileName.lastIndexOf("/");
            fileConfig = null;
            if (index != -1) {
                try {
                    if (connectorsConfig.existsFile(replacedDeployJarFileName)) {
                        connectorsConfig.deleteFile(replacedDeployJarFileName);
                    }
                }
                catch (ConfigurationException confExc) {
                    throw new BaseDeploymentException("connector_0058", new String[]{replacedDeployJarFileName, connectorsConfig.getPath()}, (Throwable)confExc);
                }
                try {
                    fileConfig = this.createConfiguration(connectorsConfig, replacedDeployJarFileName.substring(0, index), 0);
                }
                catch (ConfigurationException confExc) {
                    bdExc = new BaseDeploymentException("connector_0000", new String[]{replacedDeployJarFileName.substring(0, index), connectorsConfig.getPath()}, (Throwable)confExc);
                    if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
            }
            fileConfig = connectorsConfig;
            this.addFileAsStreamToConfig(replacedDeployJarFileName.substring(index + 1), fileConfig, new File(deployJarFileName), update);
        }
        customJarFileNames = customJarFiles.iterator();
        while (customJarFileNames.hasNext()) {
            block75: {
                fileConfig = null;
                fileName = null;
                customJarFileName = (String)customJarFileNames.next();
                index = customJarFileName.lastIndexOf("/");
                if (index != -1) {
                    try {
                        if (connectorsConfig.existsFile(customJarFileName)) {
                            connectorsConfig.deleteFile(customJarFileName);
                        }
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0058", new String[]{customJarFileName, connectorsConfig.getPath()}, (Throwable)confExc);
                    }
                    fileName = customJarFileName.substring(index + 1);
                    customJarFileName = customJarFileName.substring(0, index);
                    try {
                        fileConfig = this.getConfigurationIfExists(connectorsConfig, customJarFileName);
                    }
                    catch (ConfigurationException confExc) {
                        bdExc = new BaseDeploymentException("connector_0001", new String[]{customJarFileName, connectorsConfig.getPath()}, (Throwable)confExc);
                        if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                    try {
                        if (fileConfig == null || !fileConfig.existsFile(fileName)) {
                            continue;
                        }
                        break block75;
                    }
                    catch (ConfigurationException confExc) {
                        bdExc = new BaseDeploymentException("connector_0003", new String[]{fileName, fileConfig.getPath()}, (Throwable)confExc);
                        if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                }
                fileConfig = connectorsConfig;
                fileName = customJarFileName;
            }
            try {
                fileConfig.deleteFile(fileName);
            }
            catch (ConfigurationException confExc) {
                bdExc = new BaseDeploymentException("connector_0058", new String[]{fileName, fileConfig.getPath()}, (Throwable)confExc);
                if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            while (index != -1) {
                fileEntryNames = null;
                try {
                    fileEntryNames = fileConfig.getAllFileEntryNames();
                }
                catch (ConfigurationException confExc) {
                    bdExc = new BaseDeploymentException("connector_0004", fileConfig.getPath(), (Throwable)confExc);
                    if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
                subConfigNames = null;
                try {
                    subConfigNames = fileConfig.getAllSubConfigurationNames();
                }
                catch (ConfigurationException confExc) {
                    bdExc = new BaseDeploymentException("connector_0064", fileConfig.getPath(), (Throwable)confExc);
                    if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
                if (fileEntryNames.length == 0 && subConfigNames.length == 0) {
                    try {
                        fileConfig.deleteConfiguration();
                    }
                    catch (ConfigurationException confExc) {
                        bdExc = new BaseDeploymentException("connector_0054", fileConfig.getPath(), (Throwable)confExc);
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                        throw bdExc;
                    }
                }
                if ((index = customJarFileName.lastIndexOf("/")) == -1) continue;
                customJarFileName = customJarFileName.substring(0, index);
                try {
                    fileConfig = this.getConfiguration(connectorsConfig, customJarFileName);
                }
                catch (ConfigurationException confExc) {
                    bdExc = new BaseDeploymentException("connector_0001", new String[]{customJarFileName, connectorsConfig.getPath()}, (Throwable)confExc);
                    if (ConnectorResourceAccessor.location.beLogged(500) == false) throw bdExc;
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
            }
        }
        return allJars.toArray(new String[allJars.size()]);
    }

    public String[] updateDriverJars(String appName, JCDescriptor descr, Configuration myContainerConfig, String workAppDir, String relativePath, Vector warnings) throws DeploymentException {
        BaseDeploymentException bdExc;
        String logPrefix = "DeployAdmin.updateDriverJars(), Application: " + appName;
        DriverInfo[] drivers = descr.getDrivers();
        Vector<String> allJars = new Vector<String>();
        String driversWorkDirName = this.makeDriversDir(workAppDir) + this.sepChar + relativePath.replace('/', this.sepChar);
        int i = 0;
        while (drivers != null && i < drivers.length) {
            HashSet jars = drivers[i].getJars();
            if (jars != null) {
                Iterator jarsEnumeration = jars.iterator();
                while (jarsEnumeration.hasNext()) {
                    String jar = (String)jarsEnumeration.next();
                    File jarSourceFile = new File(jar);
                    String realDriverJarName = this.makeDriverJarName(driversWorkDirName, relativePath, drivers[i].getDriverName(), jarSourceFile.getName(), false);
                    String replacedDriverJarName = realDriverJarName.replace('\\', this.sepChar).replace('/', this.sepChar);
                    File jarOutputFile = new File(driversWorkDirName + this.sepChar + replacedDriverJarName);
                    this.mkDirs(jarOutputFile, true);
                    allJars.add(jarOutputFile.getPath());
                    try {
                        FileUtils.copyFile(jarSourceFile, jarOutputFile);
                    }
                    catch (IOException ioExc) {
                        throw new BaseDeploymentException("connector_0013", jar, (Throwable)ioExc);
                    }
                }
            }
            ++i;
        }
        Configuration driversConfig = null;
        if (allJars.size() == 0) {
            try {
                driversConfig = this.getConfiguration(myContainerConfig, "drivers/" + relativePath);
            }
            catch (ConfigurationException confExc) {
                bdExc = new BaseDeploymentException("connector_0001", new String[]{"drivers/" + relativePath, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc.getStackTraceString());
                }
                return new String[0];
            }
        }
        try {
            driversConfig = this.createConfiguration(myContainerConfig, "drivers/" + relativePath, 0);
        }
        catch (ConfigurationException confExc) {
            bdExc = new BaseDeploymentException("connector_0000", new String[]{"drivers/" + relativePath, myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        HashSet customDriverJarFiles = new HashSet();
        this.getAllFileEntryNames("", driversConfig, customDriverJarFiles);
        Iterator deployDriverJarFileNames = ((AbstractList)allJars).iterator();
        int prefixIndex = driversWorkDirName.length();
        while (deployDriverJarFileNames.hasNext()) {
            String deployDriverJarFileName = (String)deployDriverJarFileNames.next();
            String replacedDeployDriverJarFileName = deployDriverJarFileName.substring(prefixIndex + 1).replace(this.sepChar, '/');
            boolean update = customDriverJarFiles.remove(replacedDeployDriverJarFileName);
            int index = replacedDeployDriverJarFileName.lastIndexOf("/");
            Configuration fileConfig = null;
            if (index != -1) {
                try {
                    if (driversConfig.existsFile(replacedDeployDriverJarFileName)) {
                        driversConfig.deleteFile(replacedDeployDriverJarFileName);
                    }
                }
                catch (ConfigurationException confExc) {
                    throw new BaseDeploymentException("connector_0058", new String[]{replacedDeployDriverJarFileName, driversConfig.getPath()}, (Throwable)((Object)confExc));
                }
                try {
                    fileConfig = this.createConfiguration(driversConfig, replacedDeployDriverJarFileName.substring(0, index), 0);
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc2 = new BaseDeploymentException("connector_0000", new String[]{replacedDeployDriverJarFileName.substring(0, index), driversConfig.getPath()}, (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc2.getStackTraceString());
                    }
                    throw bdExc2;
                }
            }
            fileConfig = driversConfig;
            this.addFileAsStreamToConfig(replacedDeployDriverJarFileName.substring(index + 1), fileConfig, new File(deployDriverJarFileName), update);
        }
        Iterator customJarFileNames = customDriverJarFiles.iterator();
        while (customJarFileNames.hasNext()) {
            BaseDeploymentException bdExc3;
            int index;
            String customJarFileName;
            String fileName;
            Configuration fileConfig;
            block48: {
                fileConfig = null;
                fileName = null;
                customJarFileName = (String)customJarFileNames.next();
                index = customJarFileName.lastIndexOf("/");
                if (index != -1) {
                    try {
                        if (driversConfig.existsFile(customJarFileName)) {
                            driversConfig.deleteFile(customJarFileName);
                        }
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0058", new String[]{customJarFileName, driversConfig.getPath()}, (Throwable)((Object)confExc));
                    }
                    fileName = customJarFileName.substring(index + 1);
                    customJarFileName = customJarFileName.substring(0, index);
                    try {
                        fileConfig = this.getConfigurationIfExists(driversConfig, customJarFileName);
                    }
                    catch (ConfigurationException confExc) {
                        bdExc3 = new BaseDeploymentException("connector_0001", new String[]{customJarFileName, driversConfig.getPath()}, (Throwable)((Object)confExc));
                        if (ConnectorResourceAccessor.location.beLogged(500)) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc3.getStackTraceString());
                        }
                        throw bdExc3;
                    }
                    try {
                        if (fileConfig == null || !fileConfig.existsFile(fileName)) {
                            continue;
                        }
                        break block48;
                    }
                    catch (ConfigurationException confExc) {
                        bdExc3 = new BaseDeploymentException("connector_0003", new String[]{fileName, fileConfig.getPath()}, (Throwable)((Object)confExc));
                        if (ConnectorResourceAccessor.location.beLogged(500)) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc3.getStackTraceString());
                        }
                        throw bdExc3;
                    }
                }
                fileConfig = driversConfig;
                fileName = customJarFileName;
            }
            try {
                fileConfig.deleteFile(fileName);
            }
            catch (ConfigurationException confExc) {
                bdExc3 = new BaseDeploymentException("connector_0058", new String[]{fileName, fileConfig.getPath()}, (Throwable)((Object)confExc));
                if (ConnectorResourceAccessor.location.beLogged(500)) {
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc3.getStackTraceString());
                }
                throw bdExc3;
            }
            while (index != -1) {
                String[] fileEntryNames = null;
                try {
                    fileEntryNames = fileConfig.getAllFileEntryNames();
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc4 = new BaseDeploymentException("connector_0004", fileConfig.getPath(), (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc4.getStackTraceString());
                    }
                    throw bdExc4;
                }
                String[] subConfigNames = null;
                try {
                    subConfigNames = fileConfig.getAllSubConfigurationNames();
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc5 = new BaseDeploymentException("connector_0064", fileConfig.getPath(), (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc5.getStackTraceString());
                    }
                    throw bdExc5;
                }
                if (fileEntryNames.length == 0 && subConfigNames.length == 0) {
                    try {
                        fileConfig.deleteConfiguration();
                    }
                    catch (ConfigurationException confExc) {
                        BaseDeploymentException bdExc6 = new BaseDeploymentException("connector_0054", fileConfig.getPath(), (Throwable)((Object)confExc));
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc6.getStackTraceString());
                        throw bdExc6;
                    }
                }
                if ((index = customJarFileName.lastIndexOf("/")) == -1) continue;
                customJarFileName = customJarFileName.substring(0, index);
                try {
                    fileConfig = this.getConfiguration(driversConfig, customJarFileName);
                }
                catch (ConfigurationException confExc) {
                    BaseDeploymentException bdExc7 = new BaseDeploymentException("connector_0001", new String[]{customJarFileName, driversConfig.getPath()}, (Throwable)((Object)confExc));
                    if (ConnectorResourceAccessor.location.beLogged(500)) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc7.getStackTraceString());
                    }
                    throw bdExc7;
                }
            }
        }
        return allJars.toArray(new String[allJars.size()]);
    }

    public JCDescriptor[] mergeDescriptors(String appName, Configuration rootConfig, JCDescriptor defaultDescr, JCDescriptor customDescr, JCDescriptor deployDescr) throws DeploymentException {
        JCDescriptor clonedDeployDescr = (JCDescriptor)deployDescr.clone();
        deployDescr = (JCDescriptor)deployDescr.clone();
        JCDescriptor[] result = new JCDescriptor[]{customDescr != null ? customDescr : defaultDescr, clonedDeployDescr};
        this.mergeDescriptorsConfigProps(appName, defaultDescr, customDescr, clonedDeployDescr);
        this.mergeDescriptorsPoolingProps(appName, defaultDescr, customDescr, clonedDeployDescr);
        this.mergeDescriptorsLoaderRefs(appName, customDescr, clonedDeployDescr);
        this.mergeDescriptorsAliases(appName, customDescr, clonedDeployDescr);
        String prefix = null;
        prefix = customDescr != null ? customDescr.getPrefix() : defaultDescr.getPrefix();
        if (!prefix.equals("")) {
            if (customDescr != null) {
                clonedDeployDescr.setConnectorJNDIName(customDescr.getConnectorJNDIName());
                clonedDeployDescr.setDisplayName(customDescr.getDisplayName());
                deployDescr.setConnectorJNDIName(customDescr.getConnectorJNDIName());
                deployDescr.setDisplayName(customDescr.getDisplayName());
            } else {
                clonedDeployDescr.setConnectorJNDIName(defaultDescr.getConnectorJNDIName());
                clonedDeployDescr.setDisplayName(defaultDescr.getDisplayName());
                deployDescr.setConnectorJNDIName(defaultDescr.getConnectorJNDIName());
                deployDescr.setDisplayName(defaultDescr.getDisplayName());
            }
            if (clonedDeployDescr.isInternalUserStore() && clonedDeployDescr.getUserStore() != null) {
                clonedDeployDescr.setUserStore(DeployAdmin.fixName(DeployAdmin.makeConnectorName(clonedDeployDescr)));
            }
            if (deployDescr.isInternalUserStore() && deployDescr.getUserStore() != null) {
                deployDescr.setUserStore(DeployAdmin.fixName(DeployAdmin.makeConnectorName(deployDescr)));
            }
            clonedDeployDescr.setToDefault("jndi-name", false);
            clonedDeployDescr.setToDefault("display-name", false);
            clonedDeployDescr.setPrefix(prefix);
            deployDescr.setToDefault("jndi-name", false);
            deployDescr.setToDefault("display-name", false);
            deployDescr.setPrefix(prefix);
            prefix = prefix + "_";
        }
        this.writeDescriptorIntoSheet(appName, rootConfig, deployDescr, prefix + "ra.xml", prefix + "connector-j2ee-engine.xml", true, true);
        if (customDescr != null) {
            this.writeDescriptorIntoSheet(appName, rootConfig, clonedDeployDescr, prefix + "ra.xml", prefix + "connector-j2ee-engine.xml", true, false);
        }
        return result;
    }

    private void mergeDescriptorsConfigProps(String appName, JCDescriptor defaultDescr, JCDescriptor customDescr, JCDescriptor deployDescr) {
        int i;
        ConfigProperty[] props;
        String logPrefix = "DeployAdmin.mergeDescriptorsConfigProps(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        ManagedFactoryProperty mfp = null;
        HashMap<String, ConfigProperty> defaultConfProps = new HashMap<String, ConfigProperty>();
        ConfigProperty[] customConfProps = null;
        HashMap<String, ConfigProperty> deployConfProps = new HashMap<String, ConfigProperty>();
        if (customDescr == null) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", custom descriptor is not present -> merge won't be performed.");
            return;
        }
        mfp = defaultDescr.getManagedFactoryProperty();
        if (mfp != null && mfp.getConfigProperties().length != 0) {
            props = mfp.getConfigProperties();
            i = 0;
            while (i < props.length) {
                defaultConfProps.put(props[i].getConfigPropertyName(), props[i]);
                ++i;
            }
        } else {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", MFP is not present in default descriptor.");
        }
        mfp = customDescr.getManagedFactoryProperty();
        if (mfp != null && mfp.getConfigProperties().length != 0) {
            customConfProps = mfp.getConfigProperties();
        } else {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", MFP is not present in custom descriptor.");
        }
        mfp = deployDescr.getManagedFactoryProperty();
        if (mfp != null && mfp.getConfigProperties().length != 0) {
            props = mfp.getConfigProperties();
            i = 0;
            while (i < props.length) {
                deployConfProps.put(props[i].getConfigPropertyName(), props[i]);
                ++i;
            }
        } else {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", MFP is not present in deploy descriptor.");
        }
        int i2 = 0;
        while (i2 < customConfProps.length) {
            ConfigProperty customConfProp = customConfProps[i2];
            String customPropName = customConfProp.getConfigPropertyName();
            String customPropType = customConfProp.getConfigPropertyType();
            String customPropValue = customConfProp.getConfigPropertyValue();
            String customPropDescr = customConfProp.getDescription();
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", CustomPropName: " + customPropName + ", CustomPropType: " + customPropType);
            ConfigProperty defaultConfProp = (ConfigProperty)defaultConfProps.get(customPropName);
            String defaultPropName = null;
            String defaultPropType = null;
            String defaultPropValue = null;
            String defaultPropDescr = null;
            if (defaultConfProp != null) {
                defaultPropName = defaultConfProp.getConfigPropertyName();
                defaultPropType = defaultConfProp.getConfigPropertyType();
                defaultPropValue = defaultConfProp.getConfigPropertyValue();
                defaultPropDescr = defaultConfProp.getDescription();
            }
            ConfigProperty deployConfProp = (ConfigProperty)deployConfProps.remove(customPropName);
            String deployPropType = null;
            String deployPropValue = null;
            String deployPropDescr = null;
            if (deployConfProp != null) {
                deployPropType = deployConfProp.getConfigPropertyType();
                deployPropValue = deployConfProp.getConfigPropertyValue();
                deployPropDescr = deployConfProp.getDescription();
            }
            boolean defaultCustomTypeChanged = false;
            if (defaultConfProp != null && !defaultPropType.equals(customPropType)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Default-Custom changed, DefaultPropName: " + defaultPropName + ", " + defaultPropType + " != " + customPropType);
                defaultCustomTypeChanged = true;
            }
            boolean customDeployTypeChanged = false;
            if (deployConfProp != null && !customPropType.equals(deployPropType)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Custom-Deploy changed, CustomPropName: " + customPropName + ", " + customPropType + " != " + deployPropType);
                customDeployTypeChanged = true;
            }
            if (deployConfProp != null) {
                if (defaultConfProp != null) {
                    if (!defaultCustomTypeChanged && customDeployTypeChanged) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Default-Custom(unchanged), Custom-Deploy(changed), CustomPropName: " + customPropName + ", Custom Type: " + customPropType + " --> Deploy Type: " + deployPropType);
                        customConfProp.setConfigPropertyType(deployPropType);
                    }
                    if (!defaultCustomTypeChanged && ((defaultPropValue == null || defaultPropValue.equals("")) && (customPropValue == null || customPropValue.equals("")) || EqualUtils.equalObjects(defaultPropValue, customPropValue))) {
                        customConfProp.setConfigPropertyValue(deployPropValue);
                    }
                    if ((defaultPropDescr == null || defaultPropDescr.equals("")) && (customPropDescr == null || customPropDescr.equals("")) || EqualUtils.equalObjects(defaultPropDescr, customPropDescr)) {
                        customConfProp.setDescription(deployPropDescr);
                    }
                } else {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", CustomPropName: " + customPropName + ", Deploy(present), Default(not present), leave the custom one unchanged.");
                }
            } else if (defaultConfProp != null) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", CustomPropName: " + customPropName + ", Deploy(not present), Default(present), proceed with removing of the custom one.");
                customConfProps[i2] = null;
            }
            ++i2;
        }
        ArrayList<ConfigProperty> customPropsArray = new ArrayList<ConfigProperty>();
        int i3 = 0;
        while (i3 < customConfProps.length) {
            ConfigProperty customConfProp = customConfProps[i3];
            if (customConfProp != null) {
                customPropsArray.add(customConfProp);
            }
            ++i3;
        }
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Added Deployed Properties.");
        Iterator props2 = deployConfProps.values().iterator();
        while (props2.hasNext()) {
            ConfigProperty confProp = (ConfigProperty)props2.next();
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", DeployPropName: " + confProp.getConfigPropertyName() + ", DeployPropType: " + confProp.getConfigPropertyType());
            if (defaultConfProps.containsKey(confProp.getConfigPropertyName())) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", DeployPropName: " + confProp.getConfigPropertyName() + " Default(present), Custom(not present), will not be added.");
                continue;
            }
            customPropsArray.add(confProp);
        }
        mfp = deployDescr.getManagedFactoryProperty();
        deployDescr.clearManagedFactoryProperty();
        if (mfp == null) {
            mfp = new ManagedFactoryProperty();
        }
        mfp.setConfigProperties(customPropsArray.toArray(new ConfigProperty[customPropsArray.size()]));
        deployDescr.setManagedFactoryProperty(mfp);
        ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
    }

    private void mergeDescriptorsPoolingProps(String appName, JCDescriptor defaultDescr, JCDescriptor customDescr, JCDescriptor deployDescr) {
        String logPrefix = "DeployAdmin.mergeDescriptorsPoolingProps(), Application: " + appName;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        if (customDescr == null) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", custom descriptor is not present -> merge won't be performed.");
            }
            return;
        }
        int defMaxConnsNumber = defaultDescr.getMaxConnectionsNumber();
        int defMaxTimeToWait = defaultDescr.getMaxTimeToWaitConnection();
        int defConnLifeTime = defaultDescr.getConnectionLifetime();
        int defRunCleanupThread = defaultDescr.getRunCleanupThreadTime();
        int customMaxConnsNumber = customDescr.getMaxConnectionsNumber();
        int customMaxTimeToWait = customDescr.getMaxTimeToWaitConnection();
        int customConnLifeTime = customDescr.getConnectionLifetime();
        int customRunCleanupThread = customDescr.getRunCleanupThreadTime();
        if (defMaxConnsNumber != customMaxConnsNumber) {
            deployDescr.setMaxConnectionsNumber(customMaxConnsNumber);
        }
        if (defMaxTimeToWait != customMaxTimeToWait) {
            deployDescr.setMaxTimeToWaitConnection(customMaxTimeToWait);
        }
        if (defConnLifeTime != customConnLifeTime) {
            deployDescr.setConnectionLifetime(customConnLifeTime);
        }
        if (defRunCleanupThread != customRunCleanupThread) {
            deployDescr.setRunCleanupThreadTime(customRunCleanupThread);
        }
    }

    private void mergeDescriptorsLoaderRefs(String appName, JCDescriptor customDescr, JCDescriptor deployDescr) {
        String logPrefix = "DeployAdmin.mergeDescriptorsLoaderRefs(), Application: " + appName;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        if (customDescr == null) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", custom descriptor is not present -> merge won't be performed.");
            }
            return;
        }
        String[] customLoaderRefs = customDescr.getLoaderReferences();
        String[] deployLoaderRefs = deployDescr.getLoaderReferences();
        if (deployLoaderRefs == null || deployLoaderRefs.length == 0) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", deploy references are not present -> will use custom.");
            }
            deployDescr.setLoaderReferences(customLoaderRefs);
        } else if (customLoaderRefs != null && customLoaderRefs.length > 0) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", merge of deploy and custom references will be performed.");
            }
            Vector<String> realLoaderRefs = new Vector<String>();
            int i = 0;
            while (i < customLoaderRefs.length) {
                realLoaderRefs.add(customLoaderRefs[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < deployLoaderRefs.length) {
                boolean found = false;
                int j = 0;
                while (j < realLoaderRefs.size()) {
                    if (realLoaderRefs.elementAt(j).equals(deployLoaderRefs[i2])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    realLoaderRefs.add(deployLoaderRefs[i2]);
                }
                ++i2;
            }
            deployDescr.setLoaderReferences(realLoaderRefs.toArray(new String[realLoaderRefs.size()]));
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    private void mergeDescriptorsAliases(String appName, JCDescriptor customDescr, JCDescriptor deployDescr) {
        String logPrefix = "DeployAdmin.mergeDescriptorsAliases(), Application: " + appName;
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        if (customDescr == null) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", custom descriptor is not present -> merge won't be performed.");
            }
            return;
        }
        String[] customAliases = customDescr.getAliases();
        String[] deployAliases = deployDescr.getAliases();
        if (deployAliases == null || deployAliases.length == 0) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", deploy aliases are not present -> will use custom.");
            }
            deployDescr.setAliases(customAliases);
        } else if (customAliases != null && customAliases.length > 0) {
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", merge of deploy and custom aliases will be performed.");
            }
            Vector<String> realAliases = new Vector<String>();
            int i = 0;
            while (i < customAliases.length) {
                realAliases.add(customAliases[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < deployAliases.length) {
                boolean found = false;
                int j = 0;
                while (j < realAliases.size()) {
                    if (realAliases.elementAt(j).equals(deployAliases[i2])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    realAliases.add(deployAliases[i2]);
                }
                ++i2;
            }
            deployDescr.setAliases(realAliases.toArray(new String[realAliases.size()]));
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public void mergeSecurityConfigurations(String appName, JCDescriptor customDescr, JCDescriptor deployDescr, ManagedConnectionFactory mcf, Configuration myContainerConfig) throws DeploymentException {
        BaseDeploymentException bdExc;
        Iterator groupsIterator;
        Object user;
        HashSet users;
        IdentitySubject[] subjects;
        Configuration securityConfig;
        String deployAuthType;
        String deployFixedConnectorName;
        String customFixedConnectorName;
        String logPrefix;
        block79: {
            logPrefix = "DeployAdmin.mergeSecurityConfigurations(), Application: " + appName;
            String connectorName = DeployAdmin.makeConnectorName(deployDescr);
            customFixedConnectorName = DeployAdmin.fixName(DeployAdmin.makeConnectorName(customDescr));
            String customAuthType = customDescr.getAuthenticationType();
            deployFixedConnectorName = DeployAdmin.fixName(DeployAdmin.makeConnectorName(deployDescr));
            deployAuthType = deployDescr.getAuthenticationType();
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector Name: " + connectorName);
            if (customAuthType == null) {
                if (deployAuthType != null) {
                    this.registerIdentitySubjects(appName, mcf, deployDescr, myContainerConfig);
                }
                return;
            }
            securityConfig = null;
            try {
                securityConfig = myContainerConfig.getSubConfiguration("prefix:" + customDescr.getConnectorJNDIName());
            }
            catch (ConfigurationException confExc) {
                BaseDeploymentException bdExc2 = new BaseDeploymentException("connector_0055", new String[]{"prefix:" + customDescr.getConnectorJNDIName(), myContainerConfig.getPath()}, (Throwable)((Object)confExc));
                if (!ConnectorResourceAccessor.location.beLogged(100)) break block79;
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + bdExc2.getStackTraceString());
            }
        }
        if (securityConfig == null) {
            securityConfig = myContainerConfig;
        }
        SecurityContext mySecurityContext = this.getMySecurityContext(appName, deployDescr, customFixedConnectorName, securityConfig, false);
        if (deployAuthType == null || !customFixedConnectorName.equals(deployFixedConnectorName)) {
            if (customDescr.getUserStore() != null && customDescr.isInternalUserStore()) {
                this.unregisterRAUserStore(appName, customDescr, securityConfig);
            }
            this.unregisterPolicyConfiguration(appName, customDescr, securityConfig);
            if (securityConfig != myContainerConfig) {
                this.deleteConfiguration(appName, myContainerConfig, null, "prefix:" + customDescr.getConnectorJNDIName(), true);
            }
            if (deployAuthType != null) {
                this.registerIdentitySubjects(appName, mcf, deployDescr, myContainerConfig);
            }
            return;
        }
        String customUserStore = customDescr.getUserStore();
        boolean customInternalUS = customDescr.isInternalUserStore();
        String deployUserStore = deployDescr.getUserStore();
        boolean deployInternalUS = deployDescr.isInternalUserStore();
        UserStore raUserStore = null;
        Hashtable userMapping = new Hashtable();
        Hashtable groupMapping = new Hashtable();
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        Vector<CallerImpersonationConfiguration> configEntries = new Vector<CallerImpersonationConfiguration>();
        ResourcePrincipal resourcePrincipal = null;
        if (customInternalUS) {
            if (!customUserStore.equals(deployUserStore)) {
                this.unregisterRAUserStore(appName, customDescr, securityConfig);
                if (deployUserStore != null) {
                    raUserStore = this.getRAUserStore(appName, deployDescr, mySecurityContext);
                }
            } else if (deployInternalUS) {
                raUserStore = this.getRAUserStore(appName, customDescr, mySecurityContext);
                IdentitySubject[] customSubjects = customDescr.getIdentitySubjects();
                HashMap<String, String> customResPrnplNames = new HashMap<String, String>();
                int i = 0;
                while (customSubjects != null && i < customSubjects.length) {
                    ResourcePrincipal customResPrnpl = customSubjects[i].getResourcePrincipal();
                    customResPrnplNames.put(customResPrnpl.getUserName(), customResPrnpl.getPassword());
                    ++i;
                }
                IdentitySubject[] deploySubjects = deployDescr.getIdentitySubjects();
                if (deploySubjects == null) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + 0);
                } else {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + deploySubjects.length);
                }
                int i2 = 0;
                while (deploySubjects != null && i2 < deploySubjects.length) {
                    CallerPrincipal deployCallerPrnpl = deploySubjects[i2].getCallerPrincipal();
                    resourcePrincipal = deploySubjects[i2].getResourcePrincipal();
                    boolean userExists = customResPrnplNames.containsKey(resourcePrincipal.getUserName());
                    String customResPrnplPswd = (String)customResPrnplNames.remove(resourcePrincipal.getUserName());
                    if (userExists) {
                        if (customResPrnplPswd != null && !customResPrnplPswd.equals(resourcePrincipal.getPassword()) || resourcePrincipal.getPassword() != null && !resourcePrincipal.getPassword().equals(customResPrnplPswd)) {
                            try {
                                UserInfo userForUpdate = raUserStore.getUserContext().getUserInfo(resourcePrincipal.getUserName());
                                if (resourcePrincipal.getPassword() != null) {
                                    userForUpdate.setPassword(resourcePrincipal.getPassword().toCharArray());
                                }
                                userForUpdate.setPassword(null);
                            }
                            catch (SecurityException secExc) {
                                BaseDeploymentException bdExc3 = new BaseDeploymentException("connector_0069", new String[]{resourcePrincipal.getUserName(), customUserStore, customDescr.getConnectorJNDIName(), appName}, (Throwable)secExc);
                                if (ConnectorResourceAccessor.location.beLogged(500)) {
                                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc3.getStackTraceString());
                                }
                                throw bdExc3;
                            }
                        }
                    } else {
                        this.addMappingInUS(appName, customDescr.getConnectorJNDIName(), raUserStore, resourcePrincipal);
                    }
                    if (deployAuthType.equalsIgnoreCase("Principal Mapping")) {
                        HashSet groups;
                        HashSet users2 = deployCallerPrnpl.getUserNames();
                        if (users2 != null) {
                            Iterator usersIterator = users2.iterator();
                            while (usersIterator.hasNext()) {
                                Object user2 = usersIterator.next();
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add User Mapping: " + user2 + ", " + resourcePrincipal.getUserName());
                                }
                                userMapping.put(user2, resourcePrincipal.getUserName());
                            }
                        }
                        if ((groups = deployCallerPrnpl.getGroups()) != null) {
                            Iterator groupsIterator2 = groups.iterator();
                            while (groupsIterator2.hasNext()) {
                                Object group = groupsIterator2.next();
                                if (ConnectorResourceAccessor.location.beLogged(300)) {
                                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add Group Mapping: " + group + ", " + resourcePrincipal.getUserName());
                                }
                                groupMapping.put(group, resourcePrincipal.getUserName());
                            }
                        }
                    }
                    ++i2;
                }
                Iterator customResPrnplsForDelete = customResPrnplNames.keySet().iterator();
                while (customResPrnplsForDelete.hasNext()) {
                    String customResPrnplForDelete = (String)customResPrnplsForDelete.next();
                    try {
                        raUserStore.getUserContext().deleteUser(customResPrnplForDelete);
                    }
                    catch (SecurityException secExc) {
                        BaseDeploymentException bdExc4 = new BaseDeploymentException("connector_0070", new String[]{customResPrnplForDelete, customUserStore, customDescr.getConnectorJNDIName(), appName}, (Throwable)secExc);
                        if (ConnectorResourceAccessor.location.beLogged(500)) {
                            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc4.getStackTraceString());
                        }
                        throw bdExc4;
                    }
                }
            } else {
                this.unregisterRAUserStore(appName, customDescr, securityConfig);
                raUserStore = this.getRAUserStore(appName, deployDescr, mySecurityContext);
            }
        } else if (deployInternalUS) {
            raUserStore = this.registerRAUserStore(appName, deployDescr, mySecurityContext);
            subjects = deployDescr.getIdentitySubjects();
            if (subjects == null) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + 0);
            } else {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + subjects.length);
            }
            int i = 0;
            while (subjects != null && i < subjects.length) {
                CallerPrincipal callerPrincipal = subjects[i].getCallerPrincipal();
                resourcePrincipal = subjects[i].getResourcePrincipal();
                this.addMappingInUS(appName, deployDescr.getConnectorJNDIName(), raUserStore, resourcePrincipal);
                if (deployAuthType.equalsIgnoreCase("Principal Mapping")) {
                    HashSet groups;
                    users = callerPrincipal.getUserNames();
                    if (users != null) {
                        Iterator usersIterator = users.iterator();
                        while (usersIterator.hasNext()) {
                            user = usersIterator.next();
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add User Mapping: " + user + ", " + resourcePrincipal.getUserName());
                            }
                            userMapping.put(user, resourcePrincipal.getUserName());
                        }
                    }
                    if ((groups = callerPrincipal.getGroups()) != null) {
                        groupsIterator = groups.iterator();
                        while (groupsIterator.hasNext()) {
                            Object group = groupsIterator.next();
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add Group Mapping: " + group + ", " + resourcePrincipal.getUserName());
                            }
                            groupMapping.put(group, resourcePrincipal.getUserName());
                        }
                    }
                }
                ++i;
            }
        } else if (deployUserStore != null) {
            raUserStore = this.getRAUserStore(appName, deployDescr, mySecurityContext);
            if (deployAuthType.equalsIgnoreCase("Principal Mapping")) {
                subjects = deployDescr.getIdentitySubjects();
                if (subjects == null) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + 0);
                } else {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + subjects.length);
                }
                int i = 0;
                while (subjects != null && i < subjects.length) {
                    HashSet groups;
                    CallerPrincipal callerPrincipal = subjects[i].getCallerPrincipal();
                    resourcePrincipal = subjects[i].getResourcePrincipal();
                    users = callerPrincipal.getUserNames();
                    if (users != null) {
                        Iterator usersIterator = users.iterator();
                        while (usersIterator.hasNext()) {
                            user = usersIterator.next();
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add User Mapping: " + user + ", " + resourcePrincipal.getUserName());
                            }
                            userMapping.put(user, resourcePrincipal.getUserName());
                        }
                    }
                    if ((groups = callerPrincipal.getGroups()) != null) {
                        groupsIterator = groups.iterator();
                        while (groupsIterator.hasNext()) {
                            Object group = groupsIterator.next();
                            if (ConnectorResourceAccessor.location.beLogged(300)) {
                                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Add Group Mapping: " + group + ", " + resourcePrincipal.getUserName());
                            }
                            groupMapping.put(group, resourcePrincipal.getUserName());
                        }
                    }
                    ++i;
                }
            } else if (deployAuthType.equalsIgnoreCase("Configured Identity")) {
                subjects = deployDescr.getIdentitySubjects();
                if (subjects == null) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + 0);
                } else {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", IdentitySubjects: " + subjects.length);
                    resourcePrincipal = subjects[subjects.length - 1].getResourcePrincipal();
                }
            }
        }
        AppConfigurationEntry configEntry = null;
        if (deployAuthType.equalsIgnoreCase("Principal Mapping")) {
            options.put("User_Store", deployUserStore);
            options.put("Managed_Connection_Factory", mcf);
            options.put("Users_Mapping", userMapping);
            options.put("Groups_Mapping", groupMapping);
            configEntry = new PrincipalMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (deployAuthType.equalsIgnoreCase("Caller Impersonation")) {
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CallerImpersonationConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (deployAuthType.equalsIgnoreCase("Credentials Mapping")) {
            if (deployUserStore != null) {
                options.put("User_Store", deployUserStore);
            }
            options.put("Managed_Connection_Factory", mcf);
            configEntry = new CredentialsMappingConfiguration(options);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        } else if (deployAuthType.equalsIgnoreCase("Configured Identity")) {
            Hashtable<String, String> intOptions = new Hashtable<String, String>();
            intOptions.put("Configured_Identity", resourcePrincipal.getUserName());
            intOptions.put("User_Store", deployUserStore);
            intOptions.put("Managed_Connection_Factory", (String)mcf);
            configEntry = new ConfiguredIdentityConfiguration(intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthMechanism[] authMechs = deployDescr.getAuthMechanisms();
        boolean isSAPLogon = this.checkForSapLogon(authMechs);
        if (!(!isSAPLogon || deployAuthType.equalsIgnoreCase("Caller Impersonation") || deployAuthType.equalsIgnoreCase("Credentials Mapping") && deployUserStore != null)) {
            Hashtable<String, String> _intOptions = new Hashtable<String, String>();
            _intOptions.put("ume.configuration.active", "true");
            configEntry = new AppConfigurationEntry("com.sap.security.core.server.jaas.CreateAssertionTicketLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, _intOptions);
            configEntries.add((CallerImpersonationConfiguration)configEntry);
        }
        AuthenticationContext myAuthenticationContext = this.getMyAuthenticationContext(appName, deployDescr, mySecurityContext);
        try {
            myAuthenticationContext.setAuthenticationUserStore(raUserStore);
        }
        catch (SecurityException secExc) {
            bdExc = new BaseDeploymentException("connector_0036", new String[]{deployUserStore, deployFixedConnectorName}, (Throwable)secExc);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        try {
            myAuthenticationContext.setLoginModules(configEntries.toArray(new AppConfigurationEntry[configEntries.size()]));
        }
        catch (SecurityException secExc) {
            bdExc = new BaseDeploymentException("connector_0037", deployFixedConnectorName, (Throwable)secExc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
    }

    private boolean checkForSapLogon(AuthMechanism[] authMechs) {
        int i = 0;
        while (authMechs != null && i < authMechs.length) {
            AuthMechanism authMech = authMechs[i];
            if (authMech != null) {
                if (authMech.getAuthMechType().equals("BasicPassword")) {
                    return false;
                }
                if (AuthMechanism.SAP_ASSERTION_TICKET_SET.contains(authMech.getAuthMechType())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

