/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.connector.ManagedConnectionFactoryActivation;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.HashMapObjectIntPositive;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseWarningException;
import com.sap.engine.services.connector.exceptions.ConnectorException;
import com.sap.engine.services.connector.jca.AdapterCache;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.connector.jca.deploy.ApplicationInfo;
import com.sap.engine.services.connector.jca.deploy.ConnectorMonitoringInterface;
import com.sap.engine.services.connector.jca.deploy.DeployAdmin;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.resource.impl.MCEventHandler;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

public class ContainerImpl
implements ContainerInterface,
ConnectorMonitoringInterface {
    public static final String CONTAINER_NAME = "connector";
    private static final String ROOT_CONF = "apps";
    private DeployCommunicator deployCommunicator = null;
    private DeployAdmin deployAdmin = null;
    private LoadContext loadContext = null;
    ConfigurationHandler configurationHandler = null;
    private Hashtable runtimeAppsInfo = null;
    private Hashtable appsInfo = null;
    private ContainerInfo containerInfo = null;
    private Properties contextProps = null;
    private String serviceName = null;
    private static final String[] res_types = new String[]{"javax.resource.cci.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.sql.DataSource"};
    private static final int APP_PRIORITY = 85;

    public ContainerImpl(ApplicationServiceContext asc) throws ConfigurationException {
        this.deployAdmin = new DeployAdmin(asc);
        this.loadContext = asc.getCoreContext().getLoadContext();
        this.serviceName = asc.getServiceState().getServiceName();
        this.configurationHandler = asc.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
        this.init();
    }

    protected void init() {
        this.runtimeAppsInfo = new Hashtable();
        this.appsInfo = new Hashtable();
        this.containerInfo = new ContainerInfo();
        this.containerInfo.setServiceName(this.serviceName);
        this.containerInfo.setName(CONTAINER_NAME);
        this.containerInfo.setJ2EEModuleName(CONTAINER_NAME);
        this.containerInfo.setJ2EEContainer(true);
        this.containerInfo.setFileExtensions(new String[]{".rar"});
        this.containerInfo.setResourceTypes(res_types);
        this.containerInfo.setPriority(85);
        this.contextProps = new Properties();
        ((Hashtable)this.contextProps).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)this.contextProps).put("domain", "true");
    }

    public void stop() {
        String logPrefix = "ContainerImpl.stop()";
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        ResourceObjectFactory.closeFactory();
    }

    public void start() {
        String logPrefix = "ContainerImpl.start()";
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        ResourceObjectFactory.openFactory();
    }

    public void setDeployCommunicator(DeployCommunicator deployCommunicator) {
        String logPrefix = "ContainerImpl.setDeployCommunicator()";
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set DeployCommunicator: " + deployCommunicator);
        this.deployCommunicator = deployCommunicator;
        this.convertPreviouslyDeployedAdapters();
    }

    public DeployCommunicator getDeployCommunicator() {
        return this.deployCommunicator;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        String logPrefix = "ContainerImpl.setSecurityContext()";
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set SecurityContext: " + securityContext);
        }
        this.deployAdmin.setSecurityContext(securityContext);
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Vector getAllAppNames() {
        Vector result = new Vector();
        Hashtable hashtable = this.appsInfo;
        synchronized (hashtable) {
            Enumeration e = this.appsInfo.elements();
            while (e.hasMoreElements()) {
                ApplicationInfo appInfo = (ApplicationInfo)e.nextElement();
                JCDescriptor[] jcDescriptors = appInfo.getJCDescriptors();
                Vector<String> vec = null;
                int j = 0;
                while (j < jcDescriptors.length) {
                    vec = new Vector<String>();
                    vec.add(jcDescriptors[j].getDisplayName());
                    vec.add(appInfo.getApplicationName());
                    vec.add(jcDescriptors[j].getConnectorJNDIName());
                    result.add(vec);
                    ++j;
                }
            }
        }
        String[] appNames = this.deployCommunicator.getMyApplications();
        int i = 0;
        while (i < appNames.length) {
            Vector<String> vec = null;
            if (this.deployCommunicator.getStatus(appNames[i]) == 0) {
                vec = new Vector<String>();
                vec.add(null);
                vec.add(appNames[i]);
                vec.add(null);
                result.add(vec);
            }
            ++i;
        }
        return result;
    }

    public JCDescriptor getJCDescriptor(String appName, String jndiName) {
        ApplicationInfo appInfo = (ApplicationInfo)this.appsInfo.get(appName);
        if (appInfo == null) {
            return null;
        }
        JCDescriptor[] jcDescriptors = appInfo.getJCDescriptors();
        int j = 0;
        while (j < jcDescriptors.length) {
            if (jndiName.equals(jcDescriptors[j].getConnectorJNDIName())) {
                return jcDescriptors[j];
            }
            ++j;
        }
        return null;
    }

    public JCDescriptor[] getAllJCDescriptors() {
        Vector<JCDescriptor> result = new Vector<JCDescriptor>();
        Hashtable hashtable = this.appsInfo;
        synchronized (hashtable) {
            Enumeration enumeration = this.appsInfo.elements();
            while (enumeration.hasMoreElements()) {
                ApplicationInfo appInfo = (ApplicationInfo)enumeration.nextElement();
                JCDescriptor[] descriptors = appInfo.getJCDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    result.add(descriptors[i]);
                    ++i;
                }
            }
        }
        return result.toArray(new JCDescriptor[result.size()]);
    }

    public JCDescriptor[] getAllJCDescriptors(String appName) {
        return ((ApplicationInfo)this.appsInfo.get(appName)).getJCDescriptors();
    }

    public JCDescriptor[][] getAllJCDescriptorsSP10() throws RemoteException, ConnectorException {
        String[] apps = this.deployCommunicator.getMyApplications();
        if (apps == null) {
            return new JCDescriptor[0][];
        }
        ArrayList<JCDescriptor[]> allDescrs = new ArrayList<JCDescriptor[]>();
        int i = 0;
        while (i < apps.length) {
            JCDescriptor[] descriptors = this.getAllJCDescriptorsSP10(apps[i]);
            if (descriptors != null) {
                allDescrs.add(descriptors);
            }
            ++i;
        }
        return (JCDescriptor[][])allDescrs.toArray((T[])new JCDescriptor[allDescrs.size()][]);
    }

    private JCDescriptor[] getAllJCDescriptorsSP10(String appName) throws RemoteException, ConnectorException {
        ApplicationInfo appInfo = this.getApplicationInfo(appName, 3);
        return appInfo.getJCDescriptors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApplicationInfo getApplicationInfo(String appName, int phaseType) throws ConnectorException {
        ApplicationInfo applicationInfo;
        Configuration configuration = null;
        try {
            try {
                String workAppDir = null;
                try {
                    workAppDir = this.deployCommunicator.getMyWorkDirectory(appName);
                }
                catch (IOException ioexc) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0009", appName, (Throwable)ioexc);
                    ConnectorResourceAccessor.location.logT(500, "getApplicationInfo(), Error: " + bdExc.getStackTraceString());
                    throw bdExc;
                }
                ApplicationInfo appInfo = (ApplicationInfo)this.appsInfo.get(appName);
                if (appInfo == null) {
                    if (configuration == null) {
                        configuration = this.configurationHandler.openConfiguration(ROOT_CONF, 0);
                    }
                    Configuration appConfig = null;
                    try {
                        appConfig = this.deployAdmin.getConfiguration(configuration, appName + '/' + CONTAINER_NAME);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0055", new String[]{appName + '/' + CONTAINER_NAME, configuration.getPath()}, (Throwable)((Object)confExc));
                    }
                    Vector connectors = new Vector();
                    Vector allJars = new Vector();
                    Properties props = new Properties();
                    boolean realApp = this.deployAdmin.extractFiles(appConfig, appName, workAppDir, connectors, allJars, props, new Vector());
                    appInfo = new ApplicationInfo(appName, realApp);
                    this.loadApplicationFromConfiguration(appInfo, appConfig, props, connectors, phaseType);
                }
                applicationInfo = appInfo;
                Object var12_16 = null;
                if (configuration == null) return applicationInfo;
            }
            catch (Exception exc) {
                ConnectorException connExc = new ConnectorException("connector_0082", exc);
                ConnectorResourceAccessor.location.traceThrowableT(500, "getApplicationInfo(), Error: ", (Throwable)((Object)connExc));
                throw connExc;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (configuration == null) throw throwable;
            try {
                configuration.close();
                throw throwable;
            }
            catch (Exception exc) {
                ConnectorException connExc = new ConnectorException("connector_0082", exc);
                ConnectorResourceAccessor.location.traceThrowableT(500, "getApplicationInfo(), Error: ", (Throwable)((Object)connExc));
                throw connExc;
            }
        }
        try {}
        catch (Exception exc) {
            ConnectorException connExc = new ConnectorException("connector_0082", exc);
            ConnectorResourceAccessor.location.traceThrowableT(500, "getApplicationInfo(), Error: ", (Throwable)((Object)connExc));
            throw connExc;
        }
        configuration.close();
        return applicationInfo;
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Configuration config;
        Vector warnings = new Vector();
        Vector<File> newArchiveFiles = null;
        String appName = dInfo.getApplicationName();
        boolean isStandAlone = dInfo.isStandAloneArchive();
        String logPrefix = "ContainerImpl.deploy(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", StandAlone : " + isStandAlone + ", Connectors to deploy: " + archiveFiles.length);
        int i = 0;
        while (i < archiveFiles.length) {
            String version = this.deployAdmin.getConnectorVersion(appName, archiveFiles[i].getAbsolutePath(), warnings);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector Version : " + version);
            if (version.equals("1.0")) {
                if (newArchiveFiles == null) {
                    newArchiveFiles = new Vector<File>();
                }
                newArchiveFiles.add(archiveFiles[i]);
            }
            ++i;
        }
        File[] fileArray = archiveFiles = newArchiveFiles == null ? null : newArchiveFiles.toArray(new File[newArchiveFiles.size()]);
        if (archiveFiles == null) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", ArchiveFiles are void: nothing to deploy.");
            return null;
        }
        ApplicationDeployInfo resultInfo = new ApplicationDeployInfo();
        if (isStandAlone) {
            ((Hashtable)props).put("isStandAlone", "true");
        } else {
            ((Hashtable)props).put("isStandAlone", "false");
        }
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Properties: " + props);
        resultInfo.setDeployProperties(props);
        Configuration appConfig = config = dInfo.getConfiguration();
        try {
            config = config.createSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException conex) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0000", new String[]{this.containerInfo.getName(), config.getPath()}, (Throwable)((Object)conex));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error : " + bdExc.getStackTraceString());
            throw bdExc;
        }
        ResourceLoader tempLoader = null;
        ClassLoader classLoader = dInfo.getLoader();
        if (!(classLoader instanceof ResourceLoader)) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        tempLoader = (ResourceLoader)classLoader;
        Hashtable filesMapping = dInfo.getFileMappings();
        boolean realApp = true;
        if (props.getProperty("isStandAlone").equalsIgnoreCase("true")) {
            realApp = false;
            filesMapping.put(archiveFiles[0].getAbsolutePath(), archiveFiles[0].getName());
        }
        String workAppDir = null;
        try {
            workAppDir = this.deployCommunicator.getMyWorkDirectory(appName);
        }
        catch (IOException ioexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0009", appName, (Throwable)ioexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        this.deployAdmin.extractProperties(config, appName, workAppDir, props, false);
        Vector<JCDescriptor> connectors = new Vector<JCDescriptor>();
        Vector<String> connectorNames = new Vector<String>();
        Vector<String> filesForClassloader = new Vector<String>();
        ApplicationInfo appInfo = new ApplicationInfo(appName, realApp);
        this.runtimeAppsInfo.put(appName, appInfo);
        int i2 = 0;
        while (i2 < archiveFiles.length) {
            String absolutePath = archiveFiles[i2].getAbsolutePath();
            String relativePath = (String)filesMapping.get(absolutePath);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", AbsolutePath: " + absolutePath + ", RelativePath: " + relativePath);
            JCDescriptor descr = this.deployAdmin.getConnectorDescriptor(appName, realApp, absolutePath, relativePath, warnings);
            String[] allJars = this.deployAdmin.extractFiles(appName, config, workAppDir, absolutePath, relativePath, warnings, false);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Extract Connector: " + descr.getConnectorJNDIName());
            if (realApp) {
                int j = 0;
                while (j < allJars.length) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", JarFile[" + j + "] for loader : " + allJars[j]);
                    filesForClassloader.add(allJars[j]);
                    ++j;
                }
            }
            connectorNames.add(descr.getConnectorJNDIName());
            resultInfo.addDeployedResource_Type(descr.getConnectorJNDIName(), descr.getConnectionFactoryInterface());
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Type : " + descr.getConnectionFactoryInterface());
            String[] aliases = descr.getAliases();
            int j = 0;
            while (aliases != null && j < aliases.length) {
                String alias = aliases[j];
                connectorNames.add(alias);
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Alias: " + alias);
                resultInfo.addDeployedResource_Type(alias, descr.getConnectionFactoryInterface());
                ++j;
            }
            allJars = this.deployAdmin.extractDrivers(config, descr, workAppDir, relativePath, false);
            if (allJars != null) {
                if (realApp) {
                    int j2 = 0;
                    while (j2 < allJars.length) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", DriverFile[" + j2 + "] for loader : " + allJars[j2]);
                        filesForClassloader.add(allJars[j2]);
                        ++j2;
                    }
                }
                tempLoader.addResource(new JarsResource(allJars));
                appInfo.addFilesForClassLoader(allJars);
            }
            connectors.add(descr);
            ++i2;
        }
        if (realApp) {
            resultInfo.setFilesForClassloader(filesForClassloader.toArray(new String[filesForClassloader.size()]));
        }
        resultInfo.setDeployedComponentNames(connectorNames.toArray(new String[connectorNames.size()]));
        this.loadApplicationFromConfiguration(appInfo, appConfig, props, connectors, 1);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register ApplicationInfo");
        if (!appInfo.isRealApp()) {
            resultInfo.setLoaderName(this.deployAdmin.registerReferenceToConnectorGroup(tempLoader.getName(), appInfo));
            if (connectors.size() > 0) {
                this.deployAdmin.registerReferences(appInfo, (JCDescriptor)connectors.elementAt(0), tempLoader);
            }
        } else {
            resultInfo.setLoaderName(appName);
        }
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set LoaderName: " + resultInfo.getLoaderName());
        int i3 = 0;
        while (i3 < connectors.size()) {
            JCDescriptor descr = (JCDescriptor)connectors.elementAt(i3);
            ManagedConnectionFactory mcf = this.deployAdmin.instantiateMCF(tempLoader, appName, descr);
            this.deployAdmin.registerIdentitySubjects(appName, mcf, descr, config);
            DriverInfo[] drivers = descr.getDrivers();
            if (drivers != null) {
                int j = 0;
                while (j < drivers.length) {
                    this.deployAdmin.instantiateDriver(tempLoader, drivers[j].getDriverClassName());
                    ++j;
                }
            }
            ++i3;
        }
        if (warnings.size() != 0) {
            int i4 = 0;
            while (i4 < warnings.size()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Warning info: " + warnings.elementAt(i4));
                ++i4;
            }
            resultInfo.setWarnings(warnings);
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        return resultInfo;
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        this.rollbackDeploy(applicationName, true);
    }

    public void commitDeploy(String applicationName) throws WarningException {
        this.appsInfo.put(applicationName, this.runtimeAppsInfo.remove(applicationName));
        ConnectorResourceAccessor.location.logT(300, "ContainerImpl.commitDeploy(), Application: \"" + applicationName + "\" finished successfully.");
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        this.rollbackDeploy(applicationName, false);
    }

    private void rollbackDeploy(String applicationName, boolean prepare) throws WarningException {
        String logPrefix = null;
        logPrefix = prepare ? "ContainerImpl.prepareDeploy(), Application: " + applicationName : "ContainerImpl.rollbackDeploy(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        ApplicationInfo appInfo = null;
        appInfo = prepare ? (ApplicationInfo)this.runtimeAppsInfo.get(applicationName) : (ApplicationInfo)this.runtimeAppsInfo.remove(applicationName);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregister ApplicationInfo");
        if (appInfo == null) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", ApplicationInfo void: nothing to clear.");
            return;
        }
        if (!appInfo.isRealApp()) {
            this.deployAdmin.unregisterReferenceToConnectorGroup(appInfo);
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        JCDescriptor customDescr;
        ApplicationDeployInfo resultInfo = new ApplicationDeployInfo();
        Vector warnings = new Vector();
        Vector<File> newArchiveFiles = null;
        String appName = dInfo.getApplicationName();
        boolean isStandAlone = dInfo.isStandAloneArchive();
        boolean realApp = !isStandAlone;
        String logPrefix = "ContainerImpl.makeUpdate(), Application: " + appName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", StandAlone : " + isStandAlone + ", Connectors to update: " + archiveFiles.length);
        int i = 0;
        while (i < archiveFiles.length) {
            String version = this.deployAdmin.getConnectorVersion(appName, archiveFiles[i].getAbsolutePath(), warnings);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", RAR file: " + archiveFiles[i].getAbsolutePath() + " -> Connector Version: " + version);
            if (version.equals("1.0")) {
                if (newArchiveFiles == null) {
                    newArchiveFiles = new Vector<File>();
                }
                newArchiveFiles.add(archiveFiles[i]);
            }
            ++i;
        }
        File[] fileArray = archiveFiles = newArchiveFiles == null ? null : newArchiveFiles.toArray(new File[newArchiveFiles.size()]);
        if (archiveFiles == null) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", ArchiveFiles are void: nothing to update.");
            return null;
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connectors to update: " + archiveFiles.length);
        String workAppDir = null;
        try {
            workAppDir = this.deployCommunicator.getMyWorkDirectory(appName);
        }
        catch (IOException ioExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0009", appName, (Throwable)ioExc);
            if (ConnectorResourceAccessor.location.beLogged(500)) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            }
            throw bdExc;
        }
        Configuration myContainerConfig = dInfo.getConfiguration();
        try {
            myContainerConfig = myContainerConfig.getSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{this.containerInfo.getName(), myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)bdExc));
            throw bdExc;
        }
        Configuration secMetaInfCnfg = null;
        try {
            secMetaInfCnfg = myContainerConfig.getSubConfiguration("SECURE-META-INF");
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{"SECURE-META-INF", myContainerConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)bdExc));
            throw bdExc;
        }
        Properties customProps = new Properties();
        this.deployAdmin.loadProperties(appName, myContainerConfig, customProps);
        boolean customIsStandalone = "true".equalsIgnoreCase(customProps.getProperty("isStandAlone"));
        String customConnectorGroup = customProps.getProperty("connector-group");
        String connectorGroup = props.getProperty("connector-group");
        if (customIsStandalone) {
            if (realApp) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Type of application '" + appName + "' is changed from standalone to standard J2EE application.");
            } else if (customConnectorGroup != null) {
                if (!customConnectorGroup.equals(connectorGroup)) {
                    if (connectorGroup != null) {
                        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector group '" + customConnectorGroup + "' of '" + appName + "' is changed to '" + connectorGroup + "'");
                    } else {
                        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector group '" + customConnectorGroup + "' of '" + appName + "' is not explicitly specified anymore. Thus connector group already dependent from the one described in the connector-j2ee-engine.xml of deployed adapter.");
                    }
                }
            } else if (connectorGroup != null) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector group of '" + appName + "' is already set explicitly to '" + connectorGroup + "'. Thus connector group described in the connector-j2ee-engine.xml of deployed adapter will be ignored.");
            }
        } else if (isStandAlone) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Type of application '" + appName + "' is changed from standard J2EE to standalone application.");
        }
        if (isStandAlone) {
            ((Hashtable)props).put("isStandAlone", "true");
        } else {
            ((Hashtable)props).put("isStandAlone", "false");
        }
        this.deployAdmin.extractProperties(myContainerConfig, appName, workAppDir, props, true);
        resultInfo.setDeployProperties(props);
        Hashtable filesMapping = dInfo.getFileMappings();
        if (isStandAlone) {
            filesMapping.put(archiveFiles[0].getAbsolutePath(), archiveFiles[0].getName());
        }
        HashMap descrsPerRelativePathMap = new HashMap();
        HashMap files = new HashMap();
        this.deployAdmin.getValuesForAllPropertyEntries(appName, "", secMetaInfCnfg, files, true);
        Iterator fileNamesIter = files.keySet().iterator();
        while (fileNamesIter.hasNext()) {
            String fileName = (String)fileNamesIter.next();
            String name = fileName.substring(fileName.lastIndexOf("/") + 1);
            if (!name.endsWith("ra.xml") || name.startsWith("~")) continue;
            ByteArrayInputStream[] is = (ByteArrayInputStream[])files.get(fileName);
            ByteArrayInputStream defaultRaXmlIs = is[0];
            ByteArrayInputStream customRaXmlIs = is[1];
            ByteArrayInputStream foreignCustomRaXmlIs = defaultRaXmlIs;
            String relativePath = fileName.substring(1, fileName.length() - (name.length() + 1));
            String addXmlName = fileName.substring(0, fileName.length() - 6) + "connector-j2ee-engine.xml";
            is = (ByteArrayInputStream[])files.get(addXmlName);
            ByteArrayInputStream defaultAddXmlIs = null;
            ByteArrayInputStream customAddXmlIs = null;
            ByteArrayInputStream foreignCustomAddXmlIs = null;
            if (is != null) {
                defaultAddXmlIs = is[0];
                customAddXmlIs = is[1];
                foreignCustomAddXmlIs = defaultAddXmlIs;
            }
            String prefix = "";
            if (name.length() > 6) {
                prefix = name.substring(0, name.length() - 6 - 1);
            }
            JCDescriptor defaultDescr = null;
            JCDescriptor customDescr2 = null;
            if (customRaXmlIs != null && customAddXmlIs == null) {
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Use null as a connector-j2ee-engine.xml for default descriptor.");
                }
                defaultDescr = this.deployAdmin.getConnectorDescriptor(appName, realApp, relativePath, prefix, defaultRaXmlIs, null, warnings);
            } else {
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Use own connector-j2ee-engine.xml for default descriptor.");
                }
                defaultDescr = this.deployAdmin.getConnectorDescriptor(appName, realApp, relativePath, prefix, defaultRaXmlIs, defaultAddXmlIs, warnings);
            }
            if (customRaXmlIs != null) {
                if (customAddXmlIs == null) {
                    if (ConnectorResourceAccessor.location.beLogged(100)) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Use default connector-j2ee-engine.xml for custom descriptor.");
                    }
                    foreignCustomAddXmlIs.reset();
                    customDescr2 = this.deployAdmin.getConnectorDescriptor(appName, realApp, relativePath, prefix, customRaXmlIs, foreignCustomAddXmlIs, warnings);
                } else {
                    if (ConnectorResourceAccessor.location.beLogged(100)) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Use own connector-j2ee-engine.xml for custom descriptor.");
                    }
                    customDescr2 = this.deployAdmin.getConnectorDescriptor(appName, realApp, relativePath, prefix, customRaXmlIs, customAddXmlIs, warnings);
                }
            } else {
                if (customAddXmlIs != null) {
                    if (ConnectorResourceAccessor.location.beLogged(100)) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Use default ra.xml for custom descriptor.");
                    }
                    foreignCustomRaXmlIs.reset();
                    customDescr2 = this.deployAdmin.getConnectorDescriptor(appName, realApp, relativePath, prefix, foreignCustomRaXmlIs, customAddXmlIs, warnings);
                }
                if (ConnectorResourceAccessor.location.beLogged(100)) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Custom descriptor is not present.");
                }
            }
            Vector<JCDescriptor[]> descrsPerRelativePath = (Vector<JCDescriptor[]>)descrsPerRelativePathMap.get(relativePath);
            if (descrsPerRelativePath == null) {
                descrsPerRelativePath = new Vector<JCDescriptor[]>();
                descrsPerRelativePathMap.put(relativePath, descrsPerRelativePath);
            }
            if (prefix.equals("")) {
                descrsPerRelativePath.add(0, new JCDescriptor[]{defaultDescr, customDescr2});
                continue;
            }
            descrsPerRelativePath.add(new JCDescriptor[]{defaultDescr, customDescr2});
        }
        Vector<JCDescriptor[]> connectorsToUpdate = new Vector<JCDescriptor[]>();
        Vector<Serializable> connectorsToDeploy = new Vector<Serializable>();
        Vector<String> filesForClassloader = new Vector<String>();
        ResourceLoader tempLoader = null;
        try {
            tempLoader = (ResourceLoader)dInfo.getLoader();
        }
        catch (ClassCastException cce) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", dInfo.getLoader().toString()});
            ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)bdExc));
            throw bdExc;
        }
        if (tempLoader == null) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0025", appName);
            ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)bdExc));
            throw bdExc;
        }
        ApplicationInfo appInfo = new ApplicationInfo(appName, realApp);
        this.runtimeAppsInfo.put(appName, appInfo);
        Hashtable<String, JCDescriptor> newPolicyCfgToDescr = new Hashtable<String, JCDescriptor>();
        Hashtable oldPolicyCfgToDescr = new Hashtable();
        int i2 = 0;
        while (i2 < archiveFiles.length) {
            String absolutePath = archiveFiles[i2].getAbsolutePath();
            String relativePath = (String)filesMapping.get(absolutePath);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", AbsolutePath: " + absolutePath + ", RelativePath: " + relativePath);
            JCDescriptor deployDescr = this.deployAdmin.getConnectorDescriptor(appName, realApp, absolutePath, relativePath, warnings);
            String jndiName = deployDescr.getConnectorJNDIName();
            JCDescriptor previousDescr = (JCDescriptor)newPolicyCfgToDescr.get(jndiName);
            if (newPolicyCfgToDescr.get(jndiName) != null) {
                throw new BaseDeploymentException("connector_0078", new String[]{jndiName, previousDescr.getRarName(), relativePath});
            }
            newPolicyCfgToDescr.put(jndiName, deployDescr);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Extract Connector: " + deployDescr.getConnectorJNDIName());
            Vector descrsPerRelativePath = (Vector)descrsPerRelativePathMap.get(relativePath);
            if (descrsPerRelativePath != null) {
                int j = 0;
                while (j < descrsPerRelativePath.size()) {
                    int k;
                    JCDescriptor[] descrs = (JCDescriptor[])descrsPerRelativePath.elementAt(j);
                    JCDescriptor defaultDescr = descrs[0];
                    customDescr = descrs[1];
                    if (j == 0 && (customDescr != null && !customDescr.getConnectorJNDIName().equals(deployDescr.getConnectorJNDIName()) || !defaultDescr.getConnectorJNDIName().equals(deployDescr.getConnectorJNDIName()))) {
                        if (customDescr != null) {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", JNDI name '" + customDescr.getConnectorJNDIName() + "' for relative path '" + relativePath + "' is not the same as the JNDI name '" + deployDescr.getConnectorJNDIName() + "' of deployed one.");
                        } else {
                            ConnectorResourceAccessor.location.logT(300, logPrefix + ", JNDI name '" + defaultDescr.getConnectorJNDIName() + "' for relative path '" + relativePath + "' is not the same as the JNDI name '" + deployDescr.getConnectorJNDIName() + "' of deployed one.");
                        }
                    }
                    descrs = this.deployAdmin.mergeDescriptors(appName, myContainerConfig, defaultDescr, customDescr, deployDescr);
                    String[] allJars = this.deployAdmin.updateConnectorJars(appName, myContainerConfig, workAppDir, realApp, absolutePath, relativePath, warnings);
                    if (realApp) {
                        k = 0;
                        while (k < allJars.length) {
                            ConnectorResourceAccessor.location.logT(100, logPrefix + ", JarFile[" + k + "](" + relativePath + ") for loader : " + allJars[k]);
                            filesForClassloader.add(allJars[k]);
                            ++k;
                        }
                    } else if (allJars.length != 0) {
                        tempLoader.addResource(new JarsResource(allJars));
                        appInfo.addFilesForClassLoader(allJars);
                    }
                    allJars = this.deployAdmin.updateDriverJars(appName, descrs[1], myContainerConfig, workAppDir, relativePath, warnings);
                    if (realApp) {
                        k = 0;
                        while (k < allJars.length) {
                            ConnectorResourceAccessor.location.logT(100, logPrefix + ", DriverFile[" + k + "](" + relativePath + ") for loader : " + allJars[k]);
                            filesForClassloader.add(allJars[k]);
                            ++k;
                        }
                    } else if (allJars.length != 0) {
                        tempLoader.addResource(new JarsResource(allJars));
                        appInfo.addFilesForClassLoader(allJars);
                    }
                    connectorsToUpdate.add(descrs);
                    ++j;
                }
                descrsPerRelativePathMap.remove(relativePath);
            } else {
                connectorsToDeploy.add(archiveFiles[i2]);
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", JNDI name '" + deployDescr.getConnectorJNDIName() + "' for relative path '" + relativePath + "' could not be found, to be updated. Operation deploy will be performed with '" + archiveFiles + "' archive file.");
            }
            ++i2;
        }
        Iterator relativePaths = descrsPerRelativePathMap.entrySet().iterator();
        while (relativePaths.hasNext()) {
            Map.Entry entry = relativePaths.next();
            String relPath = (String)entry.getKey();
            Vector descrsPerRelativePath = (Vector)descrsPerRelativePathMap.get(relPath);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Deleting configuration for relative path '" + relPath + "'.");
            this.deployAdmin.deleteConnectorConfiguration(appName, myContainerConfig, relPath, descrsPerRelativePath, newPolicyCfgToDescr, oldPolicyCfgToDescr);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Configuration for relative path '" + relPath + "' was successfully deleted.");
        }
        int i3 = 0;
        while (i3 < connectorsToDeploy.size()) {
            File archiveFile = (File)connectorsToDeploy.elementAt(i3);
            String absolutePath = archiveFile.getAbsolutePath();
            String relativePath = (String)filesMapping.get(absolutePath);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", AbsolutePath: " + absolutePath + ", RelativePath: " + relativePath);
            JCDescriptor descr = this.deployAdmin.getConnectorDescriptor(appName, realApp, absolutePath, relativePath, warnings);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Extract Connector: " + descr.getConnectorJNDIName());
            connectorsToDeploy.setElementAt(descr, i3);
            String[] allJars = this.deployAdmin.extractFiles(appName, myContainerConfig, workAppDir, absolutePath, relativePath, warnings, true);
            if (realApp) {
                int j = 0;
                while (j < allJars.length) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", JarFile[" + j + "] for loader : " + allJars[j]);
                    filesForClassloader.add(allJars[j]);
                    ++j;
                }
            } else if (allJars.length != 0) {
                tempLoader.addResource(new JarsResource(allJars));
                appInfo.addFilesForClassLoader(allJars);
            }
            allJars = this.deployAdmin.extractDrivers(myContainerConfig, descr, workAppDir, relativePath, false);
            if (realApp) {
                int j = 0;
                while (j < allJars.length) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", DriverFile[" + j + "] for loader : " + allJars[j]);
                    filesForClassloader.add(allJars[j]);
                    ++j;
                }
            } else if (allJars.length != 0) {
                tempLoader.addResource(new JarsResource(allJars));
                appInfo.addFilesForClassLoader(allJars);
            }
            ++i3;
        }
        if (realApp) {
            resultInfo.setFilesForClassloader(filesForClassloader.toArray(new String[filesForClassloader.size()]));
        }
        Vector<JCDescriptor> connectors = new Vector<JCDescriptor>();
        Vector<String> connectorNames = new Vector<String>();
        int i4 = 0;
        while (i4 < connectorsToUpdate.size()) {
            connectors.add(((JCDescriptor[])connectorsToUpdate.elementAt(i4))[1]);
            ++i4;
        }
        int i5 = 0;
        while (i5 < connectorsToDeploy.size()) {
            connectors.add((JCDescriptor)connectorsToDeploy.elementAt(i5));
            ++i5;
        }
        this.loadApplicationFromConfiguration(appInfo, myContainerConfig, props, connectors, 3);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register ApplicationInfo");
        if (isStandAlone) {
            resultInfo.setLoaderName(this.deployAdmin.registerReferenceToConnectorGroup(tempLoader.getName(), appInfo));
            int i6 = 0;
            while (i6 < connectorsToUpdate.size()) {
                this.deployAdmin.registerReferences(appInfo, (JCDescriptor)connectors.elementAt(i6), tempLoader);
                ++i6;
            }
        } else {
            resultInfo.setLoaderName(appName);
        }
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set LoaderName: " + resultInfo.getLoaderName());
        int i7 = 0;
        while (i7 < connectorsToDeploy.size()) {
            JCDescriptor descr = (JCDescriptor)connectorsToDeploy.elementAt(i7);
            ManagedConnectionFactory mcf = this.deployAdmin.instantiateMCF(tempLoader, appName, descr);
            JCDescriptor oldDescr = (JCDescriptor)oldPolicyCfgToDescr.get(descr.getConnectorJNDIName());
            if (oldDescr != null) {
                this.deployAdmin.mergeSecurityConfigurations(appName, oldDescr, descr, mcf, myContainerConfig);
            } else {
                this.deployAdmin.registerIdentitySubjects(appName, mcf, descr, myContainerConfig);
            }
            DriverInfo[] drivers = descr.getDrivers();
            if (drivers != null) {
                int j = 0;
                while (j < drivers.length) {
                    this.deployAdmin.instantiateDriver(tempLoader, drivers[j].getDriverClassName());
                    ++j;
                }
            }
            connectorNames.add(descr.getConnectorJNDIName());
            resultInfo.addDeployedResource_Type(descr.getConnectorJNDIName(), descr.getConnectionFactoryInterface());
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Type : " + descr.getConnectionFactoryInterface());
            String[] aliases = descr.getAliases();
            int j = 0;
            while (aliases != null && j < aliases.length) {
                String alias = aliases[j];
                connectorNames.add(alias);
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Alias: " + alias);
                resultInfo.addDeployedResource_Type(alias, descr.getConnectionFactoryInterface());
                ++j;
            }
            ++i7;
        }
        int i8 = 0;
        while (i8 < connectorsToUpdate.size()) {
            JCDescriptor[] descrs = (JCDescriptor[])connectorsToUpdate.elementAt(i8);
            customDescr = descrs[0];
            JCDescriptor deployDescr = descrs[1];
            ManagedConnectionFactory mcf = this.deployAdmin.instantiateMCF(tempLoader, appName, deployDescr);
            this.deployAdmin.mergeSecurityConfigurations(appName, customDescr, deployDescr, mcf, myContainerConfig);
            DriverInfo[] drivers = deployDescr.getDrivers();
            if (drivers != null) {
                int j = 0;
                while (j < drivers.length) {
                    this.deployAdmin.instantiateDriver(tempLoader, drivers[j].getDriverClassName());
                    ++j;
                }
            }
            connectorNames.add(deployDescr.getConnectorJNDIName());
            resultInfo.addDeployedResource_Type(deployDescr.getConnectorJNDIName(), deployDescr.getConnectionFactoryInterface());
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Type : " + deployDescr.getConnectionFactoryInterface());
            String[] aliases = deployDescr.getAliases();
            int j = 0;
            while (aliases != null && j < aliases.length) {
                String alias = aliases[j];
                connectorNames.add(alias);
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Alias: " + alias);
                resultInfo.addDeployedResource_Type(alias, deployDescr.getConnectionFactoryInterface());
                ++j;
            }
            ++i8;
        }
        resultInfo.setDeployedComponentNames(connectorNames.toArray(new String[connectorNames.size()]));
        if (warnings.size() != 0) {
            int i9 = 0;
            while (i9 < warnings.size()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Warning info: " + warnings.elementAt(i9));
                ++i9;
            }
            resultInfo.setWarnings(warnings);
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        return resultInfo;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
        this.rollbackUpdate(applicationName, null, null, true);
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        this.appsInfo.put(applicationName, this.runtimeAppsInfo.remove(applicationName));
        ConnectorResourceAccessor.location.logT(300, "ContainerImpl.commitUpdate(), Application: \"" + applicationName + "\" finished successfully.");
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        this.rollbackUpdate(applicationName, applicationConfig, props, false);
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props, boolean prepare) throws WarningException {
        String logPrefix = null;
        logPrefix = prepare ? "ContainerImpl.prepareUpdate(), Application: " + applicationName : "ContainerImpl.rollbackUpdate(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        ApplicationInfo appInfo = null;
        appInfo = prepare ? (ApplicationInfo)this.runtimeAppsInfo.get(applicationName) : (ApplicationInfo)this.runtimeAppsInfo.remove(applicationName);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregister ApplicationInfo");
        if (appInfo == null) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", ApplicationInfo void: nothing to clear.");
            return;
        }
        if (!appInfo.isRealApp()) {
            this.deployAdmin.unregisterReferenceToConnectorGroup(appInfo);
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        this.appsInfo.remove(applicationName);
        ConnectorResourceAccessor.location.logT(300, "ContainerImpl.remove(), Application: " + applicationName + " successfully.");
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        String logPrefix = "DeployAdmin.downloadApplicationFiles(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        try {
            appConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{this.containerInfo.getName(), appConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        this.extractFiles(applicationName, appConfig);
        ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
    }

    private void extractFiles(String appName, Configuration appConfig) throws DeploymentException {
        String logPrefix = "DeployAdmin.extractFiles(appName, appConfig), Application: " + appName;
        String workAppDir = null;
        try {
            workAppDir = this.deployCommunicator.getMyWorkDirectory(appName);
        }
        catch (IOException ioexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0009", appName, (Throwable)ioexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        if (!FileUtils.deleteDirectory(new File(workAppDir))) {
            throw new BaseDeploymentException("connector_0088", workAppDir);
        }
        this.extractFilesConditionally(appName, appConfig, "connectors", workAppDir, false);
        this.extractFilesConditionally(appName, appConfig, "drivers", workAppDir, true);
    }

    private void extractFilesConditionally(String appName, Configuration appConfig, String configPath, String workAppDir, boolean checkIfExist) throws DeploymentException {
        String logPrefix = "DeployAdmin.extractFiles(appName, appConfig, allJars, synch), Application: " + appName;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        if (checkIfExist) {
            try {
                if (!appConfig.existsSubConfiguration(configPath)) {
                    return;
                }
            }
            catch (ConfigurationException confExc) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Error: " + confExc.getStackTraceString());
                return;
            }
        }
        try {
            appConfig = appConfig.getSubConfiguration(configPath);
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{"connectors", appConfig.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Hashtable map = new Hashtable();
        try {
            this.deployAdmin.getAllFileEntries(configPath, appConfig, map);
        }
        catch (ConfigurationException cexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0004", appConfig.getPath(), (Throwable)((Object)cexc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Iterator fileNamesIter = map.keySet().iterator();
        while (fileNamesIter.hasNext()) {
            String fileName = (String)fileNamesIter.next();
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", FileEntryName: " + fileName);
            }
            InputStream is = (InputStream)map.get(fileName);
            try {
                File file = new File(workAppDir + File.separatorChar + fileName);
                this.deployAdmin.mkDirs(file, true);
                FileUtils.writeToFile(is, file);
            }
            catch (IOException ioexc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0013", fileName, (Throwable)ioexc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
        }
    }

    public void prepareStart(String applicationName, Configuration config) throws DeploymentException, WarningException {
        String logPrefix = "ContainerImpl.prepareStart(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext(this.contextProps);
        }
        catch (NamingException nexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0006", (Throwable)nexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Configuration appConfig = config;
        try {
            config = config.getSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException confExc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0001", new String[]{this.containerInfo.getName(), config.getPath()}, (Throwable)((Object)confExc));
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Vector warnings = new Vector();
        String workAppDir = null;
        try {
            workAppDir = this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (IOException ioexc) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0009", applicationName, (Throwable)ioexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
            throw bdExc;
        }
        Vector connectors = new Vector();
        Vector allJars = new Vector();
        Properties props = new Properties();
        boolean realApp = this.deployAdmin.extractFiles(config, applicationName, workAppDir, connectors, allJars, props, warnings);
        realApp = this.loadContext.getClassLoader(applicationName) != null;
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Standalone : " + !realApp);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors: " + connectors.size());
        ApplicationInfo appInfo = new ApplicationInfo(applicationName, realApp);
        this.runtimeAppsInfo.put(applicationName, appInfo);
        this.loadApplicationFromConfiguration(appInfo, appConfig, props, connectors, 2);
        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register ApplicationInfo");
        ResourceLoader loader = null;
        if (!realApp) {
            loader = this.deployAdmin.registerConnectorLoader(appInfo, allJars.toArray(new String[allJars.size()]));
        } else {
            ClassLoader classLoader = this.loadContext.getClassLoader(applicationName);
            if (classLoader == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0025", applicationName);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            if (!(classLoader instanceof ResourceLoader)) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            loader = (ResourceLoader)classLoader;
        }
        if (!realApp) {
            int i = 0;
            while (i < connectors.size()) {
                this.deployAdmin.registerReferences(appInfo, (JCDescriptor)connectors.elementAt(i), loader);
                ++i;
            }
        }
        int i = 0;
        while (i < connectors.size()) {
            JCDescriptor descr = (JCDescriptor)connectors.elementAt(i);
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "] = " + descr.getConnectorJNDIName());
            this.deployAdmin.registerConnector(appInfo, rootCtx, descr, loader);
            ++i;
        }
        if (warnings.size() != 0) {
            int i2 = 0;
            while (i2 < warnings.size()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", WarningInfo: " + warnings.elementAt(i2));
                ++i2;
            }
            WarningException wexc = new WarningException();
            wexc.setWarnings(warnings);
            throw wexc;
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public void commitStart(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.commitStart(), Application: " + applicationName;
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        }
        ApplicationInfo runtimeAppInfo = (ApplicationInfo)this.runtimeAppsInfo.remove(applicationName);
        Vector mcfs = runtimeAppInfo.getMCFs();
        JCDescriptor[] descrs = runtimeAppInfo.getJCDescriptors();
        WarningException wExc = null;
        Vector<String> warnings = null;
        int i = 0;
        while (i < mcfs.size()) {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfs.elementAt(i);
            JCDescriptor descr = descrs[i];
            if (mcf instanceof ManagedConnectionFactoryActivation) {
                try {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector: " + descr.getConnectorJNDIName() + ", Starting MCF...");
                    ((ManagedConnectionFactoryActivation)mcf).start();
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector: " + descr.getConnectorJNDIName() + ", MCF was started successfully.");
                }
                catch (Exception raiExc) {
                    BaseWarningException bwExc = new BaseWarningException("connector_0103", (Object[])new String[]{descr.getConnectorJNDIName(), applicationName}, (Throwable)raiExc);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bwExc.getStackTraceString());
                    if (wExc == null) {
                        wExc = new WarningException();
                        warnings = new Vector<String>();
                    }
                    warnings.add(bwExc.getLocalizedMessage());
                }
            }
            ++i;
        }
        this.appsInfo.put(applicationName, runtimeAppInfo);
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        if (wExc != null) {
            wExc.setWarnings(warnings);
            throw wExc;
        }
    }

    public void rollbackStart(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.rollbackStart(), Application: " + applicationName;
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        }
        ApplicationInfo appInfo = (ApplicationInfo)this.runtimeAppsInfo.remove(applicationName);
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregister ApplicationInfo");
        }
        this.clearResources(appInfo);
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        }
    }

    public void prepareStop(String applicationName, Configuration config) throws DeploymentException, WarningException {
        String logPrefix = "ContainerImpl.prepareStop, Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully");
    }

    public void commitStop(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.commitStop(), Application: " + applicationName;
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        }
        if (ConnectorResourceAccessor.location.beLogged(100)) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Unregister ApplicationInfo");
        }
        ApplicationInfo appInfo = (ApplicationInfo)this.appsInfo.remove(applicationName);
        this.clearResources(appInfo);
        Vector mcfs = appInfo.getMCFs();
        JCDescriptor[] descrs = appInfo.getJCDescriptors();
        WarningException wExc = null;
        Vector<String> warnings = null;
        int i = 0;
        while (i < mcfs.size()) {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfs.elementAt(i);
            JCDescriptor descr = descrs[i];
            if (mcf instanceof ManagedConnectionFactoryActivation) {
                try {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector: " + descr.getConnectorJNDIName() + ", Stopping MCF...");
                    ((ManagedConnectionFactoryActivation)mcf).stop();
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector: " + descr.getConnectorJNDIName() + ", MCF was stopped successfully.");
                }
                catch (Exception raiExc) {
                    BaseWarningException bwExc = new BaseWarningException("connector_0104", (Object[])new String[]{descr.getConnectorJNDIName(), applicationName}, (Throwable)raiExc);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bwExc.getStackTraceString());
                    if (wExc == null) {
                        wExc = new WarningException();
                        warnings = new Vector<String>();
                    }
                    warnings.add(bwExc.getLocalizedMessage());
                }
            }
            ++i;
        }
        if (ConnectorResourceAccessor.location.beLogged(300)) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        }
        if (wExc != null) {
            wExc.setWarnings(warnings);
            throw wExc;
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.rollbackStop(), Application: " + applicationName;
        BaseWarningException bwExc = new BaseWarningException("connector_0102", "after prepare stop phase.Please start it again.");
        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bwExc.getStackTraceString());
        throw bwExc;
    }

    private void clearResources(ApplicationInfo appInfo) throws WarningException {
        String logPrefix = null;
        if (appInfo == null) {
            logPrefix = "ContainerImpl.clearResources(), ApplicationInfo: null";
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", ApplicationInfo void: nothing to clear.");
            return;
        }
        logPrefix = "ContainerImpl.clearResources(), Application: " + appInfo.getApplicationName();
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", Standalone: " + !appInfo.isRealApp());
        BaseWarningException bwExc = null;
        InitialContext rootContext = null;
        try {
            rootContext = new InitialContext(this.contextProps);
        }
        catch (NamingException nexc) {
            bwExc = new BaseWarningException("connector_0006", (Throwable)nexc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bwExc.getStackTraceString());
        }
        Vector warnings = new Vector();
        String[][] map = appInfo.getMapping();
        int i = 0;
        while (map != null && i < map.length) {
            try {
                this.deployAdmin.stopFactory(appInfo.getApplicationName(), map[i], warnings);
            }
            catch (Exception stopException) {
                ConnectorResourceAccessor.location.logT(500, "Exception during stop of application  " + appInfo.getApplicationName() + " : " + stopException.toString());
            }
            if (rootContext != null) {
                this.deployAdmin.unbindMCF(appInfo.getApplicationName(), rootContext, map[i][0]);
            }
            ++i;
        }
        if (!appInfo.isRealApp()) {
            try {
                this.deployAdmin.unregisterConnectorLoader(appInfo, warnings);
            }
            catch (DeploymentException dExc) {
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + dExc.getStackTraceString());
            }
        }
        int i2 = 0;
        while (i2 < warnings.size()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", WarningInfo: " + warnings.elementAt(i2));
            ++i2;
        }
        if (bwExc != null) {
            if (warnings.size() != 0) {
                bwExc.setWarnings(warnings);
            }
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", WarningException: " + bwExc.getStackTraceString());
            ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully with warnings.");
            throw bwExc;
        }
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public String[] listElements(String applicationName) {
        return null;
    }

    public String[] listApplications() {
        return null;
    }

    public File[] getClientJar(String applicationName) {
        return new File[0];
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return new ExportInfo[0];
    }

    public void notifyRuntimeChanges(String applicationName, Configuration config) throws WarningException {
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
        String logPrefix = "ContainerImpl.prepareRuntimeChanges(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.commitRuntimeChanges(), Application: " + applicationName;
        ConnectorResourceAccessor.location.logT(300, logPrefix + " started.");
        ApplicationDeployInfo appDeployInfo = this.makeDeployInfo((ApplicationInfo)this.runtimeAppsInfo.remove(applicationName));
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        return appDeployInfo;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
        String logPrefix = "ContainerImpl.rollbackRuntimeChanges(), Application: " + applicationName;
        this.runtimeAppsInfo.remove(applicationName);
        ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        String appName = "connector-" + standaloneFile.getName();
        String logPrefix = "ContainerImpl.getApplicationName(), Application : " + appName + ", File: " + standaloneFile;
        ConnectorResourceAccessor.location.logT(300, logPrefix);
        return appName;
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    public void updateConnectorSP10(String appName, JCDescriptor descriptor) throws RemoteException, ConnectorException {
        String logPrefix = "ContainerImpl.updateConnector(), Application: " + appName;
        ApplicationInfo appInfo = null;
        String connectorName = descriptor.getConnectorJNDIName();
        String prefix = descriptor.getPrefix();
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector : " + connectorName + ", Standalone : " + !descriptor.isRealApplication() + ", Prefix : " + prefix);
        }
        if (!prefix.equals("")) {
            prefix = prefix + "_";
        }
        try {
            Configuration applicationConfig = this.deployCommunicator.startRuntimeChanges(appName);
            Configuration connectorConfig = null;
            try {
                connectorConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0055", new String[]{this.containerInfo.getName(), applicationConfig.getPath()}, (Throwable)((Object)confExc));
            }
            appInfo = (ApplicationInfo)this.getApplicationInfo(appName, 3).clone();
            JCDescriptor[] descrs = appInfo.getJCDescriptors();
            boolean found = false;
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors : " + descrs.length);
            }
            int i = 0;
            while (i < descrs.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "]: " + descrs[i].getConnectorJNDIName());
                }
                if (descrs[i].getConnectorJNDIName().equals(connectorName)) {
                    found = true;
                    descrs[i] = descriptor;
                }
                ++i;
            }
            if (!found) {
                throw new BaseDeploymentException("connector_0080", new String[]{connectorName, appName});
            }
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, descriptor, prefix + "ra.xml", prefix + "connector-j2ee-engine.xml", true, false);
        }
        catch (Exception exc) {
            ConnectorException connExc = new ConnectorException("connector_0082", appName, (Throwable)exc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + connExc.getSystemStackTraceString());
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new ConnectorException("connector_0082", appName, (Throwable)exc);
        }
        this.runtimeAppsInfo.put(appName, appInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished successfully.");
    }

    public void cloneConnectorSP10(String appName, String newName, JCDescriptor descriptor) throws RemoteException, ConnectorException {
        String logPrefix = "ContainerImpl.cloneConnector(), Application: " + appName;
        ApplicationInfo appInfo = null;
        String sourceConnectorName = descriptor.getConnectorJNDIName();
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Standalone: " + descriptor.isRealApplication() + "Old Name : " + sourceConnectorName + ", New Name: " + newName);
        }
        String ch = "";
        if (newName.indexOf("~") != -1) {
            ch = "~";
        }
        if (newName.indexOf("@") != -1) {
            ch = "@";
        }
        if (newName.indexOf("#") != -1) {
            ch = "#";
        }
        if (newName.indexOf("&") != -1) {
            ch = "&";
        }
        if (newName.indexOf("/") != -1) {
            ch = "/";
        }
        if (!ch.equals("")) {
            ConnectorException connExc = new ConnectorException("connector_0083", new String[]{newName, "~, @, #, &, /"});
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + connExc.getSystemStackTraceString());
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            throw connExc;
        }
        try {
            boolean isAppStarted;
            Configuration applicationConfig = this.deployCommunicator.startRuntimeChanges(appName);
            boolean bl = isAppStarted = this.deployCommunicator.getStatus(appName) == 1;
            if (!isAppStarted) {
                throw new BaseDeploymentException("connector_0084", new String[]{newName, appName});
            }
            appInfo = (ApplicationInfo)this.getApplicationInfo(appName, 3).clone();
            JCDescriptor[] descrs = appInfo.getJCDescriptors();
            JCDescriptor sourceDescr = null;
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors : " + descrs.length);
            }
            int i = 0;
            while (i < descrs.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "]: " + descrs[i].getConnectorJNDIName());
                }
                if (newName.equals(descrs[i].getConnectorJNDIName())) {
                    throw new BaseDeploymentException("connector_0086", new String[]{appName, newName});
                }
                if (sourceConnectorName.equals(descrs[i].getConnectorJNDIName())) {
                    sourceDescr = descrs[i];
                }
                ++i;
            }
            if (sourceDescr == null) {
                throw new BaseDeploymentException("connector_0080", new String[]{sourceConnectorName, appName});
            }
            Configuration connectorConfig = null;
            try {
                connectorConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0055", new String[]{this.containerInfo.getName(), applicationConfig.getPath()}, (Throwable)((Object)confExc));
            }
            Vector warnings = new Vector();
            JCDescriptor sourceDefaultDescr = this.deployAdmin.getDefaultConnectorDescriptor(appName, sourceDescr, connectorConfig, warnings);
            descriptor.setDisplayName(newName);
            sourceDefaultDescr.setDisplayName(newName);
            descriptor.setToDefault("display-name", false);
            sourceDefaultDescr.setToDefault("display-name", false);
            descriptor.setConnectorJNDIName(newName);
            sourceDefaultDescr.setConnectorJNDIName(newName);
            descriptor.setToDefault("jndi-name", false);
            sourceDefaultDescr.setToDefault("jndi-name", false);
            descriptor.setPrefix(newName);
            sourceDefaultDescr.setPrefix(newName);
            descriptor.setAliases(null);
            sourceDefaultDescr.setAliases(null);
            appInfo.addJCDescriptor(descriptor);
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, sourceDefaultDescr, newName + "_ra.xml", newName + "_connector-j2ee-engine.xml", false, true);
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, descriptor, newName + "_ra.xml", newName + "_connector-j2ee-engine.xml", true, false);
            if (descriptor.isInternalUserStore()) {
                descriptor.setUserStore(DeployAdmin.fixName(DeployAdmin.makeConnectorName(descriptor)));
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set UserStore: " + descriptor.getUserStore());
                }
            }
            ResourceLoader loader = null;
            String loaderName = null;
            if (!descriptor.isRealApplication()) {
                String groupName = descriptor.getConnectorGroup();
                loaderName = DeployAdmin.makeRealConnectorLoaderName(groupName);
            } else {
                loaderName = appName;
            }
            ClassLoader classLoader = this.loadContext.getClassLoader(loaderName);
            if (classLoader == null) {
                throw new BaseDeploymentException("connector_0025", loaderName);
            }
            if (!(classLoader instanceof ResourceLoader)) {
                throw new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
            }
            loader = (ResourceLoader)classLoader;
            ManagedConnectionFactory mcf = this.deployAdmin.instantiateMCF(loader, appName, descriptor);
            if (descriptor.getAuthenticationType() != null) {
                this.deployAdmin.registerIdentitySubjects(appName, mcf, descriptor, connectorConfig);
            }
        }
        catch (Exception exc) {
            ConnectorException connExc = new ConnectorException("connector_0082", appName, (Throwable)exc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + connExc.getSystemStackTraceString());
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new ConnectorException("connector_0082", appName, (Throwable)exc);
        }
        this.runtimeAppsInfo.put(appName, appInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished successfully.");
    }

    public void removeConnector(String appName, String connectorName) throws RemoteException, ConnectorException {
        String logPrefix = "ContainerImpl.deleteConnector(), Application: " + appName;
        ApplicationInfo appInfo = null;
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector: " + connectorName);
        }
        try {
            Configuration applicationConfig = this.deployCommunicator.startRuntimeChanges(appName);
            appInfo = (ApplicationInfo)this.getApplicationInfo(appName, 3).clone();
            JCDescriptor[] descrs = appInfo.getJCDescriptors();
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors : " + descrs.length);
            }
            ArrayList<JCDescriptor> descrsArray = new ArrayList<JCDescriptor>();
            JCDescriptor connectorToRemove = null;
            int i = 0;
            while (descrs != null && i < descrs.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "]: " + descrs[i].getConnectorJNDIName());
                }
                if (connectorName.equals(descrs[i].getConnectorJNDIName())) {
                    connectorToRemove = descrs[i];
                } else {
                    descrsArray.add(descrs[i]);
                }
                ++i;
            }
            appInfo.setJCDescriptors(descrsArray.toArray(new JCDescriptor[descrsArray.size()]));
            if (connectorToRemove == null) {
                throw new BaseDeploymentException("connector_0080", new String[]{connectorName, appName});
            }
            if (descrs.length == 1) {
                throw new BaseDeploymentException("connector_0081", new String[]{connectorName, appName});
            }
            Configuration connectorConfig = null;
            try {
                connectorConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0055", new String[]{this.containerInfo.getName(), applicationConfig.getPath()}, (Throwable)((Object)confExc));
            }
            this.deployAdmin.deleteConnector(appName, connectorConfig, connectorToRemove, new Hashtable(), new Hashtable());
        }
        catch (Exception exc) {
            ConnectorException connExc = new ConnectorException("connector_0082", appName, (Throwable)exc);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + connExc.getSystemStackTraceString());
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            this.deployCommunicator.rollbackRuntimeChanges(appName);
            throw connExc;
        }
        this.runtimeAppsInfo.put(appName, appInfo);
        this.deployCommunicator.makeRuntimeChanges(appName, true);
        ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished successfully.");
    }

    public void startApplication(String applicationName, boolean global) throws RemoteException {
        if (global) {
            this.deployCommunicator.startApplicationAndWait(applicationName);
        } else {
            this.deployCommunicator.startApplicationLocalAndWait(applicationName);
        }
    }

    public void stopApplication(String applicationName, boolean global) throws RemoteException {
        if (global) {
            this.deployCommunicator.stopApplicationAndWait(applicationName);
        } else {
            this.deployCommunicator.stopApplicationLocalAndWait(applicationName);
        }
    }

    public boolean updateConnector(String appName, JCDescriptor descriptor) {
        String logPrefix = "ContainerImpl.updateConnector(), Application: " + appName;
        ApplicationInfo appInfo = null;
        String connectorName = descriptor.getConnectorJNDIName();
        String prefix = descriptor.getPrefix();
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector : " + connectorName + ", Standalone : " + !descriptor.isRealApplication() + ", Prefix : " + prefix);
        }
        if (!prefix.equals("")) {
            prefix = prefix + "_";
        }
        try {
            boolean isAppStarted;
            Configuration applicationConfig = null;
            try {
                applicationConfig = this.deployCommunicator.startRuntimeChanges(appName);
            }
            catch (DeploymentException dExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)((Object)dExc));
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot Rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                throw bdExc;
            }
            boolean bl = isAppStarted = this.deployCommunicator.getStatus(appName) == 1;
            if (!isAppStarted) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0085", new String[]{descriptor.getConnectorJNDIName(), appName});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            Configuration connectorConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            appInfo = (ApplicationInfo)this.appsInfo.get(appName);
            if (appInfo == null) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + "ApplicationInfo void: application is already removed");
                try {
                    this.deployCommunicator.rollbackRuntimeChanges(appName);
                }
                catch (RemoteException rex) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)rex);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot Rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                }
                if (ConnectorResourceAccessor.location.beInfo()) {
                    ConnectorResourceAccessor.location.logT(300, logPrefix + " finished with errors.");
                }
                return false;
            }
            appInfo = (ApplicationInfo)appInfo.clone();
            JCDescriptor[] descrs = appInfo.getJCDescriptors();
            boolean found = false;
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors : " + descrs.length);
            }
            int i = 0;
            while (i < descrs.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "]: " + descrs[i].getConnectorJNDIName());
                }
                if (descrs[i].getConnectorJNDIName().equals(connectorName)) {
                    found = true;
                    descrs[i] = descriptor;
                }
                ++i;
            }
            if (!found) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", Application is already updated from outside.");
                try {
                    this.deployCommunicator.rollbackRuntimeChanges(appName);
                }
                catch (RemoteException rex) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)rex);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot Rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                }
                if (ConnectorResourceAccessor.location.beInfo()) {
                    ConnectorResourceAccessor.location.logT(300, logPrefix + " finished with errors.");
                }
                return false;
            }
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, descriptor, prefix + "ra.xml", prefix + "connector-j2ee-engine.xml", true, false);
            ResourceLoader loader = null;
            String loaderName = null;
            if (!descriptor.isRealApplication()) {
                String groupName = descriptor.getConnectorGroup();
                loaderName = DeployAdmin.makeRealConnectorLoaderName(groupName);
            } else {
                loaderName = appName;
            }
            ClassLoader classLoader = this.loadContext.getClassLoader(loaderName);
            if (classLoader == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0025", loaderName);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            if (!(classLoader instanceof ResourceLoader)) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            loader = (ResourceLoader)classLoader;
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Loader: " + loader.getInfo());
            }
            this.deployAdmin.instantiateMCF(loader, appName, descriptor);
        }
        catch (Exception exc) {
            if (!(exc instanceof DeploymentException)) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)exc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getSystemStackTraceString());
            }
            try {
                this.deployCommunicator.rollbackRuntimeChanges(appName);
            }
            catch (RemoteException rex) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)rex);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot Rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
            }
            if (ConnectorResourceAccessor.location.beInfo()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + " finished with errors.");
            }
            return false;
        }
        try {
            this.runtimeAppsInfo.put(appName, appInfo);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register RuntimeApplicationInfo.");
            }
            this.deployCommunicator.makeRuntimeChanges(appName, true);
        }
        catch (RemoteException rex) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", connectorName, (Throwable)rex);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot Commit RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
            return false;
        }
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished successfully.");
        }
        return true;
    }

    public boolean cloneConnector(String appName, String newName, JCDescriptor descriptor) {
        String logPrefix = "ContainerImpl.cloneConnector(), Application: " + appName;
        ApplicationInfo appInfo = null;
        String sourceConnectorName = descriptor.getConnectorJNDIName();
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Standalone: " + descriptor.isRealApplication() + "Old Name : " + sourceConnectorName + ", New Name: " + newName);
        }
        String ch = "";
        if (newName.indexOf("~") != -1) {
            ch = "~";
        }
        if (newName.indexOf("@") != -1) {
            ch = "@";
        }
        if (newName.indexOf("#") != -1) {
            ch = "#";
        }
        if (newName.indexOf("&") != -1) {
            ch = "&";
        }
        if (newName.indexOf("/") != -1) {
            ch = "/";
        }
        if (!ch.equals("")) {
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Cannot clone connector, reason :  '" + ch + "'  symbol is not supported in '" + newName + "' name of the cloned resource adapter");
            }
            if (ConnectorResourceAccessor.location.beInfo()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            }
            return false;
        }
        try {
            boolean isAppStarted;
            Configuration applicationConfig = null;
            try {
                applicationConfig = this.deployCommunicator.startRuntimeChanges(appName);
            }
            catch (DeploymentException dExc) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0063", sourceConnectorName, (Throwable)((Object)dExc));
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                throw bdExc;
            }
            Configuration connectorConfig = null;
            try {
                connectorConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0055", new String[]{this.containerInfo.getName(), applicationConfig.getPath()}, (Throwable)((Object)confExc));
            }
            boolean bl = isAppStarted = this.deployCommunicator.getStatus(appName) == 1;
            if (!isAppStarted) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0084", new String[]{newName, appName});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            appInfo = (ApplicationInfo)this.appsInfo.get(appName);
            if (appInfo == null) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + "ApplicationInfo void: application is already removed");
                try {
                    this.deployCommunicator.rollbackRuntimeChanges(appName);
                }
                catch (RemoteException rex) {
                    BaseDeploymentException bdExc = new BaseDeploymentException("connector_0063", sourceConnectorName, (Throwable)rex);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                }
                if (ConnectorResourceAccessor.location.beInfo()) {
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
                }
                return false;
            }
            appInfo = (ApplicationInfo)appInfo.clone();
            JCDescriptor[] descrs = appInfo.getJCDescriptors();
            JCDescriptor sourceDescr = null;
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors : " + descrs.length);
            }
            int i = 0;
            while (i < descrs.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connector[" + i + "]: " + descrs[i].getConnectorJNDIName());
                }
                if (newName.equals(descrs[i].getConnectorJNDIName())) {
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Application is already updated from outside or such jndi name is already specified for a component within the same application.");
                    try {
                        this.deployCommunicator.rollbackRuntimeChanges(appName);
                    }
                    catch (RemoteException rex) {
                        BaseDeploymentException bdExc = new BaseDeploymentException("connector_0063", sourceConnectorName, (Throwable)rex);
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
                    }
                    if (ConnectorResourceAccessor.location.beInfo()) {
                        ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
                    }
                    return false;
                }
                if (sourceConnectorName.equals(descrs[i].getConnectorJNDIName())) {
                    sourceDescr = descrs[i];
                }
                ++i;
            }
            if (sourceDescr == null) {
                throw new BaseDeploymentException("connector_0080", new String[]{sourceConnectorName, appName});
            }
            Vector warnings = new Vector();
            JCDescriptor sourceDefaultDescr = this.deployAdmin.getDefaultConnectorDescriptor(appName, sourceDescr, connectorConfig, warnings);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set DisplayName: " + newName);
            }
            descriptor.setDisplayName(newName);
            sourceDefaultDescr.setDisplayName(newName);
            descriptor.setToDefault("display-name", false);
            sourceDefaultDescr.setToDefault("display-name", false);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set JNDIName: " + newName);
            }
            descriptor.setConnectorJNDIName(newName);
            sourceDefaultDescr.setConnectorJNDIName(newName);
            descriptor.setToDefault("jndi-name", false);
            sourceDefaultDescr.setToDefault("jndi-name", false);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set Prefix: " + newName);
            }
            descriptor.setPrefix(newName);
            sourceDefaultDescr.setPrefix(newName);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set Aliases: null");
            }
            descriptor.setAliases(null);
            sourceDefaultDescr.setAliases(null);
            appInfo.addJCDescriptor(descriptor);
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, sourceDefaultDescr, newName + "_ra.xml", newName + "_connector-j2ee-engine.xml", false, true);
            this.deployAdmin.writeDescriptorIntoSheet(appName, connectorConfig, descriptor, newName + "_ra.xml", newName + "_connector-j2ee-engine.xml", true, false);
            if (descriptor.isInternalUserStore()) {
                descriptor.setUserStore(DeployAdmin.fixName(DeployAdmin.makeConnectorName(descriptor)));
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set UserStore: " + descriptor.getUserStore());
                }
            }
            ResourceLoader loader = null;
            String loaderName = null;
            if (!descriptor.isRealApplication()) {
                String groupName = descriptor.getConnectorGroup();
                loaderName = DeployAdmin.makeRealConnectorLoaderName(groupName);
            } else {
                loaderName = appName;
            }
            ClassLoader classLoader = this.loadContext.getClassLoader(loaderName);
            if (classLoader == null) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0025", loaderName);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            if (!(classLoader instanceof ResourceLoader)) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0024", new String[]{"ResourceLoader", classLoader.toString()});
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getStackTraceString());
                throw bdExc;
            }
            loader = (ResourceLoader)classLoader;
            ManagedConnectionFactory mcf = this.deployAdmin.instantiateMCF(loader, appName, descriptor);
            if (descriptor.getAuthenticationType() != null) {
                this.deployAdmin.registerIdentitySubjects(appName, mcf, descriptor, connectorConfig);
            }
        }
        catch (Exception exc) {
            if (!(exc instanceof DeploymentException)) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0062", sourceConnectorName, (Throwable)exc);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + bdExc.getSystemStackTraceString());
            }
            try {
                this.deployCommunicator.rollbackRuntimeChanges(appName);
            }
            catch (RemoteException rex) {
                BaseDeploymentException bdExc = new BaseDeploymentException("connector_0063", sourceConnectorName, (Throwable)rex);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot rollback RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
            }
            if (ConnectorResourceAccessor.location.beInfo()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            }
            return false;
        }
        try {
            this.runtimeAppsInfo.put(appName, appInfo);
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Register RuntimeApplicationInfo.");
            }
            this.deployCommunicator.makeRuntimeChanges(appName, true);
        }
        catch (RemoteException rex) {
            BaseDeploymentException bdExc = new BaseDeploymentException("connector_0063", sourceConnectorName, (Throwable)rex);
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Cannot commit RuntimeChanges, reason : " + bdExc.getSystemStackTraceString());
            if (ConnectorResourceAccessor.location.beInfo()) {
                ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished with errors.");
            }
            return false;
        }
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", finished successfully.");
        }
        return true;
    }

    public String[][] getStandaloneAdapters() throws NamingException {
        String logPrefix = "ContainerImpl.getStandaloneAdapters()";
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        Vector<String[]> standaloneAdapters = new Vector<String[]>();
        ConcurrentHashMapObjectObject factories = ResourceObjectFactory.getRegisteredFactories();
        Object[] preparedCaches = factories.toArray();
        int i = 0;
        while (i < preparedCaches.length) {
            AdapterCache preparedCache = (AdapterCache)preparedCaches[i];
            boolean isStandAlone = preparedCache.isStandAlone();
            if (isStandAlone) {
                String connectorName = preparedCache.getAdapterName();
                String connFactoryInterface = preparedCache.getConnectionFactoryInterface();
                standaloneAdapters.add(new String[]{connFactoryInterface, connectorName});
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Adapter: " + connectorName + ", Type: " + connFactoryInterface);
                }
                String[] aliases = ResourceObjectFactory.getAliases(connectorName);
                int k = 0;
                while (aliases != null && k < aliases.length) {
                    String alias = aliases[k];
                    standaloneAdapters.add(new String[]{connFactoryInterface, alias});
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Adapter: " + connectorName + ", Alias: " + alias);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
        return (String[][])standaloneAdapters.toArray((T[])new String[standaloneAdapters.size()][]);
    }

    public String[][] getAdaptersBelongToApplication() throws NamingException {
        String logPrefix = "ContainerImpl.getAdaptersBelongToApplication()";
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        Vector<String[]> adaptersBelongToApplication = new Vector<String[]>();
        ConcurrentHashMapObjectObject factories = ResourceObjectFactory.getRegisteredFactories();
        Object[] preparedCaches = factories.toArray();
        int i = 0;
        while (i < preparedCaches.length) {
            AdapterCache preparedCache = (AdapterCache)preparedCaches[i];
            boolean isStandAlone = preparedCache.isStandAlone();
            if (!isStandAlone) {
                String appName = preparedCache.getAppName();
                String connectorName = preparedCache.getAdapterName();
                String connFactoryInterface = preparedCache.getConnectionFactoryInterface();
                adaptersBelongToApplication.add(new String[]{appName, connFactoryInterface, connectorName});
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", AppName: " + appName + " Adapter: " + connectorName + ", Type: " + connFactoryInterface);
                }
                String[] aliases = ResourceObjectFactory.getAliases(connectorName);
                int k = 0;
                while (aliases != null && k < aliases.length) {
                    String alias = aliases[k];
                    adaptersBelongToApplication.add(new String[]{appName, connFactoryInterface, alias});
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", Adapter: " + connectorName + ", Alias: " + alias);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
        return (String[][])adaptersBelongToApplication.toArray((T[])new String[adaptersBelongToApplication.size()][]);
    }

    public String[][] getOpenedConnectionsCount(String raName) throws ResourceException {
        String logPrefix = "ContainerImpl.getOpenedConnectionsCount(), RAName: " + raName;
        String realRaName = ResourceObjectFactory.getRealName(raName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Real Name: " + realRaName);
        }
        ConnectionHashSet mcSet = ResourceObjectFactory.getConnectionSet(realRaName);
        HashMapObjectIntPositive givenConnectionsAppInfo = mcSet.getGivenConnectionsAppInfo();
        String[][] result = null;
        ConnectionHashSet connectionHashSet = mcSet;
        synchronized (connectionHashSet) {
            result = new String[givenConnectionsAppInfo.size()][2];
            Enumeration keys = givenConnectionsAppInfo.keys();
            int i = 0;
            while (keys.hasMoreElements()) {
                String appName;
                result[i][0] = appName = (String)keys.nextElement();
                result[i][1] = String.valueOf(givenConnectionsAppInfo.get(appName));
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Application: " + appName + ", Opened MCs: " + result[i][1]);
                }
                ++i;
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
        return result;
    }

    public int getMaximumConnectionsNumber(String raName) throws ResourceException {
        String logPrefix = "ContainerImpl.getMaximumConnectionsNumber(), RAName: " + raName;
        String realRaName = ResourceObjectFactory.getRealName(raName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Real Name: " + realRaName);
        }
        int maxConns = ResourceObjectFactory.getConnectionSet(realRaName).getMaxConnectionsNumber();
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully: " + maxConns);
        }
        return maxConns;
    }

    public int getFreeManagedConnectionsNumber(String raName) throws ResourceException {
        String logPrefix = "ContainerImpl.getFreeManagedConnectionsNumber(), RAName: " + raName;
        String realRaName = ResourceObjectFactory.getRealName(raName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Real Name: " + realRaName);
        }
        int freeConns = ResourceObjectFactory.getConnectionSet(realRaName).size();
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully: " + freeConns);
        }
        return freeConns;
    }

    public int getUsedManagedConnectionsNumber(String raName) throws ResourceException {
        String logPrefix = "ContainerImpl.getUsedManagedConnectionsNumber(), RAName: " + raName;
        String realRaName = ResourceObjectFactory.getRealName(raName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Real Name: " + realRaName);
        }
        int usedConns = ResourceObjectFactory.getConnectionSet(realRaName).getGivenConnections().size();
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully: " + usedConns);
        }
        return usedConns;
    }

    public int getWaitingForConnectionsNumber(String raName) throws ResourceException {
        String logPrefix = "ContainerImpl.getWaitingForConnectionsNumber(), RAName: " + raName;
        String realRaName = ResourceObjectFactory.getRealName(raName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Real Name: " + realRaName);
        }
        int waitingForConns = ResourceObjectFactory.getConnectionSet(realRaName).getHangingConnections();
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully: " + waitingForConns);
        }
        return waitingForConns;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public boolean getDebugMode(String connFactory) throws RemoteException, ResourceException {
        ConnectionHashSet connSet = ResourceObjectFactory.getConnectionSet(connFactory);
        return connSet.debugMode();
    }

    public void switchDebugMode(String connFactory, boolean debug) throws RemoteException, ResourceException {
        String logPrefix = "ContainerImpl.switchDebugMode(), ConnectionFactory: " + connFactory + ", Debug: " + debug;
        ConnectorResourceAccessor.location.logT(100, logPrefix);
        ConnectionHashSet connSet = ResourceObjectFactory.getConnectionSet(connFactory);
        connSet.switchDebugMode(debug);
    }

    public String[] getUsedConnectionsInfo(String connFactory, boolean traceMode) throws ResourceException {
        ConnectionHashSet connSet = ResourceObjectFactory.getConnectionSet(connFactory);
        String[] result = new String[]{};
        ConnectionHashSet connectionHashSet = connSet;
        synchronized (connectionHashSet) {
            HashSet givenConnectionsSet = connSet.getGivenConnections();
            HashSet givenConnectionsInfo = connSet.getGivenConnectionsInfo();
            result = new String[givenConnectionsSet.size()];
            ManagedConnection[] usedMConns = ((AbstractCollection)givenConnectionsSet).toArray(new ManagedConnection[givenConnectionsSet.size()]);
            MCEventHandler[] mcHandlers = ((AbstractCollection)givenConnectionsInfo).toArray(new MCEventHandler[givenConnectionsInfo.size()]);
            int i = 0;
            while (i < usedMConns.length) {
                ManagedConnection usedMConn = usedMConns[i];
                int j = 0;
                while (j < mcHandlers.length) {
                    if (usedMConn.equals(mcHandlers[j].getManagedConnection())) {
                        result[i] = mcHandlers[j].getInfo(traceMode);
                        break;
                    }
                    ++j;
                }
                if (result[i] == null) {
                    result[i] = "ManagedConnection: " + usedMConn.toString() + " \n" + "   not observed, because it is acquired while debug mode was disabled";
                }
                ++i;
            }
        }
        return result;
    }

    public String[] getFreeConnectionsInfo(String connFactory) throws ResourceException {
        ConnectionHashSet connSet = ResourceObjectFactory.getConnectionSet(connFactory);
        String[] result = new String[]{};
        ConnectionHashSet connectionHashSet = connSet;
        synchronized (connectionHashSet) {
            ManagedConnection[] mConns = ((AbstractCollection)connSet).toArray(new ManagedConnection[connSet.size()]);
            result = new String[mConns.length];
            int i = 0;
            while (i < mConns.length) {
                result[i] = mConns[i].toString();
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void convertPreviouslyDeployedAdapters() {
        appNames = this.deployCommunicator.getMyApplications();
        appsForConvert = new Vector<String>();
        i = 0;
        while (i < appNames.length) {
            block88: {
                appName = appNames[i];
                appConfig = null;
                try {
                    metaInfConfig = null;
                    try {
                        appConfig = this.configurationHandler.openConfiguration(this.deployCommunicator.getAppConfigPath(appName), 0);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0001", new String[]{this.deployCommunicator.getAppConfigPath(appName), "/"}, (Throwable)confExc);
                    }
                    try {
                        metaInfConfig = appConfig.getSubConfiguration(this.containerInfo.getName() + "/" + "META-INF");
                    }
                    catch (ConfigurationException confExc) {
                        ConnectorResourceAccessor.location.logT(300, new BaseDeploymentException("connector_0001", new String[]{this.containerInfo.getName() + "/" + "META-INF", appConfig.getPath()}, (Throwable)confExc).getLocalizedMessage());
                        var11_17 = null;
                        if (appConfig != null) {
                            try {
                                appConfig.close();
                            }
                            catch (Exception confExc) {
                                ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                            }
                        }
                        break block88;
                    }
                    map = new Hashtable<K, V>();
                    try {
                        this.deployAdmin.getAllFileEntries("", metaInfConfig, map);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0004", metaInfConfig.getPath(), (Throwable)confExc);
                    }
                    fileNamesIter = map.keySet().iterator();
                    while (fileNamesIter.hasNext()) {
                        fileName = (String)fileNamesIter.next();
                        if (!fileName.substring(fileName.lastIndexOf("/") + 1).equals("ra.xml")) continue;
                        appsForConvert.add(appName);
                        break;
                    }
                    var11_17 = null;
                    ** if (appConfig == null) goto lbl-1000
                }
                catch (Throwable var10_23) {
                    var11_17 = null;
                    if (appConfig != null) {
                        try {
                            appConfig.close();
                        }
                        catch (Exception confExc) {
                            ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                        }
                    }
                    throw var10_23;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        appConfig.close();
                    }
                    catch (Exception confExc) {
                        ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block88;
                    catch (Exception exc) {
                        if (exc instanceof BaseDeploymentException) {
                            ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)exc);
                        } else {
                            bdExc = new BaseDeploymentException("connector_0050", appName, (Throwable)exc);
                            ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)bdExc);
                        }
                        var11_17 = null;
                        if (appConfig != null) {
                            try {
                                appConfig.close();
                            }
                            catch (Exception confExc) {
                                ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        workAppDir = null;
        i = 0;
        while (i < appsForConvert.size()) {
            block90: {
                block93: {
                    appName = (String)appsForConvert.elementAt(i);
                    connectorName = null;
                    appConfig = null;
                    this.deployCommunicator.startModification(appName);
                    try {
                        workAppDir = this.deployCommunicator.getMyWorkDirectory(appName);
                    }
                    catch (IOException ioexc) {
                        throw new BaseDeploymentException("connector_0009", appName, (Throwable)ioexc);
                    }
                    metaInfConfig = null;
                    secureMetaInfConfig = null;
                    try {
                        appConfig = this.configurationHandler.openConfiguration(this.deployCommunicator.getAppConfigPath(appName), 1);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0001", new String[]{this.deployCommunicator.getAppConfigPath(appName), "/"}, (Throwable)confExc);
                    }
                    try {
                        metaInfConfig = appConfig.getSubConfiguration(this.containerInfo.getName() + "/" + "META-INF");
                    }
                    catch (ConfigurationException confExc) {
                        bdExc = new BaseDeploymentException("connector_0001", new String[]{this.containerInfo.getName() + "/" + "META-INF", appConfig.getPath()}, (Throwable)confExc);
                        ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)bdExc);
                        var31_51 = null;
                        if (appConfig != null) {
                            try {
                                appConfig.close();
                            }
                            catch (Exception confExc) {
                                ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                            }
                        }
                        this.deployCommunicator.modificationDone(appName);
                        break block90;
                    }
                    try {
                        secureMetaInfConfig = this.deployAdmin.createConfiguration(appConfig, this.containerInfo.getName() + "/" + "SECURE-META-INF", 1);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0000", new String[]{this.containerInfo.getName() + "/" + "SECURE-META-INF", appConfig.getPath()}, (Throwable)confExc);
                    }
                    map = new Hashtable<K, V>();
                    try {
                        this.deployAdmin.getAllFileEntries("", metaInfConfig, map);
                    }
                    catch (ConfigurationException confExc) {
                        throw new BaseDeploymentException("connector_0004", metaInfConfig.getPath(), (Throwable)confExc);
                    }
                    fileNamesIter = map.keySet().iterator();
                    while (fileNamesIter.hasNext()) {
                        fileName = (String)fileNamesIter.next();
                        if (fileName.substring(fileName.lastIndexOf("/") + 1).equals("ra.xml")) {
                            block91: {
                                connectorName = fileName.substring(1, fileName.length() - 7);
                                propertySheet = null;
                                propertyName = null;
                                raXmlIs = (InputStream)map.get(fileName);
                                addXmlName = fileName.substring(0, fileName.length() - 6) + "connector-j2ee-engine.xml";
                                addXmlIs = (InputStream)map.get(addXmlName);
                                try {
                                    secureMetaInfConfig = this.deployAdmin.createConfiguration(secureMetaInfConfig, connectorName, 1);
                                }
                                catch (ConfigurationException confExc) {
                                    throw new BaseDeploymentException("connector_0000", new String[]{connectorName, secureMetaInfConfig.getPath()}, (Throwable)confExc);
                                }
                                try {
                                    propertySheet = secureMetaInfConfig.getPropertySheetInterface();
                                }
                                catch (ConfigurationException confExc) {
                                    throw new BaseDeploymentException("connector_0073", secureMetaInfConfig.getPath(), (Throwable)confExc);
                                }
                                try {
                                    baos = new ByteArrayOutputStream();
                                    b = new byte[1024];
                                    count = -1;
                                    try {
                                        while ((count = raXmlIs.read(b)) != -1) {
                                            baos.write(b, 0, count);
                                        }
                                        baos.flush();
                                        var23_45 = null;
                                    }
                                    catch (Throwable var22_42) {
                                        var23_45 = null;
                                        try {
                                            baos.close();
                                            var25_48 = null;
                                        }
                                        catch (Throwable var24_54) {
                                            var25_48 = null;
                                            raXmlIs.close();
                                            throw var24_54;
                                        }
                                        raXmlIs.close();
                                        throw var22_42;
                                    }
                                    try {
                                        baos.close();
                                        var25_48 = null;
                                    }
                                    catch (Throwable var24_53) {
                                        var25_48 = null;
                                        raXmlIs.close();
                                        throw var24_53;
                                    }
                                    raXmlIs.close();
                                    b = baos.toByteArray();
                                    propertyName = "ra.xml";
                                    try {
                                        propertySheet.createSecurePropertyEntry(propertyName, new String(b), propertyName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        throw new BaseDeploymentException("connector_0056", new String[]{propertyName, secureMetaInfConfig.getPath()}, (Throwable)confExc);
                                    }
                                    parentForXmlsConfig = null;
                                    try {
                                        parentForXmlsConfig = metaInfConfig.getSubConfiguration(connectorName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        throw new BaseDeploymentException("connector_0055", new String[]{connectorName, metaInfConfig.getPath()}, (Throwable)confExc);
                                    }
                                    try {
                                        parentForXmlsConfig.deleteFile(propertyName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        throw new BaseDeploymentException("connector_0058", new String[]{propertyName, parentForXmlsConfig.getPath()}, (Throwable)confExc);
                                    }
                                    metaInfFileName = this.deployAdmin.makeMetaInfDir(workAppDir) + fileName.replace('/', File.separatorChar);
                                    new File(metaInfFileName).delete();
                                    if (addXmlIs == null) break block91;
                                    baos = new ByteArrayOutputStream();
                                    b = new byte[1024];
                                    try {
                                        while ((count = addXmlIs.read(b)) != -1) {
                                            baos.write(b, 0, count);
                                        }
                                        baos.flush();
                                        var27_49 = null;
                                    }
                                    catch (Throwable var26_59) {
                                        var27_49 = null;
                                        try {
                                            baos.close();
                                            var29_50 = null;
                                        }
                                        catch (Throwable var28_58) {
                                            var29_50 = null;
                                            addXmlIs.close();
                                            throw var28_58;
                                        }
                                        addXmlIs.close();
                                        new File(metaInfFileName.substring(0, metaInfFileName.lastIndexOf("/") + 1) + propertyName).delete();
                                        throw var26_59;
                                    }
                                    try {
                                        baos.close();
                                        var29_50 = null;
                                    }
                                    catch (Throwable var28_57) {
                                        var29_50 = null;
                                        addXmlIs.close();
                                        throw var28_57;
                                    }
                                    addXmlIs.close();
                                    {
                                    }
                                    new File(metaInfFileName.substring(0, metaInfFileName.lastIndexOf("/") + 1) + propertyName).delete();
                                    b = baos.toByteArray();
                                    propertyName = "connector-j2ee-engine.xml";
                                    try {
                                        propertySheet.createSecurePropertyEntry(propertyName, new String(b), propertyName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        throw new BaseDeploymentException("connector_0056", new String[]{propertyName, secureMetaInfConfig.getPath()}, (Throwable)confExc);
                                    }
                                    try {
                                        parentForXmlsConfig.deleteFile(propertyName);
                                    }
                                    catch (ConfigurationException confExc) {
                                        throw new BaseDeploymentException("connector_0058", new String[]{propertyName, parentForXmlsConfig.getPath()}, (Throwable)confExc);
                                    }
                                }
                                catch (IOException ioexc) {
                                    throw new BaseDeploymentException("connector_0013", propertyName, (Throwable)ioexc);
                                }
                            }
                            metaInfDir = new File(this.deployAdmin.makeConnectorsDir(workAppDir) + File.separatorChar + connectorName + File.separatorChar + "META-INF");
                            metaInfDirFiles = metaInfDir.listFiles();
                            j = 0;
                            while (metaInfDirFiles != null && j < metaInfDirFiles.length) {
                                metaInfDirFile = metaInfDirFiles[j];
                                metaInfDirFile.delete();
                                ++j;
                            }
                            metaInfDir = new File(this.deployAdmin.makeMetaInfDir(workAppDir) + File.separatorChar + connectorName);
                            metaInfDirFiles = metaInfDir.listFiles();
                            j = 0;
                            while (metaInfDirFiles != null && j < metaInfDirFiles.length) {
                                metaInfDirFile = metaInfDirFiles[j];
                                metaInfDirFile.delete();
                                ++j;
                            }
                            connectorsConfig = null;
                            try {
                                connectorsConfig = appConfig.getSubConfiguration(this.containerInfo.getName() + "/" + "connectors" + "/" + connectorName + "/" + "META-INF");
                            }
                            catch (ConfigurationException confExc) {
                                throw new BaseDeploymentException("connector_0055", new String[]{this.containerInfo.getName() + "/" + "connectors" + "/" + connectorName + "/" + "META-INF", appConfig.getPath()}, (Throwable)confExc);
                            }
                            try {
                                connectorsConfig.deleteAllFiles();
                                continue;
                            }
                            catch (ConfigurationException confExc) {
                                throw new BaseDeploymentException("connector_0059", this.containerInfo.getName() + "/" + "connectors" + "/" + connectorName + "/" + "META-INF", (Throwable)confExc);
                            }
                        }
                        if (fileName.substring(fileName.lastIndexOf("/") + 1).equals("connector-j2ee-engine.xml")) continue;
                        index = fileName.lastIndexOf("/");
                        parentForXmlsConfig = null;
                        try {
                            parentForXmlsConfig = metaInfConfig.getSubConfiguration(fileName.substring(1, index));
                        }
                        catch (ConfigurationException confExc) {
                            throw new BaseDeploymentException("connector_0055", new String[]{fileName.substring(1, index), metaInfConfig.getPath()}, (Throwable)confExc);
                        }
                        try {
                            parentForXmlsConfig.deleteFile(fileName.substring(index + 1));
                        }
                        catch (ConfigurationException confExc) {
                            throw new BaseDeploymentException("connector_0058", new String[]{fileName.substring(index + 1), parentForXmlsConfig.getPath()}, (Throwable)confExc);
                        }
                    }
                    this.configurationHandler.commit();
                    var31_51 = null;
                    if (appConfig == null) break block93;
                    try {
                        appConfig.close();
                    }
                    catch (Exception confExc) {
                        ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                    }
                }
                this.deployCommunicator.modificationDone(appName);
                {
                    break block90;
                    catch (Exception exc) {
                        try {
                            this.configurationHandler.rollback();
                        }
                        catch (ConfigurationException confExc) {
                            ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                        }
                        bdExc = null;
                        bdExc = connectorName == null ? new BaseDeploymentException("connector_0051", appName, (Throwable)exc) : new BaseDeploymentException("connector_0053", new String[]{connectorName, appName}, (Throwable)exc);
                        ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)bdExc);
                        var31_51 = null;
                        if (appConfig != null) {
                            try {
                                appConfig.close();
                            }
                            catch (Exception confExc) {
                                ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                            }
                        }
                        this.deployCommunicator.modificationDone(appName);
                    }
                }
                catch (Throwable var30_62) {
                    var31_51 = null;
                    if (appConfig != null) {
                        try {
                            appConfig.close();
                        }
                        catch (Exception confExc) {
                            ConnectorResourceAccessor.location.traceThrowableT(500, "", (Throwable)confExc);
                        }
                    }
                    this.deployCommunicator.modificationDone(appName);
                    throw var30_62;
                }
            }
            ++i;
        }
    }

    private ApplicationInfo loadApplicationFromConfiguration(ApplicationInfo appInfo, Configuration appConfig, Properties props, Vector connectors, int phaseType) {
        boolean realApp;
        String appName = appInfo.getApplicationName();
        String logPrefix = "ContainerImpl.loadApplicationFromConfiguration(), Application: " + appName;
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + ", Props: " + props + ", Connectors: " + connectors.size() + ", Phase: " + phaseType);
        }
        boolean isStandAlone = !(realApp = appInfo.isRealApp());
        String connectorGroupProp = props.getProperty("connector-group");
        String connectorGroupDeploy = null;
        if (isStandAlone && phaseType != 1 && phaseType != 3) {
            try {
                connectorGroupDeploy = (String)appConfig.getConfigEntry("STR:Loader");
                connectorGroupDeploy = connectorGroupDeploy.substring("connector:".length());
                if (phaseType != 2 && connectorGroupProp != null && !connectorGroupDeploy.equals(connectorGroupProp)) {
                    ConnectorResourceAccessor.location.logT(300, logPrefix + ", Connector group '" + connectorGroupProp + "' specified in the application properties differentiate from connector group '" + connectorGroupDeploy + "' described at deploy or update phase. Thus application could be started unproperly.");
                }
            }
            catch (Exception exc) {
                ConnectorResourceAccessor.location.traceThrowableT(300, logPrefix, (Throwable)exc);
            }
        }
        int i = 0;
        while (i < connectors.size()) {
            JCDescriptor descr = (JCDescriptor)connectors.elementAt(i);
            String connectorGroupDescr = descr.getConnectorGroup();
            if (isStandAlone) {
                if (connectorGroupProp != null) {
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", ConnectorGroupProp: " + connectorGroupProp);
                    }
                    if (phaseType != 2 && !descr.isSetToDefault("connector-group") && !connectorGroupProp.equals(connectorGroupDescr)) {
                        ConnectorResourceAccessor.location.logT(300, logPrefix + ", For application '" + appName + "' connector group '" + connectorGroupProp + "' is explicitly set in deployment properties. Thus connector group '" + connectorGroupDescr + "' from connector-j2ee-engine.xml will be ignored.");
                    }
                    descr.setConnectorGroup(connectorGroupProp);
                    appInfo.setConnectorGroup(connectorGroupProp);
                } else {
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        ConnectorResourceAccessor.location.logT(100, logPrefix + ", ConnectorGroupDescr: " + connectorGroupDescr);
                    }
                    if (phaseType == 2 && connectorGroupDeploy != null && !connectorGroupDeploy.equals(connectorGroupDescr)) {
                        ConnectorResourceAccessor.location.logT(300, "For application '" + appName + "' connector group '" + connectorGroupDescr + "' differentiate from connector group '" + connectorGroupDeploy + "' described at deploy or update phase. Thus application could be started unproperly.");
                    }
                    descr.setConnectorGroup(connectorGroupDescr);
                    appInfo.setConnectorGroup(connectorGroupDescr);
                }
            }
            appInfo.addJCDescriptor(descr);
            ++i;
        }
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        }
        appInfo.setProperties(props);
        return appInfo;
    }

    private ApplicationDeployInfo makeDeployInfo(ApplicationInfo appInfo) {
        String logPrefix = "ContainerImpl.makeDeployInfo(), Application: " + appInfo.getApplicationName();
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix);
        }
        Properties props = appInfo.getProperties();
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        ArrayList<String> components = new ArrayList<String>();
        JCDescriptor[] descrs = appInfo.getJCDescriptors();
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Connectors: " + descrs.length);
        }
        int i = 0;
        while (i < descrs.length) {
            components.add(descrs[i].getConnectorJNDIName());
            result.addDeployedResource_Type(descrs[i].getConnectorJNDIName(), descrs[i].getConnectionFactoryInterface());
            if (ConnectorResourceAccessor.location.beDebug()) {
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Type : " + descrs[i].getConnectionFactoryInterface());
            }
            String[] aliases = descrs[i].getAliases();
            int j = 0;
            while (aliases != null && j < aliases.length) {
                components.add(aliases[j]);
                result.addDeployedResource_Type(aliases[j], descrs[i].getConnectionFactoryInterface());
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", Registering Alias : " + aliases[j]);
                }
                ++j;
            }
            ++i;
        }
        result.setDeployedComponentNames(components.toArray(new String[components.size()]));
        if (!appInfo.isRealApp()) {
            result.setLoaderName(DeployAdmin.makeRealConnectorLoaderName(appInfo.getConnectorGroup()));
        } else {
            result.setFilesForClassloader(appInfo.getFilesForClassLoader());
            result.setLoaderName(appInfo.getApplicationName());
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set LoaderName: " + result.getLoaderName());
        }
        result.setDeployProperties(props);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Set Properties: " + props);
        }
        if (ConnectorResourceAccessor.location.beInfo()) {
            ConnectorResourceAccessor.location.logT(300, logPrefix + " finished successfully.");
        }
        return result;
    }
}

