/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.connector.jca.ConnectorPrivilegedAction;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.jca.deploy.DeployAdmin;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.connector.resource.impl.HandleWrapper;
import com.sap.engine.services.connector.resource.impl.MCEventHandler;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ConnectionManagerImpl
implements ConnectionManager,
LazyAssociatableConnectionManager,
Serializable {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$resource$impl$HandleWrapper == null ? (class$com$sap$engine$services$connector$resource$impl$HandleWrapper = ConnectionManagerImpl.class$("com.sap.engine.services.connector.resource.impl.HandleWrapper")) : class$com$sap$engine$services$connector$resource$impl$HandleWrapper));
    private static int severityDebug = 100;
    private static int severityWarning = 400;
    private ConnectionHashSet mcSet;
    private boolean sharing_scope;
    private boolean authorization;
    private boolean isClosed = false;
    private int tr_support;
    String mcfName;
    String fixedMcfName;
    private SecurityContext securityContext;
    private UserStoreFactory usf;
    private int securityContextObjectID;
    static /* synthetic */ Class class$com$sap$engine$services$connector$resource$impl$HandleWrapper;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public ConnectionManagerImpl(String mcfName, boolean sharing_scope, boolean authorization, int tr_support, ConnectionHashSet mcSet) {
        this.mcfName = mcfName;
        this.fixedMcfName = DeployAdmin.fixName(mcfName);
        this.sharing_scope = sharing_scope;
        this.authorization = authorization;
        this.tr_support = tr_support;
        this.mcSet = mcSet;
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this.toString() + ".<constructor>(mcfName: " + mcfName + ", shScope: " + sharing_scope + ", auth: " + authorization + ", trSupport: " + tr_support + ")");
        }
    }

    public void setSecurityContext(SecurityContext security_context) {
        this.securityContext = security_context;
        if (this.securityContext != null) {
            this.usf = this.securityContext.getUserStoreContext();
            this.securityContextObjectID = ConnectorServiceFrame.threadSystem.getContextObjectId("security");
        } else {
            this.usf = null;
            this.securityContextObjectID = -1;
        }
    }

    public boolean getSharingScope() {
        return this.sharing_scope;
    }

    public boolean getAuthorization() {
        return this.authorization;
    }

    public int getTransactionSupport() {
        return this.tr_support;
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cRequestInfo) throws ResourceException {
        HandleWrapper handleWrapper;
        Subject subject;
        boolean returnMConn;
        String compName;
        String appName;
        ResourceSet resourceSetInterface;
        block32: {
            if (location.beLogged(severityDebug)) {
                location.logT(100, ">>> " + this.toString() + ".allocateConnection(mcf: " + mcf + ", reqInfo: " + cRequestInfo + ")");
            }
            if (this.isClosed) {
                BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionManager", this.mcfName});
                brExc.log();
                throw brExc;
            }
            ThreadContext tc = ConnectorServiceFrame.threadSystem.getThreadContext();
            resourceSetInterface = null;
            appName = null;
            compName = null;
            returnMConn = false;
            if (tc == null) {
                returnMConn = true;
                if (location.beLogged(severityDebug)) {
                    location.logT(100, ">>> " + this.toString() + ".allocateConnection(), ThCtx: null.");
                }
            } else {
                resourceSetInterface = ResourceSetContextObject.getCurrentResourceSet();
                if (resourceSetInterface == null) {
                    returnMConn = true;
                    if (location.beLogged(severityDebug)) {
                        location.logT(100, ">>> " + this.toString() + ".allocateConnection(), ResSet: null.");
                    }
                } else {
                    if (this.tr_support == 0) {
                        returnMConn = true;
                    }
                    appName = resourceSetInterface.getApplicationName();
                    compName = resourceSetInterface.getComponentName();
                }
            }
            subject = null;
            if (this.authorization) {
                try {
                    String userName = ((SecurityContextObject)((Object)ConnectorServiceFrame.threadSystem.getThreadContext().getContextObject(this.securityContextObjectID))).getSession().getPrincipal().getName();
                    if (location.beLogged(severityDebug)) {
                        location.logT(100, ">>> " + this.toString() + ".allocateConnection(). Caller Principal: " + userName);
                    }
                    UserContext activeUserContext = this.usf.getActiveUserStore().getUserContext();
                    UserInfo info = activeUserContext.getUserInfo(userName);
                    SecurityContext mySecurityContext = null;
                    try {
                        mySecurityContext = this.securityContext.getPolicyConfigurationContext(this.fixedMcfName);
                    }
                    catch (NullPointerException npExc) {
                        throw new BaseResourceException("connector_0030", new String[]{"security", "security service"});
                    }
                    AuthenticationContext myAuthCtx = mySecurityContext.getAuthenticationContext();
                    subject = new Subject();
                    ConnectorPrivilegedAction action = new ConnectorPrivilegedAction(activeUserContext, myAuthCtx, info, subject);
                    AccessController.doPrivileged(action);
                    if (location.beLogged(severityDebug)) {
                        Iterator credsIter = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = ConnectionManagerImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator();
                        while (credsIter.hasNext()) {
                            PasswordCredential pc = (PasswordCredential)credsIter.next();
                            ManagedConnectionFactory pcMCF = pc.getManagedConnectionFactory();
                            String resPrnplName = pc.getUserName();
                            location.logT(100, ">>> " + this.toString() + ".allocateConnection(). Resource Principal Subject: " + resPrnplName + ", " + pcMCF + "(" + mcf.equals((Object)pcMCF) + ")");
                        }
                    }
                }
                catch (Exception secExc) {
                    BaseResourceException brExc = appName != null ? new BaseResourceException("connector_0508", new String[]{this.mcfName, compName, appName}, (Throwable)secExc) : new BaseResourceException("connector_0508", new String[]{this.mcfName, "system", "system"}, (Throwable)secExc);
                    if (!location.beLogged(severityDebug)) break block32;
                    location.traceThrowableT(severityDebug, "", (Throwable)((Object)brExc));
                }
            }
        }
        ManagedConnection mConnection = null;
        if (returnMConn) {
            mConnection = this.mcSet.match(appName, subject, cRequestInfo);
            MCEventHandler mcEventHandler = new MCEventHandler(this.mcSet, mConnection, mcf, subject, cRequestInfo, this.tr_support, this.sharing_scope, mConnection instanceof DissociatableManagedConnection);
            mcEventHandler.setUsageFrom(compName, appName);
            mConnection.addConnectionEventListener((ConnectionEventListener)mcEventHandler);
            HandleWrapper handleWrapper2 = mcEventHandler.createConnectionHandle(subject, cRequestInfo);
            if (location.beLogged(severityDebug)) {
                if (resourceSetInterface != null) {
                    location.logT(100, ">>> " + this.toString() + ".allocateConnection(): " + handleWrapper2 + " -> won't be added to " + resourceSetInterface);
                } else {
                    location.logT(100, ">>> " + this.toString() + ".allocateConnection(): " + handleWrapper2 + " -> won't be added to any ResSet due to request is made from the system");
                }
            }
            return handleWrapper2.getHandle();
        }
        ResourceSetImpl resourceSet = null;
        try {
            resourceSet = (ResourceSetImpl)resourceSetInterface;
        }
        catch (ClassCastException cce) {
            BaseResourceException brExc = null;
            brExc = appName != null ? new BaseResourceException("connector_0505", new String[]{compName, appName}, (Throwable)cce) : new BaseResourceException("connector_0505", new String[]{"system", "system"}, (Throwable)cce);
            location.traceThrowableT(500, "", (Throwable)((Object)brExc));
            throw brExc;
        }
        MCEventHandler mcEventHandler = null;
        if (this.sharing_scope) {
            mcEventHandler = resourceSet.getSharedEventHandler(mcf, subject, cRequestInfo, this.tr_support);
        }
        if (mcEventHandler != null) {
            handleWrapper = mcEventHandler.createConnectionHandle(subject, cRequestInfo);
            resourceSet.addWithoutEnlist(handleWrapper);
            if (location.beLogged(severityDebug)) {
                location.logT(100, "--> ConnectionManagerImpl.allocateConnection(): " + handleWrapper + " -> to Shared ManagedConnection.");
            }
            return handleWrapper.getHandle();
        }
        if (this.tr_support == 1) {
            resourceSet.checkEnlist();
        }
        mConnection = this.mcSet.match(appName, subject, cRequestInfo);
        mcEventHandler = new MCEventHandler(this.mcSet, mConnection, mcf, subject, cRequestInfo, this.tr_support, this.sharing_scope, mConnection instanceof DissociatableManagedConnection);
        mcEventHandler.setUsageFrom(compName, appName);
        mConnection.addConnectionEventListener((ConnectionEventListener)mcEventHandler);
        handleWrapper = mcEventHandler.createConnectionHandle(subject, cRequestInfo);
        try {
            resourceSet.addAndEnlist(handleWrapper);
        }
        catch (Exception exc) {
            BaseResourceException brExc = new BaseResourceException("connector_0510", handleWrapper.toString(), (Throwable)exc);
            try {
                location.traceThrowableT(500, "", (Throwable)((Object)brExc));
                mConnection.removeConnectionEventListener((ConnectionEventListener)mcEventHandler);
                Object var20_24 = null;
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                this.mcSet.destroy(appName, mConnection, true);
                throw throwable;
            }
            this.mcSet.destroy(appName, mConnection, true);
            throw brExc;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> ConnectionManagerImpl.allocateConnection(): " + handleWrapper + " -> to new UnShared ManagedConnection.");
        }
        return handleWrapper.getHandle();
    }

    public void associateConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cxReqInfo) throws ResourceException {
        HandleWrapper handleWrapper;
        ManagedConnection mConnection;
        Subject subject;
        boolean returnMConn;
        String compName;
        String appName;
        ResourceSet resourceSetInterface;
        block32: {
            if (location.beLogged(severityDebug)) {
                location.logT(100, "--> ConnectionManagerImpl.associateConnection(" + connection + ", " + mcf + ", " + cxReqInfo + ") authorization is " + this.authorization);
            }
            if (this.isClosed) {
                BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionManager", this.mcfName});
                brExc.log();
                throw brExc;
            }
            ThreadContext tc = ConnectorServiceFrame.threadSystem.getThreadContext();
            resourceSetInterface = null;
            appName = null;
            compName = null;
            returnMConn = false;
            if (tc == null) {
                returnMConn = true;
                if (location.beLogged(severityDebug)) {
                    location.logT(100, ">>> " + this.toString() + ".associateConnection(), ThCtx: null.");
                }
            } else {
                resourceSetInterface = ResourceSetContextObject.getCurrentResourceSet();
                if (resourceSetInterface == null) {
                    returnMConn = true;
                    if (location.beLogged(severityDebug)) {
                        location.logT(100, ">>> " + this.toString() + ".associateConnection(), ResSet: null.");
                    }
                } else {
                    if (this.tr_support == 0) {
                        returnMConn = true;
                    }
                    appName = resourceSetInterface.getApplicationName();
                    compName = resourceSetInterface.getComponentName();
                }
            }
            subject = null;
            if (this.authorization) {
                try {
                    String userName = ((SecurityContextObject)((Object)ConnectorServiceFrame.threadSystem.getThreadContext().getContextObject(this.securityContextObjectID))).getSession().getPrincipal().getName();
                    UserContext activeUserContext = this.usf.getActiveUserStore().getUserContext();
                    UserInfo info = activeUserContext.getUserInfo(userName);
                    SecurityContext mySecurityContext = null;
                    try {
                        mySecurityContext = this.securityContext.getPolicyConfigurationContext(this.fixedMcfName);
                    }
                    catch (NullPointerException npExc) {
                        throw new BaseResourceException("connector_0030", new String[]{"security", "security service"});
                    }
                    AuthenticationContext myAuthCtx = mySecurityContext.getAuthenticationContext();
                    subject = new Subject();
                    ConnectorPrivilegedAction action = new ConnectorPrivilegedAction(activeUserContext, myAuthCtx, info, subject);
                    AccessController.doPrivileged(action);
                    if (location.beLogged(severityDebug)) {
                        Iterator credsIter = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = ConnectionManagerImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator();
                        while (credsIter.hasNext()) {
                            PasswordCredential pc = (PasswordCredential)credsIter.next();
                            ManagedConnectionFactory pcMCF = pc.getManagedConnectionFactory();
                            String resPrnplName = pc.getUserName();
                            location.logT(100, ">>> " + this.toString() + ".associateConnection(). Resource Principal Subject: " + resPrnplName + ", " + pcMCF + "(" + mcf.equals((Object)pcMCF) + ")");
                        }
                    }
                }
                catch (Exception secExc) {
                    BaseResourceException brExc = appName != null ? new BaseResourceException("connector_0508", new String[]{this.mcfName, compName, appName}, (Throwable)secExc) : new BaseResourceException("connector_0508", new String[]{this.mcfName, "system", "system"}, (Throwable)secExc);
                    if (!location.beLogged(severityDebug)) break block32;
                    location.traceThrowableT(severityDebug, "", (Throwable)((Object)brExc));
                }
            }
        }
        if (returnMConn) {
            mConnection = this.mcSet.match(appName, subject, cxReqInfo);
            MCEventHandler mcEventHandler = new MCEventHandler(this.mcSet, mConnection, mcf, subject, cxReqInfo, this.tr_support, this.sharing_scope, mConnection instanceof DissociatableManagedConnection);
            mcEventHandler.setUsageFrom(compName, appName);
            mConnection.addConnectionEventListener((ConnectionEventListener)mcEventHandler);
            handleWrapper = mcEventHandler.associateConnectionHandle(connection);
            if (location.beLogged(severityDebug)) {
                if (resourceSetInterface != null) {
                    location.logT(100, "--> ConnectionManagerImpl.associateConnection(): " + handleWrapper + " -> won't be added to " + resourceSetInterface);
                } else {
                    location.logT(100, "--> ConnectionManagerImpl.associateConnection(): " + handleWrapper + " -> is not added to any ResourceSet due to fisrt request was made from the system");
                }
            }
            return;
        }
        ResourceSetImpl resourceSet = null;
        try {
            resourceSet = (ResourceSetImpl)resourceSetInterface;
        }
        catch (ClassCastException cce) {
            BaseResourceException brExc = null;
            brExc = appName != null ? new BaseResourceException("connector_0505", new String[]{compName, appName}, (Throwable)cce) : new BaseResourceException("connector_0505", new String[]{"system", "system"}, (Throwable)cce);
            location.traceThrowableT(500, "", (Throwable)((Object)brExc));
            throw brExc;
        }
        MCEventHandler mcEventHandler = null;
        if (this.sharing_scope) {
            mcEventHandler = resourceSet.getSharedEventHandler(mcf, subject, cxReqInfo, this.tr_support);
        }
        if (mcEventHandler != null) {
            handleWrapper = mcEventHandler.associateConnectionHandle(connection);
            if (location.beLogged(severityDebug)) {
                location.logT(100, "--> ConnectionManagerImpl.associateConnection(): " + handleWrapper + " -> to Shared ManagedConnection.");
            }
        } else {
            if (this.tr_support == 1) {
                resourceSet.checkEnlist();
            }
            mConnection = this.mcSet.match(appName, subject, cxReqInfo);
            mcEventHandler = new MCEventHandler(this.mcSet, mConnection, mcf, subject, cxReqInfo, this.tr_support, this.sharing_scope, mConnection instanceof DissociatableManagedConnection);
            mcEventHandler.setUsageFrom(compName, appName);
            mConnection.addConnectionEventListener((ConnectionEventListener)mcEventHandler);
            handleWrapper = mcEventHandler.associateConnectionHandle(connection);
            if (location.beLogged(severityDebug)) {
                location.logT(100, "--> ConnectionManagerImpl.associateConnection(): " + handleWrapper + " -> to UnShared ManagedConnection.");
            }
            try {
                resourceSet.addAndEnlist(handleWrapper);
            }
            catch (Exception exc) {
                BaseResourceException brExc = new BaseResourceException("connector_0509", handleWrapper, (Throwable)exc);
                try {
                    location.traceThrowableT(500, "", (Throwable)((Object)brExc));
                    mConnection.removeConnectionEventListener((ConnectionEventListener)mcEventHandler);
                    Object var21_25 = null;
                }
                catch (Throwable throwable) {
                    Object var21_26 = null;
                    this.mcSet.destroy(appName, mConnection, true);
                    throw throwable;
                }
                this.mcSet.destroy(appName, mConnection, true);
                throw brExc;
            }
        }
    }

    public void close() {
        ConnectorServiceFrame.logInfo("Close ConnectionManager of '" + this.mcfName + "' resource adapter.");
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

