/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca;

import com.sap.engine.lib.util.ConcurrentHashMapObjectLong;
import com.sap.engine.lib.util.HashMapObjectIntPositive;
import com.sap.engine.services.connector.ConnectorServiceFrame;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.exceptions.BaseUnsupportedOperationException;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import com.sap.engine.services.connector.resource.impl.MCEventHandler;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class ConnectionHashSet
extends HashSet {
    private boolean isClosed = true;
    private int max = 0;
    private long timeout;
    private int hangingConnections = 0;
    HashSet givenConnections;
    HashSet givenConnectionsInfo;
    HashMapObjectIntPositive givenConnectionsAppInfo;
    String adapterName;
    boolean debugMode = false;
    public static final int RESOURCE_REFERENCE_NO_TRANSACTION = 0;
    public static final int RESOURCE_REFERENCE_LOCAL_TRANSACTION = 1;
    public static final int RESOURCE_REFERENCE_XA_TRANSACTION = 2;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$jca$ConnectionHashSet == null ? (class$com$sap$engine$services$connector$jca$ConnectionHashSet = ConnectionHashSet.class$("com.sap.engine.services.connector.jca.ConnectionHashSet")) : class$com$sap$engine$services$connector$jca$ConnectionHashSet));
    Object locker = null;
    ManagedConnectionFactory mcf;
    ConcurrentHashMapObjectLong expire = null;
    ConnectionSetCleaner cleaner = null;
    int expireTimeout = 0;
    public static final String SYSTEM = "system";
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca$ConnectionHashSet;

    public ConnectionHashSet(MCFWrapper wrapper) throws ResourceException {
        this.adapterName = wrapper.getAdapterName();
        int maxConn = wrapper.getMaxConn() >= 0 ? wrapper.getMaxConn() : 100;
        int initConn = wrapper.getInitConn() <= maxConn ? wrapper.getInitConn() : 0;
        int maxTimeToWaitForConn = wrapper.getTimeToWaitConn() >= 0 ? wrapper.getTimeToWaitConn() : 60;
        int expireTimeoutInSecs = wrapper.getConnLifetime();
        int cleanupThreadCycleTime = wrapper.getRunCleanupThread();
        this.expire = new ConcurrentHashMapObjectLong();
        this.expireTimeout = expireTimeoutInSecs * 1000;
        this.init(wrapper.getManagedConnectionFactory(), initConn, maxConn, maxTimeToWaitForConn);
        if (expireTimeoutInSecs > 0 && cleanupThreadCycleTime > 0) {
            this.cleaner = new ConnectionSetCleaner(cleanupThreadCycleTime, this);
            this.cleaner.setName("ConnectionSetCleaner Thread (UNMANAGED).");
            this.cleaner.start();
        } else {
            this.expire = null;
        }
    }

    private void init(ManagedConnectionFactory mcf, int initConn, int max, int timeout) throws ResourceException {
        this.mcf = mcf;
        this.isClosed = false;
        this.max = max;
        this.timeout = timeout * 1000;
        this.hangingConnections = 0;
        this.givenConnections = new HashSet();
        this.givenConnectionsInfo = new HashSet();
        this.givenConnectionsAppInfo = new HashMapObjectIntPositive();
        this.locker = new Object();
        try {
            int i = 0;
            while (i < initConn) {
                ManagedConnection worker = mcf.createManagedConnection(null, null);
                super.add(worker);
                this.setExpire(worker);
                ++i;
            }
        }
        catch (Exception resExc) {
            this.clear();
            ConnectorServiceFrame.logException(resExc);
            if (resExc instanceof ResourceException) {
                throw (ResourceException)resExc;
            }
            throw new ResourceException(Log.getStackTrace(resExc));
        }
    }

    public ManagedConnection match(String appName, Subject subject, ConnectionRequestInfo rInfo) throws ResourceException {
        ConnectionHashSet connectionHashSet;
        if (this.isClosed) {
            BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
            brExc.log();
            throw brExc;
        }
        ManagedConnection matched = null;
        ManagedConnection deadVictim = null;
        boolean willWait = false;
        try {
            ConnectionHashSet connectionHashSet2 = this;
            synchronized (connectionHashSet2) {
                if (this.size() != 0) {
                    matched = this.mcf.matchManagedConnections((Set)this, subject, rInfo);
                }
                if (matched != null) {
                    super.remove(matched);
                    this.givenConnections.add(matched);
                    this.unsetExpire(matched);
                    this.addManagedConnectionUsage(appName);
                    ManagedConnection managedConnection = matched;
                    return managedConnection;
                }
                if (this.size() + this.givenConnections.size() + this.hangingConnections >= this.max) {
                    if (this.size() == 0) {
                        willWait = true;
                    } else {
                        Iterator iter = super.iterator();
                        deadVictim = (ManagedConnection)iter.next();
                        super.remove(deadVictim);
                        this.unsetExpire(deadVictim);
                        ++this.hangingConnections;
                    }
                } else {
                    ++this.hangingConnections;
                }
            }
        }
        catch (Exception resExc) {
            ConnectorServiceFrame.logException(resExc);
            if (resExc instanceof ResourceException) {
                throw (ResourceException)resExc;
            }
            throw new ResourceException(Log.getStackTrace(resExc));
        }
        if (willWait) {
            Object object;
            long timer = System.currentTimeMillis();
            while (System.currentTimeMillis() - timer < this.timeout) {
                object = this.locker;
                synchronized (object) {
                    try {
                        this.locker.wait(this.timeout);
                    }
                    catch (InterruptedException e) {
                        ConnectorServiceFrame.logException(e);
                    }
                }
                ConnectionHashSet e = this;
                synchronized (e) {
                    block57: {
                        if (this.size() > 0) {
                            try {
                                matched = this.mcf.matchManagedConnections((Set)this, subject, rInfo);
                                if (matched != null) {
                                    super.remove(matched);
                                    this.givenConnections.add(matched);
                                    this.unsetExpire(matched);
                                    this.addManagedConnectionUsage(appName);
                                    ManagedConnection managedConnection = matched;
                                    return managedConnection;
                                }
                                break block57;
                            }
                            catch (Exception resExc) {
                                ConnectorServiceFrame.logException(resExc);
                                if (resExc instanceof ResourceException) {
                                    throw (ResourceException)resExc;
                                }
                                throw new ResourceException(Log.getStackTrace(resExc));
                            }
                        }
                        if (this.isClosed) {
                            BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
                            brExc.log();
                            throw brExc;
                        }
                    }
                }
            }
            object = this;
            synchronized (object) {
                Object brExc;
                if (this.size() == 0) {
                    if (this.size() + this.givenConnections.size() + this.hangingConnections >= this.max) {
                        brExc = null;
                        brExc = this.beDebugMode() ? new BaseResourceException("connector_0519", new String[]{String.valueOf(this.timeout / 1000L), this.adapterName, this.getUsedConnectionsInfo()}) : new BaseResourceException("connector_0506", new String[]{String.valueOf(this.timeout / 1000L), this.adapterName});
                        brExc.log();
                        throw brExc;
                    }
                    if (this.isClosed) {
                        brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
                        brExc.log();
                        throw brExc;
                    }
                    ++this.hangingConnections;
                } else {
                    try {
                        matched = this.mcf.matchManagedConnections((Set)this, subject, rInfo);
                        if (matched != null) {
                            super.remove(matched);
                            this.givenConnections.add(matched);
                            this.unsetExpire(matched);
                            this.addManagedConnectionUsage(appName);
                            brExc = matched;
                            return brExc;
                        }
                        Iterator iter = super.iterator();
                        deadVictim = (ManagedConnection)iter.next();
                        super.remove(deadVictim);
                        this.unsetExpire(deadVictim);
                        ++this.hangingConnections;
                    }
                    catch (Exception resExc) {
                        ConnectorServiceFrame.logException(resExc);
                        if (resExc instanceof ResourceException) {
                            throw (ResourceException)resExc;
                        }
                        throw new ResourceException(Log.getStackTrace(resExc));
                    }
                }
            }
        }
        try {
            if (deadVictim != null) {
                try {
                    deadVictim.destroy();
                }
                catch (Exception e) {
                    ConnectorServiceFrame.logException(e);
                }
            }
            matched = this.mcf.createManagedConnection(subject, rInfo);
            Object var15_25 = null;
            connectionHashSet = this;
        }
        catch (Throwable throwable) {
            Object var15_26 = null;
            ConnectionHashSet connectionHashSet3 = this;
            synchronized (connectionHashSet3) {
                --this.hangingConnections;
                if (matched != null) {
                    if (!this.isClosed) {
                        this.givenConnections.add(matched);
                        this.addManagedConnectionUsage(appName);
                    } else {
                        BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
                        brExc.log();
                        this.destroyConnection(matched);
                        throw brExc;
                    }
                }
            }
            throw throwable;
        }
        synchronized (connectionHashSet) {
            --this.hangingConnections;
            if (matched != null) {
                if (!this.isClosed) {
                    this.givenConnections.add(matched);
                    this.addManagedConnectionUsage(appName);
                } else {
                    BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
                    brExc.log();
                    this.destroyConnection(matched);
                    throw brExc;
                }
            }
        }
        return matched;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(String appName, ManagedConnection mConnection, boolean forceDestroy) throws ResourceException {
        ConnectionHashSet connectionHashSet;
        if (this.isClosed) {
            BaseResourceException brExc = new BaseResourceException("connector_0501", new String[]{"ConnectionHashSet", this.adapterName});
            brExc.log();
            throw brExc;
        }
        Exception re = null;
        try {
            mConnection.cleanup();
        }
        catch (Exception e) {
            ConnectorServiceFrame.logException(e);
            re = e;
            try {
                mConnection.destroy();
            }
            catch (Exception e1) {
                ConnectorServiceFrame.logException(e1);
                re = e1;
            }
        }
        ConnectionHashSet connectionHashSet2 = this;
        synchronized (connectionHashSet2) {
            this.givenConnections.remove(mConnection);
            this.removeManagedConnectionUsage(appName);
            if (re != null) return;
            if (!forceDestroy) {
                super.add(mConnection);
                this.setExpire(mConnection);
                Object e1 = this.locker;
                synchronized (e1) {
                    this.locker.notify();
                    return;
                }
            }
            ++this.hangingConnections;
        }
        try {
            try {
                mConnection.destroy();
            }
            catch (Exception e) {
                ConnectorServiceFrame.logException(e);
                Object var10_12 = null;
                ConnectionHashSet connectionHashSet3 = this;
                synchronized (connectionHashSet3) {
                    --this.hangingConnections;
                    return;
                }
            }
            Object var10_11 = null;
            connectionHashSet = this;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            ConnectionHashSet connectionHashSet4 = this;
            synchronized (connectionHashSet4) {
                --this.hangingConnections;
                throw throwable;
            }
        }
        synchronized (connectionHashSet) {
            --this.hangingConnections;
            return;
        }
    }

    public synchronized void clear() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.cleaner != null) {
            this.cleaner.stopThread();
        }
        this.destroyConnections(super.toArray());
        this.destroyConnections(((AbstractCollection)this.givenConnections).toArray());
        this.givenConnectionsAppInfo.clear();
        this.givenConnectionsInfo.clear();
    }

    private void destroyConnections(Object[] mConnections) {
        int i = 0;
        while (i < mConnections.length) {
            try {
                ManagedConnection victim = (ManagedConnection)mConnections[i];
                victim.destroy();
            }
            catch (Exception e) {
                ConnectorServiceFrame.logException(e);
            }
            ++i;
        }
    }

    private void destroyConnection(ManagedConnection mConnection) {
        try {
            mConnection.destroy();
        }
        catch (Exception e) {
            ConnectorServiceFrame.logException(e);
        }
    }

    private void addManagedConnectionUsage(String appName) {
        int count;
        if (appName == null) {
            appName = SYSTEM;
        }
        if ((count = this.givenConnectionsAppInfo.get(appName)) != -1) {
            this.givenConnectionsAppInfo.put(appName, ++count);
        } else {
            this.givenConnectionsAppInfo.put(appName, 1);
        }
    }

    private void removeManagedConnectionUsage(String appName) {
        int count;
        if (appName == null) {
            appName = SYSTEM;
        }
        if ((count = this.givenConnectionsAppInfo.get(appName)) == -1) {
            if (location.beLogged(100)) {
                location.logT(100, "Application '" + appName + "' is not registered for use, to be removed.");
            }
            return;
        }
        if (--count == 0) {
            this.givenConnectionsAppInfo.remove(appName);
            return;
        }
        this.givenConnectionsAppInfo.put(appName, count);
    }

    public HashMapObjectIntPositive getGivenConnectionsAppInfo() {
        return this.givenConnectionsAppInfo;
    }

    public boolean remove(Object o) throws UnsupportedOperationException {
        throw new BaseUnsupportedOperationException("connector_0700");
    }

    public boolean add(Object o) throws UnsupportedOperationException {
        throw new BaseUnsupportedOperationException("connector_0700");
    }

    public HashSet getGivenConnections() {
        return this.givenConnections;
    }

    public int getHangingConnections() {
        return this.hangingConnections;
    }

    public int getMaxConnectionsNumber() {
        return this.max;
    }

    private synchronized void cleanup() {
        Iterator iter = this.iterator();
        long currentTimer = System.currentTimeMillis();
        while (iter.hasNext()) {
            Object possibleVictim = iter.next();
            if (this.expire.get(possibleVictim) >= currentTimer) continue;
            iter.remove();
            this.expire.remove(possibleVictim);
            this.destroyConnection((ManagedConnection)possibleVictim);
        }
    }

    public void destroyUsedConnection(String mcID) throws ResourceException {
        ManagedConnection mc = null;
        MCEventHandler mcEventHandler = null;
        ConnectionHashSet connectionHashSet = this;
        synchronized (connectionHashSet) {
            mc = this.internalFind(mcID, this.givenConnections);
            this.givenConnections.remove(mc);
            Iterator iter = this.givenConnectionsInfo.iterator();
            while (iter.hasNext()) {
                mcEventHandler = (MCEventHandler)iter.next();
                mc = mcEventHandler.getManagedConnection();
                if (!mcID.equals(mc.toString())) continue;
                this.givenConnectionsInfo.remove(mcEventHandler);
                return;
            }
            mc.destroy();
        }
    }

    public void destroyFreeConnection(String mcID) throws ResourceException {
        block11: {
            ConnectionHashSet connectionHashSet;
            ManagedConnection mc = null;
            try {
                ConnectionHashSet connectionHashSet2 = this;
                synchronized (connectionHashSet2) {
                    mc = this.internalFind(mcID, this);
                    super.remove(mc);
                    this.unsetExpire(mc);
                    ++this.hangingConnections;
                }
                mc.destroy();
                Object var6_5 = null;
                if (mc == null) break block11;
                connectionHashSet = this;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (mc != null) {
                    ConnectionHashSet connectionHashSet3 = this;
                    synchronized (connectionHashSet3) {
                        --this.hangingConnections;
                    }
                }
                throw throwable;
            }
            synchronized (connectionHashSet) {
                --this.hangingConnections;
            }
        }
    }

    public void releaseUsedConnection(String mcID) throws ResourceException {
        ManagedConnection mc = null;
        ConnectionHashSet connectionHashSet = this;
        synchronized (connectionHashSet) {
            mc = this.internalFind(mcID, this.givenConnections);
            mc.cleanup();
        }
    }

    private ManagedConnection internalFind(String mcID, HashSet source) throws ResourceException {
        ManagedConnection givenMC = null;
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            givenMC = (ManagedConnection)iter.next();
            if (!mcID.equals(givenMC.toString())) continue;
            return givenMC;
        }
        throw new ResourceException("Unknown connection with ID [" + mcID + "].");
    }

    private void setExpire(Object obj) {
        if (this.expire != null) {
            this.expire.put(obj, (long)this.expireTimeout + System.currentTimeMillis());
        }
    }

    private void unsetExpire(Object obj) {
        if (this.expire != null) {
            this.expire.remove(obj);
        }
    }

    public void switchDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean beDebugMode() {
        return this.debugMode || location.beDebug();
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public void addManagedConnectionInfo(MCEventHandler mConnInfo) {
        ConnectionHashSet connectionHashSet = this;
        synchronized (connectionHashSet) {
            this.givenConnectionsInfo.add(mConnInfo);
        }
    }

    public void removeManagedConnectionInfo(MCEventHandler mConnInfo) {
        ConnectionHashSet connectionHashSet = this;
        synchronized (connectionHashSet) {
            this.givenConnectionsInfo.remove(mConnInfo);
        }
    }

    public HashSet getGivenConnectionsInfo() {
        return this.givenConnectionsInfo;
    }

    private String getUsedConnectionsInfo() {
        String usedConnsInfo = "\n";
        String[] result = new String[this.givenConnections.size()];
        ManagedConnection[] usedMConns = ((AbstractCollection)this.givenConnections).toArray(new ManagedConnection[this.givenConnections.size()]);
        MCEventHandler[] mcHandlers = ((AbstractCollection)this.givenConnectionsInfo).toArray(new MCEventHandler[this.givenConnectionsInfo.size()]);
        int i = 0;
        while (i < usedMConns.length) {
            ManagedConnection usedMConn = usedMConns[i];
            int j = 0;
            while (j < mcHandlers.length) {
                if (usedMConn.equals(mcHandlers[j].getManagedConnection())) {
                    result[i] = mcHandlers[j].getInfo(true);
                    break;
                }
                ++j;
            }
            usedConnsInfo = result[i] == null ? usedConnsInfo + "\n" + "ManagedConnection : " + usedMConn.toString() + " - not observed, because it is acquired while debug mode was disabled." : usedConnsInfo + "\n" + result[i];
            ++i;
        }
        return usedConnsInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConnectionSetCleaner
    extends Thread {
        int cycle = 0;
        boolean running = true;
        boolean inProgress = false;
        ConnectionHashSet set = null;

        public ConnectionSetCleaner(int expireCycle, ConnectionHashSet set) {
            this.cycle = expireCycle * 1000;
            this.running = true;
            this.set = set;
        }

        public synchronized void run() {
            while (this.running) {
                this.inProgress = true;
                this.set.cleanup();
                try {
                    this.inProgress = false;
                    this.wait(this.cycle);
                }
                catch (InterruptedException e) {
                    ConnectorServiceFrame.logException(e);
                    if (!this.running) break;
                }
            }
        }

        public synchronized void stopThread() {
            this.running = false;
            this.notify();
        }
    }
}

