/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.util.HashMapObjectMultiObject;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseNamingException;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.connector.jca.ConnectionManagerImpl;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;

public class AdapterCache {
    private SecurityContext securityContext = null;
    private String appName = null;
    private String adapterName = null;
    private String connFactoryInterface = null;
    private ConnectionHashSet mcSet = null;
    private HashMapObjectMultiObject preparedInstances;
    private MCFWrapper wrapper = null;
    private boolean isClosed = true;
    private boolean globalResAuth = true;
    private boolean isStandAlone = true;

    public AdapterCache(String app_name, String adapter_name, String conn_factory_interface, boolean global_res_auth, boolean is_stand_alone) {
        this.appName = app_name;
        this.adapterName = adapter_name;
        this.connFactoryInterface = conn_factory_interface;
        this.globalResAuth = global_res_auth;
        this.isStandAlone = is_stand_alone;
        this.preparedInstances = new HashMapObjectMultiObject(13, 2, 0.75f, 2, new IntHashHolderImpl());
    }

    public AdapterCache(String app_name, String adapter_name, String conn_factory_interface, boolean is_stand_alone) {
        this.appName = app_name;
        this.adapterName = adapter_name;
        this.connFactoryInterface = conn_factory_interface;
        this.isStandAlone = is_stand_alone;
        this.preparedInstances = new HashMapObjectMultiObject(13, 2, 0.75f, 2, new IntHashHolderImpl());
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getConnectionFactoryInterface() {
        return this.connFactoryInterface;
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public String getAppName() {
        return this.appName;
    }

    public Object getFactory(Hashtable properties, boolean tx_support, boolean sharing_scope, boolean res_auth, String lookupName) throws ResourceException {
        Object[] buffer;
        String logPrefix = null;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "AdapterCache.getFactory(), Connector: " + this.adapterName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Global: " + this.globalResAuth);
        }
        if (!this.globalResAuth) {
            res_auth = false;
        }
        Object factory = null;
        AdapterCache adapterCache = this;
        synchronized (adapterCache) {
            buffer = this.preparedInstances.getAll(lookupName);
        }
        if (buffer != null) {
            factory = buffer[0];
        }
        if (factory == null) {
            int tr_support = this.wrapper.getTransactionSupport();
            ConnectionManagerImpl connManager = tx_support ? new ConnectionManagerImpl(this.adapterName, sharing_scope, res_auth, tr_support, this.mcSet) : new ConnectionManagerImpl(this.adapterName, sharing_scope, res_auth, 0, this.mcSet);
            factory = this.wrapper.getManagedConnectionFactory().createConnectionFactory((ConnectionManager)connManager);
            buffer = new Object[2];
            AdapterCache adapterCache2 = this;
            synchronized (adapterCache2) {
                connManager.setSecurityContext(this.securityContext);
                if (this.isClosed) {
                    if (ConnectorResourceAccessor.location.beDebug()) {
                        if (logPrefix == null) {
                            logPrefix = "AdapterCache.getFactory(), Connector: " + this.adapterName;
                        }
                        if (ConnectorResourceAccessor.location.beDebug()) {
                            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Cache is closed. Possible reason: lookup is made whithin createManagedConnection(...) method, while initializing the connection pool, stackTrace: " + Log.getStackTrace(new Exception()));
                        }
                    }
                    connManager.close();
                }
                buffer[0] = factory;
                buffer[1] = connManager;
                this.preparedInstances.put(lookupName, buffer);
            }
            if (ConnectorResourceAccessor.location.beDebug()) {
                if (logPrefix == null) {
                    logPrefix = "AdapterCache.getFactory(), Connector: " + this.adapterName;
                }
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", LookupName: " + lookupName + ", Not in the cache: " + factory);
            }
            return factory;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "AdapterCache.getFactory(), Connector: " + this.adapterName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", LookupName: " + lookupName + ", In the cache: " + factory);
        }
        return factory;
    }

    public synchronized void close() {
        String logPrefix = null;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "AdapterCache.close(), Connector: " + this.adapterName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", Close:true, LastCloseStatus: " + this.isClosed);
        }
        if (this.isClosed) {
            return;
        }
        Object[][] values = this.preparedInstances.getAllValues();
        int i = 0;
        while (i < values.length) {
            ((ConnectionManagerImpl)values[i][1]).close();
            ++i;
        }
        this.mcSet.clear();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void open() throws ResourceException {
        block10: {
            String logPrefix = null;
            if (ConnectorResourceAccessor.location.beDebug()) {
                if (logPrefix == null) {
                    logPrefix = "AdapterCache.open(), Connector: " + this.adapterName;
                }
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Open:true, LastOpenStatus: " + !this.isClosed);
            }
            if (!this.isClosed) {
                return;
            }
            Hashtable<String, String> p = new Hashtable<String, String>();
            p.put("domain", "true");
            p.put("Context.INITIAL_CONTEXT_FACTORY", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            try {
                InitialContext ctx = new InitialContext(p);
                Object mcfWrapperObject = ctx.lookup("mcf/" + this.adapterName);
                if (mcfWrapperObject instanceof MCFWrapper) {
                    this.wrapper = (MCFWrapper)mcfWrapperObject;
                    break block10;
                }
                throw new BaseNamingException("connector_0400", new String[]{"mcf/" + this.adapterName, "MCFWrapper", mcfWrapperObject.toString()});
            }
            catch (NamingException namExc) {
                BaseResourceException brExc = new BaseResourceException("connector_0504", this.adapterName, (Throwable)namExc);
                if (logPrefix == null) {
                    logPrefix = "AdapterCache.open(), Connector: " + this.adapterName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)brExc));
                throw brExc;
            }
        }
        this.wrapper.setAdapterName(this.adapterName);
        Object[][] values = this.preparedInstances.getAllValues();
        this.mcSet = new ConnectionHashSet(this.wrapper);
        try {
            int i = 0;
            while (i < values.length) {
                Object[] buffer = values[i];
                ConnectionManagerImpl manager = (ConnectionManagerImpl)buffer[1];
                ConnectionManagerImpl connManagerImpl = new ConnectionManagerImpl(this.adapterName, manager.getSharingScope(), manager.getAuthorization(), manager.getTransactionSupport(), this.mcSet);
                connManagerImpl.setSecurityContext(this.securityContext);
                buffer[0] = this.wrapper.getManagedConnectionFactory().createConnectionFactory((ConnectionManager)connManagerImpl);
                buffer[1] = connManagerImpl;
                ++i;
            }
            Object var9_11 = null;
            this.isClosed = false;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.isClosed = false;
            throw throwable;
        }
    }

    public synchronized void setSecurityContext(SecurityContext securityContext) {
        String logPrefix = null;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "AdapterCache.setSecurityContext(), ConnectionFactory: " + this.adapterName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", SecurityContext: " + securityContext);
        }
        this.securityContext = securityContext;
        Enumeration enumeration = this.preparedInstances.elements(1);
        while (enumeration.hasMoreElements()) {
            ConnectionManagerImpl connManager = (ConnectionManagerImpl)enumeration.nextElement();
            if (ConnectorResourceAccessor.location.beDebug()) {
                if (logPrefix == null) {
                    logPrefix = "AdapterCache.setSecurityContext(), ConnectionFactory: " + this.adapterName;
                }
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", ConnectionFactory: " + connManager.mcfName + ", Set SecurityContext: " + securityContext);
            }
            connManager.setSecurityContext(securityContext);
        }
    }

    public ConnectionHashSet getConnectionSet() {
        return this.mcSet;
    }
}

