/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.deploy.descriptors.InboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.MessageListener;
import com.sap.engine.services.connector.jca15.deploy.descriptors.OutboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.gui.RuntimeControls;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;

public class ListConnectors
implements Command {
    private RuntimeControls runtimeControls = null;
    Properties status_colour = new Properties();
    static /* synthetic */ Class class$com$sap$engine$services$connector$command$ListConnectors;

    public ListConnectors(RuntimeControls runtimeControls) {
        this.runtimeControls = runtimeControls;
        InputStream is = (class$com$sap$engine$services$connector$command$ListConnectors == null ? (class$com$sap$engine$services$connector$command$ListConnectors = ListConnectors.class$("com.sap.engine.services.connector.command.ListConnectors")) : class$com$sap$engine$services$connector$command$ListConnectors).getResourceAsStream("status_colour.properties");
        try {
            this.status_colour.load(is);
        }
        catch (IOException ioe) {
            ConnectorResourceAccessor.location.logT(500, "connector_info(), Error: " + Log.getStackTrace(ioe));
        }
    }

    public String getName() {
        return "connector_info";
    }

    public String getGroup() {
        return "connector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        JCDescriptor[] jcDescriptors;
        PrintStream out = new PrintStream(os);
        boolean isConnector = false;
        boolean all = false;
        boolean isVersion = false;
        boolean isRemote = env.isRemote();
        String connectorName = null;
        String connectorVersion = null;
        if (params.length == 0 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        int i = 0;
        while (i < params.length) {
            if (params[i].equals("-a")) {
                isConnector = false;
                all = true;
            } else if (params[i].equals("-c")) {
                isConnector = true;
            } else if (params[i].equals("-v")) {
                isVersion = true;
            } else if (isConnector) {
                isConnector = false;
                connectorName = params[i];
            } else if (isVersion) {
                isVersion = false;
                connectorVersion = params[i];
            }
            ++i;
        }
        if (all) {
            try {
                jcDescriptors = this.runtimeControls.getAllAppNames();
                int MAX_APP_LEN = 48;
                if (jcDescriptors != null) {
                    out.print("\n NAME");
                    int i2 = 0;
                    while (i2 < MAX_APP_LEN - 3) {
                        out.print(" ");
                        ++i2;
                    }
                    out.println("STATUS");
                    out.print(" ");
                    int i3 = 0;
                    while (i3 < MAX_APP_LEN + 8) {
                        out.print("-");
                        ++i3;
                    }
                    out.println();
                    int i4 = 0;
                    while (i4 < jcDescriptors.size()) {
                        Vector vec = (Vector)jcDescriptors.elementAt(i4);
                        boolean isStarted = this.runtimeControls.isStartedApplication((String)vec.elementAt(1));
                        String status = isStarted ? "STARTED" : "STOPPED";
                        String name = (String)vec.elementAt(1);
                        out.print(" " + name);
                        int b = MAX_APP_LEN - name.length();
                        while (b > 0) {
                            out.print(" ");
                            --b;
                        }
                        if (isRemote) {
                            out.print(this.status_colour.getProperty(status, ""));
                        }
                        out.print(" " + status);
                        if ("STOPPED".equals(status)) {
                            out.print("!");
                        }
                        if (isRemote) {
                            out.print(this.status_colour.getProperty("DEFAULT", ""));
                        }
                        out.println();
                        ++i4;
                    }
                } else {
                    out.println(" There are no resource adapters currently deployed.");
                }
            }
            catch (NullPointerException npExc) {
                ConnectorResourceAccessor.location.logT(500, "connector_info(), Error: " + Log.getStackTrace(npExc));
                out.println("\nThere is no such connector currently deployed. For more details see connector service logs.");
            }
            catch (RemoteException rExc) {
                ConnectorResourceAccessor.location.logT(500, "connector_info(), Error: " + Log.getStackTrace(rExc));
                return;
            }
        }
        if (connectorName != null) {
            try {
                jcDescriptors = null;
                Object descriptors = null;
                jcDescriptors = this.runtimeControls.getAllJCDescriptors(connectorName);
                if (jcDescriptors != null) {
                    int j = 0;
                    while (j < jcDescriptors.length) {
                        out.println("\n" + jcDescriptors[j].getDisplayName());
                        out.println("  MCF class - " + jcDescriptors[j].getManagedConnectionFactoryClass());
                        out.println("  JNDI name - " + jcDescriptors[j].getConnectorJNDIName() + "\n");
                        ++j;
                    }
                } else if (descriptors != null) {
                    int j = 0;
                    while (j < (descriptors).length) {
                        ResourceAdapterDescriptor raDescriptor = descriptors[j].getResourceAdapterDescriptor();
                        OutboundResourceAdapterDescriptor outDescriptor = raDescriptor.getOutboundResourceAdapter();
                        ConnectionDefinition[] connDefinition = outDescriptor.getConnectionDefinitions();
                        InboundResourceAdapterDescriptor inDescriptor = raDescriptor.getInboundResourceAdapter();
                        MessageListener[] messListeners = inDescriptor.getMessageListeners();
                        out.println("\n" + descriptors[j].getDisplayName());
                        out.println("  Outbound Resource Adapter");
                        int i5 = 0;
                        while (i5 < connDefinition.length) {
                            out.println("    MCF class - " + connDefinition[i5].getManagedConnectionFactoryClass());
                            out.println("    JNDI name - " + connDefinition[i5].getJNDIName() + "\n");
                            ++i5;
                        }
                        out.println("  Inbound Resource Adapter");
                        int i6 = 0;
                        while (i6 < messListeners.length) {
                            out.println("    Message Listener type - " + messListeners[i6].getMessageListenerType());
                            out.println("    Message Listener name - " + messListeners[i6].getMessageListenerName() + "\n");
                            ++i6;
                        }
                        ++j;
                    }
                } else {
                    out.println("none");
                }
            }
            catch (NullPointerException npExc) {
                ConnectorResourceAccessor.location.logT(500, "connector_info(), Error: " + Log.getStackTrace(npExc));
                out.println("\nThere is no such connector currently deployed. For more details see connector service logs.");
            }
            catch (Exception rExc) {
                ConnectorResourceAccessor.location.logT(500, "connector_info(), Error: " + Log.getStackTrace(rExc));
                return;
            }
        }
    }

    public String getHelpMessage() {
        return "\nDisplays detailed deployed connector information.\n\nUsage: CONNECTOR_INFO <options>\nParameters: \n  <options>:\n    -a - Lists the names of all deployed connectors.\n    -c <connectorName> - Displays detailed information about this connector.\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

