/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca.deploy.ContainerImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ListConnections
implements Command {
    private ContainerImpl runtime;

    public ListConnections(ContainerImpl runtime) {
        this.runtime = runtime;
    }

    public String getName() {
        return "list_conns";
    }

    public String getGroup() {
        return "connector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        boolean traceMode = false;
        if (params.length == 1 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length > 2 || params.length < 1) {
            out.println(this.getHelpMessage());
            return;
        }
        if (params.length == 2) {
            if (params[1].equalsIgnoreCase("-showTrace")) {
                traceMode = true;
            } else {
                out.println(this.getHelpMessage());
                return;
            }
        }
        try {
            String[] freeMCs = this.runtime.getFreeConnectionsInfo(params[0]);
            String[] usedMCs = this.runtime.getUsedConnectionsInfo(params[0], traceMode);
            out.println("\r\n---------------- free connections ----------------\n");
            if (freeMCs.length == 0) {
                out.println(" none\n");
            } else {
                this.showMCsInfo(out, freeMCs);
            }
            out.println("\r\n---------------- used connections ----------------\n");
            if (usedMCs.length == 0) {
                out.println(" none\n");
            } else {
                this.showMCsInfo(out, usedMCs);
            }
        }
        catch (Exception exc) {
            ConnectorResourceAccessor.location.logT(500, "list_conns(), Error: " + Log.getStackTrace(exc));
            out.println("\nCannot list connections. For more details see connector service logs.");
        }
    }

    private void showMCsInfo(PrintStream out, String[] freeMCs) {
        int i = 0;
        while (i < freeMCs.length) {
            out.println(freeMCs[i]);
            ++i;
        }
    }

    public String getHelpMessage() {
        return "\nReturns an info list for free or(and) used physical(managed) connections,\ncreated using the specified connector.\n\nUsage: LIST_CONNS <connectorJNDIName> [-showTrace]\nParameters:\n\t<connectorName> - the jndi name of the connection factory for which the\n\t                  used and free ManagedConnection-s info will be observed\n\t<-showTrace>    - if specified, show full stack trace of given call\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

