/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca.deploy.ContainerImpl;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class GetDebugMode
implements Command {
    private ContainerImpl runtime;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$command$GetDebugMode == null ? (class$com$sap$engine$services$connector$command$GetDebugMode = GetDebugMode.class$("com.sap.engine.services.connector.command.GetDebugMode")) : class$com$sap$engine$services$connector$command$GetDebugMode));
    static /* synthetic */ Class class$com$sap$engine$services$connector$command$GetDebugMode;

    public GetDebugMode(ContainerImpl runtime) {
        this.runtime = runtime;
    }

    public String getName() {
        return "get_debug_mode";
    }

    public String getGroup() {
        return "connector";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            if (this.runtime.getDebugMode(params[0])) {
                out.println("\nRuntime debug mode is enabled.");
            } else {
                out.println("\nRuntime debug mode is disabled.");
            }
            if (location.beDebug()) {
                out.println("\nService debug mode is enabled.\n");
            } else {
                out.println("\nService debug mode is disabled.\n");
            }
        }
        catch (Exception exc) {
            ConnectorResourceAccessor.location.logT(500, "get_debug_mode(), Error: " + Log.getStackTrace(exc));
            out.println("\nCan not get runtime debug mode status. For more details see connector service logs.");
        }
    }

    public String getHelpMessage() {
        return "\nReturns debug mode status of specified connector.\nUsage: get_debug_mode <connectorName>\nParameters:\n\t<connectorName> - the jndi name of the connection factory which debug mode status is required\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

