/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.jca.AdapterCache;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;

public class ResourceObjectFactory
implements ObjectFactory {
    private static SecurityContext securityContext = null;
    protected static Hashtable aliasTable;
    protected static ConcurrentHashMapObjectObject preparedCaches;
    protected static boolean is_closed;

    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable hashtable) throws Exception {
        AdapterCache cache;
        String tx_support_str;
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.getObjectInstance()";
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        InitialContext ctx = null;
        Reference ref = (Reference)obj;
        String res_auth_str = null;
        String sharing_scope_str = null;
        boolean res_auth = false;
        boolean sharing_scope = false;
        String res_name = null;
        String resType = null;
        boolean client = false;
        boolean tx_support = true;
        RefAddr refAddr = ref.get("tx-support");
        if (refAddr != null && !(tx_support_str = (String)refAddr.getContent()).equalsIgnoreCase("true")) {
            tx_support = false;
        }
        try {
            res_auth_str = (String)ref.get("res-auth").getContent();
            sharing_scope_str = (String)ref.get("sharing-scope").getContent();
            res_name = ResourceObjectFactory.getRealName((String)ref.get("res-name").getContent());
            resType = (String)ref.get("res-type").getContent();
            boolean bl = client = ref.get("client") != null;
            if (ConnectorResourceAccessor.location.beDebug()) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.getObjectInstance()";
                }
                ConnectorResourceAccessor.location.logT(100, logPrefix + ", Client: " + client);
            }
            if (!client) {
                boolean bl2 = client = !"true".equalsIgnoreCase(SystemProperties.getProperty("server"));
                if (ConnectorResourceAccessor.location.beDebug()) {
                    if (logPrefix == null) {
                        logPrefix = "ResourceObjectFactory.getObjectInstance()";
                    }
                    ConnectorResourceAccessor.location.logT(100, logPrefix + ", ServerClient: " + client);
                }
            }
        }
        catch (NullPointerException npe) {
            BaseResourceException brExc = new BaseResourceException("connector_0502", ", please fill all fields.", (Throwable)npe);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.getObjectInstance()";
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + brExc.getStackTraceString());
            throw brExc;
        }
        String message = "";
        if (res_name == null) {
            message = message + "res-name, ";
        }
        if (resType == null) {
            message = message + "res-type, ";
        }
        if (sharing_scope_str == null) {
            message = message + "sharing-scope, ";
        }
        if (res_auth_str == null) {
            message = message + "res-auth";
        }
        if (message.endsWith(", ")) {
            message = message.substring(0, message.length() - 2);
        }
        if (!message.equals("")) {
            BaseResourceException brExc = new BaseResourceException("connector_0502", ", null content for " + message + ".");
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.getObjectInstance()";
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
            throw brExc;
        }
        if (sharing_scope_str.equals("Shareable")) {
            sharing_scope = true;
        }
        if (res_auth_str.equals("Container")) {
            res_auth = true;
        }
        Hashtable newHashtable = (Hashtable)hashtable.clone();
        newHashtable.put("domain", "true");
        if (client) {
            newHashtable.put("appclient", "true");
            ctx = new InitialContext(newHashtable);
            Object mcfWrapperObject = null;
            try {
                mcfWrapperObject = ctx.lookup("mcf/" + res_name);
            }
            catch (NamingException namExc) {
                BaseResourceException brExc = new BaseResourceException("connector_0504", res_name, (Throwable)namExc);
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.getObjectInstance()";
                }
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + brExc.getStackTraceString());
                throw brExc;
            }
            if (!(mcfWrapperObject instanceof MCFWrapper)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.getObjectInstance()";
                }
                String stackTrace = null;
                try {
                    Method method = mcfWrapperObject.getClass().getMethod("getStackTrace", null);
                    stackTrace = (String)method.invoke(mcfWrapperObject, null);
                }
                catch (Exception e) {
                    ConnectorResourceAccessor.location.traceThrowableT(500, res_name, (Throwable)e);
                    stackTrace = "No Stack Trace: " + e;
                }
                BaseResourceException brExc = new BaseResourceException("connector_0517", new Object[]{res_name, stackTrace});
                ConnectorResourceAccessor.location.traceThrowableT(500, logPrefix, (Throwable)((Object)brExc));
                throw brExc;
            }
            MCFWrapper mcfWrapper = (MCFWrapper)mcfWrapperObject;
            ManagedConnectionFactory mcf = mcfWrapper.getManagedConnectionFactory();
            return mcf.createConnectionFactory();
        }
        String lookupName = sharing_scope_str + res_auth_str + tx_support + res_name;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.getObjectInstance()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", LookupName: " + lookupName);
        }
        if ((cache = (AdapterCache)preparedCaches.get(res_name)) == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0503", res_name);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.getObjectInstance()";
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Error: " + brExc.getStackTraceString());
            throw brExc;
        }
        Object factory = cache.getFactory(newHashtable, tx_support, sharing_scope, res_auth, lookupName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.getObjectInstance()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
        return factory;
    }

    public static void stopConnectionFactory(String cfName) throws ResourceException {
        AdapterCache cache;
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.stopConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.stopConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        if ((cache = (AdapterCache)preparedCaches.get(realName)) == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0503", realName);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.stopConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
            throw brExc;
        }
        cache.close();
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.stopConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void startConnectionFactory(String cfName) throws ResourceException {
        AdapterCache cache;
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.startConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.startConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix);
        }
        if ((cache = (AdapterCache)preparedCaches.get(realName)) == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0503", realName);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.startConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
            throw brExc;
        }
        cache.open();
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.startConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static boolean isConnectionFactoryStarted(String cfName) throws ResourceException {
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        AdapterCache cache = (AdapterCache)preparedCaches.get(realName);
        if (cache == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0503", realName);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.isConnectionFactoryStarted(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
            throw brExc;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.isConnectionFactoryStarted(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
        return !cache.isClosed();
    }

    public static void closeFactory() {
        String logPrefix = null;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.closeFactory()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        is_closed = true;
        ConcurrentHashMapObjectObject concurrentHashMapObjectObject = preparedCaches;
        synchronized (concurrentHashMapObjectObject) {
            Enumeration enumeration = preparedCaches.elements();
            while (enumeration.hasMoreElements()) {
                ((AdapterCache)enumeration.nextElement()).close();
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.closeFactory()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void openFactory() {
        String logPrefix = null;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.openFactory()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix);
        }
        ConcurrentHashMapObjectObject concurrentHashMapObjectObject = preparedCaches;
        synchronized (concurrentHashMapObjectObject) {
            Enumeration enumeration = preparedCaches.elements();
            while (enumeration.hasMoreElements()) {
                AdapterCache adapterCache = null;
                try {
                    adapterCache = (AdapterCache)enumeration.nextElement();
                    adapterCache.open();
                }
                catch (ResourceException rExc) {
                    if (logPrefix == null) {
                        logPrefix = "ResourceObjectFactory.openFactory()";
                    }
                    if (rExc instanceof BaseResourceException) {
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + ((BaseResourceException)rExc).getStackTraceString());
                        continue;
                    }
                    BaseResourceException brExc = new BaseResourceException("connector_0507", new String[]{adapterCache.getAdapterName()}, (Throwable)rExc);
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
                }
            }
        }
        is_closed = false;
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.openFactory()";
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void removeConnectionFactory(String cfName) throws ResourceException {
        AdapterCache cache;
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.removeConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.removeConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix);
        }
        if ((cache = (AdapterCache)preparedCaches.remove(realName)) == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0503", realName);
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.removeConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
            throw brExc;
        }
        cache.close();
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.removeConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void addConnectionFactory(String appName, String cfName, String connFactoryInterface, boolean supportContainerAuth, boolean isStandAlone) throws ResourceException {
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.addConnectionFactory(boolean supportContainerAuth), ConnectionFactory: " + realName + ", Alias: " + cfName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (supportContainerAuth) {
            ResourceObjectFactory.addConnectionFactory(appName, realName, connFactoryInterface, isStandAlone);
        } else {
            AdapterCache cache = new AdapterCache(appName, realName, connFactoryInterface, false, isStandAlone);
            ConcurrentHashMapObjectObject concurrentHashMapObjectObject = preparedCaches;
            synchronized (concurrentHashMapObjectObject) {
                cache.setSecurityContext(securityContext);
                preparedCaches.put(realName, cache);
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.addConnectionFactory(boolean supportContainerAuth), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void addConnectionFactory(String appName, String cfName, String connFactoryInterface, boolean isStandAlone) throws ResourceException {
        String realName = ResourceObjectFactory.getRealName(cfName);
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.addConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        AdapterCache cache = new AdapterCache(appName, realName, connFactoryInterface, isStandAlone);
        ConcurrentHashMapObjectObject concurrentHashMapObjectObject = preparedCaches;
        synchronized (concurrentHashMapObjectObject) {
            cache.setSecurityContext(securityContext);
            preparedCaches.put(realName, cache);
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (logPrefix == null) {
                logPrefix = "ResourceObjectFactory.addConnectionFactory(), ConnectionFactory: " + realName + ", Alias: " + cfName;
            }
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static ConcurrentHashMapObjectObject getRegisteredFactories() {
        return preparedCaches;
    }

    public static void releaseConnection(String cfName, String connID) throws ResourceException {
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.releaseConnection(), ConnectionFactory: " + cfName + ", mConnId: " + connID;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        AdapterCache cache = (AdapterCache)preparedCaches.get(cfName);
        if (cache != null) {
            ConnectionHashSet connsSet = cache.getConnectionSet();
            connsSet.releaseUsedConnection(connID);
        }
    }

    public static void destroyConnection(String cfName, String connID, boolean forceDestroy) throws ResourceException {
        String logPrefix = null;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                if (logPrefix == null) {
                    logPrefix = "ResourceObjectFactory.destroyConnection(), ConnectionFactory: " + cfName + ", mConnId: " + connID + ", forceDestroy: " + forceDestroy;
                }
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        AdapterCache cache = (AdapterCache)preparedCaches.get(cfName);
        if (cache != null) {
            ConnectionHashSet connsSet = cache.getConnectionSet();
            try {
                connsSet.destroyUsedConnection(connID);
            }
            catch (ResourceException rex) {
                connsSet.destroyFreeConnection(connID);
            }
        }
    }

    public static String getConnectionFactoryForAlias(String alias) {
        return (String)aliasTable.get(alias);
    }

    public static boolean aliasesExist(String[] aliases) {
        int i = 0;
        while (i < aliases.length) {
            String oldCfName = (String)aliasTable.get(aliases[i]);
            if (oldCfName != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void registerAliases(String cfName, String[] aliases) throws ResourceException, IllegalArgumentException {
        String logPrefix = "ResourceObjectFactory.registerAliases(), ConnectionFactory: " + cfName;
        if (is_closed) {
            BaseResourceException brExc = new BaseResourceException("connector_0500", "ResourceObjectFactory");
            brExc.log();
            if (ConnectorResourceAccessor.location.beLogged(100)) {
                ConnectorResourceAccessor.location.traceThrowableT(100, logPrefix, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix);
        }
        int i = 0;
        while (i < aliases.length) {
            if (aliases[i].equals(cfName)) {
                BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0301", cfName);
                ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + biaExc.getStackTraceString());
                throw biaExc;
            }
            ++i;
        }
        Hashtable hashtable = aliasTable;
        synchronized (hashtable) {
            int i2 = 0;
            while (i2 < aliases.length) {
                String oldCfName = (String)aliasTable.get(aliases[i2]);
                if (oldCfName != null) {
                    BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0300", new String[]{aliases[i2], oldCfName});
                    ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + biaExc.getStackTraceString());
                    throw biaExc;
                }
                ++i2;
            }
            Enumeration enumeration = aliasTable.elements();
            while (enumeration.hasMoreElements()) {
                String oldMcfName = (String)enumeration.nextElement();
                int i3 = 0;
                while (i3 < aliases.length) {
                    if (aliases[i3].equals(oldMcfName)) {
                        BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0302", new String[]{aliases[i3], oldMcfName});
                        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + biaExc.getStackTraceString());
                        throw biaExc;
                    }
                    ++i3;
                }
            }
            int i4 = 0;
            while (i4 < aliases.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    ConnectorResourceAccessor.location.logT(100, logPrefix + " Register Alias: " + aliases[i4]);
                }
                aliasTable.put(aliases[i4], cfName);
                ++i4;
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static void unregisterAliases(String[] aliases) {
        String detailedLogPrefix = null;
        String logPrefix = "ResourceObjectFactory.unregisterAliases()";
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " started.");
        }
        Hashtable hashtable = aliasTable;
        synchronized (hashtable) {
            int i = 0;
            while (i < aliases.length) {
                if (ConnectorResourceAccessor.location.beDebug()) {
                    if (detailedLogPrefix == null) {
                        detailedLogPrefix = "ResourceObjectFactory.unregisterAliases(), ConnectionFactory: " + aliasTable.get(aliases[0]);
                    }
                    ConnectorResourceAccessor.location.logT(100, detailedLogPrefix + ", Unregister Alias: " + aliases[i]);
                }
                aliasTable.remove(aliases[i]);
                ++i;
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            if (detailedLogPrefix != null) {
                ConnectorResourceAccessor.location.logT(100, detailedLogPrefix + " finished successfully.");
            } else {
                ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
            }
        }
    }

    public static String[] getAliases(String adapterName) {
        Vector<String> aliases = new Vector<String>();
        Set entrySet = aliasTable.entrySet();
        Map.Entry[] entries = null;
        Hashtable hashtable = aliasTable;
        synchronized (hashtable) {
            entries = entrySet.toArray(new Map.Entry[entrySet.size()]);
        }
        int i = 0;
        while (i < entries.length) {
            String alias = (String)entries[i].getKey();
            String mcfName = (String)entries[i].getValue();
            if (adapterName.equals(mcfName)) {
                aliases.add(alias);
            }
            ++i;
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    public static void setSecurityContext(SecurityContext _securityContext) {
        String logPrefix = "ResourceObjectFactory.setSecurityContext()";
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + ", SecurityContext: " + _securityContext);
        }
        ConcurrentHashMapObjectObject concurrentHashMapObjectObject = preparedCaches;
        synchronized (concurrentHashMapObjectObject) {
            securityContext = _securityContext;
            Enumeration enumeration = preparedCaches.elements();
            while (enumeration.hasMoreElements()) {
                AdapterCache cache = (AdapterCache)enumeration.nextElement();
                cache.setSecurityContext(securityContext);
            }
        }
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix + " finished successfully.");
        }
    }

    public static String getRealName(String name) {
        String temp = (String)aliasTable.get(name);
        return temp == null ? name : temp;
    }

    public static ConnectionHashSet getConnectionSet(String cfName) throws ResourceException {
        String logPrefix = "ResourceObjectFactory.getConnectionSet(" + cfName + ")";
        AdapterCache ac = (AdapterCache)preparedCaches.get(cfName);
        if (ConnectorResourceAccessor.location.beDebug()) {
            ConnectorResourceAccessor.location.logT(100, logPrefix);
        }
        if (ac != null) {
            return ac.getConnectionSet();
        }
        BaseResourceException brExc = new BaseResourceException("connector_0503", cfName);
        ConnectorResourceAccessor.location.logT(500, logPrefix + ", Exception: " + brExc.getStackTraceString());
        throw brExc;
    }

    static {
        is_closed = false;
        aliasTable = new Hashtable();
        preparedCaches = new ConcurrentHashMapObjectObject(13, 2, 0.75f, new IntHashHolderImpl());
    }
}

