/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.dsr.ejb.StatisticContextEJB;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.interfaces.transaction.TransactionManagerExtension;
import com.sap.engine.services.connector.ConnectorResourceAccessor;
import com.sap.engine.services.connector.HollowDsrStatisticContextImpl;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.command.GetDebugMode;
import com.sap.engine.services.connector.command.ListConnections;
import com.sap.engine.services.connector.command.ListConnectors;
import com.sap.engine.services.connector.command.SwitchDebugMode;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseServiceException;
import com.sap.engine.services.connector.jca.ComponentExecutionContextImpl;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.jca.deploy.ContainerImpl;
import com.sap.engine.services.connector.jca15.deploy.Container15Impl;
import com.sap.engine.services.connector.jca15.endpoint.EndpointActivationImpl;
import com.sap.engine.services.connector.jca15.gui.RuntimeControlsImpl;
import com.sap.engine.services.connector.jca15.startup.Connector15Startup;
import com.sap.engine.services.connector.jca15.work.HollowTimeoutManager;
import com.sap.engine.services.connector.jca15.work.HollowTransactionManager;
import com.sap.engine.services.connector.resource.impl.ResourceContextFactoryImpl;
import com.sap.engine.services.connector.resource.impl.ResourceSetFactoryImpl;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.timeout.TimeoutManager;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ConnectorServiceFrame
extends ContainerEventListenerAdapter
implements ApplicationServiceFrame {
    private static final int MASK = 228;
    private static final TransactionManagerExtension STOPPED_TRANSACTION_SERVICE = new HollowTransactionManager();
    private static final TimeoutManager STOPPED_TIMEOUT_SERVICE;
    public static TimeoutManager timeoutManager;
    public static TransactionManagerExtension transactionManager;
    public static final String SECURITY_NAME = "security";
    public static ThreadSystem threadSystem;
    public static int resSetContextID;
    private static Log logger;
    private ApplicationServiceContext serviceContext = null;
    private ComponentExecutionContextImpl componentExecutionContext = null;
    private ContainerImpl containerImpl;
    private Container15Impl container15Impl;
    private EndpointActivationImpl endpointActivation = null;
    private Connector15Startup connector15Startup = null;
    private RuntimeControlsImpl managementInterface = null;
    private static StatisticContextEJB dsrInterface;
    private ContainerManagement containerManagment;
    private ShellInterface shell;
    private Command[] commands;
    private int commandsId;
    private Set interestingNames;

    public ConnectorServiceFrame() {
        logger = new Log(ConnectorResourceAccessor.location);
        this.interestingNames = new HashSet(5);
        this.interestingNames.add("container");
        this.interestingNames.add(SECURITY_NAME);
        this.interestingNames.add("shell");
        this.interestingNames.add("transactionext");
        this.interestingNames.add("timeout");
        this.interestingNames.add("dsr_ejbcontext_api");
    }

    public void start(ApplicationServiceContext service_context) throws ServiceException {
        this.serviceContext = service_context;
        threadSystem = this.serviceContext.getCoreContext().getThreadSystem();
        this.componentExecutionContext = new ComponentExecutionContextImpl();
        this.serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("appcontext", this.componentExecutionContext);
        ResourceSetContextObject worker = new ResourceSetContextObject(null);
        resSetContextID = threadSystem.registerContextObject("RESOURCE_SET_CONTEXT_OBJECT", worker);
        if (this.containerImpl == null) {
            try {
                this.containerImpl = new ContainerImpl(this.serviceContext);
            }
            catch (ConfigurationException confExc) {
                BaseServiceException bsExc = new BaseServiceException("connector_1000", (Throwable)((Object)confExc));
                bsExc.log();
                throw bsExc;
            }
            this.container15Impl = new Container15Impl(service_context);
            this.commands = new Command[4];
            this.commands[0] = new GetDebugMode(this.containerImpl);
            this.commands[1] = new SwitchDebugMode(this.containerImpl);
            this.commands[2] = new ListConnections(this.containerImpl);
        } else {
            this.containerImpl.start();
            this.container15Impl.start();
        }
        this.endpointActivation = new EndpointActivationImpl(this.container15Impl);
        this.serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("endpoint_api", this.endpointActivation);
        this.serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("resourcecontext_api", new ResourceContextFactoryImpl());
        this.serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("resourceset_api", new ResourceSetFactoryImpl());
        this.connector15Startup = new Connector15Startup();
        this.connector15Startup.start(service_context);
        this.serviceContext.getServiceState().registerContainerEventListener(228, this.interestingNames, this);
    }

    public void stop() {
        this.containerImpl.stop();
        this.container15Impl.stop();
        threadSystem.getThreadContext().unregisterContextObject("RESOURCE_SET_CONTEXT_OBJECT");
        if (this.containerManagment != null) {
            try {
                this.containerImpl.getDeployCommunicator().stopMyApplications(this.containerImpl.getDeployCommunicator().getMyApplications());
            }
            catch (RemoteException rExc) {
                new BaseDeploymentException("connector_0049", "1.0", (Throwable)rExc).log();
            }
            try {
                this.container15Impl.getDeployCommunicator().stopMyApplications(this.container15Impl.getDeployCommunicator().getMyApplications());
            }
            catch (RemoteException rExc) {
                new BaseDeploymentException("connector_0049", "new version", (Throwable)rExc).log();
            }
            try {
                this.containerManagment.unregisterContainer("connector");
                this.containerManagment.unregisterContainer("connector15");
            }
            catch (NullPointerException npExc) {
                new BaseDeploymentException("connector_0030", new String[]{"container"});
            }
            if (this.shell != null) {
                this.shell.unregisterCommands(this.commandsId);
            }
        }
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("appcontext");
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("endpoint_api");
        this.serviceContext.getServiceState().unregisterManagementInterface();
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
        this.serviceContext.getServiceState().unregisterContainerEventListener();
        this.shell = null;
        this.containerManagment = null;
        this.serviceContext = null;
        threadSystem = null;
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return true;
    }

    public Object getServiceInterface() {
        return this.container15Impl;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("container")) {
            this.containerManagment = (ContainerManagement)interfaceImpl;
            DeployCommunicator deployCommunicator = this.containerManagment.registerContainer("connector", this.containerImpl);
            DeployCommunicator deployCommunicator15 = this.containerManagment.registerContainer("connector15", this.container15Impl);
            this.containerImpl.setDeployCommunicator(deployCommunicator);
            this.container15Impl.setDeployCommunicator(deployCommunicator15);
            try {
                this.managementInterface = new RuntimeControlsImpl(this.container15Impl, this.containerImpl);
                this.managementInterface.setDeployCommunicator(deployCommunicator15);
                this.serviceContext.getServiceState().registerManagementInterface(this.managementInterface);
            }
            catch (ServiceException e) {
                new BaseServiceException("connector_1001", (Throwable)((Object)e)).log();
            }
            catch (RemoteException rExc) {
                ConnectorServiceFrame.logException(rExc);
            }
            this.serviceContext.getContainerContext().getObjectRegistry().registerInterface(this.container15Impl);
            try {
                deployCommunicator.startMyApplications(deployCommunicator.getMyApplications());
            }
            catch (RemoteException rExc) {
                new BaseDeploymentException("connector_0048", "1.0", (Throwable)rExc).log();
            }
            try {
                deployCommunicator15.startMyApplications(deployCommunicator15.getMyApplications());
            }
            catch (RemoteException rExc) {
                new BaseDeploymentException("connector_0048", "new version", (Throwable)rExc).log();
            }
            if (this.shell != null) {
                this.commands[3] = new ListConnectors(this.managementInterface);
                this.shell.registerCommands(this.commands);
            }
        } else if (interfaceName.equals(SECURITY_NAME)) {
            SecurityContext securityContext = (SecurityContext)interfaceImpl;
            ResourceObjectFactory.setSecurityContext(securityContext);
            this.containerImpl.setSecurityContext(securityContext);
            this.container15Impl.setSecurityContext(securityContext);
        } else if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            if (this.containerManagment != null) {
                this.commands[3] = new ListConnectors(this.managementInterface);
                this.commandsId = this.shell.registerCommands(this.commands);
            }
        } else if (interfaceName.equals("transactionext")) {
            transactionManager = (TransactionManagerExtension)interfaceImpl;
        } else if (interfaceName.equals("dsr_ejbcontext_api")) {
            dsrInterface = (StatisticContextEJB)interfaceImpl;
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("container")) {
            if (this.shell != null) {
                this.shell.unregisterCommands(this.commandsId);
            }
            this.serviceContext.getServiceState().unregisterManagementInterface();
            this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
            this.containerManagment = null;
        } else if (interfaceName.equals(SECURITY_NAME)) {
            ResourceObjectFactory.setSecurityContext(null);
            this.containerImpl.setSecurityContext(null);
        } else if (interfaceName.equals("shell")) {
            this.shell = null;
        } else if (interfaceName.equals("transactionext")) {
            transactionManager = STOPPED_TRANSACTION_SERVICE;
        } else if (interfaceName.equals("dsr_ejbcontext_api")) {
            dsrInterface = new HollowDsrStatisticContextImpl();
        }
    }

    public static void sendEventToDsr(String componentName, String applicationName, String methodName) {
        if (dsrInterface != null) {
            dsrInterface.setApplicationContext(componentName, applicationName, methodName);
        }
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if ("timeout".equals(serviceName)) {
            timeoutManager = (TimeoutManager)serviceInterface;
        }
    }

    public void serviceStopped(String serviceName) {
        if ("timeout".equals(serviceName)) {
            timeoutManager = STOPPED_TIMEOUT_SERVICE;
        }
    }

    public static void logDebug(String message) {
        if (logger != null) {
            Log.logDebug(message);
        }
    }

    public static void logInfo(String message) {
        if (logger != null) {
            Log.logInfo(message);
        }
    }

    public static void logException(Exception exc) {
        if (logger != null) {
            Log.logThrowable(exc);
        }
    }

    static {
        timeoutManager = STOPPED_TIMEOUT_SERVICE = new HollowTimeoutManager();
        transactionManager = STOPPED_TRANSACTION_SERVICE;
        threadSystem = null;
        resSetContextID = -1;
        logger = null;
        dsrInterface = null;
    }
}

