/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.server;

import com.sap.engine.services.appclient.AppClientResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class Log {
    static Category cat = null;
    static Location loc = null;

    public Log(Location loc, Category cat) {
        Log.loc = loc;
        Log.cat = cat;
    }

    public static void trcLMsg(int severity, Location loc, String messageKey, Object[] args) {
        AppClientResourceAccessor.trcLMsg(severity, loc, messageKey, args);
    }

    public static void trcLMsg(int severity, Location loc, String messageKey) {
        AppClientResourceAccessor.trcLMsg(severity, loc, messageKey);
    }

    private static void getParameterList(StringBuffer sb, Object[] args) {
        if (args != null) {
            int i = 0;
            int argsLen = args.length;
            i = 0;
            while (i < argsLen - 1) {
                sb.append(args[i]);
                sb.append(",");
                ++i;
            }
            if (argsLen > 0) {
                sb.append(args[argsLen - 1]);
            }
        }
    }

    public static String enterMtd(String classMethod, Object[] args, String message) {
        String msgParam = "->";
        if (message != null) {
            msgParam = msgParam + message;
        }
        return Log.logMtd(classMethod, args, msgParam);
    }

    public static String enterMtd(String classMethod, Object[] args) {
        return Log.enterMtd(classMethod, args, null);
    }

    public static String enterMtd(String classMethod) {
        return Log.enterMtd(classMethod, null, null);
    }

    public static String exitMtd(String classMethod, Object[] args, String message) {
        String msgParam = "<-";
        if (message != null) {
            msgParam = msgParam + message;
        }
        return Log.logMtd(classMethod, args, msgParam);
    }

    public static String exitMtd(String classMethod, Object[] args) {
        return Log.exitMtd(classMethod, args, null);
    }

    public static String exitMtd(String classMethod) {
        return Log.exitMtd(classMethod, null, null);
    }

    public static String logMtd(String classMethod, Object[] args, String message) {
        int mtdLen = classMethod == null ? 0 : classMethod.length();
        int msgLen = message == null ? 0 : message.length();
        StringBuffer sb = new StringBuffer(mtdLen + msgLen + 10);
        sb.append(classMethod);
        sb.append("(");
        Log.getParameterList(sb, args);
        sb.append(") ");
        if (msgLen > 0) {
            sb.append(message);
        }
        return sb.toString();
    }

    public static void log(int severity, Object msg) {
        if (!loc.beLogged(severity)) {
            return;
        }
        if (msg instanceof Throwable) {
            Throwable thr = (Throwable)msg;
            loc.traceThrowableT(severity, null, thr);
        } else if (msg == null) {
            loc.logT(severity, null);
        } else {
            loc.logT(severity, msg.toString());
        }
    }
}

