/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.server;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.AppClientResourceAccessor;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.ClientJar;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationAdditionalDocument;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationDocument;
import com.sap.engine.services.appclient.exceptions.BaseDeploymentException;
import com.sap.engine.services.appclient.exceptions.BaseWarningException;
import com.sap.engine.services.appclient.server.AppClientHandleDelegate;
import com.sap.engine.services.appclient.server.AppclientRuntimeImpl;
import com.sap.engine.services.appclient.server.AppclientStarter;
import com.sap.engine.services.appclient.server.AppclientStopper;
import com.sap.engine.services.appclient.server.ApplicationClientFrame;
import com.sap.engine.services.appclient.server.ClientObject;
import com.sap.engine.services.appclient.server.Log;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ApplicationClientContainer
implements ContainerInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$appclient$server$ApplicationClientContainer == null ? (class$com$sap$engine$services$appclient$server$ApplicationClientContainer = ApplicationClientContainer.class$("com.sap.engine.services.appclient.server.ApplicationClientContainer")) : class$com$sap$engine$services$appclient$server$ApplicationClientContainer));
    Hashtable clientJars = new Hashtable();
    private ApplicationClientFrame appFrame;
    private ContainerInfo info = null;
    private static final int MUST_DEPLOY = 0;
    private static final int UPDATE_DESCRIPTOR = 1;
    private static final int UPDATE_JAR = 2;
    private static final String APPLICATION_CLIENT_NAME = "appclient";
    private DeployCommunicator deployCommunicator = null;
    private Properties initCtxProps = null;
    private Log logger = null;
    private static final int APP_PRIORITY = 70;
    private AppclientRuntimeImpl appRuntime;
    static /* synthetic */ Class class$com$sap$engine$services$appclient$server$ApplicationClientContainer;

    public ApplicationClientContainer(ApplicationClientFrame appFrame, Log logger) {
        this.appFrame = appFrame;
        this.logger = logger;
        this.info = new ContainerInfo();
        this.info.setJ2EEContainer(true);
        this.info.setJ2EEModuleName("java");
        this.info.setName(APPLICATION_CLIENT_NAME);
        this.info.setServiceName(appFrame.sc.getServiceState().getServiceName());
        this.info.setFileExtensions(new String[]{".jar"});
        this.info.setPriority(70);
    }

    public void setDeployCommunicator(DeployCommunicator deploy_communicator) {
        this.deployCommunicator = deploy_communicator;
    }

    public ContainerInfo getContainerInfo() {
        return this.info;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".deploy", new Object[]{archiveFiles, dInfo, props}));
        }
        String applicationName = dInfo.getApplicationName();
        Hashtable fileMap = dInfo.getFileMappings();
        ClassLoader applicationLoader = dInfo.getLoader();
        Configuration configuration = null;
        Configuration altddConfiguration = null;
        try {
            configuration = dInfo.getConfiguration().createSubConfiguration(APPLICATION_CLIENT_NAME);
        }
        catch (ConfigurationException configEx) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0502", (Throwable)((Object)configEx));
            AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
            throw bde;
        }
        try {
            altddConfiguration = configuration.createSubConfiguration("alt_dd");
        }
        catch (ConfigurationException configEx) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0502", (Throwable)((Object)configEx));
            AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
            throw bde;
        }
        String appDirName = null;
        try {
            appDirName = this.deployCommunicator.getMyWorkDirectory(applicationName);
            File appDir = new File(appDirName);
            if (!appDir.exists()) {
                appDir.mkdirs();
            }
        }
        catch (IOException ioEx) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0405", applicationName, (Throwable)ioEx);
            AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
            throw bde;
        }
        int jarslength = archiveFiles.length;
        String[] componentNames = new String[jarslength];
        J2EEModule[] modules = dInfo.getEarDescriptor().getClients();
        Vector<String> filesForLoader = new Vector<String>();
        try {
            int i = 0;
            while (i < jarslength) {
                BaseDeploymentException bde;
                BaseDeploymentException bde2;
                J2EEModule currentModule = null;
                String archiveEarPath = (String)fileMap.get(archiveFiles[i].getAbsolutePath());
                if (archiveEarPath == null || archiveEarPath.length() == 0) {
                    BaseDeploymentException bde3 = new BaseDeploymentException("appclient_0503", archiveFiles[i]);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde3));
                    throw bde3;
                }
                String fileName = appDirName + File.separatorChar + archiveEarPath;
                filesForLoader.add(fileName);
                File file = new File(fileName);
                FileUtils.copyFile(archiveFiles[i], file);
                try {
                    configuration.addFileEntry(file);
                }
                catch (ConfigurationException cex) {
                    bde2 = new BaseDeploymentException("appclient_0504", (Throwable)((Object)cex));
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde2));
                    throw bde2;
                }
                int k = 0;
                while (k < modules.length) {
                    if (archiveEarPath.equals(modules[k].getUri())) {
                        currentModule = modules[k];
                        break;
                    }
                    ++k;
                }
                if (currentModule == null) {
                    bde2 = new BaseDeploymentException("appclient_0505", new Object[]{archiveEarPath, applicationName});
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde2));
                    throw bde2;
                }
                String altDD = currentModule.getAlt_dd();
                if (altDD != null) {
                    Exception e2;
                    FileOutputStream fos;
                    String altddFileName;
                    block39: {
                        Object var28_41;
                        altddFileName = appDirName + File.separatorChar + "alt_dd" + File.separatorChar + archiveEarPath.substring(0, archiveEarPath.length() - 3) + "xml";
                        boolean dirCreated = new File(appDirName + File.separatorChar + "alt_dd").mkdirs();
                        if (!dirCreated) {
                            bde = new BaseDeploymentException("appclient_0518", applicationName);
                            LOCATION.logT(500, "Deployment error. Error creating directory for alternative descriptor!");
                            AppClientResourceAccessor.CATEGORY_SYS_SERVER.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
                            throw bde;
                        }
                        InputStream inp = null;
                        fos = null;
                        try {
                            int read;
                            inp = applicationLoader.getResourceAsStream(altDD);
                            fos = new FileOutputStream(new File(altddFileName));
                            byte[] buffer = new byte[4096];
                            while ((read = inp.read(buffer, 0, buffer.length)) != -1) {
                                void var26_39;
                                fos.write(buffer, 0, (int)var26_39);
                            }
                            var28_41 = null;
                        }
                        catch (Throwable throwable) {
                            block42: {
                                block41: {
                                    var28_41 = null;
                                    try {
                                        inp.close();
                                    }
                                    catch (Exception e2) {
                                        if (!LOCATION.beLogged(300)) break block41;
                                        LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Deployment warning for application " + applicationName + ". Error closing reading stream for alternative descriptor!", (Throwable)e2);
                                    }
                                }
                                try {
                                    fos.close();
                                }
                                catch (Exception e2) {
                                    if (!LOCATION.beLogged(300)) break block42;
                                    LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Deployment warning for application " + applicationName + ". Error closing output stream for alternative descriptor!", (Throwable)e2);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            inp.close();
                        }
                        catch (Exception e2) {
                            if (!LOCATION.beLogged(300)) break block39;
                            LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Deployment warning for application " + applicationName + ". Error closing reading stream for alternative descriptor!", (Throwable)e2);
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {
                        if (LOCATION.beLogged(300)) {
                            LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Deployment warning for application " + applicationName + ". Error closing output stream for alternative descriptor!", (Throwable)e2);
                        }
                    }
                    File altddFile = new File(altddFileName);
                    try {
                        altddConfiguration.addFileEntry(altddFile);
                    }
                    catch (ConfigurationException cex) {
                        BaseDeploymentException bde4 = new BaseDeploymentException("appclient_0504", (Throwable)((Object)cex));
                        if (LOCATION.beLogged(500)) {
                            LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde4));
                        }
                        throw bde4;
                    }
                    componentNames[i] = this.parseAltXML(altddFile, fileName).getDisplayName();
                } else {
                    componentNames[i] = this.parseXMLFile(fileName).getDisplayName();
                }
                String mainClassName = this.getMainClassName(fileName);
                if (mainClassName == null || mainClassName.equals("")) {
                    BaseDeploymentException bde5 = new BaseDeploymentException("appclient_0506", applicationName);
                    LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde5));
                    throw bde5;
                }
                String entryName = mainClassName.replace('.', '/');
                if (!entryName.endsWith("class")) {
                    entryName = entryName + ".class";
                }
                if (new JarFile(file).getEntry(entryName) == null) {
                    bde = new BaseDeploymentException("appclient_0507", new Object[]{applicationName, "application-client"});
                    LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde));
                    throw bde;
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0113", (Throwable)ioe);
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde));
            }
            throw bde;
        }
        ApplicationDeployInfo appInfo = new ApplicationDeployInfo();
        appInfo.setWarnings(new Vector());
        appInfo.setFilesForClassloader(filesForLoader.toArray(new String[filesForLoader.size()]));
        appInfo.setDeployedComponentNames(componentNames);
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.exitMtd(this + ".deploy", new Object[]{archiveFiles, dInfo, props}), "Normal exit of deploy method.");
        }
        if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(300)) {
            AppClientResourceAccessor.DEFAULT_CATEGORY.logT(300, LOCATION, AppClientResourceAccessor.getLocalizedText("appclient_0601", new Object[]{applicationName}));
        }
        return appInfo;
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".downloadApplicationFiles", new Object[]{applicationName, appConfig}));
        }
        String appDirName = null;
        try {
            appDirName = this.deployCommunicator.getMyWorkDirectory(applicationName);
            File appDir = new File(appDirName);
            if (!appDir.exists()) {
                appDir.mkdirs();
            }
        }
        catch (IOException ioEx) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0401", applicationName, (Throwable)ioEx);
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde));
            }
            throw bde;
        }
        Configuration appCfg = null;
        if (appConfig == null) {
            throw new BaseDeploymentException("appclient_0508", APPLICATION_CLIENT_NAME);
        }
        try {
            appCfg = appConfig.getSubConfiguration(APPLICATION_CLIENT_NAME);
        }
        catch (ConfigurationException e) {
            throw new BaseDeploymentException("appclient_0508", APPLICATION_CLIENT_NAME, (Throwable)((Object)e));
        }
        try {
            this.getFiles(appCfg, appDirName);
        }
        catch (IOException e) {
            throw new BaseDeploymentException("appclient_0513", new Object[]{applicationName}, (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new BaseDeploymentException("appclient_0517", APPLICATION_CLIENT_NAME, (Throwable)((Object)e));
        }
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.exitMtd(this + ".downloadApplicationFiles", new Object[]{applicationName, appConfig}));
        }
    }

    public void prepareStart(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".prepareStart", new Object[]{applicationName, appConfig}));
        }
        String appDirName = null;
        try {
            appDirName = this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (IOException ioEx) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0401", applicationName, (Throwable)ioEx);
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde));
            }
            throw bde;
        }
        Configuration configuration = null;
        try {
            configuration = appConfig.getSubConfiguration(APPLICATION_CLIENT_NAME);
        }
        catch (ConfigurationException conex) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0508", APPLICATION_CLIENT_NAME, (Throwable)((Object)conex));
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde));
            }
            throw bde;
        }
        ClientObject[] appClients = this.readAppClientsFromDir(appDirName, applicationName);
        int i = 0;
        while (i < appClients.length) {
            BaseDeploymentException bde;
            String clientName = appClients[i].getClientName();
            ApplicationClientDescriptor descriptor = appClients[i].getDescriptor();
            Context context = null;
            InitialContext rootContext = null;
            Context envContext = null;
            try {
                rootContext = new InitialContext(this.initCtxProps);
            }
            catch (NamingException nex) {
                bde = new BaseDeploymentException("appclient_0509", (Throwable)nex);
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde));
                }
                throw new BaseDeploymentException("appclient_0509", (Throwable)nex);
            }
            try {
                ApplicationClientContainer.createSubcontext(rootContext, "appclient-environment/" + applicationName + "/" + clientName);
                envContext = (Context)rootContext.lookup("appclient-environment/" + applicationName + "/" + clientName);
            }
            catch (NamingException nex) {
                bde = new BaseDeploymentException("appclient_0510", new Object[]{applicationName}, (Throwable)nex);
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde));
                }
                throw bde;
            }
            String ctxName = "appclients/" + applicationName + "/" + clientName + "/java:comp/";
            try {
                block30: {
                    ApplicationClientContainer.createSubcontext(rootContext, ctxName + "env");
                    try {
                        rootContext.bind(ctxName + "HandleDelegate", (Object)new AppClientHandleDelegate());
                    }
                    catch (NameAlreadyBoundException nabex) {
                        if (!LOCATION.beLogged(300)) break block30;
                        LOCATION.traceThrowableT(300, "Can not bind application client env context : " + ctxName + "HandleDelegate.", (Throwable)nabex);
                    }
                }
                context = (Context)rootContext.lookup(ctxName + "env");
            }
            catch (NamingException nex) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "Can not bind application client env context : " + ctxName + "env.", (Throwable)nex);
                }
                throw new BaseDeploymentException("appclient_0511", applicationName, (Throwable)nex);
            }
            Vector warnings = new Vector();
            this.loadBeanRefs(context, descriptor, applicationName, warnings);
            this.loadEnvEntries(context, applicationName, descriptor);
            this.loadResourceEnv(context, applicationName, descriptor, warnings);
            this.loadResources(context, applicationName, descriptor, warnings);
            if (warnings.size() > 0 && AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                int warningsCount = warnings.size();
                int j = 0;
                while (j < warningsCount) {
                    String msg = (String)warnings.elementAt(j);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logT(400, LOCATION, msg);
                    ++j;
                }
            }
            try {
                this.bind(envContext, "main-classname", appClients[i].getMainClassName());
            }
            catch (NamingException e) {
                BaseDeploymentException bde2 = new BaseDeploymentException("appclient_0512", new Object[]{"main class", appClients[i].getMainClassName(), applicationName}, (Throwable)e);
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde2));
                }
                throw bde2;
            }
            File destFile = null;
            try {
                destFile = new File(this.deployCommunicator.getMyWorkDirectory(applicationName) + File.separator + applicationName + File.separator + clientName + File.separator + appClients[i].getClientJar().getName());
            }
            catch (IOException ioEx) {
                BaseDeploymentException bde3 = new BaseDeploymentException("appclient_0513", new Object[]{applicationName}, (Throwable)ioEx);
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "Error creating file " + destFile.getAbsolutePath(), (Throwable)((Object)bde3));
                }
                throw bde3;
            }
            ++i;
        }
        this.clientJars.put(applicationName, appClients);
        int i2 = 0;
        while (i2 < appClients.length) {
            if (appClients == null || appClients[i2] == null) {
                return;
            }
            AppclientStarter starter = new AppclientStarter(appClients[i2].getApplicationName(), this.appFrame);
            ++i2;
        }
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.exitMtd(this + ".prepareStart", new Object[]{applicationName, appConfig}));
        }
    }

    public void commitStart(String applicationName) throws WarningException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".commitStart", new Object[]{applicationName}));
        }
    }

    public void rollbackStart(String applicationName) throws WarningException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".rollbackStart", new Object[]{applicationName}));
        }
    }

    public void prepareStop(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        NamingException nee22;
        Context rootCtx2;
        InitialContext root2;
        BaseWarningException wEx2;
        ClientObject[] appClients;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".prepareStop", new Object[]{applicationName, appConfig}));
        }
        if ((appClients = (ClientObject[])this.clientJars.remove(applicationName)) != null && appClients.length == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < appClients.length) {
                new AppclientStopper(appClients[i].getApplicationName(), this.appFrame, this.appRuntime).stopClient();
                ++i;
            }
            Object var6_5 = null;
            wEx2 = null;
        }
        catch (Throwable throwable) {
            NamingException nee22;
            Context rootCtx2;
            InitialContext root2;
            Object var6_6 = null;
            BaseWarningException wEx2 = null;
            try {
                root2 = new InitialContext(this.initCtxProps);
                rootCtx2 = (Context)root2.lookup("appclients");
                ApplicationClientContainer.destroy((Context)rootCtx2.lookup(applicationName));
                try {
                    rootCtx2.destroySubcontext(applicationName);
                }
                catch (NamingException nee22) {
                    if (LOCATION.beLogged(300)) {
                        LOCATION.traceThrowableT(300, "Could not destroy subcontext for application " + applicationName, (Throwable)nee22);
                    }
                }
            }
            catch (NamingException nex) {
                wEx2 = new BaseWarningException("appclient_0514", applicationName, (Throwable)nex);
            }
            try {
                root2 = new InitialContext(this.initCtxProps);
                rootCtx2 = (Context)root2.lookup("appclient-environment");
                ApplicationClientContainer.destroy((Context)rootCtx2.lookup(applicationName));
                try {
                    rootCtx2.destroySubcontext(applicationName);
                }
                catch (NamingException nee22) {
                    if (LOCATION.beLogged(300)) {
                        LOCATION.traceThrowableT(300, "Could not destroy subcontext for application " + applicationName, (Throwable)nee22);
                    }
                }
            }
            catch (NamingException nex) {
                wEx2 = new BaseWarningException("appclient_0514", applicationName, (Throwable)nex);
            }
            if (wEx2 != null) {
                if (LOCATION.beLogged(300)) {
                    LOCATION.traceThrowableT(300, null, (Throwable)wEx2);
                }
                throw wEx2;
            }
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, Log.exitMtd(this + ".prepareStop", new Object[]{applicationName, appConfig}));
            }
            throw throwable;
        }
        try {
            root2 = new InitialContext(this.initCtxProps);
            rootCtx2 = (Context)root2.lookup("appclients");
            ApplicationClientContainer.destroy((Context)rootCtx2.lookup(applicationName));
            try {
                rootCtx2.destroySubcontext(applicationName);
            }
            catch (NamingException nee22) {
                if (LOCATION.beLogged(300)) {
                    LOCATION.traceThrowableT(300, "Could not destroy subcontext for application " + applicationName, (Throwable)nee22);
                }
            }
        }
        catch (NamingException nex) {
            wEx2 = new BaseWarningException("appclient_0514", applicationName, (Throwable)nex);
        }
        try {
            root2 = new InitialContext(this.initCtxProps);
            rootCtx2 = (Context)root2.lookup("appclient-environment");
            ApplicationClientContainer.destroy((Context)rootCtx2.lookup(applicationName));
            try {
                rootCtx2.destroySubcontext(applicationName);
            }
            catch (NamingException nee22) {
                if (LOCATION.beLogged(300)) {
                    LOCATION.traceThrowableT(300, "Could not destroy subcontext for application " + applicationName, (Throwable)nee22);
                }
            }
        }
        catch (NamingException nex) {
            wEx2 = new BaseWarningException("appclient_0514", applicationName, (Throwable)nex);
        }
        if (wEx2 != null) {
            if (LOCATION.beLogged(300)) {
                LOCATION.traceThrowableT(300, null, (Throwable)wEx2);
            }
            throw wEx2;
        }
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.exitMtd(this + ".prepareStop", new Object[]{applicationName, appConfig}));
        }
    }

    public void commitStop(String applicationName) throws WarningException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".commitStop", new Object[]{applicationName}));
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public void remove(String applicationName) throws DeploymentException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, Log.enterMtd(this + ".remove", new Object[]{applicationName}));
        }
    }

    public String[] listElements(String applicationName) {
        return new String[0];
    }

    public String[] listApplications() {
        return new String[0];
    }

    public File[] getClientJar(String appName) {
        return null;
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return null;
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        WarningException we;
        block3: {
            we = null;
            this.remove(dInfo.getApplicationName());
            try {
                dInfo.getConfiguration().deleteConfiguration(APPLICATION_CLIENT_NAME);
            }
            catch (ConfigurationException cex) {
                if (!LOCATION.beLogged(300)) break block3;
                LOCATION.traceThrowableT(300, "Could not make update. ", (Throwable)((Object)cex));
            }
        }
        ApplicationDeployInfo appDeployInfo = this.deploy(archiveFiles, dInfo, props);
        if (we != null) {
            appDeployInfo.addWarnings(we.getWarnings());
        }
        return appDeployInfo;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    protected ApplicationClientDescriptor parseXMLFile(String fileName) throws BaseDeploymentException {
        try {
            return new ClientJar(fileName).getClientJarDescriptor();
        }
        catch (Exception e) {
            BaseDeploymentException bde = new BaseDeploymentException("appclient_0201", fileName, (Throwable)e);
            throw bde;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ApplicationClientDescriptor parseAltXML(File altddFile, String filename) throws BaseDeploymentException {
        block21: {
            block18: {
                block20: {
                    block17: {
                        xmlStream = null;
                        file = null;
                        altXMLPath_ArchAndName = null;
                        try {
                            try {
                                xmlStream = new BufferedInputStream(new FileInputStream(altddFile));
                                doc = ApplicationClientContainer.createStandardDOMParser().parse((InputStream)xmlStream);
                                clDescriptor = new J2EEApplicationDocument().loadDescriptor(doc);
                                xmlStream.close();
                                file = new ZipFile(filename);
                                entry = file.getEntry("META-INF/appclient-j2ee-engine.xml");
                                if (entry == null && (entry = file.getEntry("meta-inf/appclient-j2ee-engine.xml")) == null && (entry = file.getEntry("META-INF/APPCLIENT-J2EE-ENGINE.XML")) == null) {
                                    if (ApplicationClientContainer.LOCATION.beLogged(300)) {
                                        ApplicationClientContainer.LOCATION.logT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Alternative descriptor not found. An empty one will be used.");
                                    }
                                    var9_11 = clDescriptor;
                                    var11_13 = null;
                                    break block17;
                                }
                                altXMLPath_ArchAndName = filename + File.separator + entry.getName();
                                xmlStream = new BufferedInputStream(file.getInputStream(entry));
                                doc = ApplicationClientContainer.createStandardDOMParser().parse((InputStream)xmlStream);
                                new J2EEApplicationAdditionalDocument().readXML(doc, clDescriptor);
                                xmlStream.close();
                                file.close();
                                var9_12 = clDescriptor;
                                break block18;
                            }
                            catch (Exception e) {
                                bde = new BaseDeploymentException("appclient_0107", filename, (Throwable)e);
                                if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500) == false) throw bde;
                                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, ApplicationClientContainer.LOCATION, null, (Throwable)bde);
                                throw bde;
                            }
                        }
                        catch (Throwable var10_22) {
                            block19: {
                                var11_15 = null;
                                try {
                                    if (xmlStream != null) {
                                        xmlStream.close();
                                    }
                                }
                                catch (Exception e) {
                                    ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0105", altXMLPath_ArchAndName, (Throwable)e);
                                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block19;
                                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
                                }
                            }
                            try {
                                if (file == null) throw var10_22;
                                file.close();
                                throw var10_22;
                            }
                            catch (Exception e) {
                                ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0106", filename, (Throwable)e);
                                if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400) == false) throw var10_22;
                                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
                                throw var10_22;
                            }
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 284->295)] { 
lbl60:
                    // 1 sources

                    if (xmlStream != null) {
                        xmlStream.close();
                    }
                    break block20;
lbl63:
                    // 1 sources

                    catch (Exception e) {
                        ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0105", altXMLPath_ArchAndName, (Throwable)e);
                        if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block20;
                        AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 340->353)] { 
lbl70:
                // 1 sources

                if (file == null) return var9_11;
                file.close();
                return var9_11;
lbl73:
                // 1 sources

                catch (Exception e) {
                    ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0106", filename, (Throwable)e);
                    if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400) == false) return var9_11;
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
                }
                return var9_11;
            }
            var11_14 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 284->295)] { 
lbl82:
            // 1 sources

            if (xmlStream != null) {
                xmlStream.close();
            }
            break block21;
lbl85:
            // 1 sources

            catch (Exception e) {
                ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0105", altXMLPath_ArchAndName, (Throwable)e);
                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block21;
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
            }
        }
        ** try [egrp 3[TRYBLOCK] [3 : 340->353)] { 
lbl92:
        // 1 sources

        if (file == null) return var9_12;
        file.close();
        return var9_12;
lbl95:
        // 1 sources

        catch (Exception e) {
            ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0106", filename, (Throwable)e);
            if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400) == false) return var9_12;
            AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, ApplicationClientContainer.LOCATION, null, (Throwable)ioEx);
        }
        return var9_12;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMainClassName(String fileName) throws BaseDeploymentException {
        JarFile file = null;
        Attributes attr = null;
        try {
            try {
                file = new JarFile(fileName);
                attr = file.getManifest().getMainAttributes();
                String string = attr.getValue("Main-Class");
                Object var7_6 = null;
                try {
                    if (file == null) return string;
                    file.close();
                    return string;
                }
                catch (IOException e) {
                    com.sap.engine.services.appclient.exceptions.IOException ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0106", fileName, (Throwable)e);
                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) return string;
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)ioEx);
                }
                return string;
            }
            catch (IOException e) {
                BaseDeploymentException bde = new BaseDeploymentException("appclient_0115", new Object[]{"Main-Class", fileName}, (Throwable)e);
                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500)) throw bde;
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
                throw bde;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {}
            catch (IOException e) {
                com.sap.engine.services.appclient.exceptions.IOException ioEx = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0106", fileName, (Throwable)e);
                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) throw throwable;
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)ioEx);
                throw throwable;
            }
            if (file == null) throw throwable;
            file.close();
            throw throwable;
        }
    }

    private String getRootLookupName(ResourceReference resource, String earAppName, String clName) {
        String resourceType = resource.getResourceType();
        String rootLookupName = resource.getResourceLink();
        if (rootLookupName == null) {
            rootLookupName = resource.getResourceName();
        }
        if (resourceType.equals("javax.sql.DataSource")) {
            if (!rootLookupName.startsWith("jdbc/")) {
                rootLookupName = "jdbc/" + rootLookupName;
            }
        } else if (resourceType.equals("javax.jms.QueueConnectionFactory")) {
            rootLookupName = "jmsFactories/client/" + rootLookupName;
        } else if (resourceType.equals("javax.jms.TopicConnectionFactory")) {
            rootLookupName = "jmsFactories/client/" + rootLookupName;
        } else if (resourceType.equals("javax.mail.Session")) {
            rootLookupName = "java:comp/env/mail/MailSession";
        } else if (resourceType.equals("java.net.URL")) {
            rootLookupName = resource.getResourceName();
            rootLookupName = !rootLookupName.startsWith("url/") ? "url/application_client/" + rootLookupName + ": used by " + clName + " of " + earAppName : "url/application_client/" + rootLookupName.substring(4) + ": used by " + clName + " of " + earAppName;
        }
        return rootLookupName;
    }

    private void loadBeanRefs(Context context, ApplicationClientDescriptor descriptor, String applicationName, Vector warnings) throws BaseDeploymentException {
        EJBeanReference[] beanRefs = descriptor.getEJBeanReferences();
        if (beanRefs != null) {
            String realBeanName = null;
            String[] clientJars = null;
            HashSet<void> set = new HashSet<void>();
            HashSet<EJBeanReference> unresolvedSet = new HashSet<EJBeanReference>();
            int k = 0;
            while (k < beanRefs.length) {
                realBeanName = beanRefs[k].getReferenceJndiLink();
                if (realBeanName == null) {
                    if (this.appFrame.ejbManager != null) {
                        realBeanName = this.appFrame.ejbManager.resolveEjbRef(applicationName, warnings, beanRefs[k].getReferenceJndiLink(), beanRefs[k].getReferenceEjbLink(), beanRefs[k].getHomeInterfaceName(), beanRefs[k].getRemoteInterfaceName(), beanRefs[k].getReferenceName());
                        if (realBeanName == null) {
                            realBeanName = applicationName + "/" + beanRefs[k].getReferenceName();
                        } else {
                            warnings.add("WARNING! Appclient in application" + applicationName + " has no ejb-link to ejb-ref " + realBeanName + ".");
                        }
                    } else {
                        warnings.add("ejb references can not be resolved , because EJBManager is not availavle");
                    }
                }
                if (this.appFrame.ejbManager != null) {
                    clientJars = this.appFrame.ejbManager.getApplicationJars(applicationName, warnings, beanRefs[k].getReferenceJndiLink(), beanRefs[k].getReferenceEjbLink(), beanRefs[k].getHomeInterfaceName(), beanRefs[k].getRemoteInterfaceName(), beanRefs[k].getReferenceName());
                } else {
                    warnings.add("EJBManager is not available and ejb-client.jars will not be added into application client's class path");
                }
                if (clientJars != null) {
                    int s = 0;
                    while (s < clientJars.length) {
                        set.add(clientJars[s]);
                        ++s;
                    }
                } else {
                    unresolvedSet.add(beanRefs[k]);
                }
                try {
                    this.bind(context, "" + beanRefs[k].getReferenceName(), new Reference(realBeanName, "com.sap.engine.services.jndi.AppclientObjectFactory", ""));
                }
                catch (NamingException e) {
                    BaseDeploymentException bde = new BaseDeploymentException("appclient_0512", new Object[]{"ejb reference", beanRefs[k].getReferenceName(), applicationName}, (Throwable)e);
                    if (LOCATION.beLogged(500)) {
                        LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)((Object)bde));
                    }
                    throw bde;
                }
                ++k;
            }
            EJBeanReference[] unresRefs = ((AbstractCollection)unresolvedSet).toArray(new EJBeanReference[0]);
            String[] realNames = ((AbstractCollection)set).toArray(new String[0]);
            descriptor.setClientJars(realNames);
            descriptor.setUnresolvedRefs(unresRefs);
        }
    }

    private void loadEnvEntries(Context context, String applicationName, ApplicationClientDescriptor descriptor) throws BaseDeploymentException {
        EnvironmentEntry[] envEntries = descriptor.getEnvironmentProperties();
        if (envEntries != null) {
            String envName = null;
            Object envValue = null;
            int k = 0;
            while (k < envEntries.length) {
                envName = envEntries[k].getEntryName();
                if (envName != null) {
                    envValue = envEntries[k].getEntryValue();
                    try {
                        this.bind(context, envName, envValue);
                    }
                    catch (NamingException e) {
                        BaseDeploymentException bde = new BaseDeploymentException("appclient_0512", new Object[]{"env entry", envName, applicationName}, (Throwable)e);
                        if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(500)) {
                            AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(500, LOCATION, null, (Throwable)((Object)bde));
                        }
                        throw bde;
                    }
                }
                ++k;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadResources(Context context, String applicationName, ApplicationClientDescriptor descriptor, Vector warnings) throws BaseDeploymentException {
        resources = descriptor.getResourceReferences();
        if (resources != null) {
            resourceType = null;
            resourceName = null;
            k = 0;
            while (k < resources.length) {
                resourceType = resources[k].getResourceType();
                resourceName = resources[k].getResourceLink();
                if (resourceName == null) {
                    resourceName = resources[k].getResourceName();
                }
                if (resourceType.equals("javax.sql.DataSource") || resourceType.equals("javax.jms.QueueConnectionFactory") || resourceType.equals("javax.jms.TopicConnectionFactory") || resourceType.equals("javax.resource.cci.ConnectionFactory")) {
                    ref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "");
                    ref.add(new StringRefAddr("res-type", resourceType));
                    ref.add(new StringRefAddr("res-name", resourceName));
                    if (resources[k].getResourceAuthorization() != 2) {
                        ref.add(new StringRefAddr("res-auth", "Container"));
                    } else {
                        ref.add(new StringRefAddr("res-auth", "Application"));
                    }
                    if (resources[k].getResourceSharingScope() != 1) {
                        ref.add(new StringRefAddr("sharing-scope", "Unshareable"));
                    } else {
                        ref.add(new StringRefAddr("sharing-scope", "Shareable"));
                    }
                    ref.add(new StringRefAddr("client", "client"));
                    try {
                        this.bind(context, resources[k].getResourceName(), ref);
                    }
                    catch (NamingException e) {
                        bde = new BaseDeploymentException("appclient_0512", new Object[]{"resource reference", resources[k].getResourceName(), applicationName}, (Throwable)e);
                        if (ApplicationClientContainer.LOCATION.beLogged(500)) {
                            ApplicationClientContainer.LOCATION.traceThrowableT(500, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)bde);
                        }
                        throw bde;
                    }
                } else if (resourceType.equals("javax.mail.Session")) {
                    try {
                        this.bind(context, resources[k].getResourceName(), new Reference("java:comp/env/mail/MailSession", "com.sap.engine.services.jndi.AppclientObjectFactory", ""));
                    }
                    catch (NamingException e) {
                        bde = new BaseDeploymentException("appclient_0512", new Object[]{"resource reference", resources[k].getResourceName(), applicationName}, (Throwable)e);
                        if (ApplicationClientContainer.LOCATION.beLogged(300)) {
                            ApplicationClientContainer.LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)bde);
                        }
                        throw bde;
                    }
                } else if (resourceType.equals("java.net.URL")) {
                    url = null;
                    try {
                        url = resources[k].getResourceLink() == null ? new URL(resources[k].getResourceName()) : new URL(resources[k].getResourceLink());
                        this.bind(context, resources[k].getResourceName(), url);
                    }
                    catch (NamingException e) {
                        bde = new BaseDeploymentException("appclient_0512", new Object[]{"resource reference", resources[k].getResourceName(), applicationName}, (Throwable)e);
                        if (ApplicationClientContainer.LOCATION.beLogged(300)) {
                            ApplicationClientContainer.LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, null, (Throwable)bde);
                        }
                        throw bde;
                    }
                    catch (MalformedURLException e) {
                        if (ApplicationClientContainer.LOCATION.beLogged(300)) {
                            ApplicationClientContainer.LOCATION.traceThrowableT(300, AppClientResourceAccessor.DEFAULT_CATEGORY, "Appclient " + applicationName + " has incorrect URL resource reference " + url, (Throwable)e);
                        }
                        msg = "WARNING! Appclient " + applicationName + " has incorrect URL resource reference " + url + ".";
                        warnings.add(msg);
                        if (!ApplicationClientContainer.LOCATION.beLogged(300)) ** GOTO lbl72
                        ApplicationClientContainer.LOCATION.logT(300, msg);
                    }
                } else {
                    msg = "Unrecognized resource-type " + resourceType + " for application " + applicationName + ". Ignored!";
                    warnings.add(msg);
                    if (ApplicationClientContainer.LOCATION.beLogged(300)) {
                        ApplicationClientContainer.LOCATION.logT(300, msg);
                    }
                }
lbl72:
                // 8 sources

                ++k;
            }
        }
    }

    private void loadResourceEnv(Context context, String applicationName, ApplicationClientDescriptor descriptor, Vector warnings) throws BaseDeploymentException {
        ResourceEnvReference[] resourcesEnv = descriptor.getResourceEnvReference();
        if (resourcesEnv != null) {
            String resourceEnvType = null;
            String jndiName = null;
            int k = 0;
            while (k < resourcesEnv.length) {
                resourceEnvType = resourcesEnv[k].getType();
                jndiName = resourcesEnv[k].getJndiName();
                if (jndiName == null) {
                    jndiName = resourcesEnv[k].getName();
                }
                if (resourceEnvType.equals("javax.jms.Queue")) {
                    jndiName = "jmsQueues/" + jndiName;
                } else if (resourceEnvType.equals("javax.jms.Topic")) {
                    jndiName = "jmsTopics/" + jndiName;
                } else {
                    String msg = "Unrecognized resource-env-type " + resourceEnvType + " for application " + applicationName + ". Ignored!";
                    warnings.add(msg);
                    if (LOCATION.beLogged(300)) {
                        LOCATION.logT(300, msg);
                    }
                }
                try {
                    this.bind(context, resourcesEnv[k].getName(), new Reference(jndiName, "com.sap.engine.services.jndi.AppclientObjectFactory", ""));
                }
                catch (NamingException e) {
                    BaseDeploymentException bde = new BaseDeploymentException("appclient_0512", new Object[]{"resource env reference", resourcesEnv[k].getName(), descriptor.getDescription(), applicationName}, (Throwable)e);
                    if (LOCATION.beLogged(500)) {
                        LOCATION.traceThrowableT(500, null, (Throwable)((Object)bde));
                    }
                    throw bde;
                }
                ++k;
            }
        }
    }

    private void listFileNames(File dir, String relativePath, Vector result) {
        File[] fileList = dir.listFiles();
        if (fileList == null || fileList.length == 0) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            String currentFileName = relativePath + File.separatorChar + fileList[i].getName();
            if (fileList[i].isDirectory()) {
                if (!fileList[i].getName().equals("alt_dd")) {
                    this.listFileNames(fileList[i], currentFileName, result);
                }
            } else {
                result.add(currentFileName.substring(1));
            }
            ++i;
        }
    }

    private ClientObject[] readAppClientsFromDir(String appDirName, String applicationName) throws BaseDeploymentException {
        Vector<ClientObject> result = new Vector<ClientObject>();
        Vector storage = new Vector();
        this.listFileNames(new File(appDirName), "", storage);
        Enumeration e = storage.elements();
        while (e.hasMoreElements()) {
            String relativePath = (String)e.nextElement();
            if (relativePath.endsWith(".policy")) continue;
            if (!relativePath.endsWith(".jar")) {
                throw new BaseDeploymentException("appclient_0515", relativePath);
            }
            String jarName = appDirName + File.separatorChar + relativePath;
            File altddFile = new File(appDirName + File.separatorChar + "alt_dd" + File.separatorChar + relativePath.substring(0, relativePath.length() - 3) + "xml");
            ApplicationClientDescriptor descriptor = null;
            descriptor = altddFile.exists() ? this.parseAltXML(altddFile, jarName) : this.parseXMLFile(jarName);
            result.add(new ClientObject(new File(jarName), applicationName, descriptor, this.getMainClassName(jarName)));
        }
        return result.toArray(new ClientObject[0]);
    }

    public static void destroy(Context root) throws NamingException {
        NameClassPair pair = null;
        NamingEnumeration<NameClassPair> ne = root.list("");
        while (ne.hasMoreElements()) {
            pair = (NameClassPair)ne.nextElement();
            if (ApplicationClientContainer.isContext(pair.getClassName())) {
                try {
                    ApplicationClientContainer.destroy((Context)root.lookup(pair.getName()));
                    root.destroySubcontext(pair.getName());
                }
                catch (ContextNotEmptyException cnee) {
                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) continue;
                    BaseDeploymentException bde = new BaseDeploymentException("appclient_0519", (Throwable)cnee);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)((Object)bde));
                }
                continue;
            }
            root.unbind("+/" + pair.getName());
        }
    }

    private static boolean isContext(String nm) {
        return nm.indexOf("javax.naming.Context") != -1 || nm.indexOf("javax.naming.directory.DirContext") != -1;
    }

    public static void cleanAll(Context root, String contextName) {
        block5: {
            BaseDeploymentException bde;
            block4: {
                try {
                    ApplicationClientContainer.destroy((Context)root.lookup(contextName));
                }
                catch (NamingException nme) {
                    if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block4;
                    bde = new BaseDeploymentException("appclient_0519", (Throwable)nme);
                    AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)((Object)bde));
                }
            }
            try {
                ApplicationClientContainer.destroyContext(root, contextName);
            }
            catch (NamingException ne) {
                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block5;
                bde = new BaseDeploymentException("appclient_0519", (Throwable)ne);
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)((Object)bde));
            }
        }
    }

    private static void destroyContext(Context root, String contextName) throws NamingException {
        block5: {
            if (contextName.equals("")) {
                return;
            }
            int index = contextName.indexOf(47);
            try {
                if (index == -1) {
                    root.destroySubcontext(contextName);
                } else {
                    String s = contextName.substring(0, index);
                    ApplicationClientContainer.destroyContext((Context)root.lookup(contextName.substring(0, index)), contextName.substring(index + 1));
                    root.destroySubcontext(s);
                }
            }
            catch (ContextNotEmptyException cne) {
                if (!AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) break block5;
                BaseDeploymentException bde = new BaseDeploymentException("appclient_0519", (Throwable)cne);
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)((Object)bde));
            }
        }
    }

    protected void deleteTempDir(String appName) throws WarningException {
        try {
            File tempDir = new File(this.deployCommunicator.getMyWorkDirectory(appName) + File.separator + "Temp");
            File[] files = tempDir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
            }
            tempDir.delete();
        }
        catch (IOException ioEx) {
            BaseWarningException bwe = new BaseWarningException("appclient_0116", (Throwable)ioEx);
            if (AppClientResourceAccessor.DEFAULT_CATEGORY.beLogged(400)) {
                AppClientResourceAccessor.DEFAULT_CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)bwe);
            }
            throw bwe;
        }
    }

    private void bind(Context root, String name, Object obj) throws NamingException {
        Context ic = root;
        Context current = null;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "Binding " + name + "<->" + obj);
        }
        try {
            String s;
            StringTokenizer st = new StringTokenizer(name, "/");
            while (true) {
                s = st.nextToken();
                if (!st.hasMoreTokens()) break;
                try {
                    current = (Context)ic.lookup(s);
                }
                catch (Exception e) {
                    current = ic.createSubcontext(s);
                }
                ic = current;
            }
            ic.rebind(s, obj);
        }
        catch (NamingException ex) {
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, "Error in binding of object " + name + ". Reason:", (Throwable)ex);
            }
            throw ex;
        }
    }

    private static void createSubcontext(Context root, String name) throws NamingException {
        Context current = root;
        String temp = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            try {
                current = (Context)current.lookup(temp);
            }
            catch (NamingException ne) {
                try {
                    current = current.createSubcontext(temp);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)current.lookup(temp);
                }
            }
        }
    }

    private void unbind(Context root, String name) throws NamingException {
        int index = name.lastIndexOf(47);
        if (index == -1) {
            root.unbind("/" + name);
        } else {
            ((Context)root.lookup(name.substring(0, index))).unbind("/" + name.substring(index + 1));
            ApplicationClientContainer.destroyContext(root, name.substring(0, index));
        }
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        throw new BaseDeploymentException("appclient_0516");
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    private void getFiles(Configuration cfg, String localPath) throws IOException, ConfigurationException {
        if (cfg != null) {
            Map fileEntries = cfg.getAllFileEntries();
            if (!fileEntries.isEmpty()) {
                Set keySet = fileEntries.keySet();
                Iterator iter = keySet.iterator();
                while (iter.hasNext()) {
                    this.getFile(cfg, (String)iter.next(), localPath);
                }
            }
            String[] allNames = cfg.getAllSubConfigurationNames();
            int k = 0;
            while (k < allNames.length) {
                String currentName = allNames[k];
                String newLocalPath = localPath + File.separatorChar + currentName;
                new File(newLocalPath).mkdirs();
                this.getFiles(cfg.getSubConfiguration(currentName), newLocalPath);
                ++k;
            }
        }
    }

    private void getFile(Configuration cfg, String filename, String localPath) throws IOException, ConfigurationException {
        FileOutputStream fileout = new FileOutputStream(localPath + File.separatorChar + filename);
        InputStream in = cfg.getFile(filename);
        byte[] buf = new byte[1024];
        int received = 0;
        while ((received = in.read(buf)) != -1) {
            fileout.write(buf, 0, received);
        }
        fileout.close();
    }

    public void setRuntimeImpl(AppclientRuntimeImpl appRuntime) {
        this.appRuntime = appRuntime;
    }

    private static StandardDOMParser createStandardDOMParser() {
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$appclient$server$ApplicationClientContainer == null ? (class$com$sap$engine$services$appclient$server$ApplicationClientContainer = ApplicationClientContainer.class$("com.sap.engine.services.appclient.server.ApplicationClientContainer")) : class$com$sap$engine$services$appclient$server$ApplicationClientContainer).getClassLoader());
            StandardDOMParser standardDOMParser = new StandardDOMParser();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMParser;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

