/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.server;

import com.sap.engine.services.appclient.exceptions.BaseDeploymentException;
import com.sap.engine.services.appclient.server.AppClientUtils;
import com.sap.engine.services.appclient.server.AppclientRuntimeImpl;
import com.sap.engine.services.appclient.server.ApplicationClientFrame;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AppclientStarter {
    private static AppClientUtils appClients = new AppClientUtils();
    private String appClientName = null;
    private String appClientArgs = null;
    private String appClientDumpFile = null;
    private ApplicationClientFrame appFrame = null;

    public AppclientStarter(String applicationClientName, ApplicationClientFrame appFrame) {
        this.appClientName = applicationClientName;
        this.appFrame = appFrame;
    }

    public void setDumpFile(String dumpFileName) {
        this.appClientDumpFile = dumpFileName;
    }

    public void setArgs(String args) {
        this.appClientArgs = args;
    }

    public void startClient() throws BaseDeploymentException {
        try {
            AppclientRuntimeImpl app = this.appFrame.appRuntime;
            if (this.appClientName == null) {
                throw new BaseDeploymentException("appclient_0500");
            }
            if (this.appClientDumpFile == null) {
                int clNumber = app.runClient(this.appClientName, this.appClientArgs);
                AppClientUtils.mapping.put(clNumber, this.appClientName);
            } else {
                int n = app.processClient(this.appClientName, this.appClientArgs, this.appClientDumpFile);
            }
        }
        catch (RemoteException re) {
            throw new BaseDeploymentException("appclient_0501", this.appClientName, (Throwable)re);
        }
    }

    private Remote getAppClient() throws NamingException {
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        InitialContext ctx = new InitialContext(p);
        return (Remote)ctx.lookup("appclient");
    }
}

