/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.descriptor.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.xml.EnvironmentXmlUtil;
import com.sap.engine.services.appclient.exceptions.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import java.io.File;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class J2EEApplicationDocument {
    public static final String APPLICATION_TRANSACTION = "Application";
    public static final String CONTAINER_TRANSACTION = "Container";
    public static final String SHAREABLE = "Shareable";
    public static final String UNSHAREABLE = "Unshareable";
    public static final String dtdUrl = "<!DOCTYPE application-client PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN\" \"http://java.sun.com/dtd/application-client_1_3.dtd\">";
    public static final String dtd = "<!DOCTYPE application-client [\n<!ELEMENT application-client (icon?, display-name, description?, env-entry*, ejb-ref*, resource-ref*, resource-env-ref*, callback-handler?)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-sharing-scope?)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-sharing-scope (#PCDATA)>\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name, resource-env-ref-type)>\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n<!ELEMENT callback-handler (#PCDATA)>\n<!ATTLIST application-client id ID #IMPLIED>\n<!ATTLIST callback-handler id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED> \n]>";
    protected Document mainDocument;
    protected Element docElement;
    protected Element clients;
    private String illegalArgumentException = null;

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public String getDTD() {
        return dtd;
    }

    public void setMainDocument(Document document) throws WrongStructureException {
        if (!document.getDocumentElement().getNodeName().equals("application-client")) {
            throw new WrongStructureException("appclient_0200");
        }
        this.mainDocument = document;
        this.docElement = document.getDocumentElement();
        NodeList list = this.docElement.getElementsByTagName("application-client");
        if (list.item(0) != null) {
            this.clients = (Element)list.item(0);
        }
    }

    public Element getDocElement() {
        return this.docElement;
    }

    public Element getClientsElement() {
        return this.clients;
    }

    public void init() {
        this.mainDocument = J2EEApplicationDocument.createDOMDocument();
        this.clients = this.mainDocument.createElement("aplication-client");
        this.mainDocument.appendChild(this.clients);
    }

    public Element addClientElement(ApplicationClientDescriptor descr) throws WrongStructureException {
        if (descr != null) {
            Element entity = this.loadClientElement(descr);
            this.clients.appendChild(entity);
            return entity;
        }
        throw new WrongStructureException("appclient_0201");
    }

    public Document loadDocument(ApplicationClientDescriptor descr) {
        this.mainDocument = J2EEApplicationDocument.createDOMDocument();
        this.mainDocument.appendChild(this.loadClientElement(descr));
        return this.mainDocument;
    }

    public Element loadClientElement(ApplicationClientDescriptor descriptor) {
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        EJBeanReference[] refs;
        String beanDescription;
        String display;
        Element entityElement = this.mainDocument.createElement("application-client");
        if (descriptor.getSmallIcon() != null || descriptor.getLargeIcon() != null) {
            Element iconElement = this.mainDocument.createElement("icon");
            entityElement.appendChild(iconElement);
            if (descriptor.getSmallIcon() != null) {
                String smallIcon = descriptor.getSmallIcon().getFileName();
                String smallIconPr = this.processString(smallIcon, true);
                this.load(iconElement, smallIconPr, "small-icon");
            }
            if (descriptor.getLargeIcon() != null) {
                String largeIcon = descriptor.getLargeIcon().getFileName();
                String largeIconPr = this.processString(largeIcon, true);
                this.load(iconElement, largeIcon, "large-icon");
            }
        }
        if ((display = descriptor.getDisplayName()) != null) {
            this.load(entityElement, display, "display-name");
        }
        if ((beanDescription = descriptor.getDescription()) != null) {
            this.load(entityElement, beanDescription, "description");
        }
        EnvironmentXmlUtil envXMLUtils = new EnvironmentXmlUtil();
        EnvironmentEntry[] envEntries = descriptor.getEnvironmentProperties();
        if (envEntries != null) {
            envXMLUtils.loadEnvEntr(this.mainDocument, entityElement, envEntries);
        }
        if ((refs = descriptor.getEJBeanReferences()) != null) {
            envXMLUtils.loadEjbRefs(this.mainDocument, entityElement, refs);
        }
        if ((resRefs = descriptor.getResourceReferences()) != null) {
            envXMLUtils.loadResourceRefs(this.mainDocument, entityElement, resRefs);
        }
        if ((resEnvRefs = descriptor.getResourceEnvReference()) != null) {
            envXMLUtils.loadResourceEnvRefs(this.mainDocument, entityElement, resEnvRefs);
        }
        this.illegalArgumentException = envXMLUtils.getErrors();
        if (descriptor.getCallBack() != null) {
            String callback = descriptor.getCallBack();
            this.load(entityElement, callback, "callback-handler");
        }
        return entityElement;
    }

    protected void load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    public ApplicationClientDescriptor loadDescriptor(Document doc) throws WrongStructureException {
        Element elm = doc.getDocumentElement();
        return this.loadApplicationDescriptor(elm);
    }

    public ApplicationClientDescriptor loadApplicationDescriptor(Element element) throws WrongStructureException {
        if (!element.getNodeName().equals("application-client")) {
            throw new WrongStructureException("appclient_0202", new Object[]{"ApplicationClientDescriptor", "application-client"});
        }
        ApplicationClientDescriptor descriptor = new ApplicationClientDescriptor();
        NodeList list = element.getChildNodes();
        if (list != null) {
            Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
            Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
            Vector<ResourceReference> resRefs = new Vector<ResourceReference>();
            Vector<ResourceEnvReference> resEnvRefs = new Vector<ResourceEnvReference>();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    Element el = (Element)list.item(i);
                    String tag = el.getNodeName();
                    Element parent = (Element)el.getParentNode();
                    String parentTag = parent.getNodeName();
                    if (tag.equals("description") && parentTag.equals("application-client")) {
                        String description = this.getTextValue(el);
                        if (!description.equals("")) {
                            descriptor.setDescription(description);
                        }
                    } else if (tag.equals("display-name")) {
                        String displayName = this.getTextValue(el);
                        if (!displayName.equals("")) {
                            descriptor.setDisplayName(displayName);
                        }
                    } else if (tag.equals("icon") && parentTag.equals("application-client")) {
                        this.getIcons(el, descriptor);
                    } else if (tag.equals("env-entry")) {
                        EnvironmentEntry envEntry = this.getEnvEntry(el);
                        if (envEntry != null) {
                            envEntries.addElement(envEntry);
                        }
                    } else if (tag.equals("ejb-ref")) {
                        EJBeanReference ejbRef = this.getEjbRef(el);
                        if (ejbRef != null) {
                            ejbRefs.addElement(ejbRef);
                        }
                    } else if (tag.equals("resource-ref")) {
                        ResourceReference resRef = this.getResourceRef(el);
                        if (resRef != null) {
                            resRefs.addElement(resRef);
                        }
                    } else if (tag.equals("resource-env-ref")) {
                        ResourceEnvReference resEnvRef = this.getResourceEnvRef(el);
                        if (resEnvRef != null) {
                            resEnvRefs.addElement(resEnvRef);
                        }
                    } else if (tag.equals("callback-handler")) {
                        String callback = this.getTextValue(el);
                        if (!callback.equals("")) {
                            descriptor.setCallBack(callback);
                        }
                    } else {
                        throw new WrongStructureException("appclient_0204", tag);
                    }
                }
                ++i;
            }
            if (envEntries.size() != 0) {
                Object[] entries = new EnvironmentEntry[envEntries.size()];
                envEntries.copyInto(entries);
                descriptor.setEnvironmentProperties((EnvironmentEntry[])entries);
            }
            if (ejbRefs.size() != 0) {
                Object[] EJBeanRefs = new EJBeanReference[ejbRefs.size()];
                ejbRefs.copyInto(EJBeanRefs);
                descriptor.setEJBeanReferences((EJBeanReference[])EJBeanRefs);
            }
            if (resRefs.size() != 0) {
                Object[] resourceRefs = new ResourceReference[resRefs.size()];
                resRefs.copyInto(resourceRefs);
                descriptor.setResourceReferences((ResourceReference[])resourceRefs);
            }
            if (resEnvRefs.size() != 0) {
                Object[] resourceEnvRefs = new ResourceEnvReference[resEnvRefs.size()];
                resEnvRefs.copyInto(resourceEnvRefs);
                descriptor.setResourceEnvReferences((ResourceEnvReference[])resourceEnvRefs);
            }
        }
        return descriptor;
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = "";
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = str2 + ch;
            ++i;
        }
        return str2;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    protected void getIcons(Element elmnt, ApplicationClientDescriptor descriptor) throws WrongStructureException {
        NodeList entryList = elmnt.getChildNodes();
        if (entryList != null) {
            int k = 0;
            while (k < entryList.getLength()) {
                if (entryList.item(k).getNodeType() == 1) {
                    Element el = (Element)entryList.item(k);
                    String tag = el.getNodeName();
                    if (tag.equals("small-icon")) {
                        String smallIcon = this.getTextValue(el);
                        if (!smallIcon.equals("")) {
                            String smallIconPr = this.processString(smallIcon, false);
                            descriptor.setSmallIcon(new SerializableFile(smallIconPr));
                        }
                    } else if (tag.equals("large-icon")) {
                        String largeIcon = this.getTextValue(el);
                        if (!largeIcon.equals("")) {
                            String largeIconPr = this.processString(largeIcon, false);
                            descriptor.setLargeIcon(new SerializableFile(largeIconPr));
                        }
                    } else {
                        throw new WrongStructureException("appclient_0204", tag);
                    }
                }
                ++k;
            }
        }
    }

    protected EnvironmentEntry getEnvEntry(Element elmnt) {
        NodeList entryList = elmnt.getChildNodes();
        if (entryList != null) {
            EnvironmentEntry envEntry = new EnvironmentEntry();
            String entryType = new String("");
            int k = 0;
            while (k < entryList.getLength()) {
                if (entryList.item(k).getNodeType() == 1) {
                    String entryValueStr;
                    Element envEl = (Element)entryList.item(k);
                    String envTag = envEl.getNodeName();
                    if (envTag.equals("description")) {
                        String description = this.getTextValue(envEl);
                        if (!description.equals("")) {
                            envEntry.setEntryDescription(description);
                        }
                    } else if (envTag.equals("env-entry-name")) {
                        String entryName = this.getTextValue(envEl);
                        if (!entryName.equals("")) {
                            envEntry.setEntryName(entryName);
                        }
                    } else if (envTag.equals("env-entry-type")) {
                        entryType = this.getTextValue(envEl);
                        if (!entryType.equals("")) {
                            envEntry.setEntryType(entryType);
                        }
                    } else if (envTag.equals("env-entry-value") && !(entryValueStr = this.getTextValue(envEl)).equals("")) {
                        if (entryValueStr.startsWith("${")) {
                            envEntry.setEntryValue(entryValueStr);
                        } else {
                            Object entryValue;
                            if (entryType.equals("java.lang.Double")) {
                                entryValue = new Double(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Integer")) {
                                entryValue = new Integer(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Boolean")) {
                                entryValue = new Boolean(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Float")) {
                                entryValue = new Float(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Short")) {
                                entryValue = new Short(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Byte")) {
                                entryValue = new Byte(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Long")) {
                                entryValue = new Long(entryValueStr);
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.String")) {
                                entryValue = entryValueStr;
                                envEntry.setEntryValue(entryValue);
                            }
                            if (entryType.equals("java.lang.Character")) {
                                entryValue = new Character(entryValueStr.charAt(0));
                                envEntry.setEntryValue(entryValue);
                            }
                        }
                    }
                }
                ++k;
            }
            return envEntry;
        }
        return null;
    }

    protected EJBeanReference getEjbRef(Element elmnt) {
        NodeList refsList = elmnt.getChildNodes();
        if (refsList != null) {
            EJBeanReference ejbRef = new EJBeanReference();
            int k = 0;
            while (k < refsList.getLength()) {
                if (refsList.item(k).getNodeType() == 1) {
                    String link;
                    Element nextEl = (Element)refsList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            ejbRef.setReferenceDescription(description);
                        }
                    } else if (nextElTag.equals("ejb-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            ejbRef.setReferenceName(name);
                        }
                    } else if (nextElTag.equals("ejb-ref-type")) {
                        String type = this.getTextValue(nextEl);
                        if (type.equals("Entity")) {
                            ejbRef.setType(1);
                        } else if (type.equals("Session")) {
                            ejbRef.setType(0);
                        }
                    } else if (nextElTag.equals("home")) {
                        String home = this.getTextValue(nextEl);
                        if (!home.equals("")) {
                            ejbRef.setHomeInterfaceName(home);
                        }
                    } else if (nextElTag.equals("remote")) {
                        String remote = this.getTextValue(nextEl);
                        if (!remote.equals("")) {
                            ejbRef.setRemoteInterfaceName(remote);
                        }
                    } else if (nextElTag.equals("ejb-link") && !(link = this.getTextValue(nextEl)).equals("")) {
                        ejbRef.setReferenceEjbLink(link);
                    }
                }
                ++k;
            }
            return ejbRef;
        }
        return null;
    }

    protected ResourceReference getResourceRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        if (resList != null) {
            ResourceReference resRef = new ResourceReference();
            int k = 0;
            while (k < resList.getLength()) {
                if (resList.item(k).getNodeType() == 1) {
                    Element nextEl = (Element)resList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            resRef.setResourceDescription(description);
                        }
                    } else if (nextElTag.equals("res-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            resRef.setResourceName(name);
                        }
                    } else if (nextElTag.equals("res-type")) {
                        String type = this.getTextValue(nextEl);
                        if (!type.equals("")) {
                            resRef.setResourceType(type);
                        }
                    } else if (nextElTag.equals("res-auth")) {
                        String authStr = this.getTextValue(nextEl);
                        if (authStr.equals(APPLICATION_TRANSACTION)) {
                            resRef.setResourceAuthorization(3);
                        } else if (authStr.equals(CONTAINER_TRANSACTION)) {
                            resRef.setResourceAuthorization(2);
                        }
                    } else if (nextElTag.equals("res-sharing-scope")) {
                        String sharingScope = this.getTextValue(nextEl);
                        if (sharingScope.equals(SHAREABLE)) {
                            resRef.setResourceSharingScope(0);
                        } else if (sharingScope.equals(UNSHAREABLE)) {
                            resRef.setResourceSharingScope(1);
                        }
                    }
                }
                ++k;
            }
            return resRef;
        }
        return null;
    }

    protected ResourceEnvReference getResourceEnvRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        if (resList != null) {
            ResourceEnvReference resRef = new ResourceEnvReference();
            int k = 0;
            while (k < resList.getLength()) {
                if (resList.item(k).getNodeType() == 1) {
                    String type;
                    Element nextEl = (Element)resList.item(k);
                    String nextElTag = nextEl.getNodeName();
                    if (nextElTag.equals("description")) {
                        String description = this.getTextValue(nextEl);
                        if (!description.equals("")) {
                            resRef.setDescription(description);
                        }
                    } else if (nextElTag.equals("resource-env-ref-name")) {
                        String name = this.getTextValue(nextEl);
                        if (!name.equals("")) {
                            resRef.setName(name);
                        }
                    } else if (nextElTag.equals("resource-env-ref-type") && !(type = this.getTextValue(nextEl)).equals("")) {
                        resRef.setType(type);
                    }
                }
                ++k;
            }
            return resRef;
        }
        return null;
    }

    public String getIllegalArgumentException() {
        return this.illegalArgumentException;
    }

    private static Document createDOMDocument() {
        Document document = null;
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        try {
            document = StandardDOMParser.createDocument();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
        return document;
    }
}

