/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.appclient.descriptor;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jar.DependenceJarUtils;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationAdditionalDocument;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationDocument;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;

public class MakeClientJar
extends DependenceJarUtils {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$appclient$descriptor$MakeClientJar == null ? (class$com$sap$engine$services$appclient$descriptor$MakeClientJar = MakeClientJar.class$("com.sap.engine.services.appclient.descriptor.MakeClientJar")) : class$com$sap$engine$services$appclient$descriptor$MakeClientJar));
    ApplicationClientDescriptor clDescriptor = null;
    ApplicationClientDescriptor additionalDescriptor = null;
    String mappingXml = null;
    static /* synthetic */ Class class$com$sap$engine$services$appclient$descriptor$MakeClientJar;

    public MakeClientJar() {
    }

    public MakeClientJar(ApplicationClientDescriptor descriptor) {
        this.clDescriptor = descriptor;
    }

    public void setDescriptor(ApplicationClientDescriptor descriptor) {
        this.clDescriptor = descriptor;
    }

    public void writeAdditionalEntries(JarOutputStream zip) throws com.sap.engine.services.appclient.exceptions.IOException {
        StandardDOMWriter writer = new StandardDOMWriter();
        J2EEApplicationDocument doc = new J2EEApplicationDocument();
        Document document = null;
        byte[] buffer = null;
        ZipEntry zEntry = null;
        CRC32 crc = null;
        try {
            if (this.clDescriptor != null) {
                document = doc.loadDocument(this.clDescriptor);
                String tmpFileName = SystemProperties.getProperty("user.dir") + File.separator + "tmp_application_client.xml";
                File tmpFile = new File(tmpFileName);
                writer.write(document, tmpFileName, doc.getDTD(), "UTF-8");
                zEntry = new ZipEntry("META-INF/application-client.xml");
                buffer = this.getBytes(new FileInputStream(tmpFileName));
                if (buffer != null) {
                    zEntry.setMethod(0);
                    zEntry.setSize(buffer.length);
                    crc = new CRC32();
                    crc.update(buffer);
                    zEntry.setCrc(crc.getValue());
                    zip.putNextEntry(zEntry);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                    tmpFile.delete();
                }
            }
            writer = new StandardDOMWriter();
            J2EEApplicationAdditionalDocument addDoc = new J2EEApplicationAdditionalDocument();
            document = null;
            buffer = null;
            zEntry = null;
            crc = null;
            if (this.clDescriptor != null) {
                document = addDoc.loadClientAdditionalElements(this.clDescriptor);
                if (addDoc.toSave) {
                    String tmpFileName = SystemProperties.getProperty("user.dir") + File.separator + "tmp_application_add_client.xml";
                    File tmpFile = new File(tmpFileName);
                    writer.write(document, tmpFileName, doc.getDTD(), "UTF-8");
                    zEntry = new ZipEntry("META-INF/appclient-j2ee-engine.xml");
                    buffer = this.getBytes(new FileInputStream(tmpFileName));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                    }
                }
            }
            if (!this.hasManifest(this.infoObjects)) {
                zEntry = new ZipEntry("META-INF/manifest.mf");
                zEntry.setSize(0L);
                crc = new CRC32();
                buffer = new byte[]{};
                crc.update(buffer);
                zEntry.setCrc(crc.getValue());
                zip.putNextEntry(zEntry);
                zip.write(buffer, 0, buffer.length);
                zip.closeEntry();
            }
        }
        catch (IOException e) {
            throw new com.sap.engine.services.appclient.exceptions.IOException("appclient_0110", e);
        }
    }

    public void makeJar(String jarName, Vector infos) throws com.sap.engine.services.appclient.exceptions.IOException {
        this.setJarFile(jarName);
        this.setInfoObjects(infos);
        if (infos == null || infos.isEmpty()) {
            throw new com.sap.engine.services.appclient.exceptions.IOException("appclient_0111", jarName);
        }
        try {
            this.makeJarFromFiles(jarName, infos);
        }
        catch (IOException e) {
            com.sap.engine.services.appclient.exceptions.IOException ioe = new com.sap.engine.services.appclient.exceptions.IOException("appclient_0112", jarName, (Throwable)e);
            ioe.log();
            throw ioe;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(InputStream in) {
        if (in == null) {
            return null;
        }
        byte[] buff = null;
        ByteArrayOutputStream b = null;
        try {
            int c;
            b = in.available() > 1 ? new ByteArrayOutputStream(in.available()) : new ByteArrayOutputStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            while ((c = bin.read()) != -1) {
                void var3_6;
                b.write((int)var3_6);
            }
            b.flush();
            b.close();
            bin.close();
            buff = b.toByteArray();
            in.close();
        }
        catch (Exception exc) {
            LOCATION.traceThrowableT(500, "Error reading input stream. ", (Throwable)exc);
        }
        return buff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

