/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Mutex;

public class PriorityMutex
extends Mutex {
    Object priorityMonitor = new Object();
    protected int priorityWaiting = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireWithPriority() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.priorityMonitor;
        synchronized (object) {
            ++this.priorityWaiting;
            while (true) {
                PriorityMutex priorityMutex = this;
                synchronized (priorityMutex) {
                    if (!this.isInUse) {
                        this.isInUse = true;
                        --this.priorityWaiting;
                        return;
                    }
                }
                try {
                    this.priorityMonitor.wait();
                }
                catch (InterruptedException e) {
                    --this.priorityWaiting;
                    this.priorityMonitor.notify();
                    throw e;
                }
            }
        }
    }

    public void release() {
        Object object = this.priorityMonitor;
        synchronized (object) {
            if (this.priorityWaiting > 0) {
                PriorityMutex priorityMutex = this;
                synchronized (priorityMutex) {
                    this.isInUse = false;
                }
                this.priorityMonitor.notify();
            } else {
                super.release();
            }
        }
    }
}

