/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;

public class CountDown
implements Sync {
    protected final int initialCount;
    protected int countToRelease;

    public CountDown(int count) {
        this.countToRelease = this.initialCount = count;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            while (this.countToRelease > 0) {
                this.wait();
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            if (this.countToRelease <= 0) {
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            do {
                this.wait(waitTime);
                if (this.countToRelease > 0) continue;
                boolean bl = true;
                return bl;
            } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
            boolean bl = false;
            return bl;
        }
    }

    public synchronized void release() {
        if (--this.countToRelease == 0) {
            this.notifyAll();
        }
    }

    public int initialCount() {
        return this.initialCount;
    }

    public synchronized int currentCount() {
        return this.countToRelease;
    }
}

