/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.cache;

import com.sap.engine.lib.util.cache.CacheGroup;
import com.sap.engine.lib.util.cache.CacheListener;
import com.sap.engine.lib.util.cache.SoftValue;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class SoftValueHashMap {
    protected CacheListener cacheListener = null;
    private Hashtable hash;
    private CacheGroup group = null;

    public SoftValueHashMap(int initialCapacity, float loadFactor, CacheGroup _group) {
        this.hash = new Hashtable(initialCapacity, loadFactor);
        this.group = _group;
    }

    public SoftValueHashMap(int initialCapacity, CacheGroup _group) {
        this.hash = new Hashtable(initialCapacity);
        this.group = _group;
    }

    public SoftValueHashMap(CacheGroup _group) {
        this.hash = new Hashtable();
        this.group = _group;
    }

    public int size() {
        return this.hash.size();
    }

    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.hash.containsValue(value);
    }

    public Object get(Object key) {
        SoftValue obj = (SoftValue)this.hash.get(key);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public Object put(Object key, Object value, boolean _alwaysInWeak) {
        return this.hash.put(key, new SoftValue(value, this.group.queue, key, this, _alwaysInWeak));
    }

    public Object remove(Object key) {
        return this.hash.remove(key);
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void clear() {
        this.hash.clear();
    }

    public Set keySet() {
        return this.hash.keySet();
    }

    public Collection values() {
        return this.hash.values();
    }

    public Set entrySet() {
        return this.hash.entrySet();
    }

    protected void registerListener(CacheListener _cacheListener) {
        this.cacheListener = _cacheListener;
    }
}

