/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.domain;

import com.sap.engine.lib.security.PermissionStorageConnector;
import com.sap.engine.lib.security.domain.UnresolvedPermissionParser;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Permission;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PermissionsFactory {
    private static Properties aliases = null;
    private static Properties classNames = null;
    private static Hashtable permissionActions = null;
    private static Hashtable permissionNames = null;
    private static PermissionStorageConnector connector = null;
    private static Field[] PERMISSION_FIELDS = null;
    static /* synthetic */ Class class$java$lang$String;

    public static void setPermissionStorageConnector(PermissionStorageConnector storageConnector) {
        connector = storageConnector;
    }

    public static String getAlias(String className) {
        String result = classNames.getProperty(className);
        return result != null ? result : className;
    }

    public static String[] getAliases() {
        Object[] array = ((Hashtable)aliases).keySet().toArray();
        String[] result = new String[array.length];
        System.arraycopy(array, 0, result, 0, result.length);
        return result;
    }

    public static String getClassName(String alias) {
        String result = aliases.getProperty(alias.toLowerCase());
        return result != null ? result : alias;
    }

    public static String[] getPermissionNames(String permissionType) {
        return (String[])permissionNames.get(permissionType);
    }

    public static String[] getPermissionActions(String permissionType) {
        return (String[])permissionActions.get(permissionType);
    }

    public static Permission createPermission(String permission, String name, String[] actions, ClassLoader loader) throws SecurityException {
        try {
            String className = null;
            String actionsPermission = "";
            className = PermissionsFactory.getClassName(permission);
            if (className == null) {
                className = permission;
            }
            if (actions != null) {
                int i = 0;
                while (i < actions.length) {
                    actionsPermission = actionsPermission + "," + actions[i];
                    ++i;
                }
            }
            if (!actionsPermission.equals("")) {
                actionsPermission = actionsPermission.trim().substring(1);
            }
            return PermissionsFactory.loadPermission(loader, className, name, actionsPermission);
        }
        catch (RuntimeException t) {
            throw new SecurityException(t.toString());
        }
    }

    private static Permission loadPermission(ClassLoader loader, String className, String names, String actions) throws SecurityException {
        if (className.equals("java.security.UnresolvedPermission")) {
            return new UnresolvedPermission(className, names, actions, new Certificate[0]);
        }
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(className);
        }
        catch (Exception e) {
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e1) {
                return new UnresolvedPermission(className, names, actions, new Certificate[0]);
            }
        }
        return PermissionsFactory.loadPermission(clazz, names, actions);
    }

    private static Permission loadPermission(Class clazz, String names, String actions) throws SecurityException {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PermissionsFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PermissionsFactory.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PermissionsFactory.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException e_1) {
                try {
                    constructor = clazz.getConstructor(null);
                }
                catch (NoSuchMethodException e_2) {
                    if (connector != null) {
                        connector.logNotice("Cannot create a constructor(with 3, 2 and 0 params) for a permission[" + clazz.getName() + ", " + names + ", " + actions + "]: " + e_1);
                    }
                    throw new SecurityException("Cannot create a constructor(with 3, 2 and 0 params) for a permission[" + clazz.getName() + ", " + names + ", " + actions + "]: " + e_1);
                }
            }
        }
        try {
            return (Permission)constructor.newInstance(names, actions);
        }
        catch (Exception _) {
            try {
                return (Permission)constructor.newInstance(names);
            }
            catch (Exception e) {
                try {
                    return (Permission)constructor.newInstance(null);
                }
                catch (Exception __) {
                    if (connector != null) {
                        connector.logNotice("Cannot create an instance of a permission[" + clazz.getName() + ", " + names + ", " + actions + "]: ", e);
                    }
                    throw new SecurityException("Cannot create an instance of a permission[" + clazz.getName() + ", " + names + ", " + actions + "]: " + e);
                }
            }
        }
    }

    public static Permission getTargetPermissionInstance(UnresolvedPermission u, Class targetPermissionClass) throws Exception {
        Permission p = null;
        try {
            String name = (String)PERMISSION_FIELDS[0].get(u);
            String actions = (String)PERMISSION_FIELDS[1].get(u);
            p = PermissionsFactory.loadPermission(targetPermissionClass, name, actions);
        }
        catch (Exception e) {
            if (connector != null) {
                connector.logNotice("Cannot create an instance of the permission: " + PermissionsFactory.getStackTrace(e));
            }
            throw new Exception("Cannot create an instance of the permission: " + PermissionsFactory.getStackTrace(e));
        }
        return p;
    }

    public static String[] getTargetPermissionData(UnresolvedPermission u) throws Exception {
        String[] result = new String[3];
        try {
            result[0] = u.getName();
            result[1] = (String)PERMISSION_FIELDS[0].get(u);
            result[2] = (String)PERMISSION_FIELDS[1].get(u);
        }
        catch (Exception e) {
            if (connector != null) {
                connector.logNotice("Cannot create an instance of the permission: " + PermissionsFactory.getStackTrace(e));
            }
            throw new Exception("Cannot create an instance of the permission: " + PermissionsFactory.getStackTrace(e));
        }
        return result;
    }

    private static String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        aliases = new Properties();
        ((Hashtable)aliases).put("all", "java.security.AllPermission");
        ((Hashtable)aliases).put("property", "java.util.PropertyPermission");
        ((Hashtable)aliases).put("runtime", "java.lang.RuntimePermission");
        ((Hashtable)aliases).put("net", "java.net.NetPermission");
        ((Hashtable)aliases).put("reflect", "java.lang.reflect.ReflectPermission");
        ((Hashtable)aliases).put("security", "java.security.SecurityPermission");
        ((Hashtable)aliases).put("serializable", "java.io.SerializablePermission");
        ((Hashtable)aliases).put("files", "java.io.FilePermission");
        ((Hashtable)aliases).put("socket", "java.net.SocketPermission");
        classNames = new Properties();
        Enumeration keys = ((Hashtable)aliases).keys();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            ((Hashtable)classNames).put(aliases.getProperty(key), key);
        }
        permissionActions = new Hashtable(11);
        permissionActions.put("files", new String[]{"read", "write", "execute", "delete"});
        permissionActions.put("socket", new String[]{"accept", "connect", "listen", "resolve"});
        permissionActions.put("property", new String[]{"read", "write"});
        permissionActions.put("all", new String[]{"<all actions>"});
        permissionNames = new Hashtable(11);
        permissionNames.put("files", new String[]{"<<ALL FILES>>"});
        permissionNames.put("all", new String[]{"<all permissions>"});
        permissionNames.put("property", new String[]{"*"});
        permissionNames.put("socket", new String[]{"*"});
        permissionNames.put("serializable", new String[]{"enableSubclassImplementation", "enableSubstitution"});
        permissionNames.put("reflect", new String[]{"suppressAccessChecks"});
        permissionNames.put("net", new String[]{"requestPasswordAuthentication", "setDefaultAuthenticator", "specifyStreamHandler"});
        permissionNames.put("runtime", new String[]{"addPermission", "removePermisssion", "createClassLoader", "getClassLoader", "setContextClassLoader", "setSecurityManager", "createSecurityManager", "exitVM", "setFactory", "setIO", "modifyThread", "stopThread", "modifyThreadGroup", "getProtectionDomain", "readFileDescriptor", "writeFileDescriptor", "accessDeclaredMembers", "queuePrintJob"});
        permissionNames.put("security", new String[]{"getPolicy", "setPolicy", "setSystemScope", "setIdentityPublicKey", "setIdentityInfo", "addIdentityCertificate", "removeIdentityCertificate", "printIdentity", "getSignerPrivateKey", "setSignerKeyPair"});
        try {
            PERMISSION_FIELDS = (Field[])AccessController.doPrivileged(new UnresolvedPermissionParser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

