/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security;

import com.sap.engine.lib.security.DomainsEnumerationPermission;
import com.sap.engine.lib.security.EnginePermission;
import com.sap.engine.lib.security.PermissionStorageConnector;
import com.sap.engine.lib.security.ProtectedProtectionDomain;
import com.sap.engine.lib.security.StandalonePermissions;
import com.sap.engine.lib.security.domain.PermissionsFactory;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProtectedPermissionCollection
extends PermissionCollection {
    protected Vector standalonePermissions = new Vector(10, 10);
    protected Hashtable permissionCollections = new Hashtable();
    private String domainName = null;
    private int isInitialized = 2;
    private static PermissionStorageConnector permissionConnector = null;
    private static final RuntimePermission ADD_PERMISSION = new RuntimePermission("addPermission");
    static /* synthetic */ Class class$java$security$AllPermission;
    static /* synthetic */ Class class$java$security$UnresolvedPermission;
    static /* synthetic */ Class class$java$lang$String;

    public static void setPermissionStorageConnector(PermissionStorageConnector connector) throws Exception {
        permissionConnector = connector;
    }

    public void free() {
        this.standalonePermissions.clear();
        this.permissionCollections.clear();
    }

    public void replacePermissions(ProtectedPermissionCollection newPermissions) {
        if (this.isInitialized != 3 && this.isInitialized()) {
            AccessController.checkPermission(ADD_PERMISSION);
        }
        this.standalonePermissions = newPermissions.standalonePermissions;
        this.permissionCollections = newPermissions.permissionCollections;
    }

    public void lockCollection() {
        if (this.isInitialized != 3 && this.isInitialized()) {
            AccessController.checkPermission(ADD_PERMISSION);
        }
        super.setReadOnly();
    }

    public ProtectedPermissionCollection() {
    }

    public ProtectedPermissionCollection(String name, PermissionCollection collection) {
        if (collection instanceof ProtectedPermissionCollection) {
            this.isInitialized = ((ProtectedPermissionCollection)collection).isInitialized;
        }
        this.domainName = name;
        if (name.equals("services/security/security.jar") || name.equals("services/security.jar")) {
            this.getCollection(ADD_PERMISSION).add(ADD_PERMISSION);
        }
        this.add(collection);
    }

    public synchronized void add(Permission permission) {
        if (permission == null) {
            throw new NullPointerException("Cannot add a null permission to collection.");
        }
        if (this.isReadOnly() && this.isInitialized != 3 && this.isInitialized()) {
            AccessController.checkPermission(ADD_PERMISSION);
        }
        if (ADD_PERMISSION.equals(permission)) {
            return;
        }
        if (permission instanceof StandalonePermissions) {
            this.permissionCollections.put(permission.getClass(), permission.newPermissionCollection());
        } else {
            PermissionCollection collection = this.getCollection(permission);
            if (collection == null) {
                this.standalonePermissions.add(permission);
            } else {
                try {
                    Permissions perm = new Permissions();
                    perm.add(permission);
                    Enumeration<Permission> e = collection.elements();
                    while (e.hasMoreElements()) {
                        Permission old = e.nextElement();
                        if (old.equals(permission)) {
                            return;
                        }
                        perm.add(old);
                    }
                    this.permissionCollections.put(permission.getClass(), perm);
                }
                catch (Exception e) {
                    ProtectedPermissionCollection.logNotice(" add permission(" + permission + ") ???:", e);
                }
            }
        }
    }

    public void add(PermissionCollection collection) {
        if (this.isReadOnly() && this.isInitialized != 3 && this.isInitialized()) {
            AccessController.checkPermission(ADD_PERMISSION);
        }
        Enumeration<Permission> elements = collection.elements();
        while (elements.hasMoreElements()) {
            this.add(elements.nextElement());
        }
    }

    public boolean implies(Permission permission) {
        Permission p;
        if (permission instanceof DomainsEnumerationPermission) {
            ProtectionDomain current_domain = ProtectionDomainFactory.getFactory().getProtectionDomain(this.domainName);
            if (current_domain != null) {
                ((DomainsEnumerationPermission)permission).addProtectionDomain(current_domain);
            }
            return true;
        }
        if (!this.isInitialized() && !this.attemptToInitialize()) {
            return true;
        }
        PermissionCollection allPermissions = (PermissionCollection)this.permissionCollections.get(class$java$security$AllPermission == null ? (class$java$security$AllPermission = ProtectedPermissionCollection.class$("java.security.AllPermission")) : class$java$security$AllPermission);
        if (allPermissions != null && allPermissions.implies(permission)) {
            return true;
        }
        PermissionCollection collection = this.getCollection(permission);
        if (collection != null && collection.implies(permission)) {
            return true;
        }
        Enumeration enumeration = this.standalonePermissions.elements();
        while (enumeration.hasMoreElements()) {
            p = (Permission)enumeration.nextElement();
            if (!p.implies(permission)) continue;
            return true;
        }
        PermissionCollection unresolvedPermissions = (PermissionCollection)this.permissionCollections.get(class$java$security$UnresolvedPermission == null ? (class$java$security$UnresolvedPermission = ProtectedPermissionCollection.class$("java.security.UnresolvedPermission")) : class$java$security$UnresolvedPermission);
        if (unresolvedPermissions != null) {
            Enumeration<Permission> enumeration2 = unresolvedPermissions.elements();
            while (enumeration2.hasMoreElements()) {
                Object var9_10;
                UnresolvedPermission u_p = (UnresolvedPermission)enumeration2.nextElement();
                Permission p2 = this.resolve(u_p, permission);
                if (p2 == null) continue;
                int status = this.isInitialized;
                try {
                    this.isInitialized = 3;
                    this.add(p2);
                    this.removeUnresolved(u_p);
                    var9_10 = null;
                    this.isInitialized = status;
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    this.isInitialized = status;
                    throw throwable;
                }
                if (!p2.implies(permission)) continue;
                return true;
            }
        }
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            p = (Permission)enumeration.nextElement();
            if (p instanceof UnresolvedPermission) {
                Object var11_12;
                if ((p = this.resolve((UnresolvedPermission)p, permission)) == null) continue;
                int status = this.isInitialized;
                try {
                    this.isInitialized = 3;
                    this.add(p);
                    var11_12 = null;
                    this.isInitialized = status;
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    this.isInitialized = status;
                    throw throwable;
                }
            }
            if (!p.implies(permission)) continue;
            return true;
        }
        if (permission instanceof EnginePermission) {
            ((EnginePermission)permission).setImpliesFailedDomain(this.domainName);
        }
        ProtectedPermissionCollection.logNotice(" AccessController.checkPermission(" + permission + ") failed at domain [" + this.domainName + "]");
        ProtectedPermissionCollection.logNotice(" domain's permissions: " + this.toString());
        return false;
    }

    private Enumeration collections() {
        if (!this.isInitialized()) {
            this.attemptToInitialize();
        }
        if (!this.isInitialized()) {
            Enumeration EMPTY_ENUMERATION = new Vector().elements();
            return EMPTY_ENUMERATION;
        }
        return this.permissionCollections.elements();
    }

    public synchronized Enumeration elements() {
        Vector<Permission> v = new Vector<Permission>();
        Enumeration emenets = this.collections();
        Enumeration<Permission> permissions = null;
        PermissionCollection collection = null;
        while (emenets.hasMoreElements()) {
            collection = (PermissionCollection)emenets.nextElement();
            permissions = collection.elements();
            while (permissions.hasMoreElements()) {
                v.add(permissions.nextElement());
            }
        }
        int i = 0;
        while (i < this.standalonePermissions.size()) {
            v.add((Permission)this.standalonePermissions.get(i));
            ++i;
        }
        return v.elements();
    }

    public synchronized void remove(Permission permission) throws Exception {
        if (!this.isInitialized() && !this.attemptToInitialize()) {
            return;
        }
        if (permission == null) {
            throw new NullPointerException("Cannot remove a null permission from collection.");
        }
        if (ADD_PERMISSION.equals(permission)) {
            return;
        }
        if (this.isReadOnly() && this.isInitialized != 3) {
            AccessController.checkPermission(ADD_PERMISSION);
        }
        if (this.standalonePermissions.contains(permission)) {
            this.standalonePermissions.remove(permission);
            return;
        }
        if (this.permissionCollections.containsKey(permission.getClass())) {
            if (permission instanceof StandalonePermissions) {
                this.permissionCollections.remove(permission.getClass());
            }
            if (permission instanceof UnresolvedPermission) {
                this.removeUnresolved((UnresolvedPermission)permission);
            } else if (permission instanceof EnginePermission) {
                this.removeEnginePermission((EnginePermission)permission);
            } else {
                Permission perm = null;
                String actionsPermission = "";
                String namesPermission = "";
                PermissionCollection collection = (PermissionCollection)this.permissionCollections.get(permission.getClass());
                Enumeration<Permission> elements = collection.elements();
                Permissions newCollection = new Permissions();
                while (elements.hasMoreElements()) {
                    perm = elements.nextElement();
                    if (!perm.implies(permission)) {
                        newCollection.add(perm);
                        continue;
                    }
                    if (perm.equals(permission) || (actionsPermission = ProtectedPermissionCollection.minus(perm.getActions(), permission.getActions())) == "") continue;
                    namesPermission = perm.getName();
                    Class[] stCl = new Class[]{class$java$lang$String == null ? ProtectedPermissionCollection.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ProtectedPermissionCollection.class$("java.lang.String") : class$java$lang$String};
                    Constructor<?> comstructor = perm.getClass().getConstructor(stCl);
                    Object[] o = new Object[]{namesPermission, actionsPermission};
                    Object c = comstructor.newInstance(o);
                    newCollection.add((Permission)c);
                }
                this.permissionCollections.remove(permission.getClass());
                if (newCollection.elements().hasMoreElements()) {
                    this.permissionCollections.put(permission.getClass(), newCollection);
                }
            }
        }
    }

    private void removeEnginePermission(EnginePermission deniedPermission) {
        PermissionCollection collection = (PermissionCollection)this.permissionCollections.get(deniedPermission.getClass());
        if (collection != null) {
            Enumeration<Permission> elements = collection.elements();
            Permissions newCollection = new Permissions();
            while (elements.hasMoreElements()) {
                EnginePermission grantedPermission = (EnginePermission)elements.nextElement();
                if (deniedPermission.implies(grantedPermission)) continue;
                newCollection.add(grantedPermission);
            }
            this.permissionCollections.remove(deniedPermission.getClass());
            if (newCollection.elements().hasMoreElements()) {
                this.permissionCollections.put(deniedPermission.getClass(), newCollection);
            }
        }
    }

    private void removeUnresolved(UnresolvedPermission permission) {
        try {
            if (!this.isInitialized() && !this.attemptToInitialize()) {
                return;
            }
            if (this.permissionCollections.containsKey(class$java$security$UnresolvedPermission == null ? (class$java$security$UnresolvedPermission = ProtectedPermissionCollection.class$("java.security.UnresolvedPermission")) : class$java$security$UnresolvedPermission)) {
                PermissionCollection collection = (PermissionCollection)this.permissionCollections.get(permission.getClass());
                Enumeration<Permission> elements = collection.elements();
                Permissions newCollection = new Permissions();
                while (elements.hasMoreElements()) {
                    String[] permission_data;
                    UnresolvedPermission perm = (UnresolvedPermission)elements.nextElement();
                    if (perm.equals(permission)) continue;
                    String[] perm_data = PermissionsFactory.getTargetPermissionData(perm);
                    if (!perm_data[0].equals((permission_data = PermissionsFactory.getTargetPermissionData(permission))[0]) || !perm_data[1].equals(permission_data[1])) {
                        newCollection.add(perm);
                        continue;
                    }
                    String newActions = ProtectedPermissionCollection.minus(perm_data[2], permission_data[2]);
                    newCollection.add(new UnresolvedPermission(perm_data[0], perm_data[1], newActions, null));
                }
                this.permissionCollections.remove(permission.getClass());
                if (newCollection.elements().hasMoreElements()) {
                    this.permissionCollections.put(permission.getClass(), newCollection);
                }
            }
        }
        catch (Throwable t) {
            ProtectedPermissionCollection.logNotice("removeUnresolved(" + permission + ") fails: " + ProtectedPermissionCollection.getStackTrace(t));
        }
    }

    public boolean isInitialized() {
        if (this.isInitialized == 0) {
            return true;
        }
        if (this.domainName == null || permissionConnector != null && !permissionConnector.isPolicyProvider()) {
            this.isInitialized = 0;
            return true;
        }
        return permissionConnector == null;
    }

    synchronized void setInitialized(boolean flag) {
        this.isInitialized = flag ? 0 : 2;
    }

    synchronized boolean attemptToInitialize() {
        if (this.isInitialized == 0 || this.isInitialized == 1 || this.isInitialized == 3) {
            return true;
        }
        if (permissionConnector != null) {
            this.isInitialized = 1;
            ProtectionDomain domain = ProtectionDomainFactory.getFactory().getProtectionDomain(this.domainName);
            if (domain != null) {
                CodeSource source = domain.getCodeSource();
                PermissionCollection collection = permissionConnector.getPermissionCollection(this.domainName, source);
                if (collection instanceof ProtectedPermissionCollection) {
                    this.replacePermissions((ProtectedPermissionCollection)collection);
                    this.isInitialized = 0;
                    return true;
                }
                if (collection != null) {
                    this.free();
                    this.add(collection);
                    this.isInitialized = 0;
                    return true;
                }
            } else {
                this.isInitialized = 0;
                return true;
            }
        }
        this.isInitialized = 2;
        return false;
    }

    private PermissionCollection getCollection(Permission permission) {
        PermissionCollection result = (PermissionCollection)this.permissionCollections.get(permission.getClass());
        if (result != null) {
            return result;
        }
        try {
            return permission.newPermissionCollection();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String minus(String first, String second) {
        String result = "";
        String[] a = null;
        String[] b = null;
        StringTokenizer tokens = null;
        int i = 0;
        tokens = new StringTokenizer(first, ",", false);
        a = new String[tokens.countTokens()];
        while (tokens.hasMoreTokens()) {
            a[i] = tokens.nextToken();
            ++i;
        }
        tokens = new StringTokenizer(second, ",", false);
        b = new String[tokens.countTokens()];
        i = 0;
        while (tokens.hasMoreTokens()) {
            b[i] = tokens.nextToken();
            ++i;
        }
        i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                if (a[i].equals(b[j])) {
                    a[i] = null;
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < a.length) {
            if (a[i] != null) {
                result = result + a[i] + ",";
            }
            ++i;
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static Class loadUnresolvedPermissionTargetClass(String targetClass, Permission checkedPermission) {
        Class<?> cp = null;
        try {
            cp = checkedPermission.getClass().getClassLoader().loadClass(targetClass);
            ProtectedPermissionCollection.logNotice("<checked_permission> classloader: " + cp.getClassLoader());
        }
        catch (Exception e) {
            if (!(e instanceof NullPointerException)) {
                ProtectedPermissionCollection.logNotice("{" + targetClass + "} not loaded by  <checked_permission>.getClass(): ", e);
                ProtectedPermissionCollection.logNotice("checked_permission : " + checkedPermission);
            }
            try {
                cp = Class.forName(targetClass);
                ProtectedPermissionCollection.logNotice("{" + targetClass + "} loaded by Class.forName(..) OK");
            }
            catch (Exception e1) {
                ProtectedPermissionCollection.logNotice("{" + targetClass + "} not loaded by Class.forName(..): ", e);
                try {
                    ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                    cp = contextLoader.loadClass(targetClass);
                    ProtectedPermissionCollection.logNotice("{" + targetClass + "} loaded by the context classloader OK");
                }
                catch (Exception e2) {
                    ProtectedPermissionCollection.logNotice("{" + targetClass + "} not loaded by the context classloader: " + e2);
                    try {
                        ClassLoader applicationClassloader = ProtectedPermissionCollection.getApplicationClassloader();
                        cp = applicationClassloader.loadClass(targetClass);
                        ProtectedPermissionCollection.logNotice("{" + targetClass + "} loaded by the application classloader OK");
                    }
                    catch (Exception e3) {
                        ProtectedPermissionCollection.logNotice("{" + targetClass + "} not loaded by the application classloader: ", e);
                        return null;
                    }
                }
            }
        }
        return cp;
    }

    private Permission resolve(UnresolvedPermission unresolvedPermission, Permission checkedPermission) {
        String targetClass = unresolvedPermission.getName();
        Class cp = ProtectedPermissionCollection.loadUnresolvedPermissionTargetClass(targetClass, checkedPermission);
        if (cp == null) {
            ProtectedPermissionCollection.logNotice("unresolved permission[" + unresolvedPermission + "] removed from domain[" + this.domainName + "] colection!");
            return null;
        }
        try {
            Permission resolvedPermission = PermissionsFactory.getTargetPermissionInstance(unresolvedPermission, cp);
            return resolvedPermission;
        }
        catch (Exception e) {
            ProtectedPermissionCollection.logNotice("PermissionsFactory.getTargetPermissionInstance(" + unresolvedPermission + ") fails: ", e);
            return null;
        }
    }

    private static ClassLoader getApplicationClassloader() throws Exception {
        ProtectionDomain[] protectionStack = ProtectionDomainFactory.getFactory().getProtectionDomainStack();
        String applicationName = ((ProtectedProtectionDomain)protectionStack[1]).getName();
        if (applicationName.startsWith("@comp@")) {
            applicationName = applicationName.substring(applicationName.lastIndexOf(":") + 1);
            return permissionConnector.getApplicationClassloader(applicationName);
        }
        throw new Exception("Cannot get the application class loader - application not found!");
    }

    private static void logNotice(Object message) {
        if (permissionConnector == null) {
            return;
        }
        permissionConnector.logNotice("[permission_collection]: " + message);
    }

    private static void logNotice(Object message, Throwable err) {
        if (permissionConnector == null) {
            return;
        }
        permissionConnector.logNotice("[permission_collection]: " + message, err);
    }

    private static String enumerationToString(Enumeration e) {
        String result = "{";
        while (e.hasMoreElements()) {
            Permission p = (Permission)e.nextElement();
            result = result + p;
        }
        return result + "}";
    }

    public synchronized String toString() {
        String result = "[\n  standalone: " + this.standalonePermissions;
        Enumeration collections = this.permissionCollections.keys();
        result = result + "\n  collections: ";
        while (collections.hasMoreElements()) {
            Class key = (Class)collections.nextElement();
            Permissions permissions = (Permissions)this.permissionCollections.get(key);
            result = result + "\n" + ProtectedPermissionCollection.enumerationToString(permissions.elements());
        }
        return result + "\n]";
    }

    private static final String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

