/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging.descriptors;

import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.LogPropertiesParser;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.tc.logging.Formatter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class LogConfiguration
implements Serializable,
Cloneable,
DeepCloneable {
    public static final long VALUE_UNDEFINED = 0L;
    private long version;
    private HashMapObjectObject controllers;
    private HashMapObjectObject destinations;
    private HashMapObjectObject formatters;

    public LogConfiguration() {
        this(0L);
    }

    public LogConfiguration(long version) {
        this.version = version;
        this.controllers = new HashMapObjectObject();
        this.destinations = new HashMapObjectObject();
        this.formatters = new HashMapObjectObject();
    }

    public static LogConfiguration readFromObjectStream(ObjectInputStream ois) throws Exception {
        return (LogConfiguration)ois.readObject();
    }

    public void writeToObjectStream(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this);
        oos.flush();
    }

    public static LogConfiguration readFromProperties(Properties properties) throws Exception {
        return LogPropertiesParser.parse(properties);
    }

    public long getVersion() {
        return this.version;
    }

    public void addLogController(LogControllerDescriptor controller) {
        this.controllers.put(controller.getName(), controller);
    }

    public void addLogDestination(LogDestinationDescriptor destination) {
        this.destinations.put(destination.toString(), destination);
    }

    public void addLogFormatter(LogFormatterDescriptor formatter) {
        this.formatters.put(formatter.toString(), formatter);
    }

    public Object removeLogFormatter(String formatterName) {
        return this.formatters.remove(formatterName);
    }

    public Object removeLogDestination(String destinationName) {
        return this.destinations.remove(destinationName);
    }

    public Object removeLogController(String controllerName) {
        return this.controllers.remove(controllerName);
    }

    public void clear() {
        this.controllers.clear();
        this.destinations.clear();
        this.formatters.clear();
    }

    public Enumeration enumerateControllersNames() {
        return this.controllers.keys();
    }

    public Enumeration enumerateDestinationsNames() {
        return this.destinations.keys();
    }

    public Enumeration enumerateFormattersNames() {
        return this.formatters.keys();
    }

    public Enumeration enumerateLogControllers() {
        return this.controllers.elements();
    }

    public Enumeration enumerateLogDestinations() {
        return this.destinations.elements();
    }

    public Enumeration enumerateLogFormatters() {
        return this.formatters.elements();
    }

    public String[] getLogControllersNames() {
        return (String[])this.controllers.getAllKeys(new String[this.controllers.size()]);
    }

    public String[] getLogDestinationsNames() {
        return (String[])this.destinations.getAllKeys(new String[this.destinations.size()]);
    }

    public String[] getLogFormattersNames() {
        return (String[])this.formatters.getAllKeys(new String[this.formatters.size()]);
    }

    public LogControllerDescriptor[] getLogControllers() {
        return (LogControllerDescriptor[])this.controllers.getAllValues(new LogControllerDescriptor[this.controllers.size()]);
    }

    public LogDestinationDescriptor[] getLogDestinations() {
        return (LogDestinationDescriptor[])this.destinations.getAllValues(new LogDestinationDescriptor[this.destinations.size()]);
    }

    public LogFormatterDescriptor[] getLogFormatters() {
        return (LogFormatterDescriptor[])this.formatters.getAllValues(new LogFormatterDescriptor[this.formatters.size()]);
    }

    public void setLogControllers(LogControllerDescriptor[] controllers) {
        this.controllers.clear();
        if (controllers != null) {
            this.addLogControllers(controllers);
        }
    }

    public void setLogDestinations(LogDestinationDescriptor[] destinations) {
        this.destinations.clear();
        if (destinations != null) {
            this.addLogDestinations(destinations);
        }
    }

    public void setLogFormatters(LogFormatterDescriptor[] formatters) {
        this.formatters.clear();
        if (formatters != null) {
            this.addLogFormatters(formatters);
        }
    }

    public void addLogControllers(LogControllerDescriptor[] controllers) {
        int i = controllers.length;
        while (--i >= 0) {
            this.controllers.put(controllers[i].getName(), controllers[i]);
        }
    }

    public void addLogDestinations(LogDestinationDescriptor[] destinations) {
        int i = destinations.length;
        while (--i >= 0) {
            this.destinations.put(destinations[i].toString(), destinations[i]);
        }
    }

    public void addLogFormatters(LogFormatterDescriptor[] formatters) {
        int i = formatters.length;
        while (--i >= 0) {
            this.formatters.put(formatters[i].toString(), formatters[i]);
        }
    }

    public void addLogConfiguration(LogConfiguration configuration) {
        this.addLogControllers(configuration.getLogControllers());
        this.addLogDestinations(configuration.getLogDestinations());
        this.addLogFormatters(configuration.getLogFormatters());
    }

    public void removeLogConfiguration(LogConfiguration configuration) {
        String[] names = configuration.getLogControllersNames();
        int i = 0;
        while (i < names.length) {
            this.removeLogController(names[i]);
            ++i;
        }
        names = configuration.getLogDestinationsNames();
        int i2 = 0;
        while (i2 < names.length) {
            this.removeLogDestination(names[i2]);
            ++i2;
        }
        names = configuration.getLogFormattersNames();
        int i3 = 0;
        while (i3 < names.length) {
            this.removeLogFormatter(names[i3]);
            ++i3;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration cfg = (LogConfiguration)obj;
        if (!this.controllers.equals(cfg.controllers)) {
            return false;
        }
        if (!this.destinations.equals(cfg.destinations)) {
            return false;
        }
        return this.formatters.equals(cfg.formatters);
    }

    public Object deepClone() {
        try {
            LogConfiguration clone = (LogConfiguration)super.clone();
            clone.controllers = (HashMapObjectObject)this.controllers.clone();
            clone.destinations = (HashMapObjectObject)this.destinations.clone();
            clone.formatters = (HashMapObjectObject)this.formatters.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        return this.deepClone();
    }

    public void applyPersistenceAdapter(PersistenceAdapter storageAdapter) {
        Enumeration elements = this.enumerateLogFormatters();
        while (elements.hasMoreElements()) {
            ((LogFormatterDescriptor)elements.nextElement()).setPersistenceAdapter(storageAdapter);
        }
        elements = this.enumerateLogDestinations();
        while (elements.hasMoreElements()) {
            ((LogDestinationDescriptor)elements.nextElement()).setPersistenceAdapter(storageAdapter);
        }
        elements = this.enumerateLogControllers();
        while (elements.hasMoreElements()) {
            ((LogControllerDescriptor)elements.nextElement()).setPersistenceAdapter(storageAdapter);
        }
    }

    public void dump() {
        System.out.println("LogConfiguration DUMP");
        Object[] f = null;
        HashMapObjectObject hashMapObjectObject = this.formatters;
        synchronized (hashMapObjectObject) {
            f = this.getLogFormatters();
        }
        Arrays.sort(f);
        System.out.println("Formatters:");
        int i = 0;
        while (i < f.length) {
            System.out.println("\tName = " + ((LogFormatterDescriptor)f[i]).getName());
            System.out.println("\tType = " + ((LogFormatterDescriptor)f[i]).getType());
            System.out.println("\tPattern = " + ((LogFormatterDescriptor)f[i]).getPattern());
            System.out.println();
            ++i;
        }
        Object[] d = null;
        HashMapObjectObject hashMapObjectObject2 = this.destinations;
        synchronized (hashMapObjectObject2) {
            d = this.getLogDestinations();
        }
        Arrays.sort(d);
        System.out.println("Destinations:");
        int i2 = 0;
        while (i2 < d.length) {
            System.out.println("\tName = " + ((LogDestinationDescriptor)d[i2]).getName());
            System.out.println("\tType = " + ((LogDestinationDescriptor)d[i2]).getType());
            System.out.println("\tCount = " + ((LogDestinationDescriptor)d[i2]).getCount());
            System.out.println("\tEffectiveSeverity = " + ((LogDestinationDescriptor)d[i2]).getEffectiveSeverity());
            System.out.println("\tEncoding = " + ((LogDestinationDescriptor)d[i2]).getEncoding());
            String[] fs = ((LogDestinationDescriptor)d[i2]).getFilters();
            System.out.println("\tFilters:");
            int j = 0;
            while (j < fs.length) {
                System.out.println("\t\t" + fs[j]);
                ++j;
            }
            LogFormatterDescriptor lfd = ((LogDestinationDescriptor)d[i2]).getFormatter();
            if (lfd == null) {
                System.out.println("\tFormatter = null");
            } else if (lfd.getName() == null) {
                System.out.println("\tFormatter = Anonymous - " + lfd.getType());
            } else {
                System.out.println("\tFormatter = " + lfd.getName());
            }
            System.out.println("\tLimit = " + ((LogDestinationDescriptor)d[i2]).getLimit());
            System.out.println("\tPattern = " + ((LogDestinationDescriptor)d[i2]).getPattern());
            System.out.println();
            ++i2;
        }
        Object[] c = null;
        HashMapObjectObject hashMapObjectObject3 = this.controllers;
        synchronized (hashMapObjectObject3) {
            c = this.getLogControllers();
        }
        Arrays.sort(c);
        System.out.println("Controllers:");
        int i3 = 0;
        while (i3 < c.length) {
            System.out.println("\tName = " + ((LogControllerDescriptor)c[i3]).getName());
            HashMapObjectByte destinations = ((LogControllerDescriptor)c[i3]).getAssociatedDestinations();
            System.out.println("\tDestinations:");
            Object[] keys = destinations.getAllKeys();
            int j = 0;
            while (j < keys.length) {
                byte type = destinations.get(keys[j]);
                String strType = null;
                switch (type) {
                    case 2: {
                        strType = "LOCAL_LOG";
                        break;
                    }
                    case 0: {
                        strType = "LOG";
                        break;
                    }
                    case 1: {
                        strType = "PRIVATE_LOG";
                    }
                }
                LogDestinationDescriptor ldd = (LogDestinationDescriptor)keys[j];
                if (ldd.getName() != null) {
                    System.out.println("\t\t" + ldd.getName() + " : " + strType);
                } else {
                    System.out.println("\t\tAnonymous - " + ldd.getType() + " : " + strType);
                }
                ++j;
            }
            System.out.println("\tBundleName = " + ((LogControllerDescriptor)c[i3]).getBundleName());
            System.out.println("\tMinSeverity = " + ((LogControllerDescriptor)c[i3]).getMinSeverity());
            System.out.println("\tMaxSeverity = " + ((LogControllerDescriptor)c[i3]).getMaxSeverity());
            String[] fs = ((LogControllerDescriptor)c[i3]).getFilters();
            System.out.println("\tFilters:");
            int j2 = 0;
            while (j2 < fs.length) {
                System.out.println("\t\t" + fs[j2]);
                ++j2;
            }
            System.out.println();
            ++i3;
        }
    }

    public static int calculateEffectiveSeverity(int parent, int min, int max) {
        if (parent < min) {
            return min;
        }
        if (parent > max) {
            return max;
        }
        return parent;
    }

    public int calculateEffectiveSeverity(String controllerName) {
        StringTokenizer names;
        int result = 701;
        if (controllerName == null) {
            return result;
        }
        LogControllerDescriptor controller = this.getLogController(controllerName);
        if (controller == null || controller.getName() == null) {
            return result;
        }
        if (controller.getMinSeverityInt() == controller.getMaxSeverityInt()) {
            return controller.getMaxSeverityInt();
        }
        String delim = null;
        String name = null;
        LogControllerDescriptor tmp = null;
        if (controller.getName().startsWith("/")) {
            name = delim = "/";
        } else {
            delim = ".";
            name = "";
        }
        tmp = (LogControllerDescriptor)this.controllers.get(name);
        if (tmp != null) {
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinSeverityInt(), tmp.getMaxSeverityInt());
        }
        if ((names = new StringTokenizer(controller.getName(), delim)).hasMoreTokens() && (tmp = (LogControllerDescriptor)this.controllers.get(name = name + names.nextToken())) != null) {
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinSeverityInt(), tmp.getMaxSeverityInt());
        }
        while (names.hasMoreTokens()) {
            tmp = (LogControllerDescriptor)this.controllers.get(name = name + delim + names.nextToken());
            if (tmp == null) continue;
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinSeverityInt(), tmp.getMaxSeverityInt());
        }
        return result;
    }

    public int calculateRelativeSeverity(String controllerName, String relativeControllerName) {
        StringTokenizer names;
        int result = 701;
        if (controllerName == null) {
            return result;
        }
        LogControllerDescriptor controller = this.getLogController(controllerName);
        if (controller == null || controller.getName() == null) {
            return result;
        }
        if (controller.getMinRelativeSeverity(relativeControllerName) == controller.getMaxRelativeSeverity(relativeControllerName)) {
            return controller.getMaxRelativeSeverity(relativeControllerName);
        }
        String delim = null;
        String name = null;
        LogControllerDescriptor tmp = null;
        if (controller.getName().startsWith("/")) {
            name = delim = "/";
        } else {
            delim = ".";
            name = "";
        }
        tmp = (LogControllerDescriptor)this.controllers.get(name);
        if (tmp != null) {
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinRelativeSeverity(relativeControllerName), tmp.getMaxRelativeSeverity(relativeControllerName));
        }
        if ((names = new StringTokenizer(controller.getName(), delim)).hasMoreTokens() && (tmp = (LogControllerDescriptor)this.controllers.get(name = name + names.nextToken())) != null) {
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinRelativeSeverity(relativeControllerName), tmp.getMaxRelativeSeverity(relativeControllerName));
        }
        while (names.hasMoreTokens()) {
            tmp = (LogControllerDescriptor)this.controllers.get(name = name + delim + names.nextToken());
            if (tmp == null) continue;
            result = LogConfiguration.calculateEffectiveSeverity(result, tmp.getMinRelativeSeverity(relativeControllerName), tmp.getMaxRelativeSeverity(relativeControllerName));
        }
        return result;
    }

    public boolean containsLogController(String name) {
        return this.controllers.containsKey(name);
    }

    public boolean containsLogDetination(String name) {
        return this.destinations.containsKey(name);
    }

    public boolean containsLogFormatter(String name) {
        return this.formatters.containsKey(name);
    }

    public LogControllerDescriptor getLogController(String name) {
        return (LogControllerDescriptor)this.controllers.get(name);
    }

    public LogDestinationDescriptor getLogDestination(String name) {
        if (name == null) {
            return null;
        }
        return (LogDestinationDescriptor)this.destinations.get(name);
    }

    public LogFormatterDescriptor getLogFormatter(String name) {
        if (name == null) {
            return null;
        }
        return (LogFormatterDescriptor)this.formatters.get(name);
    }

    public LogFormatterDescriptor getLogFormatter(Formatter realFormatter) {
        LogFormatterDescriptor[] formaterDescriptors = (LogFormatterDescriptor[])this.formatters.getAllValues(new LogFormatterDescriptor[this.formatters.size()]);
        int i = 0;
        while (i < formaterDescriptors.length) {
            if (formaterDescriptors[i].getRealFormatter() == realFormatter) {
                return formaterDescriptors[i];
            }
            ++i;
        }
        return null;
    }
}

