/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang.array;

public class ByteArray {
    private byte[] array;
    private int offset;
    private int length;

    public ByteArray(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArray(byte[] array, int offset, int length) {
        this.reuse(array, offset, length);
    }

    public void reuse(byte[] array) {
        this.reuse(array, 0, array.length);
    }

    public void reuse(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        this.check();
    }

    public byte[] getArray() {
        return this.array;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.check();
    }

    public void setLength(int length) {
        this.length = length;
        this.check();
    }

    private void check() {
        if (this.offset < 0) {
            throw new IndexOutOfBoundsException("Offset cannot be negative. ");
        }
        if (this.length < 0) {
            throw new IndexOutOfBoundsException("Length cannot be negative. ");
        }
        if (this.offset + this.length > this.array.length) {
            throw new IndexOutOfBoundsException("Offset + Length cannot be greater than array.length. ");
        }
    }
}

