/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.MonitorWithInterrupts;
import com.sap.engine.lib.lang.MonitorWithInterruptsPool;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;

public final class LongLockManagerWithInterrupts {
    private ConcurrentHashMapLongObject lockingTable = new ConcurrentHashMapLongObject();
    private MonitorWithInterruptsPool monitorPool = new MonitorWithInterruptsPool();

    private synchronized MonitorWithInterrupts getMonitor(long id) {
        MonitorWithInterrupts monitor = null;
        monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor != null) {
            ++monitor.used;
        } else {
            monitor = this.monitorPool.getMonitorWithInterrupts();
            this.lockingTable.put(id, monitor);
        }
        return monitor;
    }

    private synchronized void releaseMonitor(long id, MonitorWithInterrupts monitor) {
        if (monitor.used == 0) {
            this.lockingTable.remove(id);
            this.monitorPool.releaseMonitorWithInterrupts(monitor);
        } else {
            --monitor.used;
        }
    }

    public void readLock(long id) throws InterruptedException {
        MonitorWithInterrupts monitor = this.getMonitor(id);
        try {
            monitor.tryToAccess();
        }
        catch (InterruptedException iExc) {
            this.releaseMonitor(id, monitor);
            throw iExc;
        }
    }

    public void writeLock(long id) throws InterruptedException {
        MonitorWithInterrupts monitor = this.getMonitor(id);
        try {
            monitor.tryToChange();
        }
        catch (InterruptedException iExc) {
            this.releaseMonitor(id, monitor);
            throw iExc;
        }
    }

    public void releaseReadLock(long id) {
        MonitorWithInterrupts monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endAccess();
        this.releaseMonitor(id, monitor);
    }

    public void releaseWriteLock(long id) {
        MonitorWithInterrupts monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endChange();
        this.releaseMonitor(id, monitor);
    }
}

