/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.HashIntMonitor;
import com.sap.engine.lib.lang.Monitor;
import com.sap.engine.lib.lang.MonitorPool;
import com.sap.engine.lib.util.IntHashHolderImpl;

public final class IntLockManager {
    private HashIntMonitor lockingTable = new HashIntMonitor(11, 0.75, 10, 2, 2, new IntHashHolderImpl());
    private MonitorPool monitorPool = new MonitorPool();

    private synchronized Monitor getMonitor(int id) {
        Monitor monitor = null;
        monitor = this.lockingTable.get(id);
        if (monitor != null) {
            ++monitor.used;
        } else {
            monitor = this.monitorPool.getMonitor();
            this.lockingTable.put(id, monitor);
        }
        return monitor;
    }

    private synchronized void releaseMonitor(int id, Monitor monitor) {
        if (monitor.used == 0) {
            this.lockingTable.remove(id);
            this.monitorPool.releaseMonitor(monitor);
        } else {
            --monitor.used;
        }
    }

    public void readLock(int id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToAccess();
    }

    public void writeLock(int id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToChange();
    }

    public void releaseReadLock(int id) {
        Monitor monitor = this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endAccess();
        this.releaseMonitor(id, monitor);
    }

    public void releaseWriteLock(int id) {
        Monitor monitor = this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endChange();
        this.releaseMonitor(id, monitor);
    }
}

