/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.security.userstore.context;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.interfaces.security.userstore.listener.UserListener;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.Subject;

public interface UserContext {
    public static final String ATTRIBUTE_USERNAME = "user.name";
    public static final String ATTRIBUTE_PARENT_GROUP = "user.parentgroup";
    public static final String ATTRIBUTE_LOCKED = "user.locked";
    public static final int PROPERTY_CREATE_DATE = 1;
    public static final int PROPERTY_MODIFY_DATE = 2;
    public static final int PROPERTY_FAILED_LOGON_COUNT = 3;
    public static final int PROPERTY_LAST_FAILED_LOGON_DATE = 4;
    public static final int PROPERTY_SUCCESSFUL_LOGON_COUNT = 5;
    public static final int PROPERTY_LAST_SUCCESSFUL_LOGON_DATE = 6;
    public static final int PROPERTY_VALID_FROM_DATE = 7;
    public static final int PROPERTY_VALID_TO_DATE = 8;
    public static final int PROPERTY_LAST_CHANGED_PASSWORD_DATE = 10;
    public static final int PROPERTY_FORCE_TO_CHANGE_PASSWORD = 11;
    public static final int PROPERTY_LOCK_STATUS = 12;
    public static final int LOCKED_NO = 0;
    public static final int LOCKED_AUTO = 1;
    public static final int LOCKED_BY_ADMIN = 2;
    public static final int OPERATION_READ = 1;
    public static final int OPERATION_WRITE = 2;
    public static final int OPERATION_CHECK = 3;

    public void propertiesChanged(Properties var1);

    public void registerListener(UserListener var1, int var2) throws SecurityException;

    public void unregisterListener(UserListener var1) throws SecurityException;

    public Iterator listUsers() throws SecurityException;

    public SearchResult searchUsers(SearchFilter var1) throws SecurityException;

    public UserInfo getUserInfo(String var1) throws SecurityException;

    public UserInfo getUserInfo(X509Certificate var1) throws SecurityException;

    public UserInfo createUser(String var1) throws SecurityException;

    public void deleteUser(String var1) throws SecurityException;

    public FilterUsername getFilterUsername() throws SecurityException;

    public void setFilterUsername(FilterUsername var1) throws SecurityException;

    public FilterPassword getFilterPassword() throws SecurityException;

    public void setFilterPassword(FilterPassword var1) throws SecurityException;

    public boolean isUserPropertySupported(int var1, int var2) throws SecurityException;

    public boolean isSubjectRetrievalSupported();

    public long fillSubject(UserInfo var1, Subject var2) throws SecurityException;

    public void emptySubject(Subject var1) throws SecurityException;

    public Iterator listRootUsers() throws SecurityException;

    public int getLockAfterInvalidAttempts();

    public boolean isInEmergencyMode();

    public boolean isEmergencyUser(String var1);

    public String getEmergencyUserName();

    public SearchFilter getSearchFilter();

    public void refresh(String var1);

    public String getAnonymousUserName();
}

