/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.security.auth;

import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.lib.util.HashMapObjectObject;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;

public class PrincipalMappingConfiguration
extends AppConfigurationEntry {
    public static final String USER_STORE = "User_Store";
    public static final String MCF = "Managed_Connection_Factory";
    public static final String USER_MAPPING = "Users_Mapping";
    public static final String GROUP_MAPPING = "Groups_Mapping";
    private HashMapObjectObject userMapping = null;
    private HashMapObjectObject groupMapping = null;
    private Map options = null;

    public PrincipalMappingConfiguration(String module, AppConfigurationEntry.LoginModuleControlFlag flag, Map options) {
        super(module, flag, options);
        this.options = options;
        this.userMapping = PrincipalMappingConfiguration.convert((Map)options.get(USER_MAPPING));
        this.groupMapping = PrincipalMappingConfiguration.convert((Map)options.get(GROUP_MAPPING));
    }

    public PrincipalMappingConfiguration(Map options) {
        super("com.sap.engine.services.security.server.jaas.mapping.PrincipalMappingLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        this.options = options;
    }

    public boolean checkGroupMapping(UserStore userStore, String groupName, String identity) {
        String target = (String)this.groupMapping.get(groupName);
        if (target != null) {
            return target.equals(identity);
        }
        Iterator parents = userStore.getGroupContext().getGroupInfo(groupName).getParentGroups();
        while (parents.hasNext()) {
            if (!this.checkGroupMapping(userStore, (String)parents.next(), identity)) continue;
            return true;
        }
        return false;
    }

    public boolean checkUserMapping(UserStore userStore, String userName, String identity) {
        String target = (String)this.userMapping.get(userName);
        if (target != null) {
            return target.equals(identity);
        }
        Iterator parents = userStore.getUserContext().getUserInfo(userName).getParentGroups();
        while (parents.hasNext()) {
            if (!this.checkGroupMapping(userStore, (String)parents.next(), identity)) continue;
            return true;
        }
        return false;
    }

    public HashMapObjectObject getGroupMapping(String groupName) {
        return this.groupMapping;
    }

    public Map getOptions() {
        if (this.options != null && this.userMapping != null) {
            this.options.put(USER_MAPPING, this.userMapping);
        }
        if (this.options != null && this.groupMapping != null) {
            this.options.put(GROUP_MAPPING, this.groupMapping);
        }
        return this.options;
    }

    public HashMapObjectObject getUserMapping(String userName) {
        return this.userMapping;
    }

    public void mapGroup(String groupName, String identity) {
        this.groupMapping.put(groupName, identity);
    }

    public void mapUser(String userName, String identity) {
        this.userMapping.put(userName, identity);
    }

    public void unmapGroup(String groupName, String identity) {
        this.groupMapping.remove(groupName);
    }

    public void unmapUser(String userName, String identity) {
        this.userMapping.remove(userName);
    }

    private static final HashMapObjectObject convert(Map map) {
        if (map instanceof HashMapObjectObject) {
            return (HashMapObjectObject)((Object)map);
        }
        HashMapObjectObject result = new HashMapObjectObject();
        Iterator keys = map.keySet().iterator();
        Object key = null;
        while (keys.hasNext()) {
            key = keys.next();
            result.put(key, map.get(key));
        }
        return result;
    }
}

