/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.status;

import com.sap.engine.gui.status.ImageHolder;
import com.sap.engine.gui.status.MessageDialog;
import com.sap.engine.gui.status.ProgressThread;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.gui.status.StatusLinePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LabelProgressPanel
extends JPanel {
    private StatusLinePanel statusLinePanel;
    private JButton button;
    private JProgressBar progressBar;
    private StatusInfo currentItem;
    private Frame frame;
    private ProgressThread progressThread;

    public LabelProgressPanel(Frame frame) {
        this.frame = frame;
        this.setLayout(new BorderLayout());
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BorderLayout());
        this.statusLinePanel = new StatusLinePanel();
        this.button = new JButton();
        this.button.setPreferredSize(new Dimension(24, 24));
        this.button.setMinimumSize(new Dimension(24, 24));
        this.button.setMaximumSize(new Dimension(24, 24));
        this.button.setIcon(ImageHolder.buttonImageLetter);
        this.button.addActionListener(new ActionHandler());
        internalPanel.add((Component)this.statusLinePanel, "Center");
        internalPanel.add((Component)this.button, "East");
        this.add((Component)internalPanel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "East");
    }

    public void addItem(StatusInfo item) {
        this.currentItem = item;
        this.statusLinePanel.setItem(item);
        if (item.getStatus() != 1) {
            this.progressBar.setValue(item.getProgress());
            this.progressBar.setString(item.getProgress() + "%");
        } else {
            if (this.progressThread != null) {
                this.progressThread.kill();
            }
            this.progressThread = new ProgressThread(this.progressBar, this.statusLinePanel, this.currentItem);
            this.progressThread.start();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (LabelProgressPanel.this.currentItem != null) {
                String title = "Task ";
                switch (LabelProgressPanel.this.currentItem.getStatus()) {
                    case 1: {
                        title = title + "Running";
                        break;
                    }
                    case 2: {
                        title = title + "Error";
                        break;
                    }
                    case 0: {
                        title = title + "Finished";
                    }
                }
                MessageDialog.showDialog(LabelProgressPanel.this.frame, title, LabelProgressPanel.this.currentItem.getTitle() + "\n\n" + LabelProgressPanel.this.currentItem.getAdditionalInfo());
            }
        }
    }
}

