/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.status;

import com.sap.engine.gui.status.ImageHolder;
import com.sap.engine.gui.status.StatusInfo;
import com.sap.engine.gui.status.TaskEvent;
import com.sap.engine.gui.status.TaskEventListener;
import java.util.Vector;
import javax.swing.ImageIcon;

public class InfiniteTaskItem
implements StatusInfo {
    protected double progress;
    protected int status;
    protected String name;
    protected boolean paused;
    private Vector taskEventListeners;

    public InfiniteTaskItem() {
        this(1, 0, "");
    }

    public InfiniteTaskItem(int status, int progress, String name) {
        this.name = name;
        this.status = status;
        this.progress = progress;
    }

    public int getStatus() {
        return this.status;
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public void finished() {
        this.finished(null);
    }

    public int getProgress() {
        if (!this.paused) {
            if (this.progress >= 100.0) {
                this.status = 0;
            } else {
                this.calculate();
            }
        }
        return (int)this.progress;
    }

    public ImageIcon getImageIcon() {
        return ImageHolder.getIcon(this.status);
    }

    protected void calculate() {
        double step = (100.0 - this.progress) / 100.0;
        this.progress += step;
    }

    public String getTitle() {
        return this.name;
    }

    public String getAdditionalInfo() {
        return "No info!";
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isRunning() {
        return !this.paused;
    }

    public void startTask() {
        if (this.taskEventListeners != null) {
            int i = 0;
            while (i < this.taskEventListeners.size()) {
                final TaskEvent taskEvent = new TaskEvent(this, 0, null);
                final TaskEventListener taskEventListener = (TaskEventListener)this.taskEventListeners.elementAt(i);
                Runnable runnable = new Runnable(){

                    public void run() {
                        taskEventListener.taskEventOccured(taskEvent);
                    }
                };
                Thread eventThread = new Thread(runnable);
                eventThread.start();
                ++i;
            }
        }
    }

    public void finished(Object taskResult) {
        this.progress = 100.0;
        if (this.taskEventListeners != null) {
            int i = 0;
            while (i < this.taskEventListeners.size()) {
                final TaskEvent taskEvent = new TaskEvent(this, 1, taskResult);
                final TaskEventListener taskEventListener = (TaskEventListener)this.taskEventListeners.elementAt(i);
                Runnable runnable = new Runnable(){

                    public void run() {
                        taskEventListener.taskEventOccured(taskEvent);
                    }
                };
                Thread eventThread = new Thread(runnable);
                eventThread.start();
                ++i;
            }
        }
    }

    public void registerTaskEventListener(TaskEventListener taskEventListener) {
        if (this.taskEventListeners == null) {
            this.taskEventListeners = new Vector();
        }
        this.taskEventListeners.addElement(taskEventListener);
    }

    public void unregisterTaskEventListener(TaskEventListener taskEventListener) {
        if (this.taskEventListeners != null) {
            this.taskEventListeners.remove(taskEventListener);
            if (this.taskEventListeners.size() == 0) {
                this.taskEventListeners = null;
            }
        }
    }
}

