/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.lf;

import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelFactory {
    protected Vector lfNames = new Vector();
    protected Vector lfClassNames = new Vector();
    protected int systemLFCount = 0;

    public LookAndFeelFactory() {
        this.addSystemLF();
    }

    public void load(Properties props) {
        String names = props.getProperty("UsersLookAndFeelNames");
        String classNames = props.getProperty("UsersLookAndFeelClasses");
        if (names != null && names.trim().length() > 0 && classNames != null && classNames.trim().length() > 0) {
            StringTokenizer namesToken = new StringTokenizer(names, ";");
            StringTokenizer classToken = new StringTokenizer(classNames, ";");
            while (namesToken.hasMoreTokens() && classToken.hasMoreTokens()) {
                this.add(namesToken.nextToken().trim(), classToken.nextToken().trim());
            }
        }
    }

    public void store(Properties props) {
        String names = "";
        String classNames = "";
        int i = this.systemLFCount;
        while (i < this.lfNames.size()) {
            if (i > this.systemLFCount) {
                names = names + ";";
                classNames = classNames + ";";
            }
            names = names + this.lfNames.elementAt(i);
            classNames = classNames + this.lfClassNames.elementAt(i);
            ++i;
        }
        ((Hashtable)props).put("UsersLookAndFeelNames", names);
        ((Hashtable)props).put("UsersLookAndFeelClasses", classNames);
    }

    public void add(String name, String className) {
        int i = this.lfNames.indexOf(name);
        if (i < 0) {
            this.lfNames.addElement(name);
            this.lfClassNames.addElement(className);
        } else {
            this.lfClassNames.setElementAt(className, i);
        }
    }

    public int getSystemLFCount() {
        return this.systemLFCount;
    }

    public Vector getLookAndFeelNames() {
        return this.lfNames;
    }

    public String getLFClassName(String name) {
        int i = this.lfNames.indexOf(name);
        if (i < 0) {
            return null;
        }
        return (String)this.lfClassNames.elementAt(i);
    }

    public void removeLookAndFeel(String name) {
        int i = this.lfNames.indexOf(name);
        if (i < 0) {
            return;
        }
        this.lfNames.removeElementAt(i);
        this.lfClassNames.removeElementAt(i);
    }

    protected void addSystemLF() {
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        this.systemLFCount = lookAndFeels.length;
        int i = 0;
        while (i < this.systemLFCount) {
            this.add(lookAndFeels[i].getName(), lookAndFeels[i].getClassName());
            ++i;
        }
    }

    public void installLookAndFeel(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        int i = this.lfNames.indexOf(name);
        if (i < 0) {
            throw new ClassNotFoundException("No information about " + name + " Look And Feel");
        }
        UIManager.setLookAndFeel((String)this.lfClassNames.elementAt(i));
    }
}

