/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.lf;

import com.sap.engine.gui.editorproperties.PropertyEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;

public class LFEditor
extends PropertyEditor {
    protected String currentLaf;
    protected JLabel lafLabel;
    private String[] defaultLafs;
    private int currentLafIndex;

    public LFEditor(Properties lafs, String currentLaf, JLabel lafLabel) {
        super("Name", "Class Name");
        this.lafLabel = lafLabel;
        this.currentLaf = currentLaf;
        UIManager.LookAndFeelInfo[] lfInfos = UIManager.getInstalledLookAndFeels();
        this.defaultLafs = new String[lfInfos.length];
        int i = 0;
        while (i < lfInfos.length) {
            ((Hashtable)lafs).put(lfInfos[i].getName(), lfInfos[i].getClassName());
            this.defaultLafs[i] = lfInfos[i].getName();
            ++i;
        }
        Object[] lafNames = new String[((Hashtable)lafs).size()];
        String[] lafValues = new String[((Hashtable)lafs).size()];
        int index = 0;
        Enumeration<?> enumeration = lafs.propertyNames();
        while (enumeration.hasMoreElements()) {
            lafNames[index] = (String)enumeration.nextElement();
            lafValues[index] = lafs.getProperty(lafNames[index]);
            ++index;
        }
        int i2 = 0;
        while (i2 < lafNames.length - 1) {
            int m = i2;
            int j = i2 + 1;
            while (j < lafNames.length) {
                if (((String)lafNames[j]).compareTo((String)lafNames[m]) < 0) {
                    m = j;
                }
                ++j;
            }
            Object h = lafNames[i2];
            lafNames[i2] = lafNames[m];
            lafNames[m] = h;
            h = lafValues[i2];
            lafValues[i2] = lafValues[m];
            lafValues[m] = h;
            ++i2;
        }
        this.currentLafIndex = this.indexInArray(currentLaf, lafNames);
        this.initProperties((String[])lafNames, lafValues);
        this.table.getSelectionModel().setSelectionInterval(this.currentLafIndex, this.currentLafIndex);
        this.table.scrollRectToVisible(this.table.getCellRect(this.currentLafIndex, 0, true));
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
        if (lse == null || lse.getValueIsAdjusting()) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.table.getSelectionModel().setSelectionInterval(this.currentLafIndex, this.currentLafIndex);
            return;
        }
        this.currentLafIndex = row;
        this.currentLaf = (String)this.table.getValueAt(row, 0);
        this.lafLabel.setText("Current Look and Feel: " + this.currentLaf);
        this.removeButton.setEnabled(this.indexInArray(this.currentLaf, this.defaultLafs) == -1);
    }

    protected String getLafName() {
        return this.currentLaf;
    }

    protected String getLafClass() {
        return (String)((Hashtable)this.getProps()).get(this.currentLaf);
    }

    protected Properties getLafs() {
        return this.getProps();
    }

    private int indexInArray(Object o, Object[] a) {
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                if (a[i].equals(o)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

