/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.filechooser.ui;

import com.sap.engine.gui.filechooser.FCFile;
import com.sap.engine.gui.lf.LookAndFeelHandler;
import com.sap.engine.gui.lf.LookAndFeelListener;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class StandartFCPopUpMenu
extends JPopupMenu
implements LookAndFeelListener {
    private JMenu NewSubMenu;
    JMenuItem openItem;
    JMenuItem newFolderItem;
    JMenuItem deleteItem;
    JMenuItem renameItem;
    JList files;
    FCFile selected;

    public StandartFCPopUpMenu(JList lFiles) {
        this.init(lFiles);
    }

    protected void init(JList files) {
        this.files = files;
        this.selected = (FCFile)files.getSelectedValue();
        this.openItem = new JMenuItem("Open Folder");
        this.openItem.setActionCommand("DIR_CHNG_CMD");
        this.add(this.openItem);
        this.deleteItem = new JMenuItem("Delete");
        this.deleteItem.setActionCommand("DELETE_CMD");
        this.add(this.deleteItem);
        this.renameItem = new JMenuItem("Rename");
        this.renameItem.setActionCommand("RENAME_CMD");
        this.add(this.renameItem);
        this.addSeparator();
        this.newFolderItem = new JMenuItem("New Folder");
        this.newFolderItem.setActionCommand("MKDIR_CMD");
        this.add(this.newFolderItem);
        LookAndFeelHandler.addLookAndFeelListener(this);
    }

    public void show(JList list, int x, int y) {
        this.files = list;
        this.selected = (FCFile)this.files.getSelectedValue();
        if (this.selected == null) {
            this.openItem.setEnabled(false);
            this.deleteItem.setEnabled(false);
            this.renameItem.setEnabled(false);
        } else if (this.selected.isDirectory()) {
            this.openItem.setEnabled(true);
            this.deleteItem.setEnabled(true);
            this.renameItem.setEnabled(true);
        } else {
            this.openItem.setEnabled(false);
            this.deleteItem.setEnabled(true);
            this.renameItem.setEnabled(true);
        }
        LookAndFeelHandler.addLookAndFeelListener(this);
        super.show(list, x, y);
    }

    public void lookAndFeelChanged() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void setDelegate(ActionListener al) {
        this.openItem.addActionListener(al);
        this.deleteItem.addActionListener(al);
        this.renameItem.addActionListener(al);
        this.newFolderItem.addActionListener(al);
    }
}

