/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.filechooser.ui;

import com.sap.engine.gui.filechooser.DriveObject;
import com.sap.engine.gui.filechooser.FCFile;
import com.sap.engine.gui.filechooser.FileChooserListener;
import com.sap.engine.gui.filechooser.FileFilter;
import com.sap.engine.gui.filechooser.ui.ClickListener;
import com.sap.engine.gui.filechooser.ui.FCComboCellRenderer;
import com.sap.engine.gui.filechooser.ui.FCListCellRenderer;
import com.sap.engine.gui.filechooser.ui.FCListModel;
import com.sap.engine.gui.filechooser.ui.FCMouseListener;
import com.sap.engine.gui.filechooser.ui.FileChooserUI;
import com.sap.engine.gui.filechooser.ui.StandartFCPopUpMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StandardFileChooserUI
extends FileChooserUI
implements ActionListener,
ListSelectionListener,
DocumentListener,
ClickListener {
    JLabel curDirL = new JLabel();
    JTextField selFileTF = new JTextField();
    JComboBox filtersCB = new JComboBox();
    JButton okB = new JButton();
    JButton canB = new JButton();
    JButton upB = new JButton();
    JButton mkDirB = new JButton();
    JButton homeB = new JButton();
    JComboBox drivesCB = new JComboBox();
    JScrollBar vertBar;
    StandartFCPopUpMenu popUp;
    FCListModel lModel = new FCListModel();
    JList filesL = new JList(this.lModel);
    int type;
    String chngDir;

    public StandardFileChooserUI(FileChooserListener l) {
        super(l);
        JPanel controlP = new JPanel();
        JPanel filesP = new JPanel();
        JPanel infoP = new JPanel();
        JPanel comboP = new JPanel();
        JPanel btnP = new JPanel();
        JLabel fTypeL = new JLabel();
        JLabel fNameL = new JLabel();
        JLabel lookL = new JLabel();
        JScrollPane scrPane = new JScrollPane();
        this.vertBar = scrPane.getVerticalScrollBar();
        this.popUp = new StandartFCPopUpMenu(this.filesL);
        this.popUp.setDelegate(this);
        this.upB.setIcon(new ImageIcon(this.getClass().getResource("icons/upFolder.gif")));
        this.mkDirB.setIcon(new ImageIcon(this.getClass().getResource("icons/newFolder.gif")));
        this.homeB.setIcon(new ImageIcon(this.getClass().getResource("icons/home.gif")));
        this.upB.setToolTipText("Up One Level");
        this.homeB.setToolTipText("Home");
        this.mkDirB.setToolTipText("Create New Folder");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        controlP.setLayout(new BorderLayout());
        filesP.setLayout(new BorderLayout());
        infoP.setLayout(new GridBagLayout());
        fTypeL.setText("Files of Type:");
        fNameL.setText("File Name:");
        this.okB.setText("OK");
        this.canB.setText("Cancel");
        this.curDirL.setText(" ");
        comboP.setLayout(new GridBagLayout());
        this.upB.setPreferredSize(new Dimension(28, 23));
        this.homeB.setPreferredSize(new Dimension(28, 23));
        this.mkDirB.setPreferredSize(new Dimension(28, 23));
        lookL.setText("Look in:");
        this.add((Component)controlP, "North");
        controlP.add((Component)comboP, "West");
        comboP.add((Component)lookL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        comboP.add((Component)this.drivesCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 25, 0, 0), 40, 0));
        controlP.add((Component)btnP, "East");
        btnP.setLayout(new GridBagLayout());
        btnP.add((Component)this.upB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        btnP.add((Component)this.homeB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        btnP.add((Component)this.mkDirB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)filesP, "Center");
        filesP.setBorder(new EmptyBorder(10, 0, 0, 0));
        filesP.add((Component)scrPane, "Center");
        filesP.add((Component)this.curDirL, "North");
        scrPane.setViewportView(this.filesL);
        this.add((Component)infoP, "South");
        infoP.add((Component)fTypeL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        infoP.add((Component)fNameL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        infoP.add((Component)this.selFileTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        infoP.add((Component)this.okB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(15, 10, 5, 0), 0, 0));
        infoP.add((Component)this.filtersCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 10), 0, 0));
        infoP.add((Component)this.canB, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.filesL.setCellRenderer(new FCListCellRenderer());
        scrPane.setPreferredSize(new Dimension(400, 170));
        this.drivesCB.setRenderer(new FCComboCellRenderer());
        this.okB.addActionListener(this);
        this.okB.setActionCommand("OK_CMD");
        this.canB.addActionListener(this);
        this.canB.setActionCommand("CANCEL_CMD");
        this.upB.addActionListener(this);
        this.upB.setActionCommand("UP_CMD");
        this.homeB.addActionListener(this);
        this.homeB.setActionCommand("HOME_CMD");
        this.mkDirB.addActionListener(this);
        this.mkDirB.setActionCommand("MKDIR_CMD");
        this.drivesCB.addActionListener(this);
        this.drivesCB.setActionCommand("DRIVE_CMD");
        this.filtersCB.addActionListener(this);
        this.filtersCB.setActionCommand("FILTER_CHNG_CMD");
        this.filesL.addListSelectionListener(this);
        this.selFileTF.getDocument().addDocumentListener(this);
        this.filesL.addMouseListener(new FCMouseListener(this));
        this.selFileTF.addActionListener(this);
        this.selFileTF.setActionCommand("OK_CMD");
    }

    public void setFileChooserType(int type) {
        this.type = type;
    }

    public void setMultipleSelectionEnabled(boolean flag) {
        if (flag) {
            this.filesL.setSelectionMode(2);
        } else {
            this.filesL.setSelectionMode(0);
        }
    }

    public void setFileList(FCFile[] fObj) {
        Vector<FCFile> data = new Vector<FCFile>();
        int countDirs = 0;
        int i = 0;
        while (i < fObj.length) {
            if (fObj[i].isFile()) {
                data.addElement(fObj[i]);
            } else {
                data.insertElementAt(fObj[i], countDirs);
                ++countDirs;
            }
            ++i;
        }
        this.lModel.setData(data);
        this.filesL.getSelectionModel().clearSelection();
        this.vertBar.setValue(0);
    }

    public void setDriveList(DriveObject[] drives) {
        this.drivesCB.removeActionListener(this);
        if (this.drivesCB.getItemCount() > 0) {
            this.drivesCB.removeAllItems();
        }
        int i = 0;
        while (i < drives.length) {
            this.drivesCB.addItem(drives[i]);
            ++i;
        }
        this.drivesCB.addActionListener(this);
    }

    public void setFileName(String name) {
        this.selFileTF.setText(name);
        this.checkIfEmpty();
    }

    public void setCurrentDirectory(String dir) {
        this.curDirL.setText(dir);
    }

    public void setCurrentDrive(DriveObject drvObject) {
        this.drivesCB.removeActionListener(this);
        this.drivesCB.setSelectedItem(drvObject);
        this.drivesCB.addActionListener(this);
    }

    public void setFileFilters(FileFilter[] filters) {
        this.filtersCB.removeActionListener(this);
        if (this.filtersCB.getItemCount() > 0) {
            this.filtersCB.removeAllItems();
        }
        int i = 0;
        i = 0;
        while (i < filters.length) {
            this.filtersCB.addItem(filters[i]);
            ++i;
        }
        this.filtersCB.addActionListener(this);
    }

    public void setSelectedFileFilter(FileFilter f) {
        this.filtersCB.setSelectedItem(f);
    }

    public String[] getSelectedFileNames() {
        Vector<String> files = new Vector<String>();
        StringTokenizer sTok = new StringTokenizer(this.selFileTF.getText(), "\"");
        while (sTok.hasMoreElements()) {
            String tok = sTok.nextToken();
            if (tok.equals(" ")) continue;
            files.addElement(tok);
        }
        Object[] f = new String[files.size()];
        files.copyInto(f);
        return f;
    }

    public FileFilter getSelectedFileFilter() {
        return (FileFilter)this.filtersCB.getSelectedItem();
    }

    public DriveObject getSelectedDrive() {
        return (DriveObject)this.drivesCB.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selFileTF) {
            if (this.okB.isEnabled()) {
                this.fireCommand(e.getActionCommand());
            }
        } else {
            if (e.getSource() == this.popUp.openItem && this.filesL.getSelectedValue() != null) {
                this.chngDir = ((FCFile)this.filesL.getSelectedValue()).getName();
            }
            this.fireCommand(e.getActionCommand());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int[] ind = this.filesL.getSelectedIndices();
        if (ind.length == 0) {
            this.selFileTF.setText("");
            return;
        }
        if (ind.length == 1) {
            if (ind[0] < 0 || ind[0] >= this.lModel.getSize()) {
                this.selFileTF.setText("");
                return;
            }
            FCFile fObj = (FCFile)this.lModel.getElementAt(ind[0]);
            if (fObj.isDirectory() && this.type == 0) {
                this.selFileTF.setText("");
                return;
            }
            this.selFileTF.setText(fObj.getName());
            return;
        }
        String text = "";
        int i = 0;
        while (i < ind.length) {
            FCFile fObj;
            if (!(ind[i] < 0 || ind[i] >= this.lModel.getSize() || (fObj = (FCFile)this.lModel.getElementAt(ind[i])).isDirectory() && this.type == 0)) {
                String name = fObj.getName();
                text = text + "\"" + name + "\" ";
            }
            ++i;
        }
        this.selFileTF.setText(text);
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkIfEmpty();
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkIfEmpty();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkIfEmpty();
    }

    protected void checkIfEmpty() {
        this.okB.setEnabled(!this.selFileTF.getText().equals(""));
    }

    public void processClicks() {
        int ind = this.filesL.getSelectedIndex();
        if (ind < 0 || ind >= this.lModel.getSize()) {
            return;
        }
        FCFile fObj = (FCFile)this.lModel.getElementAt(ind);
        if (fObj.isFile()) {
            this.okB.doClick();
            return;
        }
        this.chngDir = fObj.getName();
        this.fireCommand("DIR_CHNG_CMD");
    }

    public int getClickCount() {
        return 2;
    }

    public String getChangedDir() {
        return this.chngDir;
    }

    public JList getList() {
        return this.filesL;
    }

    public void showPopupMenu(MouseEvent e) {
        this.popUp.show(this.filesL, e.getX(), e.getY());
    }

    public void setSelectedDrive(int drive) {
        this.drivesCB.removeActionListener(this);
        this.drivesCB.setSelectedIndex(drive);
        this.drivesCB.addActionListener(this);
    }

    public void clearTextField() {
        this.selFileTF.setText("");
    }
}

