/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.filechooser;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.gui.filechooser.DefaultFileObject;
import com.sap.engine.gui.filechooser.DriveObject;
import com.sap.engine.gui.filechooser.FileObject;
import com.sap.engine.gui.filechooser.FileSystem;
import java.io.File;
import java.util.Vector;

public class DefaultFileSystem
implements FileSystem {
    public DriveObject[] getSystemDrives() {
        String osName = SystemProperties.getProperty("os.name");
        if (File.separatorChar == '/') {
            return this.getUnixDrive();
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return this.getWindowsDrives();
        }
        if (osName.toLowerCase().startsWith("netware")) {
            return this.getNetwareDrive();
        }
        return this.getDefaultDrive();
    }

    protected DriveObject[] getUnixDrive() {
        DriveObject drvObj = new DriveObject("/", 2);
        return new DriveObject[]{drvObj};
    }

    protected DriveObject[] getNetwareDrive() {
        DriveObject drvObj = new DriveObject("Sys:\\", 2);
        return new DriveObject[]{drvObj};
    }

    protected DriveObject[] getWindowsDrives() {
        Vector<String> vector = new Vector<String>();
        char c = 'C';
        while (c <= 'Z') {
            char[] ac = new char[]{c, ':', '\\'};
            String s = new String(ac);
            File file = new File(s);
            if (file != null && file.exists()) {
                vector.addElement(s);
            }
            c = (char)(c + 1);
        }
        int i = vector.size() + 2;
        DriveObject[] result = new DriveObject[i];
        result[0] = new DriveObject("A:\\", 1);
        result[1] = new DriveObject("B:\\", 1);
        int j = 2;
        while (j < i) {
            result[j] = new DriveObject((String)vector.elementAt(j - 2), 2);
            ++j;
        }
        return result;
    }

    protected DriveObject[] getDefaultDrive() {
        String homeDir = SystemProperties.getProperty("user.home");
        int ind = homeDir.indexOf(File.separatorChar);
        String drv = "";
        drv = ind >= 0 ? homeDir.substring(0, ind + 1) : homeDir + File.separatorChar;
        return new DriveObject[]{new DriveObject(drv, 2)};
    }

    public FileObject getFile(String file) {
        if (file == null) {
            return null;
        }
        return new DefaultFileObject(file);
    }

    public String getUserDirectory() {
        return SystemProperties.getProperty("user.dir");
    }

    public String getHomeDirectory() {
        return SystemProperties.getProperty("user.home");
    }

    public String getFileSeparator() {
        return SystemProperties.getProperty("file.separator");
    }

    public boolean createDirectory(String d) {
        return new File(d).mkdirs();
    }

    public boolean setFileName(String oldName, String newName) {
        File newFile = new File(newName);
        return new File(oldName).renameTo(newFile);
    }

    public boolean deleteFile(String[] filenames) {
        boolean successful = true;
        int i = 0;
        while (i < filenames.length) {
            boolean success = new File(filenames[i]).delete();
            if (!success) {
                successful = false;
            }
            ++i;
        }
        return successful;
    }
}

