/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DiagramProgressBar;
import com.sap.engine.gui.diagram.SingleDiagramGridPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SingleDiagramPanel
extends JPanel {
    protected int maxValue;
    protected int minValue;
    protected Color color;
    protected int step = 5;
    protected int gridSize = 20;
    protected boolean isProgressBar = true;
    protected SingleDiagramGridPane grid;
    protected DiagramProgressBar bar;
    protected JLabel maxLabel;
    protected JLabel barLabel;
    protected JLabel valueLabel;
    protected JLabel nameLabel;

    public SingleDiagramPanel(boolean isProgress) {
        this.isProgressBar = isProgress;
        this.initDefaults();
        this.initView();
    }

    protected void initView() {
        this.setBackground(Color.black);
        this.setLayout(new GridBagLayout());
        JPanel labelsPanel = new JPanel();
        labelsPanel.setLayout(new GridBagLayout());
        labelsPanel.setBackground(Color.black);
        Color color = new Color(0, 255, 0);
        this.setColor(color);
        int i = 4;
        if (this.isProgressBar) {
            i = 3;
        }
        labelsPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 15), 0, 0));
        labelsPanel.add((Component)this.valueLabel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 25), 0, 0));
        labelsPanel.add((Component)this.barLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)this.maxLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 3), 0, 0));
        this.add((Component)this.grid, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        if (this.isProgressBar) {
            this.add((Component)this.bar, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(5, 3, 0, 5), 0, 0));
        }
        this.add((Component)labelsPanel, new GridBagConstraints(1, 1, i, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        if (this.isProgressBar) {
            this.bar.setMaxValue(maxValue);
        }
        this.grid.setMaxValue(maxValue);
        if (maxValue != Integer.MAX_VALUE) {
            this.maxLabel.setText(maxValue + "");
        } else {
            this.maxLabel.setText("Max");
        }
    }

    public void setMinValues(int minValue) {
        this.minValue = minValue;
        if (this.isProgressBar) {
            this.bar.setMinValue(minValue);
        }
        this.grid.setMinValue(minValue);
    }

    public void setNameLabel(String name) {
        this.nameLabel.setText(name);
    }

    public void setColor(Color color) {
        this.color = color;
        this.maxLabel.setForeground(color);
        this.barLabel.setForeground(color);
        this.valueLabel.setForeground(color);
        this.nameLabel.setForeground(color);
        if (this.isProgressBar) {
            this.bar.setColor(color);
        }
        this.grid.setColor(color);
    }

    public void setValue(int value) {
        this.valueLabel.setText("" + value);
        this.barLabel.setText("" + (int)((float)(value - this.minValue) / (float)this.maxValue * 100.0f) + "%");
        if (this.isProgressBar) {
            this.bar.setValue(value);
        }
        this.grid.setValue(value);
    }

    protected void initDefaults() {
        this.maxValue = 100;
        this.minValue = 0;
        this.color = Color.green;
        Font font = new Font("serif", 0, 10);
        this.maxLabel = new JLabel();
        if (this.maxValue != Integer.MAX_VALUE) {
            this.maxLabel.setText(this.maxValue + "");
        } else {
            this.maxLabel.setText("Max");
        }
        this.maxLabel.setBackground(Color.black);
        this.maxLabel.setFont(font);
        this.nameLabel = new JLabel(" ");
        this.nameLabel.setBackground(Color.black);
        this.barLabel = new JLabel();
        this.barLabel.setText("0%");
        this.barLabel.setBackground(Color.black);
        this.barLabel.setFont(font);
        this.valueLabel = new JLabel();
        this.valueLabel.setPreferredSize(new Dimension(40, 30));
        this.valueLabel.setText("0");
        this.valueLabel.setBackground(Color.black);
        this.valueLabel.setVerticalAlignment(1);
        if (this.isProgressBar) {
            this.bar = new DiagramProgressBar(this.minValue, this.maxValue, this.gridSize / 4);
            this.bar.setPreferredSize(new Dimension(15, 20));
        }
        this.grid = new SingleDiagramGridPane(this.minValue, this.maxValue, this.gridSize, this.gridSize, this.color);
    }

    public void reset() {
        this.grid.reset();
    }
}

