/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DiagramBuffer;
import com.sap.engine.gui.diagram.DiagramIterator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class SingleDiagramGridPane
extends JPanel {
    public static final int MAX_SCREEN_SIZE = 1024;
    protected int maxValue;
    protected int minValue;
    protected Color color;
    protected Color gridColor;
    protected int gridSizeX;
    protected int gridSizeY;
    private DiagramBuffer data;
    private int step;
    private int maxCount;
    private Dimension dim;

    public SingleDiagramGridPane(int minValue, int maxValue, int gridSizeX, int gridSizeY, Color color) {
        this(minValue, maxValue, gridSizeX, gridSizeY, color, new Color(0, 127, 0));
    }

    public SingleDiagramGridPane(int minValue, int maxValue, int gridSizeX, int gridSizeY, Color color, Color gridColor) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.color = color;
        this.gridColor = gridColor;
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.setStep(3);
    }

    public void setValue(int value) {
        this.data.add(value - this.minValue);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setgridSizeX(int gridSizeX) {
        this.gridSizeX = gridSizeX;
    }

    public void setgridSizeY(int gridSizeY) {
        this.gridSizeY = gridSizeY;
    }

    public void setStep(int step) {
        this.step = step;
        this.maxCount = 1024 / step;
        this.data = new DiagramBuffer(this.maxCount);
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    protected void drowHorLine(Graphics g, int width, int height) {
        int i = height - 1;
        while (i > -this.gridSizeY) {
            g.drawLine(0, i, width, i);
            i -= this.gridSizeY;
        }
    }

    protected void drowVertLine(Graphics g, int width, int height) {
        int i = width - 1;
        while (i > -this.gridSizeX) {
            g.drawLine(i, 0, i, height);
            i -= this.gridSizeX;
        }
    }

    protected void drowPoints(Graphics g, int width, int height) {
        int x = width;
        int x1 = width;
        int y = height;
        int y1 = height;
        float range = 0.0f;
        range = (float)height / (float)(this.maxValue - this.minValue);
        g.setColor(this.color);
        DiagramIterator iterator = this.data.getIterator();
        x = width;
        if (iterator.hasMore()) {
            int q = iterator.next();
            y = q != 0 ? (int)((float)height - (float)q * range) : height - 1;
        } else {
            return;
        }
        int i = width - this.step;
        while (iterator.hasMore() && i > -this.step) {
            y1 = (int)((float)height - (float)iterator.next() * range);
            g.drawLine(i, y1, x, y);
            x = i;
            y = y1;
            i -= this.step;
        }
    }

    public void reset() {
        this.data.reset();
    }

    public void paint(Graphics g) {
        this.dim = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.dim.width, this.dim.height);
        g.setColor(this.gridColor);
        this.drowHorLine(g, this.dim.width, this.dim.height);
        this.drowVertLine(g, this.dim.width, this.dim.height);
        this.drowPoints(g, this.dim.width, this.dim.height);
    }
}

