/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DiagramBuffer;
import com.sap.engine.gui.diagram.DiagramIterator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class MultiDiagramGridPane
extends JPanel {
    public static final int MAX_SCREEN_SIZE = 1024;
    protected int[] maxValues;
    protected int[] minValues;
    protected Color[] colors;
    protected Color gridColor;
    protected int gridSizeX;
    protected int gridSizeY;
    protected int diagramsCount = 0;
    private DiagramBuffer[] data;
    private int step;
    private int maxCount;
    private Dimension dim;

    public MultiDiagramGridPane(int[] minValues, int[] maxValues, int gridSizeX, int gridSizeY, Color[] colors) {
        this(minValues, maxValues, gridSizeX, gridSizeY, colors, new Color(0, 127, 0));
    }

    public MultiDiagramGridPane(int[] minValues, int[] maxValues, int gridSizeX, int gridSizeY, Color[] colors, Color gridColor) {
        this.diagramsCount = maxValues.length;
        this.maxValues = new int[this.diagramsCount];
        this.minValues = new int[this.diagramsCount];
        this.maxValues = maxValues;
        this.minValues = minValues;
        this.colors = colors;
        this.gridColor = gridColor;
        this.gridSizeX = gridSizeX;
        this.gridSizeY = gridSizeY;
        this.data = new DiagramBuffer[this.diagramsCount];
        this.setStep(3);
    }

    public void setValue(int[] values) {
        int i = 0;
        while (i < values.length) {
            this.data[i].add(values[i] - this.minValues[i]);
            ++i;
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public void setColor(Color[] colors) {
        this.colors = colors;
    }

    public void setgridSizeX(int gridSizeX) {
        this.gridSizeX = gridSizeX;
    }

    public void setgridSizeY(int gridSizeY) {
        this.gridSizeY = gridSizeY;
    }

    public void setStep(int step) {
        this.step = step;
        this.maxCount = 1024 / step;
        int i = 0;
        while (i < this.diagramsCount) {
            this.data[i] = new DiagramBuffer(this.maxCount);
            ++i;
        }
    }

    public void setMaxValue(int[] maxValues) {
        this.maxValues = maxValues;
    }

    public void setMinValue(int[] minValues) {
        this.minValues = minValues;
    }

    protected void drawHorLine(Graphics g, int width, int height) {
        int i = height - 1;
        while (i > -this.gridSizeY) {
            g.drawLine(0, i, width, i);
            i -= this.gridSizeY;
        }
    }

    protected void drawVertLine(Graphics g, int width, int height) {
        int i = width - 1;
        while (i > -this.gridSizeX) {
            g.drawLine(i, 0, i, height);
            i -= this.gridSizeX;
        }
    }

    protected void drawPoints(Graphics g, int width, int height) {
        int x = width;
        int y = height;
        int y1 = height;
        float[] range = new float[this.diagramsCount];
        DiagramIterator[] iterators = new DiagramIterator[this.diagramsCount];
        int l = 0;
        while (l < this.diagramsCount) {
            range[l] = (float)height / (float)(this.maxValues[l] - this.minValues[l]);
            g.setColor(this.colors[l]);
            x = width;
            iterators[l] = this.data[l].getIterator();
            if (iterators[l].hasMore()) {
                int q = iterators[l].next();
                y = q != 0 ? (int)((float)height - (float)q * range[l]) : height - 1;
            } else {
                return;
            }
            int i = width - this.step;
            while (iterators[l].hasMore() && i > -this.step) {
                int q = iterators[l].next();
                y1 = q != 0 ? (int)((float)height - (float)q * range[l]) : height - 1;
                g.drawLine(i, y1, x, y);
                x = i;
                y = y1;
                i -= this.step;
            }
            ++l;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i].reset();
            ++i;
        }
    }

    public void paint(Graphics g) {
        this.dim = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.dim.width, this.dim.height);
        g.setColor(this.gridColor);
        this.drawHorLine(g, this.dim.width, this.dim.height);
        this.drawVertLine(g, this.dim.width, this.dim.height);
        this.drawPoints(g, this.dim.width, this.dim.height);
    }
}

