/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class DiagramProgressBar
extends JPanel {
    protected int maxValue;
    protected int minValue;
    protected Color color;
    protected Color bgColor;
    protected Color maxColor;
    protected int gridSize;
    protected int maxTact = 0;
    protected int delayTact = 5;
    protected boolean isMaxValue = true;
    private int currentMax;
    private int currentValue;
    private Dimension dim;

    public DiagramProgressBar() {
        this(0, 100, 10);
    }

    public DiagramProgressBar(int minValue, int maxValue, int gridSize) {
        this(minValue, maxValue, gridSize, true);
    }

    public DiagramProgressBar(int minValue, int maxValue, int gridSize, boolean isMaxValue) {
        this(minValue, maxValue, gridSize, isMaxValue, Color.green, new Color(0, 100, 0), new Color(200, 10, 10));
    }

    public DiagramProgressBar(int minValue, int maxValue, int gridSize, boolean isMaxValue, Color color, Color bgColor, Color maxColor) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.currentMax = minValue;
        this.currentValue = minValue;
        this.color = color;
        this.bgColor = bgColor;
        this.maxColor = maxColor;
        this.isMaxValue = isMaxValue;
        this.gridSize = gridSize;
    }

    public void setValue(int value) {
        this.currentValue = value - this.minValue;
        ++this.maxTact;
        if (this.maxTact > this.delayTact) {
            this.currentMax = -1;
        }
        if (this.currentValue > this.currentMax) {
            this.currentMax = this.currentValue;
            this.maxTact = 0;
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDelayTact(int delayTact) {
        this.delayTact = delayTact;
    }

    public void setgridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setIsMaxValue(boolean isMaxValue) {
        this.isMaxValue = isMaxValue;
    }

    public void setMaxColor(Color maxColor) {
        this.maxColor = maxColor;
    }

    public void setMaxTact(int maxTact) {
        this.maxTact = maxTact;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void paint(Graphics g) {
        this.dim = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.dim.width, this.dim.height);
        g.setColor(this.bgColor);
        int gridCount = (int)((double)((float)this.dim.height / (float)this.gridSize) + 0.5);
        int y = this.dim.height - this.gridSize + 1;
        int x2 = this.dim.width - 2;
        int value = (int)((float)this.currentValue / (float)(this.maxValue - this.minValue) * (float)gridCount);
        int max = (int)((float)this.currentMax / (float)(this.maxValue - this.minValue) * (float)gridCount);
        int i = 0;
        while (y > -this.gridSize) {
            g.setColor(this.bgColor);
            if (i < value) {
                g.setColor(this.color);
            }
            if (this.isMaxValue && i == max) {
                g.setColor(this.maxColor);
            }
            g.fillRect(1, y, this.dim.width, this.gridSize - 1);
            y -= this.gridSize;
            ++i;
        }
    }
}

