/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.diagram;

import com.sap.engine.gui.diagram.DiagramGridPane;
import com.sap.engine.gui.diagram.DiagramProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DiagramPanel
extends JPanel {
    protected int count;
    protected int[] maxValues;
    protected int[] minValues;
    protected Color[] colors;
    protected int step = 5;
    protected int gridSize = 20;
    protected boolean isProgressBar = true;
    protected DiagramGridPane grid;
    protected DiagramProgressBar[] bars;
    protected JLabel[] maxLabels;
    protected JLabel[] barLabels;
    protected JLabel[] valueLabels;

    public DiagramPanel(int count, boolean isProgress) {
        this.count = count;
        this.isProgressBar = isProgress;
        this.maxValues = new int[count];
        this.minValues = new int[count];
        this.colors = new Color[count];
        this.bars = new DiagramProgressBar[count];
        this.maxLabels = new JLabel[count];
        this.barLabels = new JLabel[count];
        this.valueLabels = new JLabel[count];
        this.initDefaults();
        this.initView();
    }

    protected void initView() {
        this.setBackground(Color.black);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.grid, new GridBagConstraints(1, 0, this.count, this.count, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        int i = 0;
        while (i < this.count) {
            this.add((Component)this.maxLabels[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.valueLabels[i], new GridBagConstraints(i + 1, this.count + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.bars[i], new GridBagConstraints(this.count + 1 + i, 0, 1, this.count, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.barLabels[i], new GridBagConstraints(this.count + 1 + i, this.count + 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++i;
        }
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setMaxValues(int[] maxValues) {
        this.maxValues = maxValues;
    }

    public void setMinValues(int[] minValues) {
        this.minValues = minValues;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        int i = 0;
        while (i < this.count) {
            this.maxLabels[i].setForeground(colors[i]);
            this.barLabels[i].setForeground(colors[i]);
            this.valueLabels[i].setForeground(colors[i]);
            this.bars[i].setColor(colors[i]);
            ++i;
        }
        this.grid.setColor(colors);
    }

    public void setValue(int[] value) {
        int i = 0;
        while (i < this.count) {
            this.valueLabels[i].setText("" + value[i]);
            this.barLabels[i].setText("" + (int)((float)(value[i] - this.minValues[i]) / (float)this.maxValues[i] * 100.0f) + "%");
            this.bars[i].setValue(value[i]);
            ++i;
        }
        this.grid.setValue(value);
    }

    protected void initDefaults() {
        int i = 0;
        while (i < this.count) {
            this.maxValues[i] = 100;
            this.minValues[i] = 0;
            this.colors[i] = Color.green;
            Font font = new Font("serif", 0, 10);
            this.maxLabels[i] = new JLabel();
            this.maxLabels[i].setText(this.maxValues[i] + "");
            this.maxLabels[i].setBackground(Color.black);
            this.barLabels[i] = new JLabel();
            this.barLabels[i].setText("0%");
            this.barLabels[i].setBackground(Color.black);
            this.barLabels[i].setFont(font);
            this.valueLabels[i] = new JLabel();
            this.valueLabels[i].setPreferredSize(new Dimension(40, 30));
            this.valueLabels[i].setText("0");
            this.valueLabels[i].setBackground(Color.black);
            this.valueLabels[i].setVerticalAlignment(1);
            this.bars[i] = new DiagramProgressBar(this.minValues[i], this.maxValues[i], this.gridSize / 4);
            this.bars[i].setPreferredSize(new Dimension(25, 20));
            ++i;
        }
        this.grid = new DiagramGridPane(this.minValues, this.maxValues, this.gridSize, this.gridSize, this.colors);
    }
}

