/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.connect.ImageHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordChangeDialog
extends CEscapeDialog
implements ActionListener,
FocusListener {
    protected final int INITIAL_PROPDLG_WIDTH = 450;
    protected final int INITIAL_PROPDLG_HEIGHT = 175;
    protected final String OK_CMD = "ok cmd";
    protected final String CANCEL_CMD = "cancel cmd";
    protected JFrame mainFrame;
    protected JPanel mainPanel;
    protected JLabel promptLabel;
    protected JLabel oldPasswordLabel;
    protected JLabel password1Label;
    protected JLabel password2Label;
    protected JPasswordField oldPasswordField;
    protected JPasswordField password1Field;
    protected JPasswordField password2Field;
    protected JPanel logoPanel;
    protected JLabel logoLabel;
    protected JButton connectButton;
    protected JButton cancelButton;
    protected boolean canceled = true;
    protected char[] oldPassword = null;

    public PasswordChangeDialog(JFrame frame, char[] oldPassword) {
        super(frame, "Password Change", true);
        this.mainFrame = frame;
        this.oldPassword = oldPassword;
        this.initDialog();
        this.pack();
    }

    protected void initDialog() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(450, 175));
        this.promptLabel = new JLabel("You must change your password:");
        this.mainPanel.add((Component)this.promptLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.oldPasswordLabel = new JLabel("Old Password:");
        this.mainPanel.add((Component)this.oldPasswordLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.oldPasswordField = new JPasswordField();
        this.oldPasswordField.addFocusListener(this);
        this.mainPanel.add((Component)this.oldPasswordField, new GridBagConstraints(1, 1, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.password1Label = new JLabel("New Password:");
        this.mainPanel.add((Component)this.password1Label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.password1Field = new JPasswordField();
        this.password1Field.addFocusListener(this);
        this.mainPanel.add((Component)this.password1Field, new GridBagConstraints(1, 2, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.password2Label = new JLabel("Confirm Password:");
        this.mainPanel.add((Component)this.password2Label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.password2Field = new JPasswordField();
        this.password2Field.addFocusListener(this);
        this.mainPanel.add((Component)this.password2Field, new GridBagConstraints(1, 3, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.logoPanel = new JPanel();
        this.logoLabel = new JLabel(ImageHolder.bigLogo);
        this.logoPanel.add((Component)this.logoLabel, "Center");
        this.logoPanel.setPreferredSize(new Dimension(180, 60));
        this.logoPanel.setBackground(Color.white);
        this.logoPanel.setMinimumSize(new Dimension(180, 60));
        this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mainPanel.add((Component)this.logoPanel, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.connectButton = new JButton("Enter");
        this.connectButton.setMnemonic('e');
        this.connectButton.setActionCommand("ok cmd");
        this.connectButton.addActionListener(this);
        this.mainPanel.add((Component)this.connectButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('a');
        this.cancelButton.setActionCommand("cancel cmd");
        this.cancelButton.addActionListener(this);
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 5, 20), 0, 0));
        this.getContentPane().add(this.mainPanel);
        this.oldPasswordField.requestFocus();
        this.oldPasswordField.setNextFocusableComponent(this.password1Field);
        this.password1Field.setNextFocusableComponent(this.password2Field);
        this.password2Field.setNextFocusableComponent(this.connectButton);
        this.connectButton.setNextFocusableComponent(this.cancelButton);
        if (this.mainFrame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation(screenSize.width / 2 - 225, screenSize.height / 2 - 87);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PasswordChangeDialog.this.cancelAction();
            }
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public char[] getOldPassword() {
        return this.oldPasswordField.getPassword();
    }

    public char[] getNewPassword() {
        char[] pass2;
        char[] pass1;
        if (!this.isCanceled() && Arrays.equals(pass1 = this.password1Field.getPassword(), pass2 = this.password2Field.getPassword())) {
            return pass1;
        }
        return null;
    }

    protected void performEnterAction(KeyEvent e) {
        this.enterAction();
    }

    public void focusGained(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            ((JTextField)obj).selectAll();
        } else if (obj instanceof JPasswordField) {
            ((JPasswordField)obj).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            ((JTextField)obj).select(0, 0);
        } else if (obj instanceof JPasswordField) {
            ((JPasswordField)obj).select(0, 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok cmd")) {
            this.enterAction();
        } else if (cmd.equals("cancel cmd")) {
            this.cancelAction();
        }
    }

    private void enterAction() {
        this.canceled = false;
        if (this.oldPassword == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Password is incorrect!", "Error", 2);
            return;
        }
        try {
            if (!Arrays.equals(this.oldPassword, this.oldPasswordField.getPassword())) {
                JOptionPane.showMessageDialog(this.mainFrame, "Password is incorrect!", "Error", 2);
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Password is incorrect!", "Error", 2);
            return;
        }
        if (this.getNewPassword() == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Passwords do not match!", "Error", 2);
            return;
        }
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.canceled = true;
        ((Component)this).setVisible(false);
    }
}

