/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui.connect;

import com.sap.engine.gui.connect.BasicSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class BasicStatusPanel
extends JPanel {
    JLabel statusLabel = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    int progressValue = 0;

    public BasicStatusPanel() {
        this.initPanel();
    }

    protected void initPanel() {
        this.setLayout(new BorderLayout());
        this.statusLabel.setText(BasicSettings.getResourceString("ReadyMsg", "Ready !"));
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.statusLabel, "Center");
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.progressBar, "East");
        this.progressBar.setMaximum(7);
    }

    public void setText(String text) {
        this.statusLabel.setText(" " + text);
        this.statusLabel.paintImmediately(this.statusLabel.getBounds());
    }

    public void resetProgressBar() {
        this.progressValue = 0;
        this.progressBar.setValue(this.progressValue);
        this.progressBar.paintImmediately(this.progressBar.getBounds());
    }

    public void incProgressBar() {
        ++this.progressValue;
        this.progressBar.setValue(this.progressValue);
        this.progressBar.paintImmediately(this.progressBar.getBounds());
    }

    public void resetMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }
}

