/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static final int PROCESS_ALL = -1;

    public static void expandTree(JTree tree, int level) {
        if (level == -1) {
            TreePath[] pathes = TreeUtils.getAllPathes((DefaultMutableTreeNode)tree.getModel().getRoot(), level);
            int i = 0;
            while (i < pathes.length) {
                tree.expandPath(pathes[i]);
                ++i;
            }
        } else {
            TreePath[] pathes = TreeUtils.getAllPathes((DefaultMutableTreeNode)tree.getModel().getRoot(), level);
            int i = 0;
            while (i < pathes.length) {
                tree.expandPath(pathes[i]);
                ++i;
            }
        }
    }

    private static TreePath[] getAllPathes(DefaultMutableTreeNode root, int level) {
        if (root == null) {
            return new TreePath[0];
        }
        Vector<TreePath> temp = new Vector<TreePath>();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object[] temp0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            TreePath path = new TreePath(node.getPath());
            if (level == -1) {
                temp.addElement(path);
                continue;
            }
            Object[] temp2 = path.getPath();
            if (temp2.length >= level) {
                temp0 = new Object[level];
                System.arraycopy(temp2, 0, temp0, 0, level);
            } else {
                temp0 = new Object[temp2.length];
                System.arraycopy(temp2, 0, temp0, 0, temp2.length);
            }
            TreePath tempPath = new TreePath(temp0);
            temp.addElement(tempPath);
        }
        Object[] res = new TreePath[temp.size()];
        temp.copyInto(res);
        return res;
    }

    public static void collapseTree(JTree tree, int level) {
        TreePath[] pathes = TreeUtils.getAllPathes((DefaultMutableTreeNode)tree.getModel().getRoot(), level);
        int i = 0;
        while (i < pathes.length) {
            if (pathes[i].getPath().length >= level) {
                tree.collapsePath(pathes[i]);
            }
            ++i;
        }
    }
}

