/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.table.SortModel;
import com.sap.engine.gui.table.SortTableColumn;
import com.sap.engine.gui.table.SortTableHeader;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortTable
extends JTable {
    private int sortColumn = 0;
    private SortModel sortModel = null;

    public SortTable() {
    }

    public SortTable(TableModel dm) {
        super(dm);
    }

    public SortTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public SortTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public void setModel(AbstractTableModel model) {
        this.sortModel = new SortModel(model);
        super.setModel(this.sortModel);
        this.sortModel.addHeaderListener(this);
        this.sortModel.initSortColumn(this.sortColumn);
    }

    public void initSortColumn(int column) {
        this.sortColumn = column;
        if (this.sortModel != null) {
            this.sortModel.initSortColumn(column);
        }
    }

    public void setAscending(boolean ascending) {
        this.sortModel.setAscending(ascending);
        this.initSortColumn(this.sortColumn);
    }

    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            cm.removeColumnModelListener(this);
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            int i = 0;
            while (i < m.getColumnCount()) {
                SortTableColumn newColumn = new SortTableColumn(i);
                this.addColumn(newColumn);
                ++i;
            }
            cm.addColumnModelListener(this);
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new SortTableHeader(this.columnModel);
    }

    public int getTrueSelectedRow() {
        if (this.sortModel == null) {
            return -1;
        }
        int index = this.getSelectedRow();
        if (index < 0 || index >= this.getRowCount()) {
            return -1;
        }
        return this.sortModel.getTrueIndex(index);
    }

    public int getDataIndex(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return -1;
        }
        return this.sortModel.getTrueIndex(index);
    }

    public int getViewIndex(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return -1;
        }
        return this.sortModel.getViewIndex(index);
    }
}

