/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleListPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String EDIT_CMD = "EDIT_CMD";
    protected DefaultListModel listModel = new DefaultListModel();
    protected JList theList = new JList(this.listModel);
    protected JButton addButton = null;
    protected JButton removeButton = null;
    protected JButton editButton = null;
    protected String title = null;
    protected String newText = null;
    protected String editText = null;
    protected String addButtonText = null;
    protected String editButtonText = null;
    protected String[] comboElements = null;
    protected String component = null;
    protected Component parentComponent = this;
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    protected JLabel addLabel = new JLabel("Enter new element:");
    protected JComboBox addComboBox = new JComboBox();
    protected JPanel addPanel = new JPanel();
    protected JDialog addDialog = null;
    protected JPanel buttonPanel = new JPanel();
    protected JButton okButton = new JButton("OK");
    protected JButton cancelButton = new JButton("Cancel");

    public SimpleListPanel() {
        this("List", "Add", "Remove", "Edit");
    }

    public SimpleListPanel(String title) {
        this(title, "Add", "Remove", "Edit");
    }

    public SimpleListPanel(String title, String addButtonText, String removeButtonText, String editButtonText) {
        this(title, addButtonText, removeButtonText, editButtonText, null);
    }

    public SimpleListPanel(String title, String addButtonText, String removeButtonText, String editButtonText, String[] comboElements) {
        this.setComboElements(comboElements);
        this.title = title;
        if (addButtonText != null) {
            this.addButtonText = addButtonText;
            this.addButton = new JButton(addButtonText);
            this.newText = "New " + title;
        }
        if (removeButtonText != null) {
            this.removeButton = new JButton(removeButtonText);
        }
        if (editButtonText != null) {
            this.editButtonText = editButtonText;
            this.editButton = new JButton(editButtonText);
            this.editText = title;
        }
        try {
            this.init();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        EtchedBorder border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(new TitledBorder(border1, this.title));
        this.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jScrollPane1.getViewport().add((Component)this.theList, null);
        int y = 0;
        if (this.addButton != null) {
            this.addButton.setActionCommand(ADD_CMD);
            this.addButton.addActionListener(this);
            this.add((Component)this.addButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.removeButton != null) {
            this.removeButton.setActionCommand(REMOVE_CMD);
            this.removeButton.addActionListener(this);
            this.add((Component)this.removeButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.editButton != null) {
            this.editButton.setActionCommand(EDIT_CMD);
            this.editButton.addActionListener(this);
            this.add((Component)this.editButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.setEnabled(true, true, false, false);
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand(OK_CMD);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.addPanel.setLayout(new GridBagLayout());
        this.addPanel.add((Component)this.addLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.addPanel.add((Component)this.addComboBox, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 20, 0, 20), 0, 0));
        this.addPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    public JList getList() {
        return this.theList;
    }

    public void setAddText(String text) {
        this.newText = text;
    }

    public void setEditText(String text) {
        this.editText = text;
    }

    public void setComboElements(String[] comboElements) {
        this.comboElements = comboElements != null && comboElements.length != 0 ? comboElements : null;
        this.addComboBox.setEditable(true);
        this.addComboBox.removeAllItems();
        if (comboElements != null) {
            int i = 0;
            while (i < comboElements.length) {
                this.addComboBox.addItem(comboElements[i]);
                ++i;
            }
        }
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
        this.addDialog = new JDialog((Frame)parentComponent, "The element name", true);
        this.addDialog.setLocationRelativeTo((Frame)parentComponent);
        this.addDialog.getContentPane().setLayout(new BorderLayout());
        ((Component)this.addDialog).setSize(270, 120);
        this.addDialog.getContentPane().add(this.addPanel);
    }

    public void setEnabled(boolean list, boolean add, boolean remove, boolean edit) {
        this.theList.setEnabled(list);
        if (this.addButton != null) {
            this.addButton.setEnabled(add);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(remove);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(edit);
        }
    }

    public void setEnabled(boolean flag) {
        this.setEnabled(flag, flag, false, false);
    }

    public void initList(String[] names) {
        this.listModel.clear();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.listModel.addElement(names[i]);
                ++i;
            }
        }
    }

    public void initList(Vector names) {
        this.listModel.clear();
        if (names != null) {
            int i = 0;
            while (i < names.size()) {
                this.listModel.addElement(names.elementAt(i));
                ++i;
            }
        }
    }

    public String[] getListDataArray() {
        if (this.listModel == null || this.listModel.size() == 0) {
            return null;
        }
        Object[] res = new String[this.listModel.size()];
        this.listModel.copyInto(res);
        return res;
    }

    public Vector getListData() {
        if (this.listModel == null || this.listModel.size() == 0) {
            return null;
        }
        Vector temp = new Vector();
        int i = 0;
        while (i < this.listModel.size()) {
            temp.add(this.listModel.elementAt(i));
            ++i;
        }
        return temp;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
        } else if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
        } else if (cmd.equals(EDIT_CMD)) {
            this.editButtonAction();
        } else if (cmd.equals(OK_CMD)) {
            this.component = ((JTextField)this.addComboBox.getEditor().getEditorComponent()).getText();
            ((Component)this.addDialog).setVisible(false);
            this.addComboBox.setSelectedIndex(0);
        } else if (cmd.equals(CANCEL_CMD)) {
            this.component = null;
            ((JTextField)this.addComboBox.getEditor().getEditorComponent()).setText("");
            ((Component)this.addDialog).setVisible(false);
        }
    }

    private void addButtonAction() {
        this.component = null;
        if (this.comboElements == null || this.addDialog == null) {
            this.component = JOptionPane.showInputDialog(this.parentComponent, this.newText, this.addButtonText, -1);
        } else {
            this.addLabel.setText(this.newText);
            this.addDialog.setTitle(this.addButtonText);
            this.addDialog.show();
        }
        if (this.component == null || this.component.equals("")) {
            return;
        }
        if (!this.listModel.contains(this.component)) {
            this.listModel.addElement(this.component.trim());
        } else {
            JOptionPane.showMessageDialog(this.parentComponent, "There is an element named <" + this.component + "> in the list already.", "WARNING", 2);
        }
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.listModel.removeElementAt(index);
        }
    }

    public void editButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            String value = (String)this.listModel.elementAt(index);
            if (this.comboElements == null || this.addDialog == null) {
                this.component = (String)JOptionPane.showInputDialog(this.parentComponent, this.editText, this.editButtonText, -1, null, null, value);
            } else {
                ((JTextField)this.addComboBox.getEditor().getEditorComponent()).setText(value);
                this.addLabel.setText(this.editText);
                this.addComboBox.setSelectedItem(value);
                this.addDialog.setTitle(this.editButtonText);
                this.addDialog.show();
            }
            if (this.component == null || this.component.equals("") || this.component.equals(value)) {
                return;
            }
            if (!this.listModel.contains(this.component.trim())) {
                this.listModel.setElementAt(this.component.trim(), index);
            } else {
                Object[] options = new Object[]{"Yes", "No"};
                int result = JOptionPane.showOptionDialog(this.parentComponent, "An element named < " + this.component.trim() + " " + "> allready exists in the list.\nDo you want to edit <" + value + ">?", "Warning", -1, 2, null, options, options[0]);
                if (result == 0) {
                    this.listModel.removeElement(value);
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!this.theList.isSelectionEmpty()) {
            if (this.removeButton != null) {
                this.removeButton.setEnabled(true);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(true);
            }
        } else {
            if (this.removeButton != null) {
                this.removeButton.setEnabled(false);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(false);
            }
        }
    }

    public void setListRenderer(ListCellRenderer renderer) {
        this.theList.setCellRenderer(renderer);
    }
}

